<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recibo de Salário</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #405189;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 5px 5px 0 0;
        }
        .content {
            background-color: #f8f9fa;
            padding: 30px;
            border: 1px solid #dee2e6;
            border-top: none;
        }
        .info-box {
            background-color: white;
            padding: 15px;
            margin: 15px 0;
            border-left: 4px solid #405189;
            border-radius: 4px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin: 8px 0;
        }
        .label {
            font-weight: bold;
            color: #405189;
        }
        .value {
            color: #333;
        }
        .total {
            background-color: #28a745;
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 1.3em;
            font-weight: bold;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-size: 0.9em;
            border-top: 1px solid #dee2e6;
            margin-top: 20px;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background-color: #405189;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🧾 Recibo de Salário</h1>
        <p><?php echo e($processamento->nomeMes); ?>/<?php echo e($processamento->ano); ?></p>
    </div>

    <div class="content">
        <p>Olá <strong><?php echo e($salario->nomeTrabalhador); ?></strong>,</p>
        
        <p>O processamento do seu salário referente a <strong><?php echo e($processamento->nomeMes); ?>/<?php echo e($processamento->ano); ?></strong> foi concluído com sucesso!</p>

        <div class="info-box">
            <h3 style="margin-top: 0; color: #405189;">📋 Dados do Funcionário</h3>
            <div class="info-row">
                <span class="label">NBI:</span>
                <span class="value"><?php echo e($salario->nbi); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Função:</span>
                <span class="value"><?php echo e($salario->funcao); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Departamento:</span>
                <span class="value"><?php echo e($salario->grupoPessoal); ?></span>
            </div>
        </div>

        <div class="info-box">
            <h3 style="margin-top: 0; color: #405189;">💰 Resumo Financeiro</h3>
            <div class="info-row">
                <span class="label">Salário Base:</span>
                <span class="value"><?php echo e(number_format($salario->salarioBase, 2, ',', '.')); ?> Kz</span>
            </div>
            <?php if($salario->abonoFamiliar > 0): ?>
            <div class="info-row">
                <span class="label">Abono Familiar:</span>
                <span class="value"><?php echo e(number_format($salario->abonoFamiliar, 2, ',', '.')); ?> Kz</span>
            </div>
            <?php endif; ?>
            <?php if($salario->subTransporte > 0): ?>
            <div class="info-row">
                <span class="label">Subsídio Transporte:</span>
                <span class="value"><?php echo e(number_format($salario->subTransporte, 2, ',', '.')); ?> Kz</span>
            </div>
            <?php endif; ?>
            <?php if($salario->subAlimentacao > 0): ?>
            <div class="info-row">
                <span class="label">Subsídio Alimentação:</span>
                <span class="value"><?php echo e(number_format($salario->subAlimentacao, 2, ',', '.')); ?> Kz</span>
            </div>
            <?php endif; ?>
            <?php if($salario->acrescimoExtra > 0): ?>
            <div class="info-row">
                <span class="label" style="color: #28a745;">Abono Extra:</span>
                <span class="value" style="color: #28a745;">+ <?php echo e(number_format($salario->acrescimoExtra, 2, ',', '.')); ?> Kz</span>
            </div>
            <?php endif; ?>
            <?php if($salario->desconto > 0): ?>
            <div class="info-row">
                <span class="label" style="color: #dc3545;">Descontos:</span>
                <span class="value" style="color: #dc3545;">- <?php echo e(number_format($salario->desconto, 2, ',', '.')); ?> Kz</span>
            </div>
            <?php endif; ?>
        </div>

        <div class="total">
            💵 TOTAL LÍQUIDO: <?php echo e(number_format($salario->total, 2, ',', '.')); ?> Kz
        </div>

        <p style="text-align: center; margin: 20px 0;">
            O recibo detalhado está anexado a este e-mail em formato PDF.
        </p>

        <?php if($salario->descricao): ?>
        <div class="info-box">
            <h4 style="margin-top: 0; color: #405189;">📝 Observações</h4>
            <p style="margin: 0;"><?php echo e($salario->descricao); ?></p>
        </div>
        <?php endif; ?>
    </div>

    <div class="footer">
        <p><strong><?php echo e($processamento->unidadePagadora); ?></strong></p>
        <p>Processado por: <?php echo e($processamento->unidadeProcessadora); ?></p>
        <p style="font-size: 0.85em; color: #999;">
            Este é um e-mail automático, por favor não responda.
        </p>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\FINANCIAL\resources\views/emails/recibo-salario.blade.php ENDPATH**/ ?>