<?php $__env->startSection('Conteudo'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Título da página -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">
                            <i class="ri-settings-3-line label-icon align-middle fs-16 ms-2"></i> 
                            GESTÃO DE PROJECTOS
                        </h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">Gestão de Projectos</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mensagens de alerta -->
            <?php if(session('msg')): ?>
                <script>
                    document.addEventListener('DOMContentLoaded', () => {
                        Swal.fire({
                            title: "Sucesso!",
                            text: "<?php echo e(session('msg')); ?>",
                            icon: "success",
                            timer: 3000
                        });
                    });
                </script>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="ri-error-warning-line me-2"></i>
                    <?php echo e($errors->first()); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Filtros e Estatísticas -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-filter-line me-2"></i>Filtros e Estatísticas
                            </h5>
                        </div>
                        <div class="card-body">
                            <form method="GET" action="<?php echo e(route('admin.projetos.index')); ?>" id="filtrosForm">
                                <div class="row g-3">
                                    <div class="col-md-3">
                                        <label class="form-label">Buscar Projecto</label>
                                        <input type="text" name="search" class="form-control" 
                                               value="<?php echo e(request('search')); ?>" 
                                               placeholder="Nome, código ou descrição...">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Status</label>
                                        <select name="status" class="form-select">
                                            <option value="">Todos</option>
                                            <option value="0" <?php echo e(request('status') == '0' ? 'selected' : ''); ?>>Recebido</option>
                                            <option value="1" <?php echo e(request('status') == '1' ? 'selected' : ''); ?>>Em Análise</option>
                                            <option value="2" <?php echo e(request('status') == '2' ? 'selected' : ''); ?>>Aprovado</option>
                                            <option value="3" <?php echo e(request('status') == '3' ? 'selected' : ''); ?>>Rejeitado</option>
                                            <option value="4" <?php echo e(request('status') == '4' ? 'selected' : ''); ?>>Em Execução</option>
                                            <option value="5" <?php echo e(request('status') == '5' ? 'selected' : ''); ?>>Concluído</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Tipo</label>
                                        <select name="tipo_projeto" class="form-select">
                                            <option value="">Todos os tipos</option>
                                            <?php $__currentLoopData = $tiposProjecto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($tipo->id); ?>" 
                                                        <?php echo e(request('tipo_projeto') == $tipo->id ? 'selected' : ''); ?>>
                                                    <?php echo e($tipo->descricao); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Data Início</label>
                                        <input type="date" name="data_inicio" class="form-control" 
                                               value="<?php echo e(request('data_inicio')); ?>">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Data Fim</label>
                                        <input type="date" name="data_fim" class="form-control" 
                                               value="<?php echo e(request('data_fim')); ?>">
                                    </div>
                                    <div class="col-md-1">
                                        <label class="form-label">&nbsp;</label>
                                        <div class="d-flex gap-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="ri-search-line"></i>
                                            </button>
                                            <a href="<?php echo e(route('admin.projetos.index')); ?>" class="btn btn-secondary">
                                                <i class="ri-refresh-line"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">&nbsp;</label>
                                        <div class="d-flex gap-2">
                                            <!-- Dropdown PDF -->
                                            <div class="dropdown">
                                                <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownPDF" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="ri-file-pdf-line me-1"></i>PDF
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownPDF">
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="exportarPDF('visualizar')">
                                                            <i class="ri-eye-line me-2"></i>Visualizar PDF
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="exportarPDF('baixar')">
                                                            <i class="ri-download-line me-2"></i>Baixar PDF
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            
                                            <!-- Botão Excel -->
                                            <button class="btn btn-success btn-sm" onclick="exportarExcel()">
                                                <i class="ri-file-excel-line me-1"></i>Excel
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <!-- Estatísticas Rápidas - Clicáveis -->
                            <div class="row mt-4">
                                <div class="col-md-2">
                                    <div class="card border-warning status-card cursor-pointer" onclick="filtrarPorStatus(0)">
                                        <div class="card-body text-center">
                                            <i class="ri-mail-line display-6 text-warning mb-2"></i>
                                            <h6 class="card-subtitle text-warning">
                                                <i class="ri-inbox-line me-1"></i>Recebidos
                                            </h6>
                                            <h4 class="card-title text-warning"><?php echo e($projetos->where('status', 0)->count()); ?></h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="card border-info status-card cursor-pointer" onclick="filtrarPorStatus(1)">
                                        <div class="card-body text-center">
                                            <i class="ri-search-eye-line display-6 text-info mb-2"></i>
                                            <h6 class="card-subtitle text-info">
                                                <i class="ri-eye-line me-1"></i>Em Análise
                                            </h6>
                                            <h4 class="card-title text-info"><?php echo e($projetos->where('status', 1)->count()); ?></h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="card border-success status-card cursor-pointer" onclick="filtrarPorStatus(2)">
                                        <div class="card-body text-center">
                                            <i class="ri-checkbox-circle-line display-6 text-success mb-2"></i>
                                            <h6 class="card-subtitle text-success">
                                                <i class="ri-check-line me-1"></i>Aprovados
                                            </h6>
                                            <h4 class="card-title text-success"><?php echo e($projetos->where('status', 2)->count()); ?></h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="card border-danger status-card cursor-pointer" onclick="filtrarPorStatus(3)">
                                        <div class="card-body text-center">
                                            <i class="ri-close-circle-line display-6 text-danger mb-2"></i>
                                            <h6 class="card-subtitle text-danger">
                                                <i class="ri-close-line me-1"></i>Rejeitados
                                            </h6>
                                            <h4 class="card-title text-danger"><?php echo e($projetos->where('status', 3)->count()); ?></h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="card border-primary status-card cursor-pointer" onclick="filtrarPorStatus(4)">
                                        <div class="card-body text-center">
                                            <i class="ri-play-circle-line display-6 text-primary mb-2"></i>
                                            <h6 class="card-subtitle text-primary">
                                                <i class="ri-play-line me-1"></i>Em Execução
                                            </h6>
                                            <h4 class="card-title text-primary"><?php echo e($projetos->where('status', 4)->count()); ?></h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="card border-dark status-card cursor-pointer" onclick="filtrarPorStatus(5)">
                                        <div class="card-body text-center">
                                            <i class="ri-award-line display-6 text-dark mb-2"></i>
                                            <h6 class="card-subtitle text-dark">
                                                <i class="ri-trophy-line me-1"></i>Concluídos
                                            </h6>
                                            <h4 class="card-title text-dark"><?php echo e($projetos->where('status', 5)->count()); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Projetos Organizados por Instituição -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">
                                    <i class="ri-building-line me-2"></i>Carteira de Projectos
                                </h5>
                                <div class="text-muted">
                                    <i class="ri-file-list-3-line me-1"></i><?php echo e($projetos->count()); ?> <?php echo e($projetos->count() == 1 ? 'projeto' : 'projetos'); ?> encontrados
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php 
                                $projetosPorInstituicao = $projetos->groupBy(function ($projeto) {
                                    return $projeto->tecnicoProjecto ? $projeto->tecnicoProjecto->name : 'Sem Técnico Responsável';
                                });
                            ?>

                            <?php if($projetosPorInstituicao->count() > 0): ?>
                                <!-- Accordion por Instituição -->
                                <div class="accordion accordion-border-box" id="accordionInstituicoes">
                                    <?php $instituicaoIndex = 0; ?>
                                    <?php $__currentLoopData = $projetosPorInstituicao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instituicao => $projetosInstituicao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php 
                                            $totalCustoInstituicao = $projetosInstituicao->sum('limiteorcamentalP');
                                            $quantidadeProjetos = $projetosInstituicao->count();
                                            
                                            // Contagem por status
                                            $statusCount = [
                                                0 => $projetosInstituicao->where('status', 0)->count(),
                                                1 => $projetosInstituicao->where('status', 1)->count(),
                                                2 => $projetosInstituicao->where('status', 2)->count(),
                                                3 => $projetosInstituicao->where('status', 3)->count(),
                                                4 => $projetosInstituicao->where('status', 4)->count(),
                                                5 => $projetosInstituicao->where('status', 5)->count(),
                                            ];
                                        ?>
                                        
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="heading<?php echo e($instituicaoIndex); ?>">
                                                <button class="accordion-button <?php echo e($instituicaoIndex == 0 ? '' : 'collapsed'); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($instituicaoIndex); ?>" aria-expanded="<?php echo e($instituicaoIndex == 0 ? 'true' : 'false'); ?>" aria-controls="collapse<?php echo e($instituicaoIndex); ?>">
                                                    <div class="d-flex justify-content-between w-100 me-3">
                                                        <div class="instituicao-info">
                                                            <strong class="fs-6 text-primary">
                                                                <i class="ri-building-line me-2"></i><?php echo e($instituicao ?? 'Instituição N/A'); ?>

                                                            </strong>
                                                            <div class="mt-1">
                                                                <small class="text-muted">
                                                                    <i class="ri-file-list-3-line me-1"></i><?php echo e($quantidadeProjetos); ?> <?php echo e($quantidadeProjetos == 1 ? 'Projeto' : 'Projetos'); ?>

                                                                </small>
                                                            </div>
                                                        </div>
                                                        <div class="custos-info text-end">
                                                            <div class="fw-bold text-success">
                                                                <i class="ri-money-dollar-circle-line me-1"></i><?php echo e(number_format($totalCustoInstituicao, 2, ',', '.')); ?> Kz
                                                            </div>
                                                            <div class="text-muted small">
                                                                <span class="badge bg-success me-1"><?php echo e($statusCount[2] + $statusCount[4] + $statusCount[5]); ?></span>
                                                                <span class="badge bg-info me-1"><?php echo e($statusCount[1]); ?></span>
                                                                <span class="badge bg-warning"><?php echo e($statusCount[0]); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </button>
                                            </h2>
                                            <div id="collapse<?php echo e($instituicaoIndex); ?>" class="accordion-collapse collapse <?php echo e($instituicaoIndex == 0 ? 'show' : ''); ?>" aria-labelledby="heading<?php echo e($instituicaoIndex); ?>" data-bs-parent="#accordionInstituicoes">
                                                <div class="accordion-body p-0">
                                                    <!-- Resumo da Instituição -->
                                                    <div class="bg-light p-3 border-bottom">
                                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                                            <h6 class="mb-0 text-primary">
                                                                <i class="ri-pie-chart-line me-2"></i>Resumo de Status - <?php echo e($instituicao); ?>

                                                            </h6>
                                                        </div>
                                                        
                                                        <div class="row text-center">
                                                            <div class="col-md-2">
                                                                <div class="border-end">
                                                                    <h6 class="mb-1 text-warning"><i class="ri-inbox-line"></i> Recebidos</h6>
                                                                    <h5 class="mb-0 text-warning"><?php echo e($statusCount[0]); ?></h5>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="border-end">
                                                                    <h6 class="mb-1 text-info"><i class="ri-eye-line"></i> Em Análise</h6>
                                                                    <h5 class="mb-0 text-info"><?php echo e($statusCount[1]); ?></h5>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="border-end">
                                                                    <h6 class="mb-1 text-success"><i class="ri-check-line"></i> Aprovados</h6>
                                                                    <h5 class="mb-0 text-success"><?php echo e($statusCount[2]); ?></h5>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="border-end">
                                                                    <h6 class="mb-1 text-danger"><i class="ri-close-line"></i> Rejeitados</h6>
                                                                    <h5 class="mb-0 text-danger"><?php echo e($statusCount[3]); ?></h5>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="border-end">
                                                                    <h6 class="mb-1 text-primary"><i class="ri-play-line"></i> Em Execução</h6>
                                                                    <h5 class="mb-0 text-primary"><?php echo e($statusCount[4]); ?></h5>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <h6 class="mb-1 text-dark"><i class="ri-trophy-line"></i> Concluídos</h6>
                                                                <h5 class="mb-0 text-dark"><?php echo e($statusCount[5]); ?></h5>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Tabela de Projetos -->
                                                    <div class="table-responsive">
                                                        <table class="table table-hover mb-0">
                                                            <thead class="table-dark">
                                                                <tr>
                                                                    <th style="width: 10%;">Código</th>
                                                                    <th style="width: 25%;">Nome do Projeto</th>
                                                                    <th style="width: 15%;">Tipo</th>
                                                                    <th style="width: 12%;">Status</th>
                                                                    <th style="width: 12%;">Custo Total</th>
                                                                    <th style="width: 10%;">Submetido</th>
                                                                    <th style="width: 16%;">Ações</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php $__currentLoopData = $projetosInstituicao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projeto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td class="fw-semibold"><?php echo e($projeto->codProjecto); ?></td>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <i class="ri-file-text-line text-muted me-2"></i>
                                                                            <div>
                                                                                <h6 class="mb-0"><?php echo e(Str::limit($projeto->nomeProjecto, 35)); ?></h6>
                                                                                <small class="text-muted"><?php echo e($projeto->tipoProjecto->descricao ?? 'N/A'); ?></small>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <span class="badge bg-light text-dark">
                                                                            <i class="ri-bookmark-line me-1"></i><?php echo e($projeto->tipoProjecto->descricao ?? 'N/A'); ?>

                                                                        </span>
                                                                    </td>
                                                                    <td>
                                                                        <span class="badge bg-<?php echo e($projeto->status_cor ?? 'secondary'); ?>">
                                                                            <?php echo e($projeto->status_formatado ?? 'N/A'); ?>

                                                                        </span>
                                                                    </td>
                                                                    <td class="text-end fw-semibold"><?php echo e(number_format($projeto->limiteorcamentalP, 2, ',', '.')); ?> Kz</td>
                                                                    <td>
                                                                        <small class="text-muted">
                                                                            <i class="ri-calendar-line me-1"></i><?php echo e($projeto->created_at->format('d/m/Y')); ?>

                                                                        </small>
                                                                    </td>
                                                                    <td>
                                                                        <div class="d-flex gap-1">
                                                                            <button class="btn btn-soft-info btn-xs" 
                                                                                    onclick="visualizarDetalhes(<?php echo e($projeto->id); ?>)" 
                                                                                    title="Ver Detalhes">
                                                                                <i class="ri-eye-line"></i>
                                                                            </button>
                                                                            
                                                                            <?php if($projeto->podeAlterarStatus(Auth::id()) && count($projeto->proximosStatusValidos()) > 0): ?>
                                                                                <div class="dropdown">
                                                                                    <button class="btn btn-soft-primary btn-xs dropdown-toggle" 
                                                                                            type="button" data-bs-toggle="dropdown" title="Alterar Status">
                                                                                        <i class="ri-settings-3-line"></i>
                                                                                    </button>
                                                                                    <ul class="dropdown-menu">
                                                                                        <?php $__currentLoopData = $projeto->proximosStatusValidos(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                            <li>
                                                                                                <a class="dropdown-item" href="javascript:void(0)" 
                                                                                                   onclick="alterarStatus(<?php echo e($projeto->id); ?>, <?php echo e($status); ?>)">
                                                                                                    <span class="badge bg-<?php echo e(['', 'info', 'success', 'danger', 'primary', 'success'][$status]); ?> me-2"><?php echo e(['', 'Em Análise', 'Aprovar', 'Rejeitar', 'Em Execução', 'Concluir'][$status]); ?></span>
                                                                                                </a>
                                                                                            </li>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                    </ul>
                                                                                </div>
                                                                            <?php endif; ?>

                                                                            <?php if($projeto->status == 4): ?>
                                                                                <a href="<?php echo e(route('admin.projetos.pagamentos', $projeto->id)); ?>" 
                                                                                   class="btn btn-soft-success btn-xs" title="Pagamentos">
                                                                                    <i class="ri-money-dollar-circle-line"></i>
                                                                                </a>
                                                                            <?php endif; ?>

                                                                            <a href="<?php echo e(route('admin.projetos.show', $projeto->id)); ?>" 
                                                                               class="btn btn-soft-success btn-xs" title="Detalhes Completos">
                                                                                <i class="ri-file-text-line"></i>
                                                                            </a>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php $instituicaoIndex++; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <!-- Nenhum projeto encontrado -->
                                <div class="text-center py-5">
                                    <div class="mb-4">
                                        <i class="ri-folder-open-line display-4 text-muted"></i>
                                    </div>
                                    <h5 class="mb-3">Nenhum projeto encontrado</h5>
                                    <p class="text-muted mb-0">
                                        Não foram encontrados projetos com os filtros aplicados.<br>
                                        Tente ajustar os filtros ou remover as restrições de busca.
                                    </p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Paginação -->
            <?php if($projetos->hasPages()): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="d-flex justify-content-center">
                            <?php echo e($projetos->appends(request()->query())->links()); ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Botões de Exportação -->
<div class="row">
    <div class="col-md-8">
        <div class="d-flex gap-2 justify-content-start">
            <!-- Dropdown PDF -->
            <div class="dropdown">
                <button class="btn btn-danger dropdown-toggle" type="button" id="dropdownPDF" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ri-file-pdf-line me-1"></i>PDF
                </button>
                <ul class="dropdown-menu" aria-labelledby="dropdownPDF">
                    <li>
                        <a class="dropdown-item" href="#" onclick="exportarPDF('visualizar')">
                            <i class="ri-eye-line me-2"></i>Visualizar PDF
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="#" onclick="exportarPDF('baixar')">
                            <i class="ri-download-line me-2"></i>Baixar PDF
                        </a>
                    </li>
                </ul>
            </div>
            
            <!-- Botão Excel -->
            <button class="btn btn-success" onclick="exportarExcel()">
                <i class="ri-file-excel-line me-1"></i>Excel
            </button>
        </div>
    </div>
</div>

<!-- Modal de Detalhes Rápidos -->
<div class="modal fade" id="modalDetalhes" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="ri-information-line me-2"></i>
                    Detalhes do Projecto
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="conteudoDetalhes">
                <div class="text-center py-4">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Carregando...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Alteração de Status -->
<div class="modal fade" id="modalStatus" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="ri-settings-3-line me-2"></i>
                    Alterar Status do Projeto
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formStatus">
                    <input type="hidden" id="projetoId">
                    <input type="hidden" id="novoStatus">
                    
                    <div class="alert alert-info">
                        <i class="ri-information-line me-2"></i>
                        <span id="mensagemStatus"></span>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observações (Opcional)</label>
                        <textarea class="form-control" id="observacoes" name="observacoes" 
                                  rows="3" placeholder="Adicione observações sobre esta alteração..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarAlteracaoStatus()">
                    <i class="ri-check-line me-1"></i>
                    Confirmar Alteração
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// Função para visualizar detalhes rápidos
function visualizarDetalhes(projetoId) {
    const modal = new bootstrap.Modal(document.getElementById('modalDetalhes'));
    const conteudo = document.getElementById('conteudoDetalhes');
    
    // Mostrar loading
    conteudo.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border" role="status">
                <span class="visually-hidden">Carregando...</span>
            </div>
        </div>
    `;
    
    modal.show();
    
    // Fazer requisição AJAX
    fetch(`/admin/projetos/${projetoId}/detalhes`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const projeto = data.projeto;
                conteudo.innerHTML = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-primary">Informações Básicas</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Código:</strong></td><td>${projeto.codProjecto}</td></tr>
                                <tr><td><strong>Nome:</strong></td><td>${projeto.nomeProjecto}</td></tr>
                                <tr><td><strong>Tipo:</strong></td><td>${projeto.tipoProjecto}</td></tr>
                                <tr><td><strong>Custo total:</strong></td><td>${projeto.limiteorcamentalP}</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-primary">Status e Responsáveis</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Status:</strong></td><td><span class="badge bg-${projeto.status_cor}">${projeto.status_formatado}</span></td></tr>
                                <tr><td><strong>Promotor:</strong></td><td>${projeto.tecnicoProjecto}</td></tr>
                                <tr><td><strong>Gestor Resp.:</strong></td><td>${projeto.adminResponsavel}</td></tr>
                                <tr><td><strong>Submetido:</strong></td><td>${projeto.created_at}</td></tr>
                            </table>
                        </div>
                        <div class="col-12">
                            <h6 class="text-primary">Descrição</h6>
                            <p class="text-muted">${projeto.descricaoObjectivo || 'Sem descrição disponível'}</p>
                        </div>
                    </div>
                `;
            } else {
                conteudo.innerHTML = `
                    <div class="alert alert-danger">
                        <i class="ri-error-warning-line me-2"></i>
                        ${data.message}
                    </div>
                `;
            }
        })
        .catch(error => {
            conteudo.innerHTML = `
                <div class="alert alert-danger">
                    <i class="ri-error-warning-line me-2"></i>
                    Erro ao carregar detalhes. Tente novamente.
                </div>
            `;
        });
}

// Função para alterar status
function alterarStatus(projetoId, novoStatus) {
    const statusNomes = {
        1: 'Em Análise',
        2: 'Aprovado',
        3: 'Rejeitado',
        4: 'Em Execução',
        5: 'Concluído'
    };
    
    document.getElementById('projetoId').value = projetoId;
    document.getElementById('novoStatus').value = novoStatus;
    document.getElementById('mensagemStatus').textContent = 
        `Tem certeza que deseja alterar o status para "${statusNomes[novoStatus]}"?`;
    
    const modal = new bootstrap.Modal(document.getElementById('modalStatus'));
    modal.show();
}

// Função para confirmar alteração de status
function confirmarAlteracaoStatus() {
    const projetoId = document.getElementById('projetoId').value;
    const novoStatus = document.getElementById('novoStatus').value;
    const observacoes = document.getElementById('observacoes').value;
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '<?php echo e(csrf_token()); ?>';
    
    // Desabilitar botão
    const btnConfirmar = event.target;
    btnConfirmar.disabled = true;
    btnConfirmar.innerHTML = '<i class="ri-loader-4-line me-1"></i>Processando...';
    
    fetch(`/admin/projetos/${projetoId}/status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        },
        body: JSON.stringify({
            novo_status: novoStatus,
            observacoes: observacoes
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: 'Sucesso!',
                text: data.message,
                icon: 'success',
                timer: 2000
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                title: 'Erro!',
                text: data.message,
                icon: 'error'
            });
        }
    })
    .catch(error => {
        Swal.fire({
            title: 'Erro!',
            text: 'Erro na comunicação com o servidor. Tente novamente.',
            icon: 'error'
        });
    })
    .finally(() => {
        bootstrap.Modal.getInstance(document.getElementById('modalStatus')).hide();
        btnConfirmar.disabled = false;
        btnConfirmar.innerHTML = '<i class="ri-check-line me-1"></i>Confirmar Alteração';
    });
}

// Função para filtrar por status (cards clicáveis)
function filtrarPorStatus(status) {
    const form = document.getElementById('filtrosForm');
    const statusSelect = document.querySelector('[name="status"]');
    statusSelect.value = status;
    form.submit();
}

// Função para exportar PDF
function exportarPDF(tipo) {
    const params = new URLSearchParams(window.location.search);
    let url = '';
    
    if (tipo === 'visualizar') {
        url = '<?php echo e(route("admin.projetos.visualizar-pdf-listagem")); ?>';
    } else {
        url = '<?php echo e(route("admin.projetos.exportar-pdf-listagem")); ?>';
    }
    
    // Adicionar parâmetros de filtro à URL
    if (params.toString()) {
        url += '?' + params.toString();
    }
    
    if (tipo === 'visualizar') {
        window.open(url, '_blank');
    } else {
        window.location.href = url;
    }
}

// Função para exportar Excel
function exportarExcel() {
    const params = new URLSearchParams(window.location.search);
    let url = '<?php echo e(route("admin.projetos.exportar-excel-listagem")); ?>';
    
    // Adicionar parâmetros de filtro à URL
    if (params.toString()) {
        url += '?' + params.toString();
    }
    
    window.location.href = url;
}

// Auto-submit nos filtros
document.addEventListener('DOMContentLoaded', function() {
    const filtros = ['status', 'tipo_projeto'];
    filtros.forEach(filtro => {
        document.querySelector(`[name="${filtro}"]`)?.addEventListener('change', function() {
            document.getElementById('filtrosForm').submit();
        });
    });
});
</script>

<style>
/* Estilos para cards de status clicáveis */
.status-card {
    transition: all 0.3s ease;
    cursor: pointer;
}

.status-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

.status-card .display-6 {
    transition: all 0.3s ease;
}

.status-card:hover .display-6 {
    transform: scale(1.1);
}

.cursor-pointer {
    cursor: pointer;
}

/* Estilos específicos para o accordion */
.accordion-border-box .accordion-item {
    border: 1px solid #e5e5e5;
    border-radius: 8px;
    margin-bottom: 15px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
}

.accordion-border-box .accordion-item:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.accordion-border-box .accordion-button {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: none;
    padding: 20px;
    font-weight: 600;
    border-radius: 8px !important;
}

.accordion-border-box .accordion-button:not(.collapsed) {
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
    color: #1976d2;
    box-shadow: none;
}

.accordion-border-box .accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(25, 118, 210, 0.25);
}

.instituicao-info strong {
    font-size: 1.1rem;
    display: block;
    margin-bottom: 5px;
}

.custos-info {
    min-width: 200px;
}

.custos-info .fw-bold {
    font-size: 1.1rem;
    margin-bottom: 5px;
}

.accordion-body .bg-light {
    background: linear-gradient(90deg, #f8f9fa 0%, #e9ecef 100%) !important;
}

.accordion-body .border-end::after {
    content: '';
    position: absolute;
    right: 0;
    top: 10%;
    height: 80%;
    width: 1px;
    background: #dee2e6;
}

.accordion-body .col-md-2 {
    position: relative;
}

.table thead th {
    font-weight: 600;
    letter-spacing: 0.5px;
    text-transform: uppercase;
}

.table-hover tbody tr:hover {
    background-color: rgba(25, 118, 210, 0.05);
    transform: scale(1.002);
    transition: all 0.2s ease;
}

.badge {
    font-size: 0.75rem;
    padding: 0.35em 0.65em;
    border-radius: 6px;
}

.btn-xs {
    padding: 0.25rem 0.4rem;
    font-size: 0.7rem;
    line-height: 1.2;
    border-radius: 0.2rem;
}

/* Animações de entrada */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.accordion-item {
    animation: fadeInUp 0.3s ease-out;
}

.accordion-item:nth-child(2) {
    animation-delay: 0.1s;
}

.accordion-item:nth-child(3) {
    animation-delay: 0.2s;
}

.accordion-item:nth-child(4) {
    animation-delay: 0.3s;
}

/* Responsividade */
@media (max-width: 768px) {
    .instituicao-info strong {
        font-size: 1rem;
    }
    
    .custos-info {
        min-width: auto;
        margin-top: 10px;
    }
    
    .accordion-button {
        flex-direction: column;
        align-items: flex-start !important;
    }
    
    .d-flex.justify-content-between {
        flex-direction: column !important;
        gap: 10px;
    }
    
    .status-card .display-6 {
        font-size: 2rem !important;
    }
    
    .btn-xs {
        padding: 0.3rem 0.5rem;
        font-size: 0.75rem;
    }
}

/* Melhorias visuais adicionais */
.limit-text {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.card-height-100 {
    height: calc(100% - 1rem);
}

.border-end {
    border-right: 1px solid #dee2e6 !important;
}

.table-dark th {
    background-color: #405289 !important;
    border-color: #405289 !important;
}

.fs-12 {
    font-size: 0.75rem !important;
}

.fs-13 {
    font-size: 0.8125rem !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Admin/GestaoProjectos.blade.php ENDPATH**/ ?>