<?php $__env->startSection('Conteudo'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Página Principal</a></li>
                                <li class="breadcrumb-item active">Gestão de Pessoas - Remunerações</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            <?php if(session('success')): ?>
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "<?php echo e(session('success')); ?>",
                        icon: "success"
                    });
                });
            </script>
            <?php endif; ?>

            <?php if(session('error')): ?>
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "<?php echo e(session('error')); ?>",
                        icon: "error"
                    });
                });
            </script>
            <?php endif; ?>
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Remunerações</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row g-4 mb-3">
                                <div class="col-sm-auto">
                                    <div>
                                        <button type="button" class="btn btn-success add-btn" data-bs-toggle="modal" data-bs-target="#addRemuneracaoModal"><i class="ri-add-line align-bottom me-1"></i> Nova Remuneração</button>
                                    </div>
                                </div>
                                <div class="col-sm">
                                    <form action="<?php echo e(route('remuneracoes.index')); ?>" method="GET" class="d-flex justify-content-sm-end gap-2">
                                        <div class="search-box me-2">
                                            <input type="text" name="descricao" class="form-control" placeholder="Buscar por descricao..." value="<?php echo e(request('descricao')); ?>">
                                            <i class="ri-search-line search-icon"></i>
                                        </div>
                                        
                                        <div class="me-2">
                                            <select name="estado" class="form-select">
                                                <option value="">Estado</option>
                                                <option value="Ativo" <?php echo e(request('estado') == 'Ativo' ? 'selected' : ''); ?>>Ativo</option>
                                                <option value="Inativo" <?php echo e(request('estado') == 'Inativo' ? 'selected' : ''); ?>>Inativo</option>
                                            </select>
                                        </div>
                                        <div class="ms-2">
                                            <button type="submit" class="btn btn-primary">Filtrar</button>
                                            <a href="<?php echo e(route('remuneracoes.index')); ?>" class="btn btn-light">Limpar</a>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">ID</th>
                                            <th scope="col">Tipo/Classe</th>
                                            <th scope="col">Descrição</th>
                                            <th scope="col">Valor</th>
                                            <th scope="col">Observação</th>
                                            <th scope="col">Estado</th>
                                            <th scope="col">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $remuneracoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remuneracao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($remuneracao->id); ?></td>
                                            <td><?php echo e($remuneracao->tipo); ?></td>
                                            <td><?php echo e($remuneracao->descricao); ?></td>
                                            <td><?php echo e(number_format($remuneracao->valor, 2, ',', '.')); ?></td>
                                            <td><?php echo e($remuneracao->observacao); ?></td>
                                            
                                            <td>
                                                <?php if($remuneracao->status == 'Ativo'): ?>
                                                <span class="badge bg-success">Ativo</span>
                                                <?php else: ?>
                                                <span class="badge bg-danger">Inativo</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="dropdown-custom-wrapper">
                                                    <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="ri-more-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('remuneracoes.toggle-status', $remuneracao->id)); ?>">
                                                                <?php if($remuneracao->status == 'Ativo'): ?>
                                                                <i class="ri-lock-fill text-warning align-bottom me-2"></i> Desativar
                                                                <?php else: ?>
                                                                <i class="ri-lock-unlock-fill text-success align-bottom me-2"></i> Ativar
                                                                <?php endif; ?>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item delete-item" href="#" data-id="<?php echo e($remuneracao->id); ?>" data-nome="<?php echo e($remuneracao->descricao); ?>"><i class="ri-delete-bin-fill text-danger align-bottom me-2"></i> Excluir</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="9" class="text-center">Nenhuma remuneração encontrada</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                <?php echo e($remuneracoes->links()); ?>

                            </div>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de remuneracao (será acionado via JavaScript) -->
    <form id="delete-form" method="POST" style="display: none;">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>

    <!-- Modal para adicionar Remuneração -->
    <div class="modal fade" id="addRemuneracaoModal" tabindex="-1" aria-labelledby="addRemuneracaoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="addRemuneracaoModalLabel">Adicionar Remuneração</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('remuneracoes.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="tipo" class="form-label">Tipo/Classe <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="tipo" name="tipo" required maxlength="255" placeholder="Ex.: Salário Base, Subsídio, Bónus">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="valor" class="form-label">Valor <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="valor" name="valor" required min="0" step="0.01" placeholder="0,00">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="descricao" class="form-label">Descrição <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="descricao" name="descricao" required maxlength="1000" rows="3" placeholder="Descreva a remuneração"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="status" class="form-label">Estado <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="Ativo" selected>Ativo</option>
                                        <option value="Inativo">Inativo</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="mb-3">
                                    <label for="observacao" class="form-label">Observação</label>
                                    <textarea class="form-control" id="observacao" name="observacao" maxlength="1000" rows="3" placeholder="Observações (opcional)"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="tipoDocumento" class="form-label">Tipo de Documento <span class="text-danger">*</span></label>
                                    <select class="form-select" id="tipoDocumento" name="tipoDocumento" required>
                                        <option value="">Selecione o tipo</option>
                                        <option value="BI">Bilhete de Identidade</option>
                                        <option value="Passaporte">Passaporte</option>
                                        <option value="Carta de Condução">Carta de Condução</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="numeroColaborador" class="form-label">Número do Colaborador</label>
                                    <input type="text" class="form-control" id="numeroColaborador" name="numeroColaborador" maxlength="50" placeholder="Número interno do colaborador">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="telefone" class="form-label">Telefone <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" id="telefone" name="telefone" required maxlength="20" placeholder="+244 XXX XXX XXX">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" id="email" name="email" required maxlength="255" placeholder="email@exemplo.com">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="id_departamento" class="form-label">Departamento <span class="text-danger">*</span></label>
                                    <select class="form-select" id="id_departamento" name="id_departamento" required>
                                        <option value="">Selecione o departamento</option>
                                        
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="id_funcao" class="form-label">Função <span class="text-danger">*</span></label>
                                    <select class="form-select" id="id_funcao" name="id_funcao" required>
                                        <option value="">Selecione a função</option>
                                        
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="id_grupo_pessoal" class="form-label">Grupo Pessoal <span class="text-danger">*</span></label>
                                    <select class="form-select" id="id_grupo_pessoal" name="id_grupo_pessoal" required>
                                        <option value="">Selecione o grupo</option>
                                        
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">Verificação do Documento</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="checkDocumento" name="checkDocumento" value="1">
                                        <label class="form-check-label" for="checkDocumento">Documento Verificado</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">Verificação do Telefone</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="checkTelefone" name="checkTelefone" value="1">
                                        <label class="form-check-label" for="checkTelefone">Telefone Verificado</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success"><i class="ri-save-line me-1"></i> Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Configuração dos botões de exclusão
            document.querySelectorAll('.delete-item').forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const nome = this.getAttribute('data-nome');

                    Swal.fire({
                        title: "Tem certeza?",
                        text: `Você está prestes a excluir a remuneração "${nome}". Esta ação não pode ser revertida!`,
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#d33",
                        cancelButtonColor: "#3085d6",
                        confirmButtonText: "Sim, excluir!",
                        cancelButtonText: "Cancelar"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = `<?php echo e(url('remuneracoes')); ?>/${id}`;
                            form.submit();
                        }
                    });
                });
            });
        });
    </script>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        const removeById = (id) => {
          const el = document.getElementById(id);
          if (el) {
            const row = el.closest('.row');
            if (row) row.remove();
          }
        };
        // Remove blocos herdados de funcionário que não se aplicam à Remuneração
        removeById('tipoDocumento');       // também remove a linha com número do colaborador
        removeById('telefone');            // também remove a linha com email
        removeById('id_departamento');     // também remove função e grupo pessoal
        removeById('checkDocumento');      // também remove a linha com verificação de telefone
      });
    </script>

</div>
<!-- end main content-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Administracao/Remuneracao.blade.php ENDPATH**/ ?>