<?php $__env->startSection('Conteudo'); ?>
<div class="main-content"><div class="page-content"><div class="container-fluid">
<div class="row"><div class="col-12"><div class="page-title-box">
<h4>Detalhes do Processamento - <?php echo e($processamento->periodoReferencia); ?></h4>
<a href="<?php echo e(route('processamento-salarios.index')); ?>" class="btn btn-secondary btn-sm">Voltar</a>
</div></div></div>

<div class="row mb-3">
<div class="col-md-3"><div class="card"><div class="card-body text-center">
<h6>Descrição</h6><p><?php echo e($processamento->descricao); ?></p></div></div></div>
<div class="col-md-2"><div class="card"><div class="card-body text-center">
<h6>Funcionários</h6><h4><?php echo e($processamento->quantidadeFuncionarios()); ?></h4></div></div></div>
<div class="col-md-2"><div class="card"><div class="card-body text-center">
<h6>Total</h6><h4><?php echo e(number_format($processamento->totalSalarios(),2,',','.')); ?> Kz</h4></div></div></div>
<div class="col-md-2"><div class="card"><div class="card-body text-center">
<h6>Status</h6><span class="badge bg-<?php echo e($processamento->status=='Concluído'?'success':'warning'); ?>"><?php echo e($processamento->status); ?></span>
</div></div></div>
<?php
$enviados = $processamento->salariosProcessados->where('status_envio_email', 'Enviado')->count();
$falhados = $processamento->salariosProcessados->where('status_envio_email', 'Falhou')->count();
$semEmail = $processamento->salariosProcessados->where('status_envio_email', 'Sem Email')->count();
?>
<div class="col-md-3"><div class="card border-success"><div class="card-body text-center">
<h6 class="text-success"><i class="ri-mail-check-line"></i> E-mails Enviados</h6>
<h4 class="text-success"><?php echo e($enviados); ?></h4>
<?php if($falhados > 0): ?><small class="text-danger"><?php echo e($falhados); ?> falharam</small><?php endif; ?>
<?php if($semEmail > 0): ?><small class="text-muted d-block"><?php echo e($semEmail); ?> sem e-mail</small><?php endif; ?>
</div></div></div>
</div>

<div class="card"><div class="card-header d-flex justify-content-between align-items-center">
<h5 class="mb-0">Salários Processados</h5>
<div>
<?php
$semEmailCadastrado = $processamento->salariosProcessados->filter(fn($s) => !$s->email_funcionario || $s->email_funcionario == '')->count();
$pendentes = $processamento->salariosProcessados->filter(fn($s) => 
    in_array($s->status_envio_email, ['Pendente', 'Falhou', 'Sem Email']) && 
    $s->email_funcionario && 
    filter_var($s->email_funcionario, FILTER_VALIDATE_EMAIL)
)->count();
?>
<?php if($semEmailCadastrado > 0): ?>
<form method="POST" action="<?php echo e(route('processamento-salarios.sincronizar-emails',$processamento->id)); ?>" id="formSincronizar" style="display:inline;">
<?php echo csrf_field(); ?>
<button type="button" class="btn btn-info btn-sm me-2" title="Buscar e-mails dos funcionários no cadastro" onclick="confirmarSincronizacao(<?php echo e($semEmailCadastrado); ?>)">
<i class="ri-refresh-line me-1"></i>Sincronizar E-mails (<?php echo e($semEmailCadastrado); ?>)</button>
</form>
<?php endif; ?>
<?php if($pendentes > 0): ?>
<form method="POST" action="<?php echo e(route('processamento-salarios.reenviar-todos-emails',$processamento->id)); ?>" id="formReenviarTodos" style="display:inline;">
<?php echo csrf_field(); ?>
<button type="button" class="btn btn-primary btn-sm me-2" onclick="confirmarReenvioTodos(<?php echo e($pendentes); ?>)">
<i class="ri-mail-send-line me-1"></i>Reenviar Todos (<?php echo e($pendentes); ?>)</button>
</form>
<?php endif; ?>
<a href="<?php echo e(route('processamento-salarios.exportar-pdf-geral',$processamento->id)); ?>" class="btn btn-danger btn-sm">
<i class="ri-file-pdf-line me-1"></i>Exportar PDF Geral</a>
</div>
</div><div class="card-body"><div class="table-responsive"><table class="table table-hover table-sm">
<thead style="background-color:rgb(64,81,137);color:white;font-size:0.8rem">
<tr><th>NBI</th><th>Nome</th><th>Função</th><th>Salário Base</th><th>Subsídios</th><th>Abono Extra</th><th>Descontos</th><th>Total Líquido</th><th>Status E-mail</th><th>Ações</th></tr>
</thead><tbody style="font-size:0.8rem">
<?php $__currentLoopData = $processamento->salariosProcessados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr><td><?php echo e($sal->nbi); ?></td><td><?php echo e($sal->nomeTrabalhador); ?></td><td><?php echo e($sal->funcao); ?></td>
<td class="text-end"><?php echo e(number_format($sal->salarioBase,2,',','.')); ?></td>
<td class="text-end"><?php echo e(number_format($sal->subTransporte+$sal->subAlimentacao+$sal->subFerias+$sal->subOutros+$sal->abonoFamiliar,2,',','.')); ?></td>
<td class="text-end text-success"><?php echo e($sal->acrescimoExtra > 0 ? '+'.number_format($sal->acrescimoExtra,2,',','.') : '-'); ?></td>
<td class="text-end text-danger"><?php echo e(number_format($sal->desconto,2,',','.')); ?></td>
<td class="text-end fw-bold"><?php echo e(number_format($sal->total,2,',','.')); ?></td>
<td>
<?php if($sal->status_envio_email == 'Enviado'): ?>
<span class="badge bg-success" title="Enviado em <?php echo e($sal->data_envio_email ? $sal->data_envio_email->format('d/m/Y H:i') : ''); ?>"><i class="ri-mail-check-line"></i> Enviado</span>
<?php elseif($sal->status_envio_email == 'Falhou'): ?>
<span class="badge bg-danger" title="Erro: <?php echo e($sal->erro_envio_email); ?>"><i class="ri-mail-close-line"></i> Falhou</span>
<?php elseif($sal->status_envio_email == 'Sem Email'): ?>
<span class="badge bg-secondary" title="Funcionário sem e-mail cadastrado"><i class="ri-mail-line"></i> Sem E-mail</span>
<?php else: ?>
<span class="badge bg-warning" title="Aguardando envio"><i class="ri-time-line"></i> Pendente</span>
<?php endif; ?>
</td>
<td>
<a href="<?php echo e(route('processamento-salarios.recibo-individual',[$processamento->id,$sal->id])); ?>" class="btn btn-sm btn-outline-danger" title="Baixar Recibo">
<i class="ri-file-pdf-line"></i></a>
<?php if(in_array($sal->status_envio_email, ['Pendente', 'Falhou', 'Sem Email']) && $sal->email_funcionario): ?>
<form method="POST" action="<?php echo e(route('processamento-salarios.reenviar-email',[$processamento->id,$sal->id])); ?>" id="formReenviar<?php echo e($sal->id); ?>" style="display:inline;">
<?php echo csrf_field(); ?>
<button type="button" class="btn btn-sm btn-outline-primary" title="Reenviar E-mail" 
onclick="confirmarReenvioIndividual('<?php echo e($sal->nomeTrabalhador); ?>', '<?php echo e($sal->email_funcionario); ?>', <?php echo e($sal->id); ?>)">
<i class="ri-mail-send-line"></i></button>
</form>
<?php endif; ?>
</td>
</tr><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<tr style="background-color:#f8f9fa;font-weight:bold"><td colspan="7" class="text-end">TOTAL GERAL:</td>
<td class="text-end"><?php echo e(number_format($processamento->totalSalarios(),2,',','.')); ?> Kz</td><td></td><td></td></tr>
</tbody></table></div></div></div>
</div></div></div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
// Confirmar sincronização de e-mails
function confirmarSincronizacao(quantidade) {
    Swal.fire({
        title: '🔄 Sincronizar E-mails?',
        html: `
            <div style="text-align: left;">
                <p>Esta ação irá buscar os e-mails atualizados dos <strong>${quantidade} funcionário(s)</strong> no cadastro.</p>
                <ul style="margin-top: 15px;">
                    <li>Busca e-mail por NBI</li>
                    <li>Atualiza registros automaticamente</li>
                    <li>Marca como "Pendente" para envio</li>
                </ul>
            </div>
        `,
        icon: 'info',
        showCancelButton: true,
        confirmButtonColor: '#0dcaf0',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="ri-refresh-line me-1"></i>Sincronizar',
        cancelButtonText: 'Cancelar',
        width: '500px'
    }).then((result) => {
        if (result.isConfirmed) {
            document.getElementById('formSincronizar').submit();
        }
    });
}

// Confirmar reenvio em massa
function confirmarReenvioTodos(quantidade) {
    Swal.fire({
        title: '📧 Reenviar E-mails em Massa?',
        html: `
            <div style="text-align: left;">
                <p>Serão reenviados <strong>${quantidade} e-mail(s)</strong> com recibo em PDF anexado.</p>
                <div style="background: #fff3cd; padding: 10px; border-radius: 5px; margin-top: 15px;">
                    <strong style="color: #856404;">⚠️ Atenção:</strong>
                    <ul style="margin: 5px 0 0 20px; color: #856404;">
                        <li>Status: Pendente, Falhou ou Sem E-mail</li>
                        <li>Apenas funcionários com e-mail válido</li>
                    </ul>
                </div>
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="ri-mail-send-line me-1"></i>Reenviar Todos',
        cancelButtonText: 'Cancelar',
        width: '550px'
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar loading
            Swal.fire({
                title: 'Reenviando E-mails...',
                html: 'Por favor, aguarde. Este processo pode levar alguns segundos.',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            document.getElementById('formReenviarTodos').submit();
        }
    });
}

// Confirmar reenvio individual
function confirmarReenvioIndividual(nome, email, id) {
    Swal.fire({
        title: '📧 Reenviar Recibo?',
        html: `
            <div style="text-align: left;">
                <p>Reenviar recibo de salário para:</p>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 15px 0;">
                    <p style="margin: 5px 0;"><strong>Funcionário:</strong> ${nome}</p>
                    <p style="margin: 5px 0;"><strong>E-mail:</strong> <span style="color: #0d6efd;">${email}</span></p>
                </div>
                <p style="font-size: 0.9em; color: #6c757d;">
                    <i class="ri-attachment-line"></i> O recibo em PDF será anexado automaticamente.
                </p>
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="ri-mail-send-line me-1"></i>Reenviar',
        cancelButtonText: 'Cancelar',
        width: '500px'
    }).then((result) => {
        if (result.isConfirmed) {
            document.getElementById('formReenviar' + id).submit();
        }
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Administracao/DetalheProcessamentoSalario.blade.php ENDPATH**/ ?>