<?php $__env->startSection('Conteudo'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Título da página -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">
                            <i class="ri-file-list-3-line label-icon align-middle fs-16 ms-2"></i> 
                            MEUS PROJECTOS
                        </h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('homePromotor')); ?>">Página Principal</a></li>
                                <li class="breadcrumb-item active">Meus Projectos</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mensagens de alerta -->
            <?php if(@session('msg')): ?>



            <script>
                document.addEventListener('DOMContentLoaded', () => {

                    Swal.fire({
                        title: "Pronto!",
                        text: "<?php echo e(session('msg')); ?>",
                        icon: "success"
                    });
                });

            </script>

            <!-- Mensagens do sistema -->

        <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="ri-error-warning-line me-2"></i>
                    <?php echo e($errors->first()); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Botão para criar novo projeto -->
            <div class="row mb-3">
                <div class="col-12">
                    <div class="d-flex justify-content-end">
                        <a href="<?php echo e(route('Criar-Projecto')); ?>" class="btn btn-primary">
                            <i class="ri-add-line me-1"></i>
                            Novo Projecto
                        </a>
                    </div>
                </div>
            </div>

            <!-- Área de Filtros -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-filter-3-line me-2"></i>
                                Filtros de Projectos
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label">Buscar por Nome</label>
                                    <input type="text" class="form-control" id="filtroNome" placeholder="Digite o nome do projecto...">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Tipo de Projecto</label>
                                    <select class="form-select" id="filtroTipo">
                                        <option value="">Todos os tipos</option>
                                        <?php $__currentLoopData = $projetos->pluck('tipoProjecto')->unique()->filter(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($tipo->descricao); ?>"><?php echo e($tipo->descricao); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Data de Criação</label>
                                    <input type="date" class="form-control" id="filtroData">
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-flex gap-2">
                                        <button type="button" class="btn btn-outline-secondary" onclick="limparFiltros()">
                                            <i class="ri-refresh-line"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

           

            <!-- Separadores por Fases -->
            <div class="row mb-3">
                <div class="col-12">
                    <ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist" style="background-color:rgb(213, 214, 215);">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" data-bs-toggle="tab" href="#todos" role="tab" onclick="filtrarPorFase('')">
                                <i class="ri-file-list-3-line me-1"></i>
                                Todos <span class="badge bg-light text-dark ms-1" id="count-todos"><?php echo e($projetos->count()); ?></span>
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" data-bs-toggle="tab" href="#recebido" role="tab" onclick="filtrarPorFase('0')">
                                <i class="ri-inbox-line me-1"></i>
                                Recebido <span class="badge bg-secondary ms-1" id="count-recebido"><?php echo e($projetos->where('status', '0')->count()); ?></span>
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" data-bs-toggle="tab" href="#analise" role="tab" onclick="filtrarPorFase('1')">
                                <i class="ri-search-eye-line me-1"></i>
                                Em Análise <span class="badge bg-info ms-1" id="count-analise"><?php echo e($projetos->where('status', '1')->count()); ?></span>
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" data-bs-toggle="tab" href="#aprovado" role="tab" onclick="filtrarPorFase('2')">
                                <i class="ri-check-line me-1"></i>
                                Aprovado <span class="badge bg-primary ms-1" id="count-aprovado"><?php echo e($projetos->where('status', '2')->count()); ?></span>
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" data-bs-toggle="tab" href="#rejeitado" role="tab" onclick="filtrarPorFase('3')">
                                <i class="ri-close-line me-1"></i>
                                Rejeitado <span class="badge bg-danger ms-1" id="count-rejeitado"><?php echo e($projetos->where('status', '3')->count()); ?></span>
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" data-bs-toggle="tab" href="#execucao" role="tab" onclick="filtrarPorFase('4')">
                                <i class="ri-play-line me-1"></i>
                                Em Execução <span class="badge bg-warning ms-1" id="count-execucao"><?php echo e($projetos->where('status', '4')->count()); ?></span>
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" data-bs-toggle="tab" href="#concluido" role="tab" onclick="filtrarPorFase('5')">
                                <i class="ri-check-double-line me-1"></i>
                                Concluído <span class="badge bg-success ms-1" id="count-concluido"><?php echo e($projetos->where('status', '5')->count()); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Lista de projetos -->
            <div class="row" id="listaProjetos">
                <?php $__empty_1 = true; $__currentLoopData = $projetos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projeto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-xxl-4 col-lg-6 mb-3 mb-lg-4 projeto-item" 
                         data-status="<?php echo e($projeto->status); ?>" 
                         data-nome="<?php echo e(strtolower($projeto->nomeProjecto)); ?>" 
                         data-tipo="<?php echo e($projeto->tipoProjecto->descricao ?? ''); ?>" 
                         data-data="<?php echo e($projeto->created_at->format('Y-m-d')); ?>">
                        <div class="card card-height-100 shadow-sm border-0">
                            <div class="card-header border-0 pb-0">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h5 class="card-title mb-1 limit-text" title="<?php echo e($projeto->nomeProjecto); ?>">
                                            <?php echo e($projeto->nomeProjecto); ?>

                                        </h5>                                        
                                        
                                        <p class="text-muted mb-0">
                                            <small class="text-white"><?php echo e($projeto->tipoProjecto->descricao ?? 'N/A'); ?></small>                                                                                  
                                        </p>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <?php switch($projeto->status):
                                            case ('0'): ?>
                                                <span class="badge bg-secondary">Recebido</span>
                                                <?php break; ?>
                                            <?php case ('1'): ?>
                                                <span class="badge bg-info">Em Análise</span>
                                                <?php break; ?>
                                            <?php case ('2'): ?>
                                                <span class="badge bg-primary">Aprovado</span>
                                                <?php break; ?>
                                            <?php case ('3'): ?>
                                                <span class="badge bg-danger">Rejeitado</span>
                                                <?php break; ?>
                                            <?php case ('4'): ?>
                                                <span class="badge bg-warning">Em Execução</span>
                                                <?php break; ?>
                                            <?php case ('5'): ?>
                                                <span class="badge bg-success">Concluído</span>
                                                <?php break; ?>
                                            <?php default: ?>
                                                <span class="badge bg-dark">Indefinido</span>
                                        <?php endswitch; ?>
                                    </div>

                                    
                                </div>
                            </div>
                            
                            <div class="card-body pt-2">
                                <div class="row g-2 mb-3">
                                    <div class="col-12">
                                        <div class="p-2 bg-light rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Código do Projecto:</h6>
                                            <p class="mb-0 fw-medium">
                                                <?php echo e(($projeto->codProjecto)); ?>

                                            </p>
                                        </div>
                                    </div>
                                    
                                </div>
                                <div class="row g-2 mb-3">
                                    <div class="col-6">
                                        <div class="p-2 bg-light rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Custo Total do Projeto</h6>
                                            <p class="mb-0 fw-medium">
                                                <?php echo e(number_format($projeto->limiteorcamentalP, 2, ',', '.')); ?> AOA
                                            </p>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="p-2 bg-light rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Beneficiários</h6>
                                            <p class="mb-0 fw-medium"><?php echo e(number_format($projeto->beneficiarioDP)); ?></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row g-2 mb-3">
                                    <div class="col-6">
                                        <div class="p-2 bg-light rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Cronogramas Físicos das Atividades</h6>
                                            <p class="mb-0 fw-medium"><?php echo e($projeto->cronogramasFisicos->count()); ?></p>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="p-2 bg-light rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Programações Financeiras</h6>
                                            <p class="mb-0 fw-medium"><?php echo e($projeto->programacoesFinanceiras->count()); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-3">
                                    <div class="col-12">
                                        <div class="p-2 bg-light rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Gestor Responsável</h6>
                                            <p class="mb-0 fw-medium">
                                                <?php echo e(($projeto->adminResponsavel->name ?? 'Por Definir')); ?>

                                            </p>
                                        </div>
                                    </div>
                                    
                                </div>

                                <!-- valor desembolsado/financiado -->
                                <?php if($projeto->pagamentos->count() > 0): ?>
                                <div class="row g-2 mb-3">
                                    <div class="col-12">
                                        <div class="p-2 bg-success-subtle rounded">
                                            <h6 class="mb-1 fs-12 text-muted">Valor Desembolsado/Financiado</h6>
                                            <p class="mb-0 fw-medium">
                                                <?php echo e(number_format($projeto->pagamentos->sum('valor'), 2, ',', ' ')); ?> (Kz)
                                            </p>
                                        </div>
                                    </div>
                                    
                                </div>
                                <!-- valor desembolsado/financiado -->

                                <?php endif; ?>
                                
                                <div class="mb-3">
                                    <h6 class="fs-12 text-muted mb-1">Período</h6>
                                    <p class="mb-0">
                                        <small>
                                            <?php echo e(date('d/m/Y', strtotime($projeto->duracaoP))); ?> até 
                                            <?php echo e(date('d/m/Y', strtotime($projeto->duracaoF))); ?>

                                        </small>
                                    </p>
                                </div>

                                <div class="mb-3">
                                    <h6 class="fs-12 text-muted mb-1">Localização</h6>
                                    <p class="mb-0 limit-text" title="<?php echo e($projeto->localizacao_projecto); ?>">
                                        <small><?php echo e($projeto->localizacao_projecto); ?></small>
                                    </p>
                                </div>
                            </div>

                            <div class="card-footer bg-transparent border-top">
                                <div class="d-flex gap-2">
                                    <a href="<?php echo e(route('projetos.show', $projeto->id)); ?>" class="btn btn-soft-primary btn-sm flex-fill">
                                        <i class="ri-eye-line me-1"></i>
                                        Ver Detalhes
                                    </a>
                                    <a href="<?php echo e(route('projetos.edit', $projeto->id)); ?>" class="btn btn-soft-warning btn-sm flex-fill">
                                        <i class="ri-edit-line me-1"></i>
                                        Editar
                                    </a>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-soft-success btn-sm dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false" title="Opções PDF">
                                            <i class="ri-file-pdf-line"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('projetos.visualizar-pdf', $projeto->id)); ?>" target="_blank">
                                                    <i class="ri-eye-line me-2"></i>
                                                    Visualizar
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('projetos.exportar-pdf', $projeto->id)); ?>">
                                                    <i class="ri-download-line me-2"></i>
                                                    Baixar
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <button type="button" class="btn btn-soft-danger btn-sm" onclick="confirmarExclusao(<?php echo e($projeto->id); ?>)">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body text-center py-5">
                                <div class="mb-4">
                                    <i class="ri-folder-open-line display-4 text-muted"></i>
                                </div>
                                <h5 class="mb-3">Nenhum projeto encontrado</h5>
                                <p class="text-muted mb-4">Você ainda não criou nenhum projeto. Comece criando seu primeiro projeto.</p>
                                <a href="<?php echo e(route('Criar-Projecto')); ?>" class="btn btn-primary">
                                    <i class="ri-add-line me-1"></i>
                                    Criar Primeiro Projeto
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- Paginação (se necessário) -->
           
            
       
                <?php endif; ?>
                
            </div>

            
        </div>
    </div>
</div>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="modalExcluir" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirmar Exclusão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <i class="ri-delete-bin-line display-4 text-danger mb-3"></i>
                    <h5>Tem certeza que deseja excluir este projeto?</h5>
                    <p class="text-muted">Esta ação não poderá ser desfeita.</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <form id="formExcluir" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Sim, Excluir</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmarExclusao(projetoId) {
    const form = document.getElementById('formExcluir');
    form.action = `/projetos/${projetoId}`;
    
    const modal = new bootstrap.Modal(document.getElementById('modalExcluir'));
    modal.show();
}

// Variáveis para armazenar o filtro de fase ativo
let filtroFaseAtivo = '';

// Função para filtrar projetos por fase
function filtrarPorFase(status) {
    filtroFaseAtivo = status;
    aplicarFiltros();
}

// Função para aplicar todos os filtros
function aplicarFiltros() {
    const filtroNome = document.getElementById('filtroNome').value.toLowerCase();
    const filtroTipo = document.getElementById('filtroTipo').value;
    const filtroData = document.getElementById('filtroData').value;
    
    const projetos = document.querySelectorAll('.projeto-item');
    let contadores = {
        todos: 0,
        '0': 0, // Recebido
        '1': 0, // Em Análise
        '2': 0, // Aprovado
        '3': 0, // Rejeitado
        '4': 0, // Em Execução
        '5': 0  // Concluído
    };
    
    projetos.forEach(projeto => {
        const status = projeto.getAttribute('data-status');
        const nome = projeto.getAttribute('data-nome');
        const tipo = projeto.getAttribute('data-tipo');
        const data = projeto.getAttribute('data-data');
        
        let mostrar = true;
        
        // Filtro por fase
        if (filtroFaseAtivo !== '' && status !== filtroFaseAtivo) {
            mostrar = false;
        }
        
        // Filtro por nome
        if (filtroNome && !nome.includes(filtroNome)) {
            mostrar = false;
        }
        
        // Filtro por tipo
        if (filtroTipo && tipo !== filtroTipo) {
            mostrar = false;
        }
        
        // Filtro por data
        if (filtroData && data !== filtroData) {
            mostrar = false;
        }
        
        // Mostrar ou ocultar o projeto
        if (mostrar) {
            projeto.style.display = 'block';
            contadores.todos++;
            if (contadores.hasOwnProperty(status)) {
                contadores[status]++;
            }
        } else {
            projeto.style.display = 'none';
        }
    });
    
    // Atualizar contadores nas abas (apenas se não há filtros de texto ativos)
    if (!filtroNome && !filtroTipo && !filtroData) {
        atualizarContadores(contadores);
    }
    
    // Verificar se há projetos visíveis
    verificarProjetosVisiveis();
}

// Função para actualizar os contadores nas abas
function atualizarContadores(contadores) {
    document.getElementById('count-todos').textContent = contadores.todos;
    document.getElementById('count-recebido').textContent = contadores['0'];
    document.getElementById('count-analise').textContent = contadores['1'];
    document.getElementById('count-aprovado').textContent = contadores['2'];
    document.getElementById('count-rejeitado').textContent = contadores['3'];
    document.getElementById('count-execucao').textContent = contadores['4'];
    document.getElementById('count-concluido').textContent = contadores['5'];
}

// Função para verificar se há projetos visíveis e mostrar mensagem adequada
function verificarProjetosVisiveis() {
    const projetosVisiveis = document.querySelectorAll('.projeto-item[style*="display: block"], .projeto-item:not([style*="display: none"])');
    const mensagemVazia = document.querySelector('.col-12 .card .card-body.text-center');
    
    if (projetosVisiveis.length === 0) {
        // Se não há mensagem vazia, criar uma
        if (!mensagemVazia) {
            const listaProjetos = document.getElementById('listaProjetos');
            const divVazia = document.createElement('div');
            divVazia.className = 'col-12';
            divVazia.id = 'mensagem-vazia';
            divVazia.innerHTML = `
                <div class="card">
                    <div class="card-body text-center py-5">
                        <div class="mb-4">
                            <i class="ri-search-line display-4 text-muted"></i>
                        </div>
                        <h5 class="mb-3">Nenhum projeto encontrado</h5>
                        <p class="text-muted mb-4">Nenhum projeto corresponde aos filtros aplicados. Tente ajustar os critérios de busca.</p>
                    </div>
                </div>
            `;
            listaProjetos.appendChild(divVazia);
        }
    } else {
        // Remover mensagem vazia se existir
        const mensagemVaziaDiv = document.getElementById('mensagem-vazia');
        if (mensagemVaziaDiv) {
            mensagemVaziaDiv.remove();
        }
    }
}

// Função para limpar todos os filtros
function limparFiltros() {
    document.getElementById('filtroNome').value = '';
    document.getElementById('filtroTipo').value = '';
    document.getElementById('filtroData').value = '';
    filtroFaseAtivo = '';
    
    // Reativar aba "Todos"
    document.querySelector('.nav-link.active').classList.remove('active');
    document.querySelector('a[onclick="filtrarPorFase(\'\')"]').classList.add('active');
    
    aplicarFiltros();
}

// Event listeners para filtros em tempo real
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('filtroNome').addEventListener('input', aplicarFiltros);
    document.getElementById('filtroTipo').addEventListener('change', aplicarFiltros);
    document.getElementById('filtroData').addEventListener('change', aplicarFiltros);
});
</script>

<style>
.card-height-100 {
    height: 100%;
}

.limit-text {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 250px;
}

.card {
    transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1) !important;
}

/* Estilos para os filtros */
.nav-tabs-custom .nav-link {
    position: relative;
    padding: 12px 20px;
    border: none;
    background: transparent;
    color: #6c757d;
    font-weight: 500;
    transition: all 0.3s ease;
}

.nav-tabs-custom .nav-link:hover,
.nav-tabs-custom .nav-link.active {
    color: #495057;
    background-color: #f8f9fa;
    border-bottom: 2px solid #405189;
}

.nav-tabs-custom .nav-link .badge {
    font-size: 0.7rem;
    font-weight: 600;
}

/* Animação para projetos filtrados */
.projeto-item {
    transition: opacity 0.3s ease, transform 0.3s ease;
}

.projeto-item[style*="display: none"] {
    opacity: 0;
    transform: scale(0.95);
}

/* Estilos para a área de filtros */
.card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 0.375rem 0.375rem 0 0 !important;
}

.card-header .card-title {
    color: white;
    margin-bottom: 0;
}

/* Responsividade para filtros */
@media (max-width: 768px) {
    .nav-tabs-custom {
        flex-wrap: wrap;
    }
    
    .nav-tabs-custom .nav-link {
        font-size: 0.875rem;
        padding: 8px 12px;
    }
    
    .nav-tabs-custom .nav-link .badge {
        font-size: 0.65rem;
    }
}

/* Destaque para filtros ativos */
.form-control:focus,
.form-select:focus {
    border-color: #405189;
    box-shadow: 0 0 0 0.2rem rgba(64, 81, 137, 0.25);
}

/* Indicação visual de filtros aplicados */
.form-control:not(:placeholder-shown),
.form-select option:checked {
    background-color: #f8f9fa;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseCliente', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Clientes/ListarProjectos.blade.php ENDPATH**/ ?>