<?php $__env->startSection('Conteudo'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Página Principal</a></li>
                                <li class="breadcrumb-item active">Gestão de Desembolso</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            <?php if(session('success')): ?>
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "<?php echo e(session('success')); ?>",
                        icon: "success"
                    });
                });
            </script>
            <?php endif; ?>

            <?php if(session('error')): ?>
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "<?php echo e(session('error')); ?>",
                        icon: "error"
                    });
                });
            </script>
            <?php endif; ?>
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                
                <div class="col-lg-12">
                    
                    <!-- Resumo/Dashboard -->
            <div class="row mb-2">
                <div class="col-md-4">
                    <div class="card border-primary dashboard-card">
                        <i class="ri-funds-line card-icon text-primary"></i>
                        <div class="card-body text-center">
                            <h6 class="card-subtitle text-primary"><i class="ri-arrow-up-line"></i> Total Orçamentado</h6>
                            <h3 class="card-title mt-2 count-up"><?php echo e(number_format($totalProjetosExecucao, 2, ',', '.')); ?> Kz</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-success dashboard-card">
                        <i class="ri-money-dollar-circle-line card-icon text-success"></i>
                        <div class="card-body text-center">
                            <h6 class="card-subtitle text-success"><i class="ri-check-line"></i> Total Desembolsado</h6>
                            <h3 class="card-title mt-2 count-up"><?php echo e(number_format($totalPago, 2, ',', '.')); ?> Kz</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-danger dashboard-card">
                        <i class="ri-alarm-warning-line card-icon text-danger"></i>
                        <div class="card-body text-center">
                            <h6 class="card-subtitle text-danger"><i class="ri-arrow-down-line"></i> Total por Desembolsar</h6>
                            <h3 class="card-title mt-2 count-up"><?php echo e(number_format($totalProjetosExecucao - $totalPago, 2, ',', '.')); ?> Kz</h3>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Fim Resumo/Dashboard -->
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Ponto de Situação dos Desembolsos no Período</h4>
                                
                                <!-- Botões de Exportação Geral -->
                                <div class="btn-group">
                                    <!-- Dropdown PDF -->
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="ri-file-pdf-line me-1"></i>PDF Geral
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="<?php echo e(route('admin.desembolso.visualizar-pdf-geral')); ?>" target="_blank">
                                                <i class="ri-eye-line me-2"></i>Visualizar PDF
                                            </a></li>
                                            <li><a class="dropdown-item" href="<?php echo e(route('admin.desembolso.exportar-pdf-geral')); ?>">
                                                <i class="ri-download-line me-2"></i>Baixar PDF
                                            </a></li>
                                        </ul>
                                    </div>
                                    
                                    <!-- Botão Excel -->
                                    <button type="button" class="btn btn-success" onclick="window.location='<?php echo e(route('admin.desembolso.exportar-excel-geral')); ?>'">
                                        <i class="ri-file-excel-line me-1"></i>Excel Geral
                                    </button>
                                </div>
                            </div>
                        </div><!-- end card header -->

                        <div class="card-body">
                            
                            

                            <!-- Accordion por Instituição -->
                            <div class="accordion accordion-border-box" id="accordionInstituicoes">
                                <?php $instituicaoIndex = 0; ?>
                                <?php $__currentLoopData = $projetos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instituicao => $projetosInstituicao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php 
                                        $totalCustoInstituicao = $projetosInstituicao->sum('limiteorcamentalP');
                                        $totalDesembolsadoInstituicao = $projetosInstituicao->sum(function($projeto) { 
                                            return $projeto->valorTotalPago(); 
                                        });
                                        $totalPorDesembolsar = $totalCustoInstituicao - $totalDesembolsadoInstituicao;
                                        $percentualExecucao = $totalCustoInstituicao > 0 ? ($totalDesembolsadoInstituicao / $totalCustoInstituicao) * 100 : 0;
                                        $quantidadeProjetos = $projetosInstituicao->count();
                                    ?>
                                    
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading<?php echo e($instituicaoIndex); ?>">
                                            <button class="accordion-button <?php echo e($instituicaoIndex == 0 ? '' : 'collapsed'); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($instituicaoIndex); ?>" aria-expanded="<?php echo e($instituicaoIndex == 0 ? 'true' : 'false'); ?>" aria-controls="collapse<?php echo e($instituicaoIndex); ?>">
                                                <div class="d-flex justify-content-between w-100 me-3">
                                                    <div class="instituicao-info">
                                                        <strong class="fs-6 text-primary"><?php echo e($instituicao ?? 'Instituição N/A'); ?></strong>
                                                        <div class="mt-1">
                                                            <small class="text-muted">
                                                                <i class="ri-file-list-3-line me-1"></i><?php echo e($quantidadeProjetos); ?> <?php echo e($quantidadeProjetos == 1 ? 'Projeto' : 'Projetos'); ?>

                                                            </small>
                                                        </div>
                                                    </div>
                                                    <div class="custos-info text-end">
                                                        <div class="fw-bold text-success">
                                                            <i class="ri-money-dollar-circle-line me-1"></i><?php echo e(number_format($totalCustoInstituicao, 2, ',', '.')); ?> Kz
                                                        </div>
                                                        <div class="text-muted small">
                                                            <span class="badge bg-<?php echo e($percentualExecucao >= 75 ? 'success' : ($percentualExecucao >= 50 ? 'warning' : 'danger')); ?>">
                                                                <?php echo e(number_format($percentualExecucao, 1, ',', '.')); ?>% Executado
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="collapse<?php echo e($instituicaoIndex); ?>" class="accordion-collapse collapse <?php echo e($instituicaoIndex == 0 ? 'show' : ''); ?>" aria-labelledby="heading<?php echo e($instituicaoIndex); ?>" data-bs-parent="#accordionInstituicoes">
                                            <div class="accordion-body p-0">
                                                <!-- Resumo da Instituição -->
                                                <div class="bg-light p-3 border-bottom">
                                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                                        <h5 class="mb-0 text-primary">
                                                            <i class="ri-building-line me-2"></i>Resumo Financeiro - <?php echo e($instituicao); ?>

                                                        </h5>
                                                        
                                                        <!-- Botões de Exportação por Instituição -->
                                                        <div class="btn-group btn-group-sm">
                                                            <!-- Dropdown PDF -->
                                                            <div class="btn-group btn-group-sm" role="group">
                                                                <button type="button" class="btn btn-outline-danger dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">
                                                                    <i class="ri-file-pdf-line me-1"></i>PDF
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item" href="<?php echo e(route('admin.desembolso.visualizar-pdf-instituicao')); ?>?instituicao=<?php echo e(urlencode($instituicao)); ?>" target="_blank">
                                                                        <i class="ri-eye-line me-2"></i>Visualizar
                                                                    </a></li>
                                                                    <li><a class="dropdown-item" href="<?php echo e(route('admin.desembolso.exportar-pdf-instituicao')); ?>?instituicao=<?php echo e(urlencode($instituicao)); ?>">
                                                                        <i class="ri-download-line me-2"></i>Baixar
                                                                    </a></li>
                                                                </ul>
                                                            </div>
                                                            
                                                            <!-- Botão Excel -->
                                                            <button type="button" class="btn btn-outline-success btn-sm" onclick="window.location='<?php echo e(route('admin.desembolso.exportar-excel-instituicao')); ?>?instituicao=<?php echo e(urlencode($instituicao)); ?>'">
                                                                <i class="ri-file-excel-line me-1"></i>Excel
                                                            </button>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="row text-center">
                                                        <div class="col-md-3">
                                                            <div class="border-end">
                                                                <h6 class="mb-1 text-primary">Custo Total</h6>
                                                                <h5 class="mb-0"><?php echo e(number_format($totalCustoInstituicao, 2, ',', '.')); ?> Kz</h5>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="border-end">
                                                                <h6 class="mb-1 text-success">Desembolsado</h6>
                                                                <h5 class="mb-0"><?php echo e(number_format($totalDesembolsadoInstituicao, 2, ',', '.')); ?> Kz</h5>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="border-end">
                                                                <h6 class="mb-1 text-danger">Por Desembolsar</h6>
                                                                <h5 class="mb-0"><?php echo e(number_format($totalPorDesembolsar, 2, ',', '.')); ?> Kz</h5>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <h6 class="mb-1 text-info">Execução</h6>
                                                            <h5 class="mb-0"><?php echo e(number_format($percentualExecucao, 1, ',', '.')); ?>%</h5>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Tabela de Projetos -->
                                                <div class="table-responsive">
                                                    <table class="table table-hover mb-0">
                                                        <thead style="background-color:rgb(64,81,137); color: white; font-size: 0.74rem; text-align: center; vertical-align: middle">
                                                            <tr>
                                                                <th>Código</th>
                                                                <th style="min-width: 200px;">Designação</th>
                                                                <th>Duração</th>
                                                                <th>Estado</th>
                                                                <th>Localização</th>
                                                                <th>Tipo</th>
                                                                <th>Custo Total (Kz)</th>
                                                                <th>Valor Desembolsado</th>
                                                                <th>Execução (%)</th>
                                                                <th>Por Desembolsar</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody style="font-size: 0.74rem;">
                                                            <?php $__currentLoopData = $projetosInstituicao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projeto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="text-center"><?php echo e($projeto->codProjecto); ?></td>
                                                                <td><?php echo e($projeto->nomeProjecto); ?></td>
                                                                <td class="text-center">
                                                                    <?php echo e(date('Y', strtotime($projeto->duracaoP))); ?> - <?php echo e(date('Y', strtotime($projeto->duracaoF))); ?>

                                                                    <br><small class="text-muted">(<?php echo e((date('Y', strtotime($projeto->duracaoF)) - date('Y', strtotime($projeto->duracaoP)))); ?> anos)</small>
                                                                </td>
                                                                <td class="text-center">
                                                                    <span class="badge bg-<?php echo e(['warning', 'info', 'success', 'danger', 'primary', 'success'][$projeto->status]); ?>">
                                                                        <?php echo e(['Recebido', 'Em Análise', 'Aprovado', 'Rejeitado', 'Em Execução', 'Concluído'][$projeto->status]); ?>

                                                                    </span>
                                                                </td>
                                                                <td class="text-center">
                                                                    <?php echo e($projeto->provincia); ?>

                                                                    <?php if($projeto->localizacao_projecto): ?>
                                                                        <br><small class="text-muted"><?php echo e($projeto->localizacao_projecto); ?></small>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td><?php echo e($projeto->tipoProjecto->descricao ?? 'N/A'); ?></td>
                                                                <td class="text-end"><?php echo e(number_format($projeto->limiteorcamentalP, 2, ',', '.')); ?></td>
                                                                <td class="text-end"><?php echo e(number_format($projeto->valorTotalPago(), 2, ',', '.')); ?></td>
                                                                <td class="text-center">
                                                                    <?php $execucaoProjeto = ($projeto->valorTotalPago() / $projeto->limiteorcamentalP) * 100; ?>
                                                                    <span class="badge bg-<?php echo e($execucaoProjeto >= 75 ? 'success' : ($execucaoProjeto >= 50 ? 'warning' : 'danger')); ?>">
                                                                        <?php echo e(number_format($execucaoProjeto, 1, ',', '.')); ?>%
                                                                    </span>
                                                                </td>
                                                                <td class="text-end"><?php echo e(number_format($projeto->limiteorcamentalP - $projeto->valorTotalPago(), 2, ',', '.')); ?></td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $instituicaoIndex++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <!-- Paginação -->
                            <?php if(isset($projetos) && method_exists($projetos, 'links')): ?>
                                <div class="d-flex justify-content-center mt-4">
                                    <?php echo e($projetos->links()); ?>

                                </div>
                            <?php endif; ?>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

            

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de tipo de projeto (será acionado via JavaScript) -->
    </div>
<!-- end main content-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .dashboard-card {
        transition: all 0.3s ease;
        border-left: 4px solid;
        position: relative;
        overflow: hidden;
    }
    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    .dashboard-card .card-icon {
        position: absolute;
        right: 20px;
        top: 20px;
        font-size: 80px;
        opacity: 0.1;
    }
    .card-subtitle i {
        font-size: 24px;
        vertical-align: middle;
        margin-right: 10px;
    }
    .count-up {
        font-weight: 700;
        font-size: 28px;
    }
    .card-subtitle {
        font-size: 16px;
        margin-bottom: 10px;
    }

    /* Estilos específicos para o accordion */
    .accordion-border-box .accordion-item {
        border: 1px solid #e5e5e5;
        border-radius: 8px;
        margin-bottom: 15px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }
    
    .accordion-border-box .accordion-item:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        transform: translateY(-2px);
    }

    .accordion-border-box .accordion-button {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border: none;
        padding: 20px;
        font-weight: 600;
        border-radius: 8px !important;
    }

    .accordion-border-box .accordion-button:not(.collapsed) {
        background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
        color: #1976d2;
        box-shadow: none;
    }

    .accordion-border-box .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(25, 118, 210, 0.25);
    }

    .instituicao-info strong {
        font-size: 1.1rem;
        display: block;
        margin-bottom: 5px;
    }

    .custos-info {
        min-width: 200px;
    }

    .custos-info .fw-bold {
        font-size: 1.1rem;
        margin-bottom: 5px;
    }

    .accordion-body .bg-light {
        background: linear-gradient(90deg, #f8f9fa 0%, #e9ecef 100%) !important;
    }

    .accordion-body .border-end::after {
        content: '';
        position: absolute;
        right: 0;
        top: 10%;
        height: 80%;
        width: 1px;
        background: #dee2e6;
    }

    .accordion-body .col-md-3 {
        position: relative;
    }

    .table thead th {
        font-weight: 600;
        letter-spacing: 0.5px;
        text-transform: uppercase;
    }

    .table-hover tbody tr:hover {
        background-color: rgba(25, 118, 210, 0.05);
        transform: scale(1.002);
        transition: all 0.2s ease;
    }

    .badge {
        font-size: 0.75rem;
        padding: 0.35em 0.65em;
        border-radius: 6px;
    }

    /* Animações de entrada */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .accordion-item {
        animation: fadeInUp 0.3s ease-out;
    }

    .accordion-item:nth-child(2) {
        animation-delay: 0.1s;
    }

    .accordion-item:nth-child(3) {
        animation-delay: 0.2s;
    }

    .accordion-item:nth-child(4) {
        animation-delay: 0.3s;
    }

    /* Responsividade */
    @media (max-width: 768px) {
        .instituicao-info strong {
            font-size: 1rem;
        }
        
        .custos-info {
            min-width: auto;
            margin-top: 10px;
        }
        
        .accordion-button {
            flex-direction: column;
            align-items: flex-start !important;
        }
        
        .d-flex.justify-content-between {
            flex-direction: column !important;
            gap: 10px;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        $('.count-up').each(function() {
            var value = $(this).text().replace(/[^0-9.,]/g, '');
            $(this).prop('Counter', 0).animate({
                Counter: value
            }, {
                duration: 2000,
                easing: 'swing',
                step: function(now) {
                    $(this).text(parseFloat(now).toLocaleString('pt-AO', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    }) + ' Kz');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Administracao/desembolso.blade.php ENDPATH**/ ?>