<?php $__env->startSection('Conteudo'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Cabeçalho -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPE - Área do Promotor</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Página Principal</a></li>
                                <li class="breadcrumb-item active">Dashboard</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cards de resumo -->
            <div class="row">
                <!-- Total de Projetos -->
                <div class="col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-primary-subtle text-primary rounded-2 fs-2">
                                        <i data-feather="briefcase" class="text-primary"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Total de Projectos</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($totalProjectos); ?></h4>
                                    <p class="text-muted mb-0">Todos os projectos submetidos</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Em Análise -->
                <div class="col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-info-subtle text-info rounded-2 fs-2">
                                        <i data-feather="loader" class="text-info"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Em Análise</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[1]); ?></h4>
                                    <p class="text-muted mb-0">Projectos em avaliação</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Em Execução -->
                <div class="col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-warning-subtle text-warning rounded-2 fs-2">
                                        <i data-feather="trending-up" class="text-warning"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Em Execução</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[4]); ?></h4>
                                    <p class="text-muted mb-0">Projectos em execução</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Concluídos -->
                <div class="col-xl-3">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-success-subtle text-success rounded-2 fs-2">
                                        <i data-feather="check-circle" class="text-success"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Concluídos</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[5]); ?></h4>
                                    <p class="text-muted mb-0">Projectos finalizados</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Progresso do Portfolio -->
            <div class="row">
                <div class="col-xl-8">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Visão Geral dos Projectos</h4>
                        </div>
                        
                        <div class="card-body">
                            <div id="portfolio-progress" class="apex-charts" data-colors='["--vz-success", "--vz-primary", "--vz-warning", "--vz-danger", "--vz-info", "--vz-secondary"]'></div>
                            
                            <div class="mt-3">
                                <div class="d-flex justify-content-center align-items-center mb-4">
                                    <h2 class="me-3 ff-secondary mb-0"><?php echo e($taxaAprovacao); ?>%</h2>
                                    <div>
                                        <p class="text-muted mb-0">Taxa de aprovação dos projectos</p>
                                    </div>
                                </div>
                                
                                <!-- Status dos projectos com valores reais -->
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-success align-middle me-2"></i> Concluídos</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[5]); ?> Projectos</span>
                                        <span class="text-success fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[5], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-primary align-middle me-2"></i> Em Execução</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[4]); ?> Projectos</span>
                                        <span class="text-primary fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[4], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-info align-middle me-2"></i> Aprovados para Homologação</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[2]); ?> Projectos</span>
                                        <span class="text-info fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[2], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-warning align-middle me-2"></i> Em Análise</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[1]); ?> Projectos</span>
                                        <span class="text-warning fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[1], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-secondary align-middle me-2"></i> Recebidos</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[0]); ?> Projectos</span>
                                        <span class="text-secondary fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[0], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-danger align-middle me-2"></i> Rejeitados</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[3]); ?> Projectos</span>
                                        <span class="text-danger fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[3], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Painel lateral direito -->
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Meus Projectos Recentes</h4>
                        </div>
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-borderless table-sm align-middle mb-0">
                                    <thead class="text-muted table-light">
                                        <tr>
                                            <th scope="col">Projecto</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Data submissão</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $projectosRecentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projecto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-13 mb-0">
                                                            <a href="<?php echo e(route('Listar-Projecto')); ?>" class="text-dark">
                                                                <?php echo e(\Illuminate\Support\Str::limit($projecto->nomeProjecto, 25)); ?>

                                                            </a>
                                                        </h6>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <?php
                                                    $statusColors = [
                                                        0 => 'secondary',
                                                        1 => 'info',
                                                        2 => 'primary',
                                                        3 => 'danger',
                                                        4 => 'warning',
                                                        5 => 'success'
                                                    ];
                                                    $statusText = [
                                                        0 => 'Recebido',
                                                        1 => 'Em Análise',
                                                        2 => 'Aprovado',
                                                        3 => 'Rejeitado',
                                                        4 => 'Em Execução',
                                                        5 => 'Concluído'
                                                    ];
                                                ?>
                                                <span class="badge bg-<?php echo e($statusColors[$projecto->status]); ?>-subtle text-<?php echo e($statusColors[$projecto->status]); ?>">
                                                    <?php echo e($statusText[$projecto->status]); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php echo e(\Carbon\Carbon::parse($projecto->created_at)->format('d/m/Y')); ?>

                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="align-items-center mt-4 pt-2 justify-content-between d-flex">
                                <div class="flex-shrink-0">
                                    <div class="text-muted">
                                        <a href="<?php echo e(route('Listar-Projecto')); ?>" class="text-decoration-underline">Ver todos os projectos</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Fluxo de Aprovação -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Fluxo de Aprovação</h5>
                        </div>
                        <div class="card-body">
                            <div class="progress-nav mb-4">
                                <div class="progress" style="height: 6px;">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                            
                            <ul class="progress-steps progress-success">
                                <li>
                                    <span>1</span>
                                    <div class="step-title">Recebido</div>
                                </li>
                                <li>
                                    <span>2</span>
                                    <div class="step-title">Em Análise</div>
                                </li>
                                <li>
                                    <span>3</span>
                                    <div class="step-title">Aprovado</div>
                                </li>
                                <li>
                                    <span>4</span>
                                    <div class="step-title">Rejeitado</div>
                                </li>
                                <li>
                                    <span>5</span>
                                    <div class="step-title">Em Execução</div>
                                </li>
                                <li>
                                    <span>6</span>
                                    <div class="step-title">Concluído</div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('Scripts'); ?>
<!-- ApexCharts -->
<script src="<?php echo e(asset('assets/libs/apexcharts/apexcharts.min.js')); ?>"></script>

<!-- Dashboard init -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Dados para o gráfico
    var options = {
        series: [
            <?php echo e($projectosPorStatus[0]); ?>, // Recebido
            <?php echo e($projectosPorStatus[1]); ?>, // Em Análise
            <?php echo e($projectosPorStatus[2]); ?>, // Aprovado
            <?php echo e($projectosPorStatus[3]); ?>, // Rejeitado
            <?php echo e($projectosPorStatus[4]); ?>, // Em Execução
            <?php echo e($projectosPorStatus[5]); ?>  // Concluído
        ],
        chart: {
            type: 'donut',
            height: 230
        },
        labels: [
            'Recebido', 'Em Análise', 'Aprovado', 'Rejeitado', 'Em Execução', 'Concluído'
        ],
        colors: [
            '#727CF5', '#F97F51', '#0099CC', '#EA5455', '#FFC300', '#1ABC9C'
        ]
    };

    var chart = new ApexCharts(document.querySelector("#portfolio-progress"), options);
    chart.render();
});
</script>
<?php echo $__env->make('Layout.LayoutBaseCliente', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Clientes/home.blade.php ENDPATH**/ ?>