<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Desembolsos - <?php echo e($instituicao); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 15px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #405289;
        }
        
        .title {
            font-size: 16px;
            font-weight: bold;
            color: #405289;
            margin-bottom: 5px;
        }
        
        .subtitle {
            font-size: 12px;
            color: #666;
        }
        
        .instituicao-info {
            background-color: #e3f2fd;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            border-left: 4px solid #1976d2;
        }
        
        .instituicao-nome {
            font-size: 14px;
            font-weight: bold;
            color: #1976d2;
            margin-bottom: 10px;
        }
        
        .resumo-instituicao {
            margin-bottom: 20px;
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
        }
        
        .resumo-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #405289;
        }
        
        .resumo-valores {
            display: inline-block;
            width: 100%;
        }
        
        .valor-item {
            display: inline-block;
            width: 25%;
            text-align: center;
            margin-right: 1.5%;
            padding: 8px;
            background-color: white;
            border-radius: 3px;
            border: 1px solid #dee2e6;
        }
        
        .valor-label {
            font-size: 9px;
            color: #666;
            margin-bottom: 3px;
        }
        
        .valor-numero {
            font-size: 11px;
            font-weight: bold;
        }
        
        .valor-numero.orcamentado { color: #007bff; }
        .valor-numero.desembolsado { color: #28a745; }
        .valor-numero.pendente { color: #dc3545; }
        .valor-numero.execucao { color: #17a2b8; }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .table-header {
            background-color: #405289;
            color: white;
        }
        
        th, td {
            border: 1px solid #ccc;
            padding: 5px;
            font-size: 9px;
            text-align: center;
        }
        
        th {
            font-weight: bold;
            font-size: 10px;
        }
        
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        
        .badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
            font-weight: bold;
            color: white;
        }
        
        .badge-warning { background-color: #ffc107; color: #212529; }
        .badge-info { background-color: #17a2b8; }
        .badge-success { background-color: #28a745; }
        .badge-danger { background-color: #dc3545; }
        .badge-primary { background-color: #007bff; }
        
        .footer {
            position: fixed;
            bottom: 10px;
            left: 15px;
            right: 15px;
            text-align: center;
            font-size: 8px;
            color: #666;
            border-top: 1px solid #ccc;
            padding-top: 5px;
        }
        
        .stats-section {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #fff3cd;
            border-radius: 5px;
            border-left: 4px solid #ffc107;
        }
        
        .stats-title {
            font-size: 12px;
            font-weight: bold;
            color: #856404;
            margin-bottom: 5px;
        }
        
        .stats-text {
            font-size: 10px;
            color: #856404;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">SIGEPE - FUNEA</div>
        <div class="title">RELATÓRIO DE DESEMBOLSOS POR INSTITUIÇÃO</div>
        <div class="subtitle">Data de Geração: <?php echo e($dataGeracao); ?></div>
    </div>

    <div class="instituicao-info">
        <div class="instituicao-nome"><?php echo e($instituicao); ?></div>
        <div style="font-size: 10px; color: #666;">
            Total de Projetos: <?php echo e($projetos->count()); ?> <?php echo e($projetos->count() == 1 ? 'projeto' : 'projetos'); ?>

        </div>
    </div>

    <div class="resumo-instituicao">
        <div class="resumo-title">RESUMO FINANCEIRO</div>
        <div class="resumo-valores">
            <div class="valor-item">
                <div class="valor-label">Total Orçamentado</div>
                <div class="valor-numero orcamentado"><?php echo e(number_format($totalCusto, 2, ',', '.')); ?> Kz</div>
            </div>
            <div class="valor-item">
                <div class="valor-label">Total Desembolsado</div>
                <div class="valor-numero desembolsado"><?php echo e(number_format($totalDesembolsado, 2, ',', '.')); ?> Kz</div>
            </div>
            <div class="valor-item">
                <div class="valor-label">Por Desembolsar</div>
                <div class="valor-numero pendente"><?php echo e(number_format($totalCusto - $totalDesembolsado, 2, ',', '.')); ?> Kz</div>
            </div>
            <div class="valor-item">
                <div class="valor-label">% Executado</div>
                <?php $percentualExecucao = $totalCusto > 0 ? ($totalDesembolsado / $totalCusto) * 100 : 0; ?>
                <div class="valor-numero execucao"><?php echo e(number_format($percentualExecucao, 1, ',', '.')); ?>%</div>
            </div>
        </div>
    </div>

    <div class="stats-section">
        <div class="stats-title">ANÁLISE DE DESEMPENHO</div>
        <div class="stats-text">
            <?php 
                $projetosEmExecucao = $projetos->where('status', 4)->count();
                $projetosConcluidos = $projetos->where('status', 5)->count();
                $projetosAprovados = $projetos->where('status', 2)->count();
            ?>
            Projetos em Execução: <?php echo e($projetosEmExecucao); ?> | 
            Projetos Concluídos: <?php echo e($projetosConcluidos); ?> | 
            Projetos Aprovados: <?php echo e($projetosAprovados); ?> | 
            Taxa de Execução Financeira: <?php echo e(number_format($percentualExecucao, 1, ',', '.')); ?>%
        </div>
    </div>

    <table>
        <thead class="table-header">
            <tr>
                <th style="width: 10%;">Código</th>
                <th style="width: 25%;">Designação do Projeto</th>
                <th style="width: 8%;">Início</th>
                <th style="width: 8%;">Fim</th>
                <th style="width: 10%;">Status</th>
                <th style="width: 8%;">Província</th>
                <th style="width: 12%;">Custo Total (Kz)</th>
                <th style="width: 12%;">Desembolsado (Kz)</th>
                <th style="width: 7%;">Exec. %</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $projetos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projeto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($projeto->codProjecto); ?></td>
                <td class="text-left"><?php echo e($projeto->nomeProjecto); ?></td>
                <td><?php echo e(date('Y', strtotime($projeto->duracaoP))); ?></td>
                <td><?php echo e(date('Y', strtotime($projeto->duracaoF))); ?></td>
                <td>
                    <?php $statusLabels = ['Recebido', 'Em Análise', 'Aprovado', 'Rejeitado', 'Em Execução', 'Concluído']; ?>
                    <?php $statusClasses = ['warning', 'info', 'success', 'danger', 'primary', 'success']; ?>
                    <span class="badge badge-<?php echo e($statusClasses[$projeto->status] ?? 'warning'); ?>">
                        <?php echo e($statusLabels[$projeto->status] ?? 'N/A'); ?>

                    </span>
                </td>
                <td><?php echo e($projeto->provincia ?? 'N/A'); ?></td>
                <td class="text-right"><?php echo e(number_format($projeto->limiteorcamentalP, 2, ',', '.')); ?></td>
                <td class="text-right"><?php echo e(number_format($projeto->valorTotalPago(), 2, ',', '.')); ?></td>
                <td>
                    <?php $execucaoProjeto = $projeto->limiteorcamentalP > 0 ? ($projeto->valorTotalPago() / $projeto->limiteorcamentalP) * 100 : 0; ?>
                    <?php echo e(number_format($execucaoProjeto, 1, ',', '.')); ?>%
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php if($projetos->count() > 0): ?>
    <div style="margin-top: 20px; padding: 10px; background-color: #d1ecf1; border-radius: 5px;">
        <div style="font-size: 10px; font-weight: bold; color: #0c5460; margin-bottom: 5px;">
            RESUMO ESTATÍSTICO
        </div>
        <div style="font-size: 9px; color: #0c5460;">
            <?php
                $custoMedio = $projetos->avg('limiteorcamentalP');
                $desembolsoMedio = $projetos->avg(function($projeto) { return $projeto->valorTotalPago(); });
                $maiorProjeto = $projetos->sortByDesc('limiteorcamentalP')->first();
            ?>
            Custo Médio por Projeto: <?php echo e(number_format($custoMedio, 2, ',', '.')); ?> Kz | 
            Desembolso Médio: <?php echo e(number_format($desembolsoMedio, 2, ',', '.')); ?> Kz
            <?php if($maiorProjeto): ?>
                | Maior Projeto: <?php echo e($maiorProjeto->codProjecto); ?> (<?php echo e(number_format($maiorProjeto->limiteorcamentalP, 2, ',', '.')); ?> Kz)
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="footer">
        <div>SIGEPE - FUNEA | Sistema de Gestão de Projetos de Emprego</div>
        <div>Relatório da Instituição: <?php echo e($instituicao); ?> | Gerado em <?php echo e($dataGeracao); ?></div>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\FINANCIAL\resources\views/pdf/desembolso-instituicao.blade.php ENDPATH**/ ?>