 


 <?php $__env->startSection('Conteudo'); ?>
   
 <div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Cabeçalho -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPE - Área do Gestor</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Página Principal</a></li>
                                <li class="breadcrumb-item active">Dashboard</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cards de resumo -->
            <div class="row">
                <!-- Total de Projetos -->
                <div class="col-xl-2">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-primary-subtle text-primary rounded-2 fs-2">
                                        <i data-feather="briefcase" class="text-primary"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Total de Projectos</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($totalProjectos); ?></h4>
                                    <p class="text-muted mb-0"><b><?php echo e(number_format($somatorioPorStatus[6], 2, ',', '.')); ?> AOA</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Recebidos -->
                <div class="col-xl-2">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-primary-subtle text-primary rounded-2 fs-2">
                                        <i data-feather="download" class="text-primary"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Recebidos</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[0]); ?></h4>
                                    <p class="text-muted mb-0"><b><?php echo e(number_format($somatorioPorStatus[0], 2, ',', '.')); ?> AOA</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <!-- Em Análise -->
                <div class="col-xl-2">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-info-subtle text-info rounded-2 fs-2">
                                        <i data-feather="loader" class="text-info"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Em Análise</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[1]); ?></h4>
                                    <p class="text-muted mb-0"><b><?php echo e(number_format($valoresPorStatus[1], 2, ',', '.')); ?> AOA</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Aprovados para Homologação -->
                <div class="col-xl-2">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-info-subtle text-info rounded-2 fs-2">
                                        <i data-feather="check" class="text-info"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Aprovados</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[2]); ?></h4>
                                    <p class="text-muted mb-0"><b><?php echo e(number_format($valoresPorStatus[2], 2, ',', '.')); ?> AOA</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
                <!-- Em Acompanhamento -->
                <div class="col-xl-2">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-warning-subtle text-warning rounded-2 fs-2">
                                        <i data-feather="trending-up" class="text-warning"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Em Execução</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[4]); ?></h4>
                                    <p class="text-muted mb-0"><b><?php echo e(number_format($valoresPorStatus[4], 2, ',', '.')); ?> AOA</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Concluídos -->
                <div class="col-xl-2">
                    <div class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-success-subtle text-success rounded-2 fs-2">
                                        <i data-feather="check-circle" class="text-success"></i>
                                    </span>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="text-uppercase fw-medium text-muted mb-3">Concluídos</p>
                                    <h4 class="fs-4 mb-3"><?php echo e($projectosPorStatus[5]); ?></h4>
                                    <p class="text-muted mb-0"><b><?php echo e(number_format($valoresPorStatus[5], 2, ',', '.')); ?> AOA</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Progresso do Portfolio -->
            <div class="row">
                <div class="col-xl-8">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1"><i class=" ri-pie-chart-line"></i> Visão Geral dos Projectos</h4>
                        </div>
                        
                        <div class="card-body">
                            <div id="portfolio-progress" class="apex-charts" data-colors='["--vz-success", "--vz-primary", "--vz-warning", "--vz-danger", "--vz-info", "--vz-secondary"]'></div>
                            
                            <div class="mt-3">
                                <div class="d-flex justify-content-center align-items-center mb-4">
                                    <h2 class="me-3 ff-secondary mb-0"><?php echo e($taxaAprovacao); ?>%</h2>
                                    <div>
                                        <p class="text-muted mb-0">Taxa de aprovação dos projectos</p>
                                    </div>
                                </div>
                                
                                <!-- Status dos projectos com valores reais -->
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-success align-middle me-2"></i> Concluídos</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[5]); ?> Projectos</span>
                                        <span class="text-success fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[5], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-primary align-middle me-2"></i> Em Execução</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[4]); ?> Projectos</span>
                                        <span class="text-primary fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[4], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-info align-middle me-2"></i> Aprovados para Homologação</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[2]); ?> Projectos</span>
                                        <span class="text-info fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[2], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-warning align-middle me-2"></i> Em Análise</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[1]); ?> Projectos</span>
                                        <span class="text-warning fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[1], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between border-bottom border-bottom-dashed py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-secondary align-middle me-2"></i> Recebidos</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[0]); ?> Projectos</span>
                                        <span class="text-secondary fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[0], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between py-2">
                                    <p class="fw-medium mb-0"><i class="ri-checkbox-blank-circle-fill text-danger align-middle me-2"></i> Rejeitados</p>
                                    <div>
                                        <span class="text-muted pe-5"><?php echo e($projectosPorStatus[3]); ?> Projectos</span>
                                        <span class="text-danger fw-medium fs-12"><?php echo e(number_format($valoresPorStatus[3], 2, ',', '.')); ?> AOA</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Painel lateral direito -->
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1"><i class="ri-external-link-line"></i> Atalhos</h4>
                        </div>
                        
                        <div class="card-body">
                            
                            <div class="list-group">
                                <a href="<?php echo e(route('admin.projetos.index')); ?>"><button type="button" class="list-group-item list-group-item-action link-secondary link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover">Carteira de Projectos</button></a>
                                <a href="<?php echo e(route('admin.desembolso.index')); ?>"><button type="button" class="list-group-item list-group-item-action link-secondary link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover">Plano de Desembolsos</button></a>
                                <a href="<?php echo e(route('Listar-EntidadePromotora')); ?>"><button type="button" class="list-group-item list-group-item-action link-secondary link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover">Proponentes de Projectos</button></a>
                                <a href="<?php echo e(route('processamento-salarios.index')); ?>"><button type="button" class="list-group-item list-group-item-action link-secondary link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover">Processamento de Salários</button></a>
                                <a href="#"><button type="button" class="list-group-item list-group-item-action link-secondary link-offset-2 text-decoration-underline link-underline-opacity-25 link-underline-opacity-100-hover">Plano Orçamental Estratégico <?php echo e(date('Y')); ?></button></a>
                            </div>
                            
                        </div>
                    </div>
                    
                    <!-- Fluxo de Aprovação -->
                    
                </div>
            </div>
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('Scripts'); ?>
<!-- ApexCharts -->
<script src="<?php echo e(asset('assets/libs/apexcharts/apexcharts.min.js')); ?>"></script>

<!-- Dashboard init -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Dados para o gráfico
    var options = {
        series: [
            <?php echo e($projectosPorStatus[0]); ?>, // Recebido
            <?php echo e($projectosPorStatus[1]); ?>, // Em Análise
            <?php echo e($projectosPorStatus[2]); ?>, // Aprovado
            <?php echo e($projectosPorStatus[3]); ?>, // Rejeitado
            <?php echo e($projectosPorStatus[4]); ?>, // Em Execução
            <?php echo e($projectosPorStatus[5]); ?>  // Concluído
        ],
        chart: {
            type: 'donut',
            height: 230
        },
        labels: [
            'Recebido', 'Em Análise', 'Aprovado', 'Rejeitado', 'Em Execução', 'Concluído'
        ],
        colors: [
            '#727CF5', '#F97F51', '#0099CC', '#EA5455', '#FFC300', '#1ABC9C'
        ]
    };

    var chart = new ApexCharts(document.querySelector("#portfolio-progress"), options);
    chart.render();
});
</script>
<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Administracao/home.blade.php ENDPATH**/ ?>