<?php $__env->startSection('Conteudo'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Página Principal</a></li>
                                <li class="breadcrumb-item active">Gestão de Grupos Pessoais</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            <?php if(session('success')): ?>
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "<?php echo e(session('success')); ?>",
                        icon: "success"
                    });
                });
            </script>
            <?php endif; ?>

            <?php if(session('error')): ?>
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "<?php echo e(session('error')); ?>",
                        icon: "error"
                    });
                });
            </script>
            <?php endif; ?>
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Grupos Pessoais</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row g-4 mb-3">
                                <div class="col-sm-auto">
                                    <div>
                                        <button type="button" class="btn btn-success add-btn" data-bs-toggle="modal" data-bs-target="#addGrupoPessoaisModal"><i class="ri-add-line align-bottom me-1"></i> Adicionar Grupo Pessoal</button>
                                    </div>
                                </div>
                                <div class="col-sm">
                                    <form action="<?php echo e(route('grupo-pessoais.index')); ?>" method="GET" class="d-flex justify-content-sm-end">
                                        <div class="search-box me-2">
                                            <input type="text" name="nomeGrupo" class="form-control" placeholder="Buscar por nome do grupo..." value="<?php echo e(request('nomeGrupo')); ?>">
                                            <i class="ri-search-line search-icon"></i>
                                        </div>
                                        <div class="ms-2">
                                            <select name="estado" class="form-select">
                                                <option value="">Estado</option>
                                                <option value="Ativo" <?php echo e(request('estado') == 'Ativo' ? 'selected' : ''); ?>>Ativo</option>
                                                <option value="Inativo" <?php echo e(request('estado') == 'Inativo' ? 'selected' : ''); ?>>Inativo</option>
                                            </select>
                                        </div>
                                        <div class="ms-2">
                                            <button type="submit" class="btn btn-primary">Filtrar</button>
                                            <a href="<?php echo e(route('grupo-pessoais.index')); ?>" class="btn btn-light">Limpar</a>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">ID</th>
                                            <th scope="col">Nome do Grupo</th>
                                            <th scope="col">Observação</th>
                                            <th scope="col">Data de Criação</th>
                                            <th scope="col">Estado</th>
                                            <th scope="col">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $grupoPessoais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grupoPessoal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($grupoPessoal->id); ?></td>
                                            <td><?php echo e($grupoPessoal->nomeGrupo); ?></td>
                                            <td><?php echo e($grupoPessoal->ObservacaoGrupo ?? 'N/A'); ?></td>
                                            <td><?php echo e(date('d/m/Y', strtotime($grupoPessoal->created_at))); ?></td>
                                            <td>
                                                <?php if($grupoPessoal->estado == 'Ativo'): ?>
                                                <span class="badge bg-success">Ativo</span>
                                                <?php else: ?>
                                                <span class="badge bg-danger">Inativo</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="dropdown-custom-wrapper">
                                                    <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="ri-more-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="<?php echo e(route('grupo-pessoais.edit', $grupoPessoal->id)); ?>"><i class="ri-pencil-fill text-success align-bottom me-2"></i> Editar</a></li>
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('grupo-pessoais.toggle-status', $grupoPessoal->id)); ?>">
                                                                <?php if($grupoPessoal->estado == 'Ativo'): ?>
                                                                <i class="ri-lock-fill text-warning align-bottom me-2"></i> Desativar
                                                                <?php else: ?>
                                                                <i class="ri-lock-unlock-fill text-success align-bottom me-2"></i> Ativar
                                                                <?php endif; ?>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item delete-item" href="#" data-id="<?php echo e($grupoPessoal->id); ?>" data-nome="<?php echo e($grupoPessoal->nomeGrupo); ?>"><i class="ri-delete-bin-fill text-danger align-bottom me-2"></i> Excluir</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center">Nenhum grupo pessoal encontrado</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                <?php echo e($grupoPessoais->links()); ?>

                            </div>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de grupo pessoal (será acionado via JavaScript) -->
    <form id="delete-form" method="POST" style="display: none;">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>

    <!-- Modal para adicionar grupo pessoal -->
    <div class="modal fade" id="addGrupoPessoaisModal" tabindex="-1" aria-labelledby="addGrupoPessoaisModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="addGrupoPessoaisModalLabel">Adicionar Grupo Pessoal</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('grupo-pessoais.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="nomeGrupo" class="form-label">Nome do Grupo <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nomeGrupo" name="nomeGrupo" required maxlength="255" placeholder="Ex: Recursos Humanos, TI, Financeiro">
                            <div class="form-text">Informe o nome do grupo pessoal com até 255 caracteres.</div>
                        </div>
                        <div class="mb-3">
                            <label for="ObservacaoGrupo" class="form-label">Observação</label>
                            <textarea class="form-control" id="ObservacaoGrupo" name="ObservacaoGrupo" rows="3" maxlength="1000" placeholder="Observações adicionais sobre o grupo pessoal (opcional)"></textarea>
                            <div class="form-text">Máximo de 1000 caracteres.</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success"><i class="ri-save-line me-1"></i> Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Configuração dos botões de exclusão
            document.querySelectorAll('.delete-item').forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const nome = this.getAttribute('data-nome');

                    Swal.fire({
                        title: "Tem certeza?",
                        text: `Você está prestes a excluir o grupo pessoal "${nome}". Esta ação não pode ser revertida!`,
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#d33",
                        cancelButtonColor: "#3085d6",
                        confirmButtonText: "Sim, excluir!",
                        cancelButtonText: "Cancelar"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = `<?php echo e(url('grupo-pessoais')); ?>/${id}`;
                            form.submit();
                        }
                    });
                });
            });
        });
    </script>

</div>
<!-- end main content-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Administracao/GrupoPessoais.blade.php ENDPATH**/ ?>