<?php $__env->startSection('Conteudo'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Título -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Gestão de Pagamentos - <?php echo e($projecto->nomeProjecto); ?></h4>
                    </div>
                </div>
            </div>

            <!-- Formulário de pagamento -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Registrar Novo Pagamento</h5>

                            <a href="<?php echo e(route('admin.projetos.index')); ?>" class="btn btn-secondary">
                                <i class="ri-arrow-left-line me-1"></i>
                                Voltar 
                            </a>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.projetos.pagamento', $projecto->id)); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="form-label">Descrição</label>
                                        <textarea name="descricao" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Valor (Kz)</label>
                                        <input type="number" name="valor" class="form-control" step="0.01" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Data</label>
                                        <input type="date" name="data" class="form-control" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Anexo (Opcional)</label>
                                        <input type="file" name="anexo" class="form-control">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">Registrar Pagamento</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lista de pagamentos -->
            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Histórico de Pagamentos</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Data</th>
                                            <th>Projeto</th>
                                            <th>Descrição</th>
                                            <th>Valor (Kz)</th>
                                            <th>Registrado por</th>
                                            <th>Anexo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $pagamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pagamento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($pagamento->data); ?></td>
                                            <td><?php echo e($projecto->nomeProjecto); ?></td>
                                            <td><?php echo e($pagamento->descricao); ?></td>
                                            <td><?php echo e(number_format($pagamento->valor, 2, ',', '.')); ?></td>
                                            <td><?php echo e($pagamento->user->name); ?></td>
                                            <td>
                                                <?php if($pagamento->anexo): ?>
                                                    <a href="<?php echo e(Storage::url($pagamento->anexo)); ?>" target="_blank">Ver</a>
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5" class="text-center">Nenhum pagamento registrado</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Admin/pagamentos.blade.php ENDPATH**/ ?>