<?php $__env->startSection('Conteudo'); ?>


    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div
                            class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                            <h4 class="mb-sm-0"><i class="ri-briefcase-fill label-icon align-middle fs-16 ms-2"></i> SUBMETER
                                NOVO PROJECTO</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Página Principal</a></li>
                                    <li class="breadcrumb-item active"> Submeter novo projecto</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <!-- Mensagens do sistema -->

                <?php if(@session('msg')): ?>



                    <script>
                        document.addEventListener('DOMContentLoaded', () => {

                            Swal.fire({
                                title: "Pronto!",
                                text: "<?php echo e(session('msg')); ?>",
                                icon: "success"
                            });
                        });

                    </script>

                    <!-- Mensagens do sistema -->

                <?php endif; ?>
                <?php if(@session('error')): ?>


                    <script>
                        document.addEventListener('DOMContentLoaded', () => {

                            Swal.fire({
                                title: "Erro!",
                                text: "<?php echo e(session('error')); ?>",
                                icon: "error"
                            });
                        });

                    </script>

                    <!-- Mensagens do sistema -->

                <?php endif; ?>


            </div>
            <!-- container-fluid -->

            <form action="<?php echo e(route('Projecto-store')); ?>" method="POST" id="meuFormulario" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>

                <div class="row">
                    <div class="col-lg-12">


                        <div class="alert alert-primary alert-dismissible alert-additional fade show material-shadow"
                            role="alert">
                            <div class="alert-body">
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <i class="ri-error-warning-line fs-16 align-middle"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h5 class="alert-heading">Nota</h5>
                                        <p class="mb-0" style=" text-align:justify;  text-justify:inter-word;"><strong>Antes
                                                de Começar:</strong>
                                        <ul class="mb-0">
                                            <li>Tenha todos os dados necessários em mãos (cronogramas, orçamentos, etc.);
                                            </li>
                                            <li>Recomendamos utilizar Chrome, Firefox ou Edge actualizados;</li>
                                            <li>Preencha todos os campos obrigatórios (*);</li>
                                            <li>Revise as informações antes de submeter;</li>
                                            <li>Certifique-se de que os ficheiros anexados estão no formato correcto (.pdf)
                                                e dentro do tamanho máximo permitido (10MB);</li>
                                            <li>Após submeter, aguarde a confirmação por email.</li>

                                        </ul>
                                        
                        
                                        </p>
                                    </div>
                                    
                                </div>
                                <div class="alert alert-info">
                            <strong>Suporte:</strong> Em caso de dúvidas, contacte: 
                            <a href="mailto:suporte@sigipie.co.ao" class="text-decoration-none">suporte@sigipie.co.ao</a> ou 
                            <a href="tel:+244999999999" class="text-decoration-none">(+244) 999-999-999</a>
                        </div>
                            </div>

                        </div>

                    </div>


                    <div class="col-lg-6">

                        <div class="card">
                            <div class="card-header bg-primary">
                                <h5 class="card-title mb-0" style="color: #ffffff;"><i
                                        class="ri-stack-fill label-icon align-middle fs-16 ms-2"></i> Identificação do
                                    Projecto</h5>
                            </div>
                            <div class="card-body">


                                <div class="row">
                                    <div class="col-lg-2">
                                        <div class="mb-3 mb-lg-4">
                                            <label for="codProjecto" class="form-label">ID</label>
                                             

                                            <input type="text" class="form-control bg-light" name="codProjecto"
                                                id="codProjecto" placeholder="Código do projecto" readonly
                                               value="<?php echo e(old('codProjecto')); ?>"
                                                style="font-size:11px; height: 40px; font-weight: bold;">

                                                <?php if($errors->has('codProjecto')): ?>
                                                <span class="text-danger"><?php echo e($errors->first('codProjecto')); ?></span>
                                            <?php endif; ?>
                                            
                          
                                            <input type="hidden" name="responsavel" value="<?php echo e(auth()->user()->id); ?>">

                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="mb-3 mb-lg-4">
                                            <label for="nomeProjecto" class="form-label">Projecto *</label>
                                            <input type="text" name="nomeProjecto" class="form-control mb-lg-1"
                                                id="nomeProjecto" value="<?php echo e(old('nomeProjecto')); ?>"
                                                placeholder="Nome do Projecto">

                                            <?php if($errors->has('nomeProjecto')): ?>
                                                <span class="text-danger"><?php echo e($errors->first('nomeProjecto')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="mb-3 mb-lg-1">
                                            <label for="tipoProjectFK" class="form-label">Tipo *</label>
                                            <select class="form-select mb-lg-1 " name="tipoProjectFK" id="tipoProjectFK">

                                                    <option value="" selected>Selecione</option>
                                                    <?php $__empty_1 = true; $__currentLoopData = $projectos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projecto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <option value=" <?php echo e($projecto->id); ?>" <?php echo e(old('tipoProjectFK') == $projecto->id ? 'selected' : ''); ?>><?php echo e($projecto->descricao); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <option value="">Nenhum registro foi encontrado...</option>
                                                <?php endif; ?>
                                            </select>
                                            <?php if($errors->has('tipoProjectFK')): ?>
                                                <span class="text-danger d-sm-flex"><?php echo e($errors->first('tipoProjectFK')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>



                                <div class="row">



                                    <div class="col-lg-12">
                                        <div class="mb-4 mb-lg-4">
                                            <label for="ckeditor-classic" class="form-label">Descrição e Objectivo(s) do
                                                Projecto *</label>
                                            <textarea class="form-control mb-lg-10" name="descObjectivo"
                                                id="ckeditor-classic" style="height: 286px"
                                                placeholder="1.Descrição | 2. Objectivo(s)"><?php echo e(old('descObjectivo')); ?></textarea>
                                            <?php if($errors->has('descObjectivo')): ?>
                                                <span
                                                    class="text-danger d-sm-flex"><?php echo e($errors->first('descObjectivo')); ?></span>
                                            <?php endif; ?>

                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="mb-3 mb-lg-4">
                                            <label for="limiteorcamentalP-0" class="form-label">Custo Total do Projecto *</label>
                                            <input type="number" name="limiteorcamentalP" id="limiteorcamentalP"
                                                class="form-control  mb-lg-1" value="<?php echo e(old('limiteorcamentalP')); ?>"
                                                placeholder="0.00" min="0" />

                                            <?php if($errors->has('limiteorcamentalP')): ?>
                                                <span
                                                    class="text-danger d-sm-flex"><?php echo e($errors->first('limiteorcamentalP')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                   
                                    <div class="col-lg-3">
                                        <div class="mb-3 mb-lg-4">
                                            <label for="duracaoP-0" class="form-label">Data Inicial *</label>
                                            <input type="date" class="form-control mb-lg-1" name="duracaoP" id="duracaoP-0"
                                                value="<?php echo e(old('duracaoP')); ?>" placeholder="0.00" min="0" />

                                            <?php if($errors->has('duracaoP')): ?>
                                                <span class="text-danger d-sm-flex"><?php echo e($errors->first('duracaoP')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 mb-lg-4">
                                            <label for="duracaoF-0" class="form-label">Data Final *</label>
                                            <input type="date" class="form-control mb-lg-1" name="duracaoF" id="duracaoF-0"
                                                value="<?php echo e(old('duracaoF')); ?>" placeholder="0.00" min="0" />

                                            <?php if($errors->has('duracaoF')): ?>
                                                <span class="text-danger d-sm-flex"><?php echo e($errors->first('duracaoF')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i
                                        class="ri-file-list-3-fill label-icon align-middle fs-16 ms-2"></i> Contrato e Facturas</h5>
                            </div>
                            <div class="card-body">
                                <div>
                                    <p class="text-muted">Ficheiro único Contrato (.pdf), tamanho máximo 10MB</p>
                                    <input type="file" name="contratoP" id="contratoP" value="<?php echo e(old('contratoP')); ?>"
                                        class="form-control mb-lg-1" accept="application/pdf">

                                    <?php if($errors->has('contratoP')): ?>
                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('contratoP')); ?></span>
                                    <?php endif; ?>

                                </div><br><br>
                                <div>
                                    <p class="text-muted">Ficheiro único Factura (.pdf), tamanho máximo 10MB *</p>
                                    <input type="file" name="facturaP" id="facturaP" value="<?php echo e(old('facturaP')); ?>"
                                        class="form-control mb-lg-1" accept="application/pdf">

                                    <?php if($errors->has('facturaP')): ?>
                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('facturaP')); ?></span>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <!-- end card -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i
                                        class=" ri-edit-2-fill label-icon align-middle fs-16 ms-2"></i> Aprovação</h5>
                            </div>
                            <div class="card-body">

                                <div class="mb-3 mb-lg-4">
                                    <label for="aprovadopor" class="form-label">Responsável Máximo da instituição *</label>
                                    <input type="text" name="aprovadopor" class="form-control mb-lg-1"
                                        id="aprovadopor" value="<?php echo e(old('aprovadopor')); ?>"
                                        placeholder="Responsável Máximo da instituição (PCA, Gestor, etc)">

                                    <?php if($errors->has('aprovadopor')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('aprovadopor')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <label for="justificacao" class="form-label">Justificação *</label>
                                    <textarea class="form-control mb-lg-1" name="justificacao" rows="6"
                                        placeholder="Justificação da aprovação"><?php echo e(old('justificacao')); ?></textarea>

                                    <?php if($errors->has('justificacao')): ?>
                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('justificacao')); ?></span>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i
                                        class=" ri-stackshare-line label-icon align-middle fs-16 ms-2"></i> Caracterização
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="mb-3 mb-lg-2">
                                            <label for="choices-categories-input" class="form-label">Âmbito *</label>

                                            <input type="hidden" class="form-control mb-lg-1" name="ffinanciamento"
                                                id="ffinanciamento" value="FUNEA" />

                                            <select class="form-select" name="ambito" id="choices-categories-input">
                                                <option value="" <?php echo e(!old('ambito') ? 'selected' : ''); ?>>Selecione</option>
                                                <?php $__currentLoopData = ['Provincial', 'Municipal', 'Distrital']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($option); ?>" <?php echo e(old('ambito') == $option ? 'selected' : ''); ?>>
                                                        <?php echo e($option); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($errors->has('ambito')): ?>
                                                <span class="text-danger d-sm-flex"><?php echo e($errors->first('ambito')); ?></span>
                                            <?php endif; ?>

                                        </div>
                                    </div>


                                    <div class="col-lg-4">
                                        <div class="mb-3  mb-lg-2">
                                            <label for="choices-privacy-status-input" class="form-label">Metodologia de
                                                Financiamento *</label>

                                            <select class="form-select" name="mFuncionamento" id="choices-categories-input">
                                                <option value="" <?php echo e(!old('mFuncionamento') ? 'selected' : ''); ?>>Selecione
                                                </option>
                                                <?php $__currentLoopData = ['Integral', 'Parcial']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($option); ?>" <?php echo e(old('mFuncionamento') == $option ? 'selected' : ''); ?>>
                                                        <?php echo e($option); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <?php if($errors->has('mFuncionamento')): ?>
                                                <span
                                                    class="text-danger d-sm-flex"><?php echo e($errors->first('mFuncionamento')); ?></span>
                                            <?php endif; ?>

                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="mb-3  mb-lg-2">
                                            <label for="choices-privacy-status-input" class="form-label">Localização
                                                *</label>

                                            <select class="form-select" name="localizacao_projecto" id="choices-categories-input">

                                                <option value="" <?php echo e(!old('localizacao_projecto') ? 'selected' : ''); ?>>Selecione
                                                </option>
                                                <?php $__currentLoopData = ["Nacional","Bengo", "Benguela", "Bié", "Cabinda", "Cuando-Cubango", "Cuanza-Norte", "Cuanza-Sul", "Cunene", "Huambo", "Huíla", "Luanda", "Lunda-Norte", "Lunda-Sul", "Malanje", "Moxico", "Namibe", "Uíge", "Zaire", "Icolo e Bengo", "Moxico-Leste", "Luanda-Sul", "Cazengo"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($option); ?>" <?php echo e(old('localizacao_projecto') == $option ? 'selected' : ''); ?>>
                                                        <?php echo e($option); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <?php if($errors->has('localizacao_projecto')): ?>
                                                <span class="text-danger d-sm-flex"><?php echo e($errors->first('localizacao_projecto')); ?></span>
                                            <?php endif; ?>

                                        </div>
                                    </div>

                                </div>

                                <div class="row">


                                </div>
                            </div>

                            <!-- end card body -->
                        </div>
                        <!-- end card -->
                        <div class="card">
                            <div class="card-header ">
                                <h5 class="card-title mb-0"><i
                                        class="ri-book-3-line label-icon align-middle fs-16 ms-2"></i> Estudos</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="mb-6  mb-lg-2">
                                            <label for="choices-text-input" class="form-label">Impacto Económico e Social
                                                *</label>
                                            <p class="text-muted">Ficheiro único (.pdf), tamanho máximo 10MB </p>
                                            <input type="file" name="impactoSocial" id="impactoSocial"
                                                class="form-control mb-lg-1" accept="application/pdf">

                                            <?php if($errors->has('impactoSocial')): ?>
                                                <span class="text-danger d-sm-flex"><?php echo e($errors->first('impactoSocial')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="mb-6  mb-lg-6">
                                            <label for="choices-privacy-status-input" class="form-label">Técnicos ou de
                                                Engenharia</label>
                                            <p class="text-muted">Ficheiro único (.pdf), tamanho máximo 10MB </p>
                                            <input type="file" name="tecEng" id="tecEng" class="form-control"
                                                accept="application/pdf">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="mb-3  mb-lg-6">
                                            <label for="choices-privacy-status-input" class="form-label">Análise
                                                Custo-Benefício ou Custo-Efectividade </label>
                                            <p class="text-muted">Ficheiro único (.pdf), tamanho máximo 10MB </p>
                                            <input type="file" name="custoBE" id="custoBE" class="form-control"
                                                accept="application/pdf">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="mb-3  mb-lg-6">
                                            <label for="choices-privacy-status-input" class="form-label">Viabilidade
                                                Económica-Financeira </label>
                                            <p class="text-muted">Ficheiro único (.pdf), tamanho máximo 10MB </p>
                                            <input type="file" name="viabilidade" id="viabilidade" class="form-control"
                                                accept="application/pdf">

                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="mb-3  mb-lg-6">
                                            <label for="choices-privacy-status-input" class="form-label">Impacto
                                                Ambiental</label>
                                            <p class="text-muted">Ficheiro único (.pdf), tamanho máximo 10MB </p>
                                            <input type="file" name="impactoAmbiental" id="impactoAmbiental"
                                                class="form-control" accept="application/pdf">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="mb-3  mb-lg-6">
                                            <label for="choices-privacy-status-input" class="form-label">Mitigação dos
                                                Impactos Ambientais</label>
                                            <p class="text-muted">Ficheiro único (.pdf), tamanho máximo 10MB </p>
                                            <input type="file" name="mitigacaoImpactos" id="mitigacaoImpactos"
                                                class="form-control" accept="application/pdf">

                                        </div>
                                    </div>
                                </div>

                            </div>
                            <!-- end card body -->
                        </div>

                        <!-- Início das Informações bancárias -->
                        <div class="card">
                            <div class="card-header ">
                                <h5 class="card-title mb-0"><i
                                        class="ri-book-3-line label-icon align-middle fs-16 ms-2"></i> Detalhes Bancários da Entidade Promotora</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div id="products-container">
                                        <div>
                                            <div class="row">
        
                                                <div class="col-xl-4">
                                                    <div class="mb-3">
                                                        <label for="nomeInst" class="form-label">Nome da Instituição *</label>
                                                        <select name="nomeInst" id="nomeInst" class="form-select" aria-label="Default select example">
                                                            <option value="">-- Selecione o Banco --</option>
                                                            <option value="SIGF">SIGF</option>
                                                            <option value="Banco Angolano de Investimentos (BAI)">Banco Angolano de Investimentos (BAI)</option>
                                                            <option value="Banco de Poupança e Crédito (BPC)">Banco de Poupança e Crédito (BPC)</option>
                                                            <option value="Banco de Comércio e Indústria (BCI)">Banco de Comércio e Indústria (BCI)</option>
                                                            <option value="Banco Comercial Angolano (BCA)">Banco Comercial Angolano (BCA)</option>
                                                            <option value="Standard Bank Angola (SBA)">Standard Bank Angola (SBA)</option>
                                                            <option value="Banco de Negócios Internacional (BNI)">Banco de Negócios Internacional (BNI)</option>
                                                            <option value="Banco de Fomento Angola (BFA)">Banco de Fomento Angola (BFA)</option>
                                                            <option value="Banco KEVE">Banco KEVE</option>
                                                            <option value="Banco SOL">Banco SOL</option>
                                                            <option value="Banco VALOR">Banco VALOR</option>
                                                            <option value="Banco YETU">Banco YETU</option>
                                                            <option value="Banco MILLENIUM ATLÂNTICO (BMA)">Banco MILLENIUM ATLÂNTICO (BMA)</option>
                                                            <option value="Banco BIC">Banco BIC</option>
                                                            <option value="Banco Económico">Banco Económico</option>
                                                            <option value="Banco VTB África">Banco VTB África</option>
                                                            <option value="Banco Caixa Geral Totta de Angola (BCH)">Banco Caixa Geral Totta de Angola (BCH)</option>
                                                            <option value="Banco Angolano de Agricultura (BAA)">Banco Angolano de Agricultura (BAA)</option>
                                                            <option value="Banco BMG">Banco BMG</option>
                                                            <option value="Banco de Investimento Rural de Angola (BIR)">Banco de Investimento Rural de Angola (BIR)</option>
                                                        </select>
                                                        <?php if($errors->has('nomeInst')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('nomeInst')); ?></span>
                                                    <?php endif; ?>
                                                    </div>
                                                    
        
                                                </div><!-- end col -->
        
                                                <div class="col-xl-8">
        
                                                    <div class="mb-3">
                                                        <label for="enderecoAgencia" class="form-label">Endereço da Agência *</label>
                                                        <input type="text" name="enderecoAgencia" id="enderecoAgencia" class="form-control" placeholder="Ex. Rua 22 Maianga">
                                                        
                                                        <?php if($errors->has('enderecoAgencia')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('enderecoAgencia')); ?></span>
                                                        <?php endif; ?>
        
                                                    </div>
        
                                                </div><!-- end col -->
                                            </div><!-- end row -->
                                        </div>
                                        <div>
                                            <div class="row">
        
                                                <div class="col-xl-4">
                                                    <div class="mb-3">
                                                        <label for="contactoAgencia" class="form-label">Contaco da Agencia *</label>
                                                        <input type="text" name="contactoAgencia" id="contactoAgencia"
                                                            class="form-control" placeholder="Ex. 222222222">
                                                        <?php if($errors->has('contactoAgencia')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('contactoAgencia')); ?></span>
                                                        <?php endif; ?>  
                                                    </div>
        
                                                </div><!-- end col -->
        
                                                <div class="col-xl-8">
        
                                                    <div class="mb-3">
                                                        <label for="numeroConta" class="form-label">Conta Bancária *</label>
                                                        <input type="text" name="numeroConta" id="numeroConta"
                                                            class="form-control" placeholder="Ex. 0000 0000 0000 00 000" >
                                                        <?php if($errors->has('numeroConta')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('numeroConta')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
        
                                                </div><!-- end col -->
                                            </div><!-- end row -->
                                        </div>
        
        
        
                                        <div>
                                            <!--<h6 class="mb-3 fs-14 text-muted">Time Formatting</h6>-->
                                            <div class="row">
                                             
                                                <div class="col-xl-6">
        
                                                    <div class="mb-3">
                                                        <label for="iban" class="form-label">IBAN *</label>
                                                        <input type="text" name="iban" id="iban" class="form-control"
                                                        placeholder="Ex. AO06 0000 0000 0000 0000 0000 0" >
        
                                                    </div>
                                                    <?php if($errors->has('iban')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('iban')); ?></span>
                                                    <?php endif; ?>
        
                                                </div><!-- end col -->
        
                                                <div class="col-xl-6">
                                                    <div class="mb-3">
                                                        <label for="swif" class="form-label">SWIF *</label>
                                                        <input type="text" name="swif" id="swif" class="form-control"
                                                        placeholder="BXXPAOLU " id="cleave-ccard" >
                                                    </div>
                                                </div><!-- end col -->
                                            </div><!-- end row -->
                                        </div>
                                        <div><br>
                                            <h6 class="mb-3 fs-14 text-muted">Assinates da Conta</h6>
                                            <div class="row">
                                             
                                                <div class="col-xl-6">
        
                                                    <div class="mb-3">
                                                        <label for="Assinante1" class="form-label">1º Assinante *</label>
                                                        <input type="text" name="Assinante1" id="Assinante1" class="form-control"
                                                        placeholder="Ex. Valery Manuel TSeyi" >
                                                        <?php if($errors->has('Assinante1')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('Assinante1')); ?></span>
                                                    <?php endif; ?>
                                                    </div>
                                                   
        
                                                </div><!-- end col -->
        
                                                <div class="col-xl-6">
                                                    <div class="mb-3">
                                                        <label for="Assinante2" class="form-label">2º Assinante</label>
                                                        <input type="text" name="Assinante2" id="Assinante2" class="form-control"
                                                        placeholder="Ex. João Silva" id="cleave-ccard">
                                                        <?php if($errors->has('Assinante2')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('Assinante2')); ?></span>
                                                    <?php endif; ?>
                                                    </div>
                                                 
                                                </div><!-- end col -->
                                            </div><!-- end row -->
                                            <div class="row">
                                             
                                                <div class="col-xl-6">
        
                                                    <div class="mb-3">
                                                        <label for="Assinante3" class="form-label">3º Assinante</label>
                                                        <input type="text" name="Assinante3" id="Assinante3" class="form-control"
                                                        placeholder="Ex. José André">
        
                                                    </div>
                                                    <?php if($errors->has('Assinante3')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('Assinante3')); ?></span>
                                                    <?php endif; ?>
        
                                                </div><!-- end col -->
        
                                                <div class="col-xl-6">
                                                    <div class="mb-3">
                                                        <label for="Assinante4" class="form-label">4º Assinante</label>
                                                        <input type="text" name="Assinante4" id="Assinante4" class="form-control"
                                                        placeholder="Ex. Joaquina Fortuna" >
                                                    </div>
                                                </div><!-- end col -->
                                                <div class="col-xl-12">
                                                    <div class="mb-3">
                                                        <label for="nif" class="form-label">NIF</label>
                                                        <input type="text" name="nif" id="nif" class="form-control"
                                                        placeholder="Ex. 500000000" >

                                                        <?php if($errors->has('nif')): ?>
                                                        <span class="text-danger d-sm-flex"><?php echo e($errors->first('nif')); ?></span>
                                                    <?php endif; ?>
                                                    </div>
                                                </div><!-- end col -->
                                            </div><!-- end row -->
                                        </div>
        
                                    </div>
                                </div>

                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- Fim Informações bancárias -->

                    </div>
                    <!-- end col -->
                    <div class="col-lg-6">


                        <!-- INICIO ÁREA ACTIVIDADES-->
                        <div class="card">
                            <div class="card-header bg-success">
                                <h6 class="card-title mb-0" style="color: #ffffff;"><i
                                    class=" ri-file-add-line label-icon align-middle fs-16 ms-2"></i>
                                Cronograma Físico das Actividades</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb- ">
                                    <div class="container">
                                        

                                        <div id="products-container">
                                            <div class="product-group card mb-0">
                                                <div class="card-body">
                                                    <div class="row">                                                        

                                                    <!-- GRAU DE EXECUÇÃO FÍSICA -->
                                                    <div class="row product-group1" id="products-container1">
                                                        <h6 class="card-title mb-0 ">1º Actividade</h6><br><br>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="actividadeAno-0" class="form-label">Ano de Execução
                                                                    *</label>
                                                                <select class="form-select"
                                                                    name="actividadeAno[0]" id="actividadeAno-0">
                                                                    <option value="" <?php echo e(!old('actividadeAno.0') ? 'selected' : ''); ?>>Selecione</option>

                                                                    <option value="<?php echo e(now()->format('Y')-1); ?>" <?php echo e(old('actividadeAno.0') == now()->format('Y')-1 ? 'selected' : ''); ?>>
                                                                     <?php echo e(now()->format('Y')-1); ?>

                                                                    </option>

                                                                    <?php $__currentLoopData = [now()->format('Y'), (now()->format('Y') + 1), (now()->format('Y') + 2)]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option); ?>" <?php echo e(old('actividadeAno.0') == $option ? 'selected' : ''); ?>>
                                                                            <?php echo e($option); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>

                                                                <?php if($errors->has('actividadeAno.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('actividadeAno.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="actividadePercentual-0" class="form-label"> % Peso
                                                                    *</label>
                                                                <input type="number" class="form-control  mb-lg-1"value="<?php echo e(old('actividadePercentual.0')); ?>" name="actividadePercentual[0]"
                                                                    id="actividadePercentual-0" placeholder="0" />

                                                                <?php if($errors->has('actividadePercentual.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('actividadePercentual.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-3">
                                                                <label for="actividadeDataInicio-0" class="form-label">
                                                                    Início *</label>
                                                                <input type="date" class="form-control  mb-lg-1"
                                                                    id="actividadeDataInicio-0"
                                                                    value="<?php echo e(old('actividadeDataInicio.0')); ?>"
                                                                    name="actividadeDataInicio[0]"
                                                                    placeholder="DD/MM/AAAA" style="font-size: 11px;"
                                                                    data-provider="flatpickr">

                                                                <?php if($errors->has('actividadeDataInicio.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('actividadeDataInicio.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-3">
                                                                <label for="actividadeDataFim-0" class="form-label">Término
                                                                    *</label>
                                                                <input type="date" class="form-control  mb-lg-1"
                                                                    id="actividadeDataFim-0"
                                                                    value="<?php echo e(old('actividadeDataFim.0')); ?>"
                                                                    name="actividadeDataFim[0]"
                                                                    placeholder="DD/MM/AAAA" style="font-size: 11px;"
                                                                    data-provider="flatpickr">

                                                                <?php if($errors->has('actividadeDataFim.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('actividadeDataFim.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>



                                                        <div class="col-lg-12">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="actividadeDescricao-0" class="form-label">Descrição da
                                                                    Execução Fisica *</label>
                                                                <textarea class="form-control mb-lg-1"
                                                                    name="actividadeDescricao[0]"
                                                                    id="actividadeDescricao-0" rows="6"
                                                                    placeholder="Descrição"><?php echo e(old('actividadeDescricao.0')); ?></textarea>

                                                                <?php if($errors->has('actividadeDescricao.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('actividadeDescricao.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>


                                                    </div>
                                                    <!-- =================================================================================================== -->
                                                    <div class="col-lg-3">
                                                        <div class="mb-3 mb-lg-2">
                                                            <br>
                                                            <button type="button" id="add-product1"
                                                                class="btn btn-success mb-3">Adicionar actividade</button>
                                                        </div>
                                                    </div>
                                                    <!-- =================================================================================================== -->
                                                    <!-- FIM DO GRAU DE EXECUÇÃO FÍSICA -->


                                                    





                                                    <div class="row">



                                                        <h6 class="mb-0 fs-14 text-muted"><br><i
                                                                class="ri-bar-chart-fill label-icon align-middle fs-16 ms-2"></i>
                                                            Programação Financeira
                                                            (Despesa)</h6>
                                                        <hr class="my-2 mb-4">


                                                        <!--  Programação Financeira (Despesa) -->
                                                    <div class="row product-group2" id="products-container2">
                                                        <h6 class="card-title mb-0 "><br>1º Despesa<br><br> </h6>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="ano-0" class="form-label">Ano de Execução
                                                                    *</label>
                                                                <select class="form-select"
                                                                    name="despesaAno[0]" id="ano-0">
                                                                    <option value="" <?php echo e(!old('despesaAno.0') ? 'selected' : ''); ?>>Selecione</option>
                                                                    <option value="<?php echo e(now()->format('Y')-1); ?>" <?php echo e(old('despesaAno.0') == now()->format('Y')-1 ? 'selected' : ''); ?>>
                                                                        <?php echo e(now()->format('Y')-1); ?>

                                                                    </option>
                                                                    <?php $__currentLoopData = [now()->format('Y'), (now()->format('Y') + 1), (now()->format('Y') + 2)]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option); ?>" <?php echo e(old('despesaAno.0') == $option ? 'selected' : ''); ?>>
                                                                            <?php echo e($option); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>

                                                                <?php if($errors->has('despesaAno.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaAno.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaValor-0" class="form-label"> Valor AOA
                                                                    *</label>
                                                                <input type="number" class="form-control  mb-lg-1"
                                                                    value="<?php echo e(old('despesaValor.0')); ?>"
                                                                    name="despesaValor[0]"
                                                                    id="despesaValor-0" placeholder="0,00" />

                                                                <?php if($errors->has('despesaValor.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaValor.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaDatainicial-0" class="form-label">Início *</label>
                                                                <input type="date" class="form-control  mb-lg-1"
                                                                    id="despesaDatainicial-0"
                                                                    value="<?php echo e(old('despesaDatainicial.0')); ?>"
                                                                    name="despesaDatainicial[0]"
                                                                    placeholder="DD/MM/AAAA" style="font-size: 11px;"
                                                                    data-provider="flatpickr">

                                                                <?php if($errors->has('despesaDatainicial.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaDatainicial.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaDatafinal-0" class="form-label">Término
                                                                    *</label>
                                                                <input type="date" class="form-control  mb-lg-1"
                                                                    id="despesaDatafinal-0"
                                                                    value="<?php echo e(old('despesaDatafinal.0')); ?>"
                                                                    name="despesaDatafinal[0]"
                                                                    placeholder="DD/MM/AAAA" style="font-size: 11px;"
                                                                    data-provider="flatpickr">

                                                                <?php if($errors->has('despesaDatafinal.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaDatafinal.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>



                                                        <div class="col-lg-12">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaDescricao-0" class="form-label">Descrição da
                                                                    Execução Fisica *</label>
                                                                <textarea class="form-control mb-lg-1"
                                                                    name="despesaDescricao[0]"
                                                                    id="despesaDescricao-0" rows="6"
                                                                    placeholder="Descrição"><?php echo e(old('despesaDescricao.0')); ?></textarea>

                                                                <?php if($errors->has('despesaDescricao.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaDescricao.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>


                                                    </div>
                                                    <!-- =================================================================================================== -->
                                                    <div class="col-lg-3">
                                                        <div class="mb-3 mb-lg-2">
                                                            <br>
                                                            <button type="button" id="add-product2"
                                                                class="btn btn-success mb-3">Adicionar despesas</button>
                                                        </div>
                                                    </div>
                                                    <!-- =================================================================================================== -->
                                                    <!-- FIM DA PROGRAMAÇÃO DAS DESPESAS DO PROJECTO -->



                                                        




                                                        <h6 class="mb-0 fs-14 text-muted"><br><br><i
                                                                class="   ri-bar-chart-fill label-icon align-middle fs-16 ms-2"></i>
                                                            Indicadores do Projecto</h6>
                                                        <hr class="my-2 mb-4">
                                                        

                                                        <div class="col-lg-5">

                                                            <div class="mb-3 mb-lg-4">
                                                                <label for="beneficiarioDP-0" class="form-label">Nº Beneficiados *</label>
                                                                <input type="number" class="form-control  mb-lg-1" name="beneficiarioDP"
                                                                    id="beneficiarioDP-0" value="<?php echo e(old('beneficiarioDP')); ?>" placeholder="0.00"
                                                                    min="0" />
                    
                                                                <?php if($errors->has('beneficiarioDP')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('beneficiarioDP')); ?></span>
                                                                <?php endif; ?>
                    
                                                            </div>
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="empregosDirectos" class="form-label">Empregos directos
                                                                    criados *</label>
                                                                <input type="number" class="form-control mb-lg-1"
                                                                    name="empregosDirectos"
                                                                    value="<?php echo e(old('empregosDirectos')); ?>"
                                                                    id="empregosDirectos" placeholder="0" min="0" />

                                                                <?php if($errors->has('empregosDirectos')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('empregosDirectos')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="kitsDistribuidos" class="form-label">Nº Kits Distribuidos
                                                                     *</label>
                                                                <input type="number" class="form-control mb-lg-1"
                                                                    name="kitsDistribuidos"
                                                                    value="<?php echo e(old('kitsDistribuidos')); ?>"
                                                                    id="kitsDistribuidos" placeholder="0" min="0" />

                                                                <?php if($errors->has('kitsDistribuidos')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('kitsDistribuidos')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>


                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                      
                                    </div>

                                </div>
                                <div>


                                </div>
                            </div>
                            <!-- end card body -->
                        </div>

                        <div class="text-end mb-4">
                            <button type="reset" class="btn btn-danger w-sm">Cancelar</button>
                            
                            <button type="submit" class="btn btn-primary w-sm" id="btn-criar-projecto" >
                                <i class="ri-save-line me-1"></i>Confirmar e Salvar
                            </button>
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>

            </form>

            <!-- end row -->
        </div>

<!-- Adicionar dinamicamente Cronograma das actividades -->

<script>

 // ----------- FIM ÁREA QUE GERA O CÓDIGO DO PROJECTO DINAMICAMENTE ---------------   

document.getElementById('nomeProjecto').addEventListener('input', function() {
    const nomeProjecto = this.value;
    const codProjectoField = document.getElementById('codProjecto');
    
    if (nomeProjecto) {
        // Pegar iniciais (maiúsculas) de cada palavra
        const iniciais = nomeProjecto
            .split(' ')
            .filter(word => word.length > 2)
            .map(word => word[0].toUpperCase())
            .join('');
        
        // Obter data atual
        const now = new Date();
        const mes = String(now.getMonth() + 1).padStart(2, '0'); // mês com 2 dígitos
        const ano = now.getFullYear();
        
        // Formatando o código
        const phpCodRef = <?php echo e($codRef); ?>;
        const codigo = `${iniciais}.${mes}.${ano}.${phpCodRef+1}`;
        
        // Atualizar o campo
        codProjectoField.value = codigo;
    } else {
        codProjectoField.value = '';
    }
});
// ----------- FIM ÁREA QUE GERA O CÓDIGO DO PROJECTO DINAMICAMENTE ---------------




    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('add-product1').addEventListener('click', function () {
            const container = document.getElementById('products-container1');
            const productGroups1 = document.querySelectorAll('.product-group1');
            const newIndex = productGroups1.length;
            const anoPrimeiro = new Date().getFullYear();

            const newProductGroup = document.createElement('div');
            newProductGroup.className = 'product-group1';
            newProductGroup.innerHTML = ` <div class="row">

                                            <h6 class="card-title mb-0 "><hr>${newIndex + 1}º Actividade<br><br> </h6>


                                                    <div class="col-lg-3">
                                                        <div class="mb-3 mb-lg-2">
                                                            <label for="actividadeAno-${newIndex}"
                                                                class="form-label">Ano de Execução *</label>
                                                                <select class="form-select"  name="actividadeAno[${newIndex}]" id="actividadeAno-${newIndex}" data-choices
                                                                    data-choices-search-false id="choices-categories-input">
                                                                    <option value="" selected>Selecione</option>
                                                                    <option value="<?php echo e(now()->format('Y')); ?>"><?php echo e(now()->format('Y')); ?></option>
                                                                    <option value="<?php echo e(now()->format('Y') + 1); ?>"><?php echo e(now()->format('Y') + 1); ?></option>
                                                                    <option value="<?php echo e(now()->format('Y') + 2); ?>"><?php echo e(now()->format('Y') + 2); ?></option>
                                                                </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3">
                                                        <div class="mb-3 mb-lg-2">
                                                            <label for="actividadePercentual-${newIndex}" class="form-label"> % Peso*</label>
                                                            <input type="number" class="form-control"name="actividadePercentual[${newIndex}]" id="actividadePercentual-${newIndex}" placeholder="0"  />
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3">
                                                        <div class="mb-3 mb-lg-3">
                                                            <label for="actividadeDataInicio-${newIndex}" class="form-label">
                                                                Início *</label>
                                                            <input type="date" class="form-control" id="actividadeDataInicio-${newIndex}" name="actividadeDataInicio[${newIndex}]" placeholder="DD/MM/AAAA" style="font-size: 11px;" data-provider="flatpickr">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3">
                                                        <div class="mb-3 mb-lg-3">
                                                            <label for="actividadeDataFim-${newIndex}" class="form-label">Término *</label>
                                                            <input type="date" class="form-control" id="actividadeDataFim-${newIndex}" name="actividadeDataFim[${newIndex}]" placeholder="DD/MM/AAAA" style="font-size: 11px;" data-provider="flatpickr">
                                                        </div>
                                                    </div>



                                                     <div class="col-lg-12">
                                                        <div class="mb-3 mb-lg-2">
                                                            <label for="actividadeDescricao-${newIndex}" class="form-label">Descrição da
                                                                Execução Fisica *</label>
                                                            <textarea class="form-control mb-lg-1"
                                                                name="actividadeDescricao[${newIndex}]" id="actividadeDescricao-${newIndex}" rows="6" placeholder="Descrição"></textarea>
                                                        </div>
                                                    </div>



                                        <div class="col-lg-5">
                                                        <div class="mb-3 mb-lg-2">
                                                            <button type="button" class="btn btn-danger btn-sm remove-product1">Remover</button>
                                                        </div>


                                        </div>

                                    `;

        container.appendChild(newProductGroup);

        // Adicionar evento de remoção
        newProductGroup.querySelector('.remove-product1').addEventListener('click', function () {
            container.removeChild(newProductGroup);
        });
    });

    // Adicionar evento de remoção para o primeiro produto (se existir botão)
    const firstRemoveBtn1 = document.querySelector('.product-group1 .remove-product1');
    if (firstRemoveBtn1) {
        firstRemoveBtn1.addEventListener('click', function () {
            document.getElementById('products-container1').removeChild(this.closest('.product-group1'));
        });
    }


    document.getElementById('add-product2').addEventListener('click', function () {
        const container = document.getElementById('products-container2');
        const productGroups2 = document.querySelectorAll('.product-group2');
        const newIndex = productGroups2.length;
        const anoPrimeiro = new Date().getFullYear();

        const newProductGroup = document.createElement('div');
        newProductGroup.className = 'product-group2';
        newProductGroup.innerHTML = ` <div class="row">

                                            <h6 class="card-title mb-0 "><br><hr>${newIndex + 1}º Despesa<br><br> </h6>
                                                   
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="ano-${newIndex}" class="form-label">Ano de Execução
                                                                    *</label>
                                                                <select class="form-select"
                                                                    name="despesaAno[${newIndex}]" id="ano-${newIndex}">
                                                                    <option value="" <?php echo e(!old('despesaAno.${newIndex}') ? 'selected' : ''); ?>>Selecione</option>
                                                                    <?php $__currentLoopData = [now()->format('Y'), (now()->format('Y') + 1), (now()->format('Y') + 2)]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option); ?>" <?php echo e(old('despesaAno.${newIndex}') == $option ? 'selected' : ''); ?>>
                                                                            <?php echo e($option); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>

                                                                <?php if($errors->has('despesaAno.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaAno.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaValor-${newIndex}" class="form-label"> Valor AOA
                                                                    *</label>
                                                                <input type="number" class="form-control  mb-lg-1"
                                                                    value="<?php echo e(old('despesaValor.${newIndex}')); ?>"
                                                                    name="despesaValor[${newIndex}]"
                                                                    id="despesaValor-${newIndex}" placeholder="0,00" />

                                                                <?php if($errors->has('despesaValor.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaValor.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaDatainicial-${newIndex}" class="form-label">Início *</label>
                                                                <input type="date" class="form-control  mb-lg-1"
                                                                    id="despesaDatainicial-${newIndex}"
                                                                    value="<?php echo e(old('despesaDatainicial.${newIndex}')); ?>"
                                                                    name="despesaDatainicial[${newIndex}]"
                                                                    placeholder="DD/MM/AAAA" style="font-size: 11px;"
                                                                    data-provider="flatpickr">

                                                                <?php if($errors->has('despesaDatainicial.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaDatainicial.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaDatafinal-${newIndex}" class="form-label">Término
                                                                    *</label>
                                                                <input type="date" class="form-control  mb-lg-1"
                                                                    id="despesaDatafinal-${newIndex}"
                                                                    value="<?php echo e(old('despesaDatafinal.${newIndex}')); ?>"
                                                                    name="despesaDatafinal[${newIndex}]"
                                                                    placeholder="DD/MM/AAAA" style="font-size: 11px;"
                                                                    data-provider="flatpickr">

                                                                <?php if($errors->has('despesaDatafinal.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaDatafinal.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>



                                                        <div class="col-lg-12">
                                                            <div class="mb-3 mb-lg-2">
                                                                <label for="despesaDescricao-${newIndex}" class="form-label">Descrição da
                                                                    Execução Fisica *</label>
                                                                <textarea class="form-control mb-lg-1"
                                                                    name="despesaDescricao[${newIndex}]"
                                                                    id="despesaDescricao-${newIndex}" rows="6"
                                                                    placeholder="Descrição"><?php echo e(old('despesaDescricao.${newIndex}')); ?></textarea>

                                                                <?php if($errors->has('despesaDescricao.*')): ?>
                                                                    <span
                                                                        class="text-danger d-sm-flex"><?php echo e($errors->first('despesaDescricao.*')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>




                                        <div class="col-lg-5">
                                                        <div class="mb-3 mb-lg-2">
                                                            <button type="button" class="btn btn-danger btn-sm remove-product2">Remover</button>
                                                        </div>


                                        </div>

                                    `;

        container.appendChild(newProductGroup);

        // Adicionar evento de remoção
        newProductGroup.querySelector('.remove-product2').addEventListener('click', function () {
            container.removeChild(newProductGroup);
        });
    });

    // Adicionar evento de remoção para o primeiro produto (se existir botão)
    const firstRemoveBtn2 = document.querySelector('.product-group2 .remove-product2');
    if (firstRemoveBtn2) {
        firstRemoveBtn2.addEventListener('click', function () {
            document.getElementById('products-container2').removeChild(this.closest('.product-group2'));
        });
    }

});


</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layout.LayoutBaseCliente', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Clientes/CriarProjecto.blade.php ENDPATH**/ ?>