<?php $__env->startSection('title', 'Editar Projeto'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Breadcrumb -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">Editar Projeto</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('homePromotor')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('Listar-Projecto')); ?>">Projetos</a></li>
                        <li class="breadcrumb-item active">Editar</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Form de Edição -->
    <form method="POST" action="<?php echo e(route('projetos.update', $projeto->id)); ?>" enctype="multipart/form-data" id="formEditarProjecto">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">
                            <i class="ri-edit-line me-2"></i>Dados do Projeto
                        </h4>
                        
                        <!-- Informações Básicas -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="codProjecto" class="form-label">Código do Projeto <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="codProjecto" id="codProjecto" 
                                           value="<?php echo e(old('codProjecto', $projeto->codProjecto)); ?>" required>
                                    <?php $__errorArgs = ['codProjecto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nomeProjecto" class="form-label">Nome do Projecto <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="nomeProjecto" id="nomeProjecto" 
                                           value="<?php echo e(old('nomeProjecto', $projeto->nomeProjecto)); ?>" required>
                                    <?php $__errorArgs = ['nomeProjecto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tipo" class="form-label">Tipo de Projecto <span class="text-danger">*</span></label>
                                    <select class="form-select" name="tipo" id="tipo" required>
                                        <option value="">Selecione o tipo</option>
                                        <?php $__currentLoopData = $tipoprojecto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($tipo->id); ?>" 
                                                <?php echo e(old('tipo', $projeto->tipo) == $tipo->id ? 'selected' : ''); ?>>
                                                <?php echo e($tipo->nomeTP); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['tipo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="limiteorcamentalP" class="form-label">Custo Total do Projecto (AOA) <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" name="limiteorcamentalP" id="limiteorcamentalP" 
                                           value="<?php echo e(old('limiteorcamentalP', $projeto->limiteorcamentalP)); ?>" step="0.01" required>
                                    <?php $__errorArgs = ['limiteorcamentalP'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="duracaoP" class="form-label">Data de Início <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="duracaoP" id="duracaoP" 
                                           value="<?php echo e(old('duracaoP', $projeto->duracaoP)); ?>" required>
                                    <?php $__errorArgs = ['duracaoP'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="duracaoF" class="form-label">Data de Fim <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="duracaoF" id="duracaoF" 
                                           value="<?php echo e(old('duracaoF', $projeto->duracaoF)); ?>" required>
                                    <?php $__errorArgs = ['duracaoF'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="descricaoObjectivo" class="form-label">Descrição/Objetivo <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="descricaoObjectivo" id="descricaoObjectivo" 
                                              rows="4" required><?php echo e(old('descricaoObjectivo', $projeto->descricaoObjectivo)); ?></textarea>
                                    <?php $__errorArgs = ['descricaoObjectivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Cronograma Físico -->
                        <h5 class="mb-3">
                            <i class="ri-calendar-line me-2"></i>Cronograma Físico das Atividades
                            <button type="button" class="btn btn-sm btn-success ms-2" id="add-atividade">
                                <i class="ri-add-line me-1"></i>Adicionar Atividade
                            </button>
                        </h5>
                        
                        <div id="cronograma-container">
                            <?php $__currentLoopData = $projeto->cronogramasFisicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cronograma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card border-light mb-3 cronograma-item">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="card-title mb-0"><?php echo e($index + 1); ?>ª Atividade</h6>
                                            <?php if($index > 0): ?>
                                                <button type="button" class="btn btn-sm btn-danger remove-cronograma">
                                                    <i class="ri-delete-bin-line"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Ano <span class="text-danger">*</span></label>
                                                    <select class="form-select" name="actividadeAno[<?php echo e($index); ?>]" required>
                                                        <option value="">Selecione</option>
                                                        <?php for($ano = date('Y'); $ano <= date('Y') + 5; $ano++): ?>
                                                            <option value="<?php echo e($ano); ?>" 
                                                                <?php echo e(old("actividadeAno.$index", $cronograma->ano) == $ano ? 'selected' : ''); ?>>
                                                                <?php echo e($ano); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Data Início <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" name="actividadeDataInicio[<?php echo e($index); ?>]" 
                                                           value="<?php echo e(old("actividadeDataInicio.$index", $cronograma->data_inicio)); ?>" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Data Fim <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" name="actividadeDataFim[<?php echo e($index); ?>]" 
                                                           value="<?php echo e(old("actividadeDataFim.$index", $cronograma->data_fim)); ?>" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Percentual (%) <span class="text-danger">*</span></label>
                                                    <input type="number" class="form-control" name="actividadePercentual[<?php echo e($index); ?>]" 
                                                           value="<?php echo e(old("actividadePercentual.$index", $cronograma->percentual)); ?>" 
                                                           min="0" max="100" step="0.01" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Descrição da Atividade <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="actividadeDescricao[<?php echo e($index); ?>]" 
                                                              rows="3" required><?php echo e(old("actividadeDescricao.$index", $cronograma->descricao)); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <hr class="my-4">

                        <!-- Programação Financeira -->
                        <h5 class="mb-3">
                            <i class="ri-money-dollar-circle-line me-2"></i>Programação Financeira
                            <button type="button" class="btn btn-sm btn-success ms-2" id="add-despesa">
                                <i class="ri-add-line me-1"></i>Adicionar Despesa
                            </button>
                        </h5>
                        
                        <div id="despesas-container">
                            <?php $__currentLoopData = $projeto->programacoesFinanceiras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $programacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card border-light mb-3 despesa-item">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="card-title mb-0"><?php echo e($index + 1); ?>ª Despesa</h6>
                                            <?php if($index > 0): ?>
                                                <button type="button" class="btn btn-sm btn-danger remove-despesa">
                                                    <i class="ri-delete-bin-line"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Ano <span class="text-danger">*</span></label>
                                                    <select class="form-select" name="despesaAno[<?php echo e($index); ?>]" required>
                                                        <option value="">Selecione</option>
                                                        <?php for($ano = date('Y'); $ano <= date('Y') + 5; $ano++): ?>
                                                            <option value="<?php echo e($ano); ?>" 
                                                                <?php echo e(old("despesaAno.$index", $programacao->ano) == $ano ? 'selected' : ''); ?>>
                                                                <?php echo e($ano); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Valor (AOA) <span class="text-danger">*</span></label>
                                                    <input type="number" class="form-control" name="despesaValor[<?php echo e($index); ?>]" 
                                                           value="<?php echo e(old("despesaValor.$index", $programacao->valor)); ?>" 
                                                           step="0.01" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Data Inicial <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" name="despesaDatainicial[<?php echo e($index); ?>]" 
                                                           value="<?php echo e(old("despesaDatainicial.$index", $programacao->data_inicial)); ?>" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Data Final <span class="text-danger">*</span></label>
                                                    <input type="date" class="form-control" name="despesaDatafinal[<?php echo e($index); ?>]" 
                                                           value="<?php echo e(old("despesaDatafinal.$index", $programacao->data_final)); ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Descrição da Execução Física <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" name="despesaDescricao[<?php echo e($index); ?>]" 
                                                              rows="3" required><?php echo e(old("despesaDescricao.$index", $programacao->descricao)); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <hr class="my-4">

                        <!-- Indicadores -->
                        <h5 class="mb-3">
                            <i class="ri-bar-chart-fill me-2"></i>Indicadores do Projeto
                        </h5>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="beneficiarioDP" class="form-label">Nº Beneficiados <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" name="beneficiarioDP" id="beneficiarioDP" 
                                           value="<?php echo e(old('beneficiarioDP', $projeto->beneficiarioDP)); ?>" min="0" required>
                                    <?php $__errorArgs = ['beneficiarioDP'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="Emprego" class="form-label">Empregos Diretos Criados <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" name="Emprego" id="Emprego" 
                                           value="<?php echo e(old('Emprego', $projeto->Emprego)); ?>" min="0" required>
                                    <?php $__errorArgs = ['Emprego'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="nKitsDistribuidos" class="form-label">Nº Kits Distribuídos <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" name="nKitsDistribuidos" id="nKitsDistribuidos" 
                                           value="<?php echo e(old('nKitsDistribuidos', $projeto->nKitsDistribuidos)); ?>" min="0" required>
                                    <?php $__errorArgs = ['nKitsDistribuidos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Botões de Ação -->
        <div class="row">
            <div class="col-12">
                <div class="text-end mb-4">
                    <a href="<?php echo e(route('Listar-Projecto')); ?>" class="btn btn-secondary me-2">
                        <i class="ri-arrow-left-line me-1"></i>Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="ri-save-line me-1"></i>Atualizar Projeto
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let cronogramaIndex = <?php echo e(count($projeto->cronogramasFisicos)); ?>;
    let despesaIndex = <?php echo e(count($projeto->programacoesFinanceiras)); ?>;

    // Adicionar atividade
    document.getElementById('add-atividade').addEventListener('click', function() {
        const container = document.getElementById('cronograma-container');
        const currentYear = new Date().getFullYear();
        
        const newItem = document.createElement('div');
        newItem.className = 'card border-light mb-3 cronograma-item';
        newItem.innerHTML = `
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="card-title mb-0">${cronogramaIndex + 1}ª Atividade</h6>
                    <button type="button" class="btn btn-sm btn-danger remove-cronograma">
                        <i class="ri-delete-bin-line"></i>
                    </button>
                </div>
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Ano <span class="text-danger">*</span></label>
                            <select class="form-select" name="actividadeAno[${cronogramaIndex}]" required>
                                <option value="">Selecione</option>
                                ${Array.from({length: 6}, (_, i) => currentYear + i).map(ano => 
                                    `<option value="${ano}">${ano}</option>`
                                ).join('')}
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Data Início <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="actividadeDataInicio[${cronogramaIndex}]" required>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Data Fim <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="actividadeDataFim[${cronogramaIndex}]" required>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Percentual (%) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="actividadePercentual[${cronogramaIndex}]" 
                                   min="0" max="100" step="0.01" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label">Descrição da Atividade <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="actividadeDescricao[${cronogramaIndex}]" rows="3" required></textarea>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        container.appendChild(newItem);
        cronogramaIndex++;
    });

    // Adicionar despesa
    document.getElementById('add-despesa').addEventListener('click', function() {
        const container = document.getElementById('despesas-container');
        const currentYear = new Date().getFullYear();
        
        const newItem = document.createElement('div');
        newItem.className = 'card border-light mb-3 despesa-item';
        newItem.innerHTML = `
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="card-title mb-0">${despesaIndex + 1}ª Despesa</h6>
                    <button type="button" class="btn btn-sm btn-danger remove-despesa">
                        <i class="ri-delete-bin-line"></i>
                    </button>
                </div>
                
                <div class="row">
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Ano <span class="text-danger">*</span></label>
                            <select class="form-select" name="despesaAno[${despesaIndex}]" required>
                                <option value="">Selecione</option>
                                ${Array.from({length: 6}, (_, i) => currentYear + i).map(ano => 
                                    `<option value="${ano}">${ano}</option>`
                                ).join('')}
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Valor (AOA) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="despesaValor[${despesaIndex}]" step="0.01" required>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Data Inicial <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="despesaDatainicial[${despesaIndex}]" required>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label class="form-label">Data Final <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="despesaDatafinal[${despesaIndex}]" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label">Descrição da Execução Física <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="despesaDescricao[${despesaIndex}]" rows="3" required></textarea>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        container.appendChild(newItem);
        despesaIndex++;
    });

    // Remover cronograma
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-cronograma')) {
            e.target.closest('.cronograma-item').remove();
        }
        
        if (e.target.closest('.remove-despesa')) {
            e.target.closest('.despesa-item').remove();
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseCliente', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Clientes/EditarProjecto.blade.php ENDPATH**/ ?>