<?php $__env->startSection('head-extra'); ?>
<style>
    .btn {
        cursor: pointer;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('Conteudo'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('tipo-projecto')); ?>">Tipos de Projeto</a></li>
                                <li class="breadcrumb-item active">Editar Tipo de Projeto</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Editar Tipo de Projeto: <?php echo e($tipo->descricao); ?></h4>
                        </div><!-- end card header -->

                        <div class="card-body">

                            <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                            <?php endif; ?>

                            <form action="<?php echo e(route('TipoProjecto-update', $tipo->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label for="descricao" class="form-label">Descrição <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="descricao" name="descricao" value="<?php echo e(old('descricao', $tipo->descricao)); ?>" required maxlength="60">
                                            <div class="form-text">Informe uma descrição única com até 60 caracteres.</div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">Status</label>
                                            <div class="form-check form-switch form-switch-md">
                                                <input class="form-check-input" type="checkbox" role="switch" id="status" name="status" value="1" <?php echo e($tipo->status == 1 ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="status">
                                                    <span class="badge <?php echo e($tipo->status == 1 ? 'bg-success' : 'bg-danger'); ?>" id="statusBadge">
                                                        <?php echo e($tipo->status == 1 ? 'Ativo' : 'Inativo'); ?>

                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-12">
                                        <a href="<?php echo e(route('tipo-projecto')); ?>" class="btn btn-secondary">Cancelar</a>
                                        <button type="submit" class="btn btn-primary"><i class="ri-save-line me-1"></i> Salvar Alterações</button>
                                    </div>
                                </div>
                            </form>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Atualiza o badge de status quando o switch é alterado
            const statusSwitch = document.getElementById('status');
            const statusBadge = document.getElementById('statusBadge');
            
            statusSwitch.addEventListener('change', function() {
                if (this.checked) {
                    statusBadge.className = 'badge bg-success';
                    statusBadge.textContent = 'Ativo';
                } else {
                    statusBadge.className = 'badge bg-danger';
                    statusBadge.textContent = 'Inativo';
                }
            });
        });
    </script>

</div>
<!-- end main content-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\FINANCIAL\resources\views/Administracao/EditarTipoProjecto.blade.php ENDPATH**/ ?>