<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Ficha de Inscrição - <?php echo e($projeto->nomeProjecto ?? 'Projeto'); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 2px solid #2a5298;
            padding-bottom: 15px;
        }
        
        .header h1 {
            color: #2a5298;
            font-size: 16px;
            margin: 4px 0;
        }
        
        .header h2 {
            color: #666;
            font-size: 14px;
            margin: 3px 0;
        }
        
        .section {
            margin-bottom: 20px;
            border: 1px solid #ccc;
        }
        
        .section-header {
            background: #2a5298;
            color: white;
            padding: 8px 12px;
            font-weight: bold;
            font-size: 12px;
        }
        
        .section-body {
            padding: 12px;
        }
        
        .project-header {
            background: #f8f9fa;
            padding: 12px;
            margin-bottom: 20px;
            border-left: 3px solid #2a5298;
        }
        
        .project-title {
            font-size: 16px;
            font-weight: bold;
            color: #2a5298;
            margin-bottom: 8px;
        }
        
        .field-row {
            margin-bottom: 8px;
        }
        
        .field-label {
            font-weight: bold;
            color: #495057;
            display: inline-block;
            width: 30%;
            vertical-align: top;
        }
        
        .field-value {
            display: inline-block;
            width: 68%;
            border-bottom: 1px dotted #ccc;
            min-height: 16px;
            padding-bottom: 2px;
            text-align: justify;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        
        th {
            background: #f0f0f0;
            font-weight: bold;
            padding: 6px;
            border: 1px solid #ccc;
            text-align: center;
            font-size: 10px;
        }
        
        td {
            padding: 6px;
            border: 1px solid #ccc;
            font-size: 10px;
        }
        
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            color: white;
        }
        
        .badge-success { background: #28a745; }
        .badge-warning { background: #ffc107; color: #000; }
        .badge-danger { background: #dc3545; }
        .badge-primary { background:rgb(72, 169, 196); }
        .badge-primary1 { background:rgb(51, 104, 179); }
        
        .signatures {
            margin-top: 30px;
            text-align: center;
        }
        
        .signature-box {
            display: inline-block;
            width: 45%;
            padding: 15px;
            margin: 10px;
            border: 1px solid #ccc;
            vertical-align: top;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 30px;
            padding-top: 4px;
            font-size: 9px;
        }
        
        .footer {
            text-align: center;
            font-size: 9px;
            color: #666;
        }
    </style>
</head>
<body>
    <img src="<?php echo e(asset('public/assets/images/logo-funea.jpg')); ?>" alt="" height="22">
    <div class="header">
        <h1>Ficha de Inscrição de Projecto - FUNEA</h1>
    </div>

    <div class="project-header">
        <div class="project-title"><?php echo e($projeto->nomeProjecto ?? 'N/A'); ?></div>
        <div class="field-row">
            <span class="field-label">Código:</span>
            <span class="field-value"><?php echo e($projeto->codProjecto ?? 'N/A'); ?></span>
        </div>
        <div class="field-row">
            <span class="field-label">Promotor:</span>
            <span class="field-value"><?php echo e($usuario->name ?? 'N/A'); ?></span>
        </div>
        <div class="field-row">
            <span class="field-label">Data de Criação:</span>
            <span class="field-value"><?php echo e($projeto->created_at ? $projeto->created_at->format('d/m/Y') : 'N/A'); ?></span>
        </div>
        <div class="field-row">
            <span class="field-label">Status:</span>
            <span class="field-value">
                <?php
                    $status = $projeto->status ?? 0;
                    $badgeClass = match($status) {
                        '0' => 'badge-primary',
                        '1' => 'badge-primary1',
                        '2' => 'badge-success',
                        '3' => 'badge-danger',
                        '4' => 'badge-warning',
                        '5' => 'badge-success',
                        default => 'badge-warning'
                    };
                    $statusText = [
                        0 => 'Recebido',
                        1 => 'Em Análise',
                        2 => 'Aprovado',
                        3 => 'Rejeitado',
                        4 => 'Em Execução',
                        5 => 'Concluído'
                    ];
                ?>
                <span class="badge <?php echo e($badgeClass); ?>">  <?php echo e($statusText[$projeto->status]); ?></span>
            
            </span>
        </div>
    </div>

    <div class="section">
        <div class="section-header">SEÇÃO I - IDENTIFICAÇÃO DO PROJETO</div>
        <div class="section-body">
            <div class="field-row">
                <span class="field-label">Objetivo do Projecto:</span>
                <span class="field-value"><br><?php echo $projeto->descricaoObjectivo ?? 'N/A'; ?></span>
            </div>
            <div class="field-row">
                <span class="field-label">Justificação:</span>
                <span class="field-value"><?php echo $projeto->justificacao ?? 'N/A'; ?></span>
            </div>
            <div class="field-row">
                <span class="field-label">Responsável:</span>
                <span class="field-value"><?php echo $projeto->aprovadoPor ?? 'N/A'; ?></span>
            </div>
            <div class="field-row">
                <span class="field-label">Nº de Beneficiários:</span>
                <span class="field-value"><?php echo e($projeto->beneficiarioDP ?? 'N/A'); ?></span>
            </div>
            <div class="field-row">
                <span class="field-label">Empregos Diretos:</span>
                <span class="field-value"><?php echo e($projeto->empregosDirectos ?? 'N/A'); ?></span>
            </div>
            <div class="field-row">
                <span class="field-label">Kits Distribuídos:</span>
                <span class="field-value"><?php echo e($projeto->kitsDistribuidos ?? 'N/A'); ?></span>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-header">SEÇÃO II - INFORMAÇÕES FINANCEIRAS</div>
        <div class="section-body">
            <div class="field-row">
                <span class="field-label">Custo Total do Projecto:</span>
                <span class="field-value">AOA <?php echo e(number_format($projeto->limiteorcamentalP ?? 0, 2, ',', '.')); ?></span>
            </div>
            <div class="field-row">
                <span class="field-label">Forma de Financiamento:</span>
                <span class="field-value"><?php echo e($projeto->mFuncionamento ?? 'N/A'); ?></span>
            </div>
        </div>
    </div>  

    <div class="section">
        <div class="section-header">SEÇÃO V - CRONOGRAMA FÍSICO</div>
        <div class="section-body">
            <?php if($projeto->cronogramasFisicos && $projeto->cronogramasFisicos->count() > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>Actividade</th>
                            <th>Ano</th>
                            <th>Percentual</th>
                            <th>Data Início</th>
                            <th>Data Fim</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $projeto->cronogramasFisicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cronograma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($cronograma->descricao ?? 'N/A'); ?></td>
                            <td><?php echo e($cronograma->ano ?? 'N/A'); ?></td>
                            <td><?php echo e($cronograma->percentual.'%' ?? 'N/A'); ?></td>
                            <td><?php echo e($cronograma->data_inicio ? date('d/m/Y', strtotime($cronograma->data_inicio)) : 'N/A'); ?></td>
                            <td><?php echo e($cronograma->data_fim ? date('d/m/Y', strtotime($cronograma->data_fim)) : 'N/A'); ?></td>
                            
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>Nenhum cronograma físico cadastrado.</p>
            <?php endif; ?>
        </div>
    </div>

    <div class="section">
        <div class="section-header">SEÇÃO VI - PROGRAMAÇÃO FINANCEIRA</div>
        <div class="section-body">
            <?php if($projeto->programacoesFinanceiras && $projeto->programacoesFinanceiras->count() > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>Descrição</th>
                            <th>Valor</th>
                            <th>Data Inicial</th>
                            <th>Data Final</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $totalGeral = 0; ?>
                        <?php $__currentLoopData = $projeto->programacoesFinanceiras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $programacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $totalGeral += $programacao->valor ?? 0; ?>
                        <tr>
                            <td><?php echo e($programacao->descricao ?? 'N/A'); ?></td>
                            <td>AOA <?php echo e(number_format($programacao->valor ?? 0, 2, ',', '.')); ?></td>
                            <td><?php echo e($programacao->created_at ? $programacao->created_at->format('d/m/Y') : 'N/A'); ?></td>
                            <td><?php echo e($programacao->updated_at ? $programacao->updated_at->format('d/m/Y') : 'N/A'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr style="background: #f0f0f0; font-weight: bold;">
                            <td>TOTAL GERAL</td>
                            <td>AOA <?php echo e(number_format($totalGeral, 2, ',', '.')); ?></td>
                            <td colspan="2">-</td>
                        </tr>
                    </tbody>
                </table>
            <?php else: ?>
                <p>Nenhuma programação financeira cadastrada.</p>
            <?php endif; ?>
        </div>
    </div>

    

    <div class="section">
        <div class="section-header">DECLARAÇÃO DE VERACIDADE</div>
        <div class="section-body">
            <p style="text-align: justify; margin-bottom: 15px; font-size: 11px; line-height: 1.5;">
                <strong>Eu, <?php echo e($usuario->name ?? '[Nome do Promotor]'); ?>, </strong>
                na qualidade de promotor do projecto "<?php echo e($projeto->nomeProjecto ?? '[Nome do Projeto]'); ?>", 
                declaro sob compromisso de honra que todas as informações prestadas nesta ficha são verdadeiras 
                e que me responsabilizo pela veracidade dos dados apresentados.
            </p>
            <p style="text-align: justify; font-size: 10px; line-height: 1.4; color: #666;">
                Declaro ainda estar ciente das implicações legais decorrentes de informações falsas ou 
                incorretas, sujeitando-me às penalidades previstas na legislação vigente.
            </p>
        </div>
    </div>

    

    <div class="footer">
        <div style="border-top: 1px solid #ccc; padding-top: 10px; margin-top: 15px;">
            <strong> FUNDO DE NACIONAL DE EMPREGO DE ANGOLA (FUNEA)</strong><br>
            Website: www.funea.gov.ao | Email: info@funea.gov.ao | Telefone: +244 222 000 000
        </div>
        <div style="margin-top: 10px; font-size: 9px; color: #999;">
            <strong>Documento gerado automaticamente em:</strong> <?php echo e($dataExportacao ?? date('d/m/Y H:i:s')); ?><br>
            <strong>Código do Projeto:</strong> <?php echo e($projeto->codProjecto ?? 'N/A'); ?> | 
            <strong>Versão:</strong> <?php echo e($projeto->versao ?? '1.0'); ?>

        </div>
    </div>

</body>
</html>
<?php /**PATH C:\laragon\www\FINANCIAL\resources\views/pdf/ficha-projeto-final-simples.blade.php ENDPATH**/ ?>