<?php

use App\Http\Controllers\AcessoController;
use App\Http\Controllers\BancoController;
use App\Http\Controllers\CoordenadasBancariasController;
use App\Http\Controllers\DepartamentoController;
use App\Http\Controllers\DesembolsoController;
use App\Http\Controllers\EmpresaController;
use App\Http\Controllers\EntidadeController;
use App\Http\Controllers\FuncionarioController;
use App\Http\Controllers\RemuneracaoController;
use App\Http\Controllers\FuncoesController;
use App\Http\Controllers\GrupoPessoaisController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\HomePromotorController;
use App\Http\Controllers\ProcessamentoSalarioController;
use App\Http\Controllers\ProjectoController;
use App\Http\Controllers\TipoProjectoController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// ROTAS PUBLICAS
Route::get('/me', function () {

    return view('Mail.NotificacaoCobranca');
});

Route::get('/mail', function () {
    Mail::send('Mail.NotificacaoCobranca', ['curso' => 'vALERY'], function ($m) {
        $m->to('cvalery.servluanda@gmail.com', 'Valery Tseyi');
        $m->subject('Condomínio');
    });
    dd('Sucesso');
    // return view('Mail.NotificacaoCobranca');
});
// Rotas de Controle de acesso
Route::get('/', [AcessoController::class, 'index'])->name('login');
Route::post('/loginP', [AcessoController::class, 'loginProcess'])->name('loginProcess');
Route::get('/login', [AcessoController::class, 'index'])->name('login');
// Route::view('/{path}','seguranca.auth-sigin');

// Redireciona quando não localiza a rota
Route::fallback(function () {
    return redirect()->route('login');
});

// ROTAS PRIVADAS DEFINIDAS POR GRUPOS DE USUÁRIOS (ADMINISTRADORES)

// =======================================================================================================================================================

Route::group(['middleware' => 'admin'], function () {

    // Logout do APP
    Route::get('/logout', [AcessoController::class, 'logoutProcess'])->name('logoutProcess');

    // Rotas da homePage de Administração
    Route::get('/HomeAdmin', [HomeController::class, 'index'])->name('home');

    // Rotas de Listar Projectos entidadePromotora
    Route::get('/EntidadePromotora', [EntidadeController::class, 'index'])->name('Listar-EntidadePromotora'); // LISTAR ENTIDADE PROMOTORA
    Route::post('/CriarEntidadePromotora', [EntidadeController::class, 'store'])->name('EntidadePromotora-store'); // LISTAR ENTIDADE PROMOTORA

    // Rotas de Promotor
    Route::post('/store-Promotor', [UserController::class, 'store'])->name('promotor-store'); // CADASTRAR PROMOTOR

    // Rotas Tipo de Projecto
    Route::get('/TipoProjecto', [TipoProjectoController::class, 'index'])->name('tipo-projecto'); // LISTAR TIPOS DE PROJETO
    Route::post('/store-TipoProjecto', [TipoProjectoController::class, 'store'])->name('TipoProjecto-store'); // CADASTRAR TIPO DE PROJETO
    Route::get('/edit-TipoProjecto/{id}', [TipoProjectoController::class, 'edit'])->name('TipoProjecto-edit'); // EDITAR TIPO DE PROJETO
    Route::put('/update-TipoProjecto/{id}', [TipoProjectoController::class, 'update'])->name('TipoProjecto-update'); // ATUALIZAR TIPO DE PROJETO
    Route::get('/toggle-status-TipoProjecto/{id}', [TipoProjectoController::class, 'toggleStatus'])->name('TipoProjecto-toggle'); // ATIVAR/DESATIVAR TIPO DE PROJETO
    Route::delete('/delete-TipoProjecto/{id}', [TipoProjectoController::class, 'destroy'])->name('TipoProjecto-delete'); // EXCLUIR TIPO DE PROJETO

    // Rotas de Gerenciamento de Usuários (CRUD completo)
    Route::get('/usuarios', [UserController::class, 'index'])->name('users.index'); // Listar todos os usuários
    Route::get('/usuarios/criar', [UserController::class, 'create'])->name('users.create'); // Formulário para criar usuário
    Route::post('/usuarios', [UserController::class, 'store'])->name('users.store'); // Cadastrar usuário
    Route::get('/usuarios/{id}', [UserController::class, 'show'])->name('users.show'); // Visualizar detalhes do usuário
    Route::get('/usuarios/{id}/editar', [UserController::class, 'edit'])->name('users.edit'); // Formulário para editar usuário
    Route::put('/usuarios/{id}', [UserController::class, 'update'])->name('users.update'); // Atualizar usuário
    Route::delete('/usuarios/{id}', [UserController::class, 'destroy'])->name('users.destroy'); // Excluir usuário
    Route::post('/usuarios/{id}/reset-senha', [UserController::class, 'resetPassword'])->name('users.reset-password'); // Redefinir senha

    // Rotas de Gestão de Projetos para Administradores
    Route::get('/admin/projetos', [ProjectoController::class, 'indexAdmin'])->name('admin.projetos.index'); // Listar projetos para admin
    Route::get('/admin/projetos/{id}', [ProjectoController::class, 'showAdmin'])->name('admin.projetos.show'); // Detalhes do projeto para admin
    Route::post('/admin/projetos/{id}/status', [ProjectoController::class, 'atualizarStatus'])->name('admin.projetos.status'); // Atualizar status
    Route::get('/admin/projetos/{id}/detalhes', [ProjectoController::class, 'obterDetalhes'])->name('admin.projetos.detalhes'); // Obter detalhes via AJAX
    Route::get('/admin/projetos/{id}/exportar-excel', [ProjectoController::class, 'exportarExcel'])->name('admin.projetos.exportar-excel'); // Exportar projeto para Excel
    Route::get('/admin/projetos/{id}/exportar-pdf', [ProjectoController::class, 'exportarPDFAdmin'])->name('admin.projetos.exportar-pdf'); // Exportar projeto para PDF
    Route::get('/admin/projetos/{id}/visualizar-pdf', [ProjectoController::class, 'visualizarPDFAdmin'])->name('admin.projetos.visualizar-pdf'); // Visualizar PDF do projeto

    // Rotas de Desembolso
    Route::get('/admin/desembolso', [DesembolsoController::class, 'indexAdmin'])->name('admin.desembolso.index'); // Listar projetos para admin

    // Rotas para gerenciamento de pagamentos
    Route::post('/admin/projetos/{projecto}/pagamento', [ProjectoController::class, 'registrarPagamento'])->name('admin.projetos.pagamento');
    Route::get('/admin/projetos/{projecto}/pagamentos', [ProjectoController::class, 'listarPagamentos'])->name('admin.projetos.pagamentos');

    // Rotas de Desembolso - Exportações
    Route::get('/admin/desembolso/exportar-pdf-geral', [DesembolsoController::class, 'exportarPDFGeral'])->name('admin.desembolso.exportar-pdf-geral');
    Route::get('/admin/desembolso/visualizar-pdf-geral', [DesembolsoController::class, 'visualizarPDFGeral'])->name('admin.desembolso.visualizar-pdf-geral');
    Route::get('/admin/desembolso/exportar-excel-geral', [DesembolsoController::class, 'exportarExcelGeral'])->name('admin.desembolso.exportar-excel-geral');
    Route::get('/admin/desembolso/exportar-pdf-instituicao', [DesembolsoController::class, 'exportarPDFInstituicao'])->name('admin.desembolso.exportar-pdf-instituicao');
    Route::get('/admin/desembolso/visualizar-pdf-instituicao', [DesembolsoController::class, 'visualizarPDFInstituicao'])->name('admin.desembolso.visualizar-pdf-instituicao');
    Route::get('/admin/desembolso/exportar-excel-instituicao', [DesembolsoController::class, 'exportarExcelInstituicao'])->name('admin.desembolso.exportar-excel-instituicao');

    // Rotas CRUD para Coordenadas Bancárias
    Route::resource('/coordenadas-bancarias', CoordenadasBancariasController::class);
    Route::get('/coordenadas-bancarias/{id}/toggle-status', [CoordenadasBancariasController::class, 'toggleStatus'])->name('coordenadas-bancarias.toggle-status');

    // Rotas CRUD para Departamentos
    Route::resource('/departamentos', DepartamentoController::class);
    Route::get('/departamentos/{id}/toggle-status', [DepartamentoController::class, 'toggleStatus'])->name('departamentos.toggle-status');

    // Rotas CRUD para Funções
    Route::resource('/funcoes', FuncoesController::class);
    Route::get('/funcoes/{id}/toggle-status', [FuncoesController::class, 'toggleStatus'])->name('funcoes.toggle-status');

    // Rotas CRUD para Grupos Pessoais
    Route::resource('/grupo-pessoais', GrupoPessoaisController::class);
    Route::get('/grupo-pessoais/{id}/toggle-status', [GrupoPessoaisController::class, 'toggleStatus'])->name('grupo-pessoais.toggle-status');

    // Rotas CRUD para Funcionários
    Route::resource('/funcionarios', FuncionarioController::class);
    Route::get('/funcionarios/{id}/toggle-status', [FuncionarioController::class, 'toggleStatus'])->name('funcionarios.toggle-status');
    // Atribuição de Remunerações a Funcionários
    Route::post('/funcionarios/{id}/remuneracoes', [FuncionarioController::class, 'storeRemuneracao'])->name('funcionarios.remuneracoes.store');
    // Coordenadas Bancárias
    Route::get('/funcionarios/{id}/coordenadas', [FuncionarioController::class, 'getCoordenadas'])->name('funcionarios.coordenadas.get');
    Route::post('/funcionarios/{id}/coordenadas', [FuncionarioController::class, 'updateCoordenadas'])->name('funcionarios.coordenadas.update');

    // Remunerações
    Route::resource('remuneracoes',RemuneracaoController::class);
    Route::get('remuneracoes/{id}/toggle-status', [RemuneracaoController::class, 'toggleStatus'])->name('remuneracoes.toggle-status');

    // Rotas para Banco (incompletas - apenas index e store)
    Route::get('/banco', [BancoController::class, 'index'])->name('banco.index');
    Route::post('/banco', [BancoController::class, 'store'])->name('banco.store');

    // Rotas para Empresa (incompletas - apenas index e store)
    Route::get('/empresa', [EmpresaController::class, 'index'])->name('empresa.index');
    Route::post('/empresa', [EmpresaController::class, 'store'])->name('empresa.store');

    // Rotas de Exportação Geral de Projetos
    Route::get('/admin/projetos/exportar-pdf-listagem', [ProjectoController::class, 'exportarPDFListagemGeral'])->name('admin.projetos.exportar-pdf-listagem');
    Route::get('/admin/projetos/visualizar-pdf-listagem', [ProjectoController::class, 'visualizarPDFListagemGeral'])->name('admin.projetos.visualizar-pdf-listagem');
    Route::get('/admin/projetos/exportar-excel-listagem', [ProjectoController::class, 'exportarExcelListagemGeral'])->name('admin.projetos.exportar-excel-listagem');

    // Rotas de Processamento de Salários
    Route::post('/processamento-salarios/preparar', [ProcessamentoSalarioController::class, 'create'])->name('processamento-salarios.preparar');
    Route::resource('/processamento-salarios', ProcessamentoSalarioController::class);
    Route::get('/processamento-salarios/{id}/exportar-pdf-geral', [ProcessamentoSalarioController::class, 'exportarPDFGeral'])->name('processamento-salarios.exportar-pdf-geral');
    Route::get('/processamento-salarios/{processamentoId}/recibo/{salarioId}', [ProcessamentoSalarioController::class, 'exportarPDFIndividual'])->name('processamento-salarios.recibo-individual');
    Route::post('/processamento-salarios/{processamentoId}/reenviar-email/{salarioId}', [ProcessamentoSalarioController::class, 'reenviarEmail'])->name('processamento-salarios.reenviar-email');
    Route::post('/processamento-salarios/{processamentoId}/reenviar-todos-emails', [ProcessamentoSalarioController::class, 'reenviarTodosEmails'])->name('processamento-salarios.reenviar-todos-emails');
    Route::post('/processamento-salarios/{processamentoId}/sincronizar-emails', [ProcessamentoSalarioController::class, 'sincronizarEmails'])->name('processamento-salarios.sincronizar-emails');

}); // FIM GRUPO DE ROTAS ADMINISTRAÇÃO

// =======================================================================================================================================================

// GRUPO DE ROTAS ENTIDADE PROMOTORA
Route::group(['middleware' => 'client'], function () {

    // Logout do APP
    Route::get('/logout', [AcessoController::class, 'logoutProcess'])->name('logoutProcess');

    // Rotas da homePage de clientes
    Route::get('/HomePromotor', [HomePromotorController::class, 'index'])->name('homePromotor');

    // Rotas de Cadastro de Projectos // Rotas de Listar Projectos
    Route::get('/CriarProjecto', [ProjectoController::class, 'index'])->name('Criar-Projecto'); // FORMULÁRIO DE CADASTRO
    Route::post('/StoreProjecto', [ProjectoController::class, 'store'])->name('Projecto-store'); // CADASTRAR PROJETO

    Route::get('/listarProjecto', [ProjectoController::class, 'show'])->name('Listar-Projecto'); // LISTAR PROJETO

    // Rota para visualizar detalhes do projeto com iniciativas e atividades
    Route::get('/projetos/{id}', [ProjectoController::class, 'viewDetails'])->name('projetos.show');
    // Rota para editar projeto
    Route::get('/projetos/{id}/editar', [ProjectoController::class, 'edit'])->name('projetos.edit');
    // Rota para atualizar projeto
    Route::put('/projetos/{id}/atualizar', [ProjectoController::class, 'update'])->name('projetos.update');
    // Rota para atualizar o status de uma iniciativa
    Route::patch('/iniciativas/{id}/status', [ProjectoController::class, 'updateIniciativaStatus'])->name('iniciativas.status');
    // Rota para atualizar o status de uma atividade
    Route::patch('/atividades/{id}/status', [ProjectoController::class, 'updateAtividadeStatus'])->name('atividades.status');

    // ROTAS PERFIL UTILIZADOR
    Route::get('/perfil', [UserController::class, 'showProfile'])->name('cliente.perfil.show');
    Route::put('/perfil/atualizar', [UserController::class, 'updateProfile'])->name('cliente.perfil.update');

    // Rotas para Projetos
    Route::get('/CriarProjecto', [ProjectoController::class, 'index'])->name('Criar-Projecto');
    Route::post('/StoreProjecto', [ProjectoController::class, 'store'])->name('Projecto-store');
    Route::get('/listarProjecto', [ProjectoController::class, 'show'])->name('Listar-Projecto');
    Route::get('/projetos/{id}/editar', [ProjectoController::class, 'edit'])->name('projetos.edit');
    Route::put('/projetos/{id}/atualizar', [ProjectoController::class, 'update'])->name('projetos.update');

    // Novas rotas para o CRUD completo
    Route::post('/projetos/resumo', [ProjectoController::class, 'getResumo'])->name('projetos.resumo');
    Route::get('/projetos/{id}', [ProjectoController::class, 'showDetails'])->name('projetos.show');
    Route::get('/projetos/{id}/visualizar-pdf', [ProjectoController::class, 'visualizarPDF'])->name('projetos.visualizar-pdf');
    Route::get('/projetos/{id}/exportar-pdf', [ProjectoController::class, 'exportarPDF'])->name('projetos.exportar-pdf');
    Route::get('/projetos/{id}/relatorio', [ProjectoController::class, 'downloadRelatorio'])->name('projetos.relatorio');
    Route::get('/projetos/{id}/relatorio-completo', [ProjectoController::class, 'downloadRelatorioCompleto'])->name('projetos.relatorio-completo');

    // Rotas para Relatórios de Execução
    Route::get('/projetos/{projeto}/relatorios', [\App\Http\Controllers\RelatorioExecucaoController::class, 'index'])->name('projetos.relatorios.index');
    Route::get('/projetos/{projeto}/relatorios/criar', [\App\Http\Controllers\RelatorioExecucaoController::class, 'create'])->name('projetos.relatorios.create');
    Route::post('/projetos/{projeto}/relatorios', [\App\Http\Controllers\RelatorioExecucaoController::class, 'store'])->name('projetos.relatorios.store');
    Route::get('/projetos/{projeto}/relatorios/{relatorio}', [\App\Http\Controllers\RelatorioExecucaoController::class, 'show'])->name('projetos.relatorios.show');
    Route::get('/projetos/{projeto}/relatorios/{relatorio}/edit', [\App\Http\Controllers\RelatorioExecucaoController::class, 'edit'])->name('projetos.relatorios.edit');
    Route::put('/projetos/{projeto}/relatorios/{relatorio}', [\App\Http\Controllers\RelatorioExecucaoController::class, 'update'])->name('projetos.relatorios.update');
    Route::delete('/projetos/{projeto}/relatorios/{relatorio}', [\App\Http\Controllers\RelatorioExecucaoController::class, 'destroy'])->name('projetos.relatorios.destroy');
    Route::get('/projetos/{projeto}/relatorios/{relatorio}/anexos/{anexo}', [\App\Http\Controllers\RelatorioExecucaoController::class, 'downloadAnexo'])->name('projetos.relatorios.anexos.download');
});
