<!DOCTYPE html>
<html><head><meta charset="UTF-8"><title>Recibo de Salário</title>
<style>
body{font-family:Arial,sans-serif;font-size:11px;margin:20px}
.header{text-align:center;margin-bottom:20px;border-bottom:2px solid #333;padding-bottom:10px}
.header h2{margin:5px 0;color:#333}
.info-row{display:inline-block;width:48%;margin-bottom:8px}
.label{font-weight:bold;color:#555}
table{width:100%;border-collapse:collapse;margin:15px 0}
th,td{border:1px solid #ddd;padding:8px;text-align:left}
th{background-color:#405189;color:white}
.text-right{text-align:right}
.total-row{background-color:#f0f0f0;font-weight:bold}
.footer{margin-top:30px;font-size:9px;text-align:center;color:#666}
</style></head><body>
<div class="header">
<h2>FUNEA - FUNDO NACIONAL DE EMPREGO DE ANGOLA</h2>
<h3>RECIBO DE SALÁRIO</h3>
<p><strong>Período:</strong> {{$processamento->nomeMes}}/{{$processamento->ano}}</p>
</div>

<div style="margin-bottom:20px">
<div class="info-row"><span class="label">Trabalhador:</span> {{$salario->nomeTrabalhador}}</div>
<div class="info-row"><span class="label">NBI:</span> {{$salario->nbi}}</div>
<div class="info-row"><span class="label">Função:</span> {{$salario->funcao}}</div>
<div class="info-row"><span class="label">Grupo:</span> {{$salario->grupoPessoal}}</div>
<div class="info-row"><span class="label">Unidade:</span> {{$processamento->unidadeProcessadora}}</div>
<div class="info-row"><span class="label">Data:</span> {{$processamento->dataProcessamento->format('d/m/Y')}}</div>
</div>

<table><thead><tr><th>Descrição</th><th class="text-right">Valor (Kz)</th></tr></thead><tbody>
<tr><td>Salário Base</td><td class="text-right">{{number_format($salario->salarioBase,2,',','.')}}</td></tr>
@if($salario->abonoFamiliar>0)<tr><td>Abono Familiar</td><td class="text-right">{{number_format($salario->abonoFamiliar,2,',','.')}}</td></tr>@endif
@if($salario->subTransporte>0)<tr><td>Subsídio de Transporte</td><td class="text-right">{{number_format($salario->subTransporte,2,',','.')}}</td></tr>@endif
@if($salario->subAlimentacao>0)<tr><td>Subsídio de Alimentação</td><td class="text-right">{{number_format($salario->subAlimentacao,2,',','.')}}</td></tr>@endif
@if($salario->subFerias>0)<tr><td>Subsídio de Férias</td><td class="text-right">{{number_format($salario->subFerias,2,',','.')}}</td></tr>@endif
@if($salario->subOutros>0)<tr><td>Outros Subsídios</td><td class="text-right">{{number_format($salario->subOutros,2,',','.')}}</td></tr>@endif
@if($salario->acrescimoExtra>0)<tr><td>Abono Extra</td><td class="text-right" style="color:green">+{{number_format($salario->acrescimoExtra,2,',','.')}}</td></tr>@endif
<tr class="total-row"><td>TOTAL BRUTO</td><td class="text-right">{{number_format($salario->totalBruto+$salario->acrescimoExtra,2,',','.')}}</td></tr>
<tr><td>Descontos (IRT e outros)</td><td class="text-right" style="color:red">-{{number_format($salario->desconto,2,',','.')}}</td></tr>
<tr class="total-row" style="background-color:#405189;color:white"><td>TOTAL LÍQUIDO</td><td class="text-right">{{number_format($salario->total,2,',','.')}}</td></tr>
</tbody></table>

<div style="margin-top:40px">
<p><strong>Por extenso:</strong> {{$salario->total}} Kwanzas</p>
</div>

<div class="footer">
<p>Este recibo foi gerado eletronicamente pelo Sistema de Gestão de Projectos/Iniciativas de Emprego - SIGEPIE</p>
<p>Processado em {{now()->format('d/m/Y H:i')}}</p>
</div>
</body></html>
