<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Gestão de Projetos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            line-height: 1.4;
            margin: 0;
            padding: 15px;
            color: #333;
        }
        
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #2c5aa0;
            padding-bottom: 10px;
        }
        
        .header h1 {
            color: #2c5aa0;
            font-size: 18px;
            margin: 0 0 5px 0;
            font-weight: bold;
        }
        
        .header p {
            margin: 0;
            color: #666;
            font-size: 9px;
        }
        
        .summary-section {
            background: #f8f9fa;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
            border-left: 4px solid #2c5aa0;
        }
        
        .summary-title {
            font-size: 12px;
            font-weight: bold;
            color: #2c5aa0;
            margin-bottom: 8px;
        }
        
        .summary-grid {
            display: table;
            width: 100%;
        }
        
        .summary-row {
            display: table-row;
        }
        
        .summary-cell {
            display: table-cell;
            padding: 3px 10px;
            vertical-align: top;
            width: 25%;
        }
        
        .summary-cell strong {
            font-size: 11px;
            color: #2c5aa0;
        }
        
        .summary-cell span {
            font-size: 10px;
            color: #333;
        }
        
        .status-badges {
            margin-top: 8px;
        }
        
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
            font-weight: bold;
            margin-right: 5px;
            color: white;
        }
        
        .badge-warning { background-color: #ffc107; color: #000; }
        .badge-info { background-color: #17a2b8; }
        .badge-success { background-color: #28a745; }
        .badge-danger { background-color: #dc3545; }
        .badge-primary { background-color: #007bff; }
        .badge-secondary { background-color: #6c757d; }
        
        .institution-section {
            margin-bottom: 20px;
            break-inside: avoid;
        }
        
        .institution-header {
            background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
            padding: 8px 12px;
            border-radius: 5px;
            margin-bottom: 8px;
            border-left: 4px solid #2196f3;
        }
        
        .institution-name {
            font-size: 12px;
            font-weight: bold;
            color: #1976d2;
            margin: 0;
        }
        
        .institution-stats {
            font-size: 9px;
            color: #666;
            margin-top: 2px;
        }
        
        .projects-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 8px;
        }
        
        .projects-table th {
            background-color: #2c5aa0;
            color: white;
            padding: 6px 4px;
            text-align: left;
            font-weight: bold;
            font-size: 8px;
        }
        
        .projects-table td {
            padding: 4px;
            border-bottom: 1px solid #dee2e6;
            vertical-align: top;
        }
        
        .projects-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        .project-code {
            font-weight: bold;
            color: #2c5aa0;
        }
        
        .project-name {
            max-width: 120px;
            word-wrap: break-word;
        }
        
        .project-cost {
            text-align: right;
            font-weight: bold;
            color: #28a745;
        }
        
        .footer {
            position: fixed;
            bottom: 10px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 8px;
            color: #666;
            border-top: 1px solid #dee2e6;
            padding-top: 5px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .fw-bold { font-weight: bold; }
        
        @media print {
            body { 
                margin: 0;
                padding: 10px;
            }
            .header h1 { font-size: 16px; }
            .summary-title { font-size: 11px; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Relatório de Gestão de Projetos</h1>
        <p>Sistema de Gestão Financeira | Gerado em {{ date('d/m/Y H:i:s') }}</p>
    </div>

    <div class="summary-section">
        <div class="summary-title">Resumo Geral</div>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell">
                    <strong>Total de Projetos:</strong><br>
                    <span>{{ $totalProjetos }}</span>
                </div>
                <div class="summary-cell">
                    <strong>Custo Total:</strong><br>
                    <span>{{ number_format($custoTotal, 2, ',', '.') }} Kz</span>
                </div>
                <div class="summary-cell">
                    <strong>Instituições:</strong><br>
                    <span>{{ $projetosPorInstituicao->count() }}</span>
                </div>
                <div class="summary-cell">
                    <strong>Custo Médio:</strong><br>
                    <span>{{ $totalProjetos > 0 ? number_format($custoTotal / $totalProjetos, 2, ',', '.') : '0,00' }} Kz</span>
                </div>
            </div>
        </div>
        
        <div class="status-badges">
            <span class="badge badge-warning">{{ $statusCounts['recebidos'] }} Recebidos</span>
            <span class="badge badge-info">{{ $statusCounts['em_analise'] }} Em Análise</span>
            <span class="badge badge-success">{{ $statusCounts['aprovados'] }} Aprovados</span>
            <span class="badge badge-danger">{{ $statusCounts['rejeitados'] }} Rejeitados</span>
            <span class="badge badge-primary">{{ $statusCounts['em_execucao'] }} Em Execução</span>
            <span class="badge badge-secondary">{{ $statusCounts['concluidos'] }} Concluídos</span>
        </div>
    </div>

    @foreach($projetosPorInstituicao as $instituicao => $projetos)
        <div class="institution-section">
            <div class="institution-header">
                <div class="institution-name">{{ $instituicao }}</div>
                <div class="institution-stats">
                    {{ $projetos->count() }} projetos | 
                    Custo Total: {{ number_format($projetos->sum('limiteorcamentalP'), 2, ',', '.') }} Kz |
                    <span class="badge badge-success">{{ $projetos->where('status', 2)->count() + $projetos->where('status', 4)->count() + $projetos->where('status', 5)->count() }}</span>
                    <span class="badge badge-info">{{ $projetos->where('status', 1)->count() }}</span>
                    <span class="badge badge-warning">{{ $projetos->where('status', 0)->count() }}</span>
                </div>
            </div>

            <table class="projects-table">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nome do Projeto</th>
                        <th>Tipo</th>
                        <th>Status</th>
                        <th>Custo (Kz)</th>
                        <th>Data</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($projetos as $projeto)
                        <tr>
                            <td class="project-code">{{ $projeto->codProjecto ?? 'N/A' }}</td>
                            <td class="project-name">{{ Str::limit($projeto->nomeProjecto ?? 'N/A', 40) }}</td>
                            <td>{{ $projeto->tipoProjecto->name ?? 'N/A' }}</td>
                            <td>
                                @switch($projeto->status)
                                    @case(0)
                                        <span class="badge badge-warning">Recebido</span>
                                        @break
                                    @case(1)
                                        <span class="badge badge-info">Em Análise</span>
                                        @break
                                    @case(2)
                                        <span class="badge badge-success">Aprovado</span>
                                        @break
                                    @case(3)
                                        <span class="badge badge-danger">Rejeitado</span>
                                        @break
                                    @case(4)
                                        <span class="badge badge-primary">Em Execução</span>
                                        @break
                                    @case(5)
                                        <span class="badge badge-secondary">Concluído</span>
                                        @break
                                    @default
                                        <span class="badge badge-secondary">N/A</span>
                                @endswitch
                            </td>
                            <td class="project-cost">{{ number_format($projeto->limiteorcamentalP ?? 0, 2, ',', '.') }}</td>
                            <td>{{ $projeto->created_at ? $projeto->created_at->format('d/m/Y') : 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if(!$loop->last && $loop->iteration % 2 == 0)
            <div class="page-break"></div>
        @endif
    @endforeach

    <div class="footer">
        <p>
            Sistema de Gestão Financeira | 
            Relatório gerado automaticamente em {{ date('d/m/Y H:i:s') }} | 
            Página <span class="pagenum"></span>
        </p>
    </div>
</body>
</html>
