<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Ficha de Inscrição - {{ $projeto->nomeProjecto ?? 'Projeto' }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
        }
        
        /* CABEÇALHO SIMPLES */
        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 2px solid #2a5298;
            padding-bottom: 15px;
        }
        
        .header h1 {
            color: #2a5298;
            font-size: 16px;
            margin: 5px 0;
        }
        
        .header h2 {
            color: #666;
            font-size: 14px;
            margin: 3px 0;
        }
        
        /* SEÇÕES */
        .section {
            margin-bottom: 20px;
            border: 1px solid #ccc;
        }
        
        .section-header {
            background: #2a5298;
            color: white;
            padding: 8px 12px;
            font-weight: bold;
            font-size: 12px;
        }
        
        .section-body {
            padding: 12px;
        }
        
        /* CAMPOS SIMPLES */
        .field-row {
            margin-bottom: 8px;
            width: 100%;
        }
        
        .field-label {
            font-weight: bold;
            color: #495057;
            display: inline-block;
            width: 30%;
            vertical-align: top;
        }
        
        .field-value {
            display: inline-block;
            width: 68%;
            border-bottom: 1px dotted #ccc;
            min-height: 16px;
            padding-bottom: 2px;
        }
        
        /* TABELAS SIMPLES */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        
        th {
            background: #f0f0f0;
            font-weight: bold;
            padding: 6px;
            border: 1px solid #ccc;
            text-align: center;
            font-size: 10px;
        }
        
        td {
            padding: 6px;
            border: 1px solid #ccc;
            font-size: 10px;
        }
        
        /* STATUS E BADGES */
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            color: white;
        }
        
        .badge-success { background: #28a745; }
        .badge-warning { background: #ffc107; color: #000; }
        .badge-danger { background: #dc3545; }
        
        /* ASSINATURAS SIMPLES */
        .signatures {
            margin-top: 30px;
            width: 100%;
        }
        
        .signature-box {
            display: inline-block;
            width: 48%;
            padding: 15px;
            text-align: center;
            border: 1px solid #ccc;
            vertical-align: top;
            margin-right: 2%;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 30px;
            padding-top: 4px;
            font-size: 9px;
        }
        
        /* RODAPÉ */
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ccc;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
        
        /* INFORMAÇÕES DO PROJETO */
        .project-header {
            background: #f8f9fa;
            padding: 12px;
            margin-bottom: 20px;
            border-left: 3px solid #2a5298;
        }
        
        .project-title {
            font-size: 16px;
            font-weight: bold;
            color: #2a5298;
            margin-bottom: 8px;
        }
        
        .section-title {
            font-weight: bold;
            margin-bottom: 10px;
            background-color: #f5f5f5;
            padding: 5px;
        }
        
        .field-row {
            display: flex;
            margin-bottom: 8px;
        }
        
        .field-label {
            width: 30%;
            font-weight: bold;
        }
        
        .field-value {
            width: 70%;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }
        
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        
        th {
            background-color: #f2f2f2;
        }
        
        .signature-section {
            margin-top: 30px;
        }
        
        .signature-line {
            border-top: 1px solid #000;
            width: 200px;
            margin-top: 40px;
            display: inline-block;
        }
        
        .decision-box {
            margin: 20px 0;
        }
        
        .empty-field {
            display: inline-block;
            border-bottom: 1px solid #333;
            min-width: 100px;
            margin: 0 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- CABEÇALHO -->
        <div class="header">
            <h1>Ficha de Inscrição de Projecto - FUNEA</h1>
        </div>

        <!-- INFORMAÇÕES BÁSICAS DO PROJETO -->
        <div class="project-header">
            <div class="project-title">{{ $projeto->nomeProjecto ?? 'N/A' }}</div>
            <div class="field-row">
                <span class="field-label">Código:</span>
                <span class="field-value">{{ $projeto->codProjecto ?? 'N/A' }}</span>
            </div>
            <div class="field-row">
                <span class="field-label">Promotor:</span>
                <span class="field-value">{{ $usuario->name ?? 'N/A' }}</span>
            </div>
            <div class="field-row">
                <span class="field-label">Data de Criação:</span>
                <span class="field-value">{{ $projeto->created_at ? $projeto->created_at->format('d/m/Y') : 'N/A' }}</span>
            </div>
            <div class="field-row">
                <span class="field-label">Status:</span>
                <span class="field-value">
                    @php
                        $status = $projeto->status ?? 'pendente';
                        $badgeClass = match($status) {
                            'aprovado' => 'badge-success',
                            'rejeitado' => 'badge-danger', 
                            'em-analise' => 'badge-info',
                            default => 'badge-warning'
                        };
                        if(isset($projeto->status)) {
                            switch($projeto->status) {
                                case 'aprovado': $status = 'success'; $statusText = 'Aprovado'; break;
                                case 'rejeitado': $status = 'danger'; $statusText = 'Rejeitado'; break;
                            }
                        }
                    @endphp
                    <div class="field-row">
                        <div class="field-label">Status:</div>
                        <div class="field-value"><span class="badge badge-{{ $status }}">{{ $statusText }}</span></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- SEÇÃO I: IDENTIFICAÇÃO DO PROJETO -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-info"></span>
                SEÇÃO I - IDENTIFICAÇÃO DO PROJETO
            </div>
            <div class="section-body">
                <div class="field-row">
                    <div class="field-label">Objetivo do Projeto:</div>
                    <div class="field-value">{!! $projeto->descricaoObjectivo ?? 'N/A' !!}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Justificação:</div>
                    <div class="field-value">{{ $projeto->justificacao ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Nº de Beneficiários Diretos:</div>
                    <div class="field-value">{{ $projeto->beneficiarioDP ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Empregos Diretos:</div>
                    <div class="field-value">{{ $projeto->empregosDirectos ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Kits Distribuídos:</div>
                    <div class="field-value">{{ $projeto->kitsDistribuidos ?? 'N/A' }}</div>
                </div>
            </div>
        </div>

        <!-- SEÇÃO II: INFORMAÇÕES FINANCEIRAS -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-money"></span>
                SEÇÃO II - INFORMAÇÕES FINANCEIRAS
            </div>
            <div class="section-body">
                <div class="field-row">
                    <div class="field-label">Limite Orçamental:</div>
                    <div class="field-value currency">{{ number_format($projeto->limiteorcamentalP ?? 0, 2, ',', '.') }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Meio de Funcionamento:</div>
                    <div class="field-value">{{ $projeto->mFuncionamento ?? 'N/A' }}</div>
                </div>
                @php
                    $totalProgramacao = $projeto->programacoesFinanceiras->sum('valor') ?? 0;
                @endphp
                <div class="field-row">
                    <div class="field-label">Total Programação Financeira:</div>
                    <div class="field-value currency">{{ number_format($totalProgramacao, 2, ',', '.') }}</div>
                </div>
            </div>
        </div>

        <!-- SEÇÃO III: LOCALIZAÇÃO -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-location"></span>
                SEÇÃO III - LOCALIZAÇÃO DO PROJETO
            </div>
            <div class="section-body">
                <div class="field-row">
                    <div class="field-label">Localização:</div>
                    <div class="field-value">{{ $projeto->localizacao_projecto ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Âmbito:</div>
                    <div class="field-value">{{ $projeto->ambito ?? 'N/A' }}</div>
                </div>
            </div>
        </div>

        <!-- SEÇÃO IV: DESCRIÇÃO DETALHADA -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-description"></span>
                SEÇÃO IV - DESCRIÇÃO DETALHADA
            </div>
            <div class="section-body">
                <div class="field-row">
                    <div class="field-label">Descrição Completa:</div>
                    <div class="field-value">{{ $projeto->descricaoObjectivo ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
        <!-- SEÇÃO V: CRONOGRAMA FÍSICO DAS ATIVIDADES -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-calendar"></span>
                SEÇÃO V - CRONOGRAMA FÍSICO DAS ATIVIDADES
            </div>
            <div class="section-body">
                @if($projeto->cronogramasFisicos && $projeto->cronogramasFisicos->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width: 35%;">Atividade</th>
                                <th style="width: 15%;">Frequência</th>
                                <th style="width: 10%;">Meta</th>
                                <th style="width: 15%;">Data Início</th>
                                <th style="width: 15%;">Data Fim</th>
                                <th style="width: 10%;">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($projeto->cronogramasFisicos as $cronograma)
                                <tr>
                                    <td>{{ $cronograma->atividade ?? 'N/A' }}</td>
                                    <td>{{ $cronograma->frequencia ?? 'N/A' }}</td>
                                    <td>{{ $cronograma->meta ?? 'N/A' }}</td>
                                    <td>{{ $cronograma->data_inicio ? date('d/m/Y', strtotime($cronograma->data_inicio)) : 'N/A' }}</td>
                                    <td>{{ $cronograma->data_fim ? date('d/m/Y', strtotime($cronograma->data_fim)) : 'N/A' }}</td>
                                    <td>
                                        @php
                                            $statusClass = 'warning';
                                            $statusText = 'Pendente';
                                            if($cronograma->status == 'concluido') {
                                                $statusClass = 'success';
                                                $statusText = 'Concluído';
                                            } elseif($cronograma->status == 'em_andamento') {
                                                $statusClass = 'info';
                                                $statusText = 'Em Andamento';
                                            }
                                        @endphp
                                        <span class="badge badge-{{ $statusClass }}">{{ $statusText }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="field-value empty">Nenhuma atividade cadastrada</div>
                @endif
            </div>
        </div>

        <!-- SEÇÃO VI: PROGRAMAÇÃO ORÇAMENTAL -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-money"></span>
                SEÇÃO VI - PROGRAMAÇÃO ORÇAMENTAL
            </div>
            <div class="section-body">
                @if($projeto->programacoesFinanceiras && $projeto->programacoesFinanceiras->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width: 40%;">Descrição da Despesa</th>
                                <th style="width: 15%;">Categoria</th>
                                <th style="width: 15%;">Data</th>
                                <th style="width: 15%;">Valor (AOA)</th>
                                <th style="width: 15%;">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $totalDespesas = 0; @endphp
                            @foreach($projeto->programacoesFinanceiras as $programacao)
                                @php $totalDespesas += $programacao->valor ?? 0; @endphp
                                <tr>
                                    <td>{{ $programacao->descricao ?? 'N/A' }}</td>
                                    <td>{{ $programacao->categoria ?? 'N/A' }}</td>
                                    <td>{{ $programacao->data ? date('d/m/Y', strtotime($programacao->data)) : 'N/A' }}</td>
                                    <td class="currency">{{ number_format($programacao->valor ?? 0, 2, ',', '.') }}</td>
                                    <td>
                                        @php
                                            $statusClass = 'warning';
                                            $statusText = 'Pendente';
                                            if($programacao->status == 'aprovado') {
                                                $statusClass = 'success';
                                                $statusText = 'Aprovado';
                                            } elseif($programacao->status == 'rejeitado') {
                                                $statusClass = 'danger';
                                                $statusText = 'Rejeitado';
                                            }
                                        @endphp
                                        <span class="badge badge-{{ $statusClass }}">{{ $statusText }}</span>
                                    </td>
                                </tr>
                            @endforeach
                            <tr class="total-row">
                                <td colspan="3"><strong>TOTAL GERAL</strong></td>
                                <td class="currency"><strong>{{ number_format($totalDespesas, 2, ',', '.') }}</strong></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                @else
                    <div class="field-value empty">Nenhuma programação financeira cadastrada</div>
                @endif
            </div>
        </div>

        <!-- SEÇÃO VII: INFORMAÇÕES DO PROMOTOR -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-user"></span>
                SEÇÃO VII - INFORMAÇÕES DO PROMOTOR
            </div>
            <div class="section-body">
                <div class="field-row">
                    <div class="field-label">Nome Completo:</div>
                    <div class="field-value">{{ $usuario->name ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Email:</div>
                    <div class="field-value">{{ $usuario->email ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Contato:</div>
                    <div class="field-value">{{ $usuario->telefone ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Cargo/Função:</div>
                    <div class="field-value">{{ $usuario->cargo ?? 'Promotor de Projetos' }}</div>
                </div>
            </div>
        </div>
        <!-- SEÇÃO VIII: INFORMAÇÕES BANCÁRIAS -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-bank"></span>
                SEÇÃO VIII - INFORMAÇÕES BANCÁRIAS E CONTACTO
            </div>
            <div class="section-body">
                <div class="field-row">
                    <div class="field-label">Banco:</div>
                    <div class="field-value">{{ $projeto->banco ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Número da Conta:</div>
                    <div class="field-value">{{ $projeto->numeroConta ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">IBAN:</div>
                    <div class="field-value">{{ $projeto->iban ?? 'N/A' }}</div>
                </div>
                <div class="field-row">
                    <div class="field-label">Contacto Principal:</div>
                    <div class="field-value">{{ $projeto->contactoPrincipal ?? $usuario->telefone ?? 'N/A' }}</div>
                </div>
            </div>
        </div>

        <!-- DECLARAÇÃO DE VERACIDADE -->
        <div class="section">
            <div class="section-header">
                <span class="section-icon icon-project"></span>
                DECLARAÇÃO DE VERACIDADE
            </div>
            <div class="section-body">
                <p style="text-align: justify; margin-bottom: 15px; font-size: 11px; line-height: 1.5;">
                    <strong>Eu, {{ $usuario->name ?? '[Nome do Promotor]' }}, </strong>
                    na qualidade de promotor do projeto "{{ $projeto->nomeProjecto ?? '[Nome do Projeto]' }}", 
                    declaro sob compromisso de honra que todas as informações prestadas nesta ficha são verdadeiras 
                    e que me responsabilizo pela veracidade dos dados apresentados.
                </p>
                <p style="text-align: justify; font-size: 10px; line-height: 1.4; color: #666;">
                    Declaro ainda estar ciente das implicações legais decorrentes de informações falsas ou 
                    incorretas, sujeitando-me às penalidades previstas na legislação vigente.
                </p>
            </div>
        </div>

        <!-- ASSINATURAS -->
        <div class="signatures clearfix">
            <div class="signature-box">
                <div style="margin-bottom: 15px;">
                    <strong>PROMOTOR DO PROJETO</strong>
                </div>
                <div style="margin-bottom: 10px; font-size: 10px;">
                    Nome: {{ $usuario->name ?? 'N/A' }}
                </div>
                <div style="margin-bottom: 10px; font-size: 10px;">
                    Email: {{ $usuario->email ?? 'N/A' }}
                </div>
                <div style="margin-bottom: 10px; font-size: 10px;">
                    Data: {{ date('d/m/Y') }}
                </div>
                <div class="signature-line">
                    Assinatura do Promotor
                </div>
            </div>

            <div class="signature-box">
                <div style="margin-bottom: 15px;">
                    <strong>ANÁLISE TÉCNICA - INAPEM</strong>
                </div>
                <div style="margin-bottom: 10px; font-size: 10px;">
                    Técnico Responsável: ___________________
                </div>
                <div style="margin-bottom: 10px; font-size: 10px;">
                    Código de Análise: ___________________
                </div>
                <div style="margin-bottom: 10px; font-size: 10px;">
                    Data de Análise: ___________________
                </div>
                <div class="signature-line">
                    Assinatura e Carimbo do Técnico
                </div>
            </div>
        </div>

        <!-- RODAPÉ -->
        <div class="footer">
            <div style="border-top: 1px solid #dee2e6; padding-top: 10px; margin-top: 15px;">
                <strong>INSTITUTO NACIONAL DE APOIO ÀS MICRO, PEQUENAS E MÉDIAS EMPRESAS (INAPEM)</strong><br>
                Ministério da Economia e Planeamento - República de Angola<br>
                Website: www.inapem.gov.ao | Email: info@inapem.gov.ao | Telefone: +244 222 000 000
            </div>
            <div style="margin-top: 10px; font-size: 9px; color: #999;">
                <strong>Documento gerado automaticamente em:</strong> {{ $dataExportacao ?? date('d/m/Y H:i:s') }}<br>
                <strong>Código do Projeto:</strong> {{ $projeto->codProjecto ?? 'N/A' }} | 
                <strong>Versão:</strong> {{ $projeto->versao ?? '1.0' }}
            </div>
        </div>

    </div>
</body>
</html>
                        <td>N.º de Beneficiários</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>N.º de Kits Distribuidos</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>Empregos Criaados</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="section">
            <div class="section-title">8. Detalhes Bancários da Entidade Promotora</div>
            <div class="field-row">
                <div class="field-label">Nome do Banco</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Endereço da Agência</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Contacto da Agência</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Número de Conta</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">IBAN</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Nome e Assinatura do 1º Titular da conta</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Nome e Assinatura do 2º Titular da conta</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Nome e Assinatura do 3º Titular da conta</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">Nome e Assinatura do 4º Titular da conta</div>
                <div class="field-value empty-field"></div>
            </div>
            <div class="field-row">
                <div class="field-label">NIF</div>
                <div class="field-value empty-field"></div>
            </div>
        </div>
        
        <div class="section">
            <div class="section-title">DECISÃO</div>
            <div class="field-row">
                <div class="field-label">Apreciada em</div>
                <div class="field-value empty-field"></div>
                <div class="field-label">Seguimento</div>
                <div class="field-value empty-field"></div>
            </div>
            
            <div class="field-row">
                <div class="field-label">Justificação da decisão tomada</div>
                <div class="field-value empty-field" style="width: 70%; height: 50px;"></div>
            </div>
            
            <div class="decision-box">
                <input type="checkbox" id="aprovado" name="decisao">
                <label for="aprovado">APROVADO</label>
                
                <input type="checkbox" id="rejeitada" name="decisao" style="margin-left: 20px;">
                <label for="rejeitada">REJEITADA</label>
            </div>
            
            <div class="signature-section">
                <p>Em <span class="empty-field"></span>/<span class="empty-field"></span>/<span class="empty-field"></span></p>
            </div>
        </div>
    </div>
</body>
</html>