<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Desembolsos Geral</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 15px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #405289;
        }
        
        .title {
            font-size: 16px;
            font-weight: bold;
            color: #405289;
            margin-bottom: 5px;
        }
        
        .subtitle {
            font-size: 12px;
            color: #666;
        }
        
        .resumo-geral {
            margin-bottom: 20px;
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
        }
        
        .resumo-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #405289;
        }
        
        .resumo-valores {
            display: inline-block;
            width: 100%;
        }
        
        .valor-item {
            display: inline-block;
            width: 30%;
            text-align: center;
            margin-right: 1%;
            padding: 8px;
            background-color: white;
            border-radius: 3px;
            border: 1px solid #dee2e6;
        }
        
        .valor-label {
            font-size: 9px;
            color: #666;
            margin-bottom: 3px;
        }
        
        .valor-numero {
            font-size: 11px;
            font-weight: bold;
        }
        
        .valor-numero.orcamentado { color: #007bff; }
        .valor-numero.desembolsado { color: #28a745; }
        .valor-numero.pendente { color: #dc3545; }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .table-header {
            background-color: #405289;
            color: white;
        }
        
        th, td {
            border: 1px solid #ccc;
            padding: 4px;
            font-size: 8px;
            text-align: center;
        }
        
        th {
            font-weight: bold;
            font-size: 9px;
        }
        
        .instituicao-row {
            background-color: #e9ecef;
            font-weight: bold;
            font-size: 9px;
        }
        
        .text-left { text-align: left; }
        .text-right { text-align: right; }
        
        .badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 7px;
            font-weight: bold;
            color: white;
        }
        
        .badge-warning { background-color: #ffc107; color: #212529; }
        .badge-info { background-color: #17a2b8; }
        .badge-success { background-color: #28a745; }
        .badge-danger { background-color: #dc3545; }
        .badge-primary { background-color: #007bff; }
        
        .footer {
            position: fixed;
            bottom: 10px;
            left: 15px;
            right: 15px;
            text-align: center;
            font-size: 8px;
            color: #666;
            border-top: 1px solid #ccc;
            padding-top: 5px;
        }
        
        .page-break {
            page-break-before: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">SIGEPE - FUNEA</div>
        <div class="title">RELATÓRIO GERAL DE DESEMBOLSOS</div>
        <div class="subtitle">Data de Geração: {{ $dataGeracao }}</div>
    </div>

    <div class="resumo-geral">
        <div class="resumo-title">RESUMO EXECUTIVO GERAL</div>
        <div class="resumo-valores">
            <div class="valor-item">
                <div class="valor-label">Total Orçamentado</div>
                <div class="valor-numero orcamentado">{{ number_format($totalProjetosExecucao, 2, ',', '.') }} Kz</div>
            </div>
            <div class="valor-item">
                <div class="valor-label">Total Desembolsado</div>
                <div class="valor-numero desembolsado">{{ number_format($totalPago, 2, ',', '.') }} Kz</div>
            </div>
            <div class="valor-item">
                <div class="valor-label">Total por Desembolsar</div>
                <div class="valor-numero pendente">{{ number_format($totalProjetosExecucao - $totalPago, 2, ',', '.') }} Kz</div>
            </div>
        </div>
        <div style="margin-top: 10px; text-align: center;">
            <strong>Percentual de Execução: 
                @php $percentualGeral = $totalProjetosExecucao > 0 ? ($totalPago / $totalProjetosExecucao) * 100 : 0; @endphp
                {{ number_format($percentualGeral, 1, ',', '.') }}%
            </strong>
        </div>
    </div>

    <table>
        <thead class="table-header">
            <tr>
                <th style="width: 8%;">Código</th>
                <th style="width: 20%;">Designação</th>
                <th style="width: 8%;">Duração</th>
                <th style="width: 8%;">Status</th>
                <th style="width: 8%;">Província</th>
                <th style="width: 12%;">Tipo</th>
                <th style="width: 12%;">Custo Total (Kz)</th>
                <th style="width: 12%;">Desembolsado (Kz)</th>
                <th style="width: 6%;">Exec.%</th>
                <th style="width: 12%;">Por Desembolsar</th>
            </tr>
        </thead>
        <tbody>
            @foreach($projetos as $instituicao => $projetosInstituicao)
                <tr class="instituicao-row">
                    <td colspan="10" class="text-left">
                        <strong>{{ $instituicao ?? 'Instituição N/A' }}</strong>
                        ({{ $projetosInstituicao->count() }} {{ $projetosInstituicao->count() == 1 ? 'projeto' : 'projetos' }})
                    </td>
                </tr>
                @foreach($projetosInstituicao as $projeto)
                <tr>
                    <td>{{ $projeto->codProjecto }}</td>
                    <td class="text-left">{{ $projeto->nomeProjecto }}</td>
                    <td>{{ date('Y', strtotime($projeto->duracaoP)) }}-{{ date('Y', strtotime($projeto->duracaoF)) }}</td>
                    <td>
                        @php $statusLabels = ['Recebido', 'Em Análise', 'Aprovado', 'Rejeitado', 'Em Execução', 'Concluído']; @endphp
                        @php $statusClasses = ['warning', 'info', 'success', 'danger', 'primary', 'success']; @endphp
                        <span class="badge badge-{{ $statusClasses[$projeto->status] ?? 'warning' }}">
                            {{ $statusLabels[$projeto->status] ?? 'N/A' }}
                        </span>
                    </td>
                    <td>{{ $projeto->provincia ?? 'N/A' }}</td>
                    <td class="text-left">{{ $projeto->tipoProjecto->descricao ?? 'N/A' }}</td>
                    <td class="text-right">{{ number_format($projeto->limiteorcamentalP, 2, ',', '.') }}</td>
                    <td class="text-right">{{ number_format($projeto->valorTotalPago(), 2, ',', '.') }}</td>
                    <td>
                        @php $execucao = $projeto->limiteorcamentalP > 0 ? ($projeto->valorTotalPago() / $projeto->limiteorcamentalP) * 100 : 0; @endphp
                        {{ number_format($execucao, 1, ',', '.') }}%
                    </td>
                    <td class="text-right">{{ number_format($projeto->limiteorcamentalP - $projeto->valorTotalPago(), 2, ',', '.') }}</td>
                </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <div>SIGEPE - FUNEA | Sistema de Gestão de Projetos de Emprego</div>
        <div>Relatório gerado em {{ $dataGeracao }} | Página {PAGE_NUM} de {PAGE_COUNT}</div>
    </div>
</body>
</html>
