<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conta Criada - SIGEPIE FUNEA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            overflow: hidden;
        }
        .email-header {
            background-color: #1a5276;
            padding: 20px;
            text-align: center;
        }
        .email-logo {
            /* Responsividade aprimorada */
            max-height: 60px;
            height: auto;
            width: auto;
            max-width: 100%;
            
            /* Efeito de transição suave */
            transition: all 0.3s ease;
            
            /* Garante que a imagem não ultrapasse o container */
            display: block;
            margin: 0 auto;
        }
        
        /* Media Queries para ajustes específicos */
        @media only screen and (max-width: 480px) {
            .email-logo {
                max-height: 50px; /* Reduz um pouco em telas muito pequenas */
            }
            .email-header {
                padding: 15px 10px;
            }
            .email-header h2 {
                font-size: 1.25rem;
            }
        }
        
        @media only screen and (max-width: 320px) {
            .email-logo {
                max-height: 40px; /* Tamanho mínimo para manter legibilidade */
            }
        }
        
        .email-body {
            padding: 30px;
            background-color: #ffffff;
        }
        .email-footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #6c757d;
        }
        .btn-primary {
            background-color: #1a5276;
            border-color: #1a5276;
            padding: 10px 20px;
            font-weight: 500;
        }
        .credentials-box {
            background-color: #f8f9fa;
            border-left: 4px solid #1a5276;
            padding: 15px;
            margin: 20px 0;
            border-radius: 0 4px 4px 0;
        }
        .security-note {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 0 4px 4px 0;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Cabeçalho -->
        <div class="email-header ">
            <img src="https://giscardtecnologia.ao/funea-sigepie/public/assets/images/logo-light.png" alt="Logo FUNEIA" class="email-logo">
            <h6 style="color: white; margin-top: 10px;">SIGEPIE - FUNEA</h6> 
        </div>
        
        <!-- Corpo do E-mail -->
        <div class="email-body">
            <h3>Olá, {{ $nome }}!</h3>
            <p>Bem-vindo ao <strong>Sistema de Gestão de Projetos e Iniciativas de Emprego (SIGEPIE)</strong> do FUNEA.</p>
            <p>Sua conta de <strong>{{ $tipoUsuario }}</strong> foi criada com sucesso. Abaixo estão os detalhes para acesso:</p>
            
            <div class="credentials-box">
                <h5>Credenciais de Acesso</h5>
                <p><strong>E-mail:</strong> {{ $email }}</p>
                <p><strong>Senha temporária:</strong> {{ $palavra }}</p>
            </div>

            <div class="security-note">
                <h5><i class="bi bi-shield-lock"></i> Importante para sua segurança</h5>
                <p>Esta é uma senha temporária. Por favor, altere-a após o seu primeiro acesso ao sistema.</p>
            </div>

            <div class="d-grid gap-2">
                <a href="https://giscardtecnologia.ao/funea-sigepie/public/login" class="btn btn-primary">Acessar o SIGEPIE</a>
            </div>
            
            <p style="margin-top: 20px;">Se você não solicitou a criação desta conta, por favor ignore este e-mail ou entre em contato com o suporte técnico.</p>
        </div>
        
        <!-- Rodapé -->
        <div class="email-footer">
            <p>© {{ date('Y') }} SIGEPIE - FUNEA. Todos os direitos reservados.</p>
            <p>Largo do Ambiente - Rua dos Municípios Portugueses, Luanda - Angola<br>Tel ..: (+244) 222 760 257, Edifício do MAPTSS, 8º Andar.</p>
            
            <p>
                <a href="https://www.funea.gov.ao" style="color: #1a5276; text-decoration: none;">Website</a> | 
                <a href="mailto:contacto@funea.gov.ao" style="color: #1a5276; text-decoration: none;">Suporte</a>
            </p>
        </div>
    </div>
</body>
</html>
