<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>SIGEPE - FUNEA</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- App favicon -->
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.png') }}">

    <!-- Layout config Js -->
    <script src="{{ asset('assets/js/layout.js') }}"></script>
    <!-- Bootstrap Css -->
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="{{ asset('assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="{{ asset('assets/css/app.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="{{ asset('assets/css/custom.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('assets/libs/dropzone/dropzone.css') }}" rel="stylesheet" type="text/css" />
    
    @yield('head-extra')

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .limit-text {
            white-space: nowrap; /* Impede que o texto quebre em várias linhas */
            overflow: hidden; /* Esconde o texto que ultrapassa o limite */
            text-overflow: ellipsis; /* Adiciona reticências ao texto que ultrapassa o limite */
            max-width: 250px; /* Define a largura máxima da célula */
        }

                /* Solução definitiva para dropdown em tabelas */
        .dropdown-custom-wrapper {
            position: static; /* Mantém o botão no fluxo normal */
        }

        .dropdown-custom-wrapper .dropdown-menu {
            position: absolute;
            z-index: 1060; /* Superior ao z-index do Bootstrap (1050) */
            inset: auto auto 0px 0px; /* Posicionamento alternativo */
            transform: translate(0px, -40px); /* Ajuste de posição */
        }

        /* Garante que o dropdown não seja cortado por overflow
        .table-responsive {
            overflow: visible !important;
        } */
    
    </style>

</head>

<body>
<!-- Begin page -->
<div id="layout-wrapper">

    <header id="page-topbar">
    <div class="layout-width">
        <div class="navbar-header">
            <div class="d-flex">
                <!-- LOGO -->
                <div class="navbar-brand-box horizontal-logo">
                    <a href="{{ route('home') }}" class="logo logo-dark">
                        <span class="logo-sm">
                            <img src="{{ asset('assets/images/logo-sm.png') }}" alt="" height="22">
                        </span>
                        <span class="logo-lg">
                            <img src="{{ asset('assets/images/logo-dark.png') }}" alt="" height="17">
                        </span>
                    </a>
    
                    <a href="{{ route('home') }}" class="logo logo-light">
                        <span class="logo-sm">
                            <img src="{{ asset('assets/images/logo-sm.png') }}" alt="" height="22">
                        </span>
                        <span class="logo-lg">
                            <img src="{{ asset('assets/images/logo-light.png') }}" alt="" height="17">
                        </span>
                    </a>
                </div>
    
                <button type="button" class="btn btn-sm px-3 fs-16 header-item vertical-menu-btn topnav-hamburger material-shadow-none" id="topnav-hamburger-icon">
                    <span class="hamburger-icon">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </button>
    
                <!-- App Search-->
                <form class="app-search d-none d-md-block">
                    <div class="position-relative">
                        <input type="text" class="form-control" placeholder="Buscar..." autocomplete="off" id="search-options" value="">
                        <span class="mdi mdi-magnify search-widget-icon"></span>
                        <span class="mdi mdi-close-circle search-widget-icon search-widget-icon-close d-none" id="search-close-options"></span>
                    </div>
                    <div class="dropdown-menu dropdown-menu-lg" id="search-dropdown">
                        <div data-simplebar style="max-height: 320px;">
                            <!-- item-->
                            <div class="dropdown-header">
                                <h6 class="text-overflow text-muted mb-0 text-uppercase">Recent Searches</h6>
                            </div>
    
                            <div class="dropdown-item bg-transparent text-wrap">
                                <a href="index.html" class="btn btn-soft-secondary btn-sm rounded-pill">how to setup <i class="mdi mdi-magnify ms-1"></i></a>
                                <a href="index.html" class="btn btn-soft-secondary btn-sm rounded-pill">buttons <i class="mdi mdi-magnify ms-1"></i></a>
                            </div>
                            <!-- item-->
                            <div class="dropdown-header mt-2">
                                <h6 class="text-overflow text-muted mb-1 text-uppercase">Pages</h6>
                            </div>
    
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item notify-item">
                                <i class="ri-bubble-chart-line align-middle fs-18 text-muted me-2"></i>
                                <span>Analytics Dashboard</span>
                            </a>
    
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item notify-item">
                                <i class="ri-lifebuoy-line align-middle fs-18 text-muted me-2"></i>
                                <span>Help Center</span>
                            </a>
    
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item notify-item">
                                <i class="ri-user-settings-line align-middle fs-18 text-muted me-2"></i>
                                <span>My account settings</span>
                            </a>
    
                            <!-- item-->
                            <div class="dropdown-header mt-2">
                                <h6 class="text-overflow text-muted mb-2 text-uppercase">Members</h6>
                            </div>
    
                            <div class="notification-list">
                                <!-- item -->
                                <a href="javascript:void(0);" class="dropdown-item notify-item py-2">
                                    <div class="d-flex">
                                        <img src="{{ asset('assets/images/users/avatar-2.jpg') }}" class="me-3 rounded-circle avatar-xs" alt="user-pic">
                                        <div class="flex-grow-1">
                                            <h6 class="m-0">Angela Bernier</h6>
                                            <span class="fs-11 mb-0 text-muted">Manager</span>
                                        </div>
                                    </div>
                                </a>
                                <!-- item -->
                                <a href="javascript:void(0);" class="dropdown-item notify-item py-2">
                                    <div class="d-flex">
                                        <img src="{{ asset('assets/images/users/avatar-3.jpg') }}" class="me-3 rounded-circle avatar-xs" alt="user-pic">
                                        <div class="flex-grow-1">
                                            <h6 class="m-0">David Grasso</h6>
                                            <span class="fs-11 mb-0 text-muted">Web Designer</span>
                                        </div>
                                    </div>
                                </a>
                                <!-- item -->
                                <a href="javascript:void(0);" class="dropdown-item notify-item py-2">
                                    <div class="d-flex">
                                        <img src="{{ asset('assets/images/users/avatar-5.jpg') }}" class="me-3 rounded-circle avatar-xs" alt="user-pic">
                                        <div class="flex-grow-1">
                                            <h6 class="m-0">Mike Bunch</h6>
                                            <span class="fs-11 mb-0 text-muted">React Developer</span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
    
                        <div class="text-center pt-3 pb-1">
                            <a href="pages-search-results.html" class="btn btn-primary btn-sm">View All Results <i class="ri-arrow-right-line ms-1"></i></a>
                        </div>
                    </div>
                </form>
            </div>
    
            <div class="d-flex align-items-center">
    
                <div class="dropdown d-md-none topbar-head-dropdown header-item">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle" id="page-header-search-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="bx bx-search fs-22"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-search-dropdown">
                        <form class="p-3">
                            <div class="form-group m-0">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Buscar..." aria-label="Recipient's username">
                                    <button class="btn btn-primary" type="submit"><i class="mdi mdi-magnify"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
    
                
    
                
               
    
                <div class="ms-1 header-item d-none d-sm-flex">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle" data-toggle="fullscreen">
                        <i class='bx bx-fullscreen fs-22'></i>
                    </button>
                </div>
    
                <div class="ms-1 header-item d-none d-sm-flex">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle light-dark-mode">
                        <i class='bx bx-moon fs-22'></i>
                    </button>
                </div>
    
                <div class="dropdown topbar-head-dropdown ms-1 header-item" id="notificationDropdown">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle" id="page-header-notifications-dropdown" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true" aria-expanded="false">
                        <i class='bx bx-bell fs-22'></i>
                        <span class="position-absolute topbar-badge fs-10 translate-middle badge rounded-pill bg-danger">3<span class="visually-hidden">unread messages</span></span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-notifications-dropdown">
    
                        <div class="dropdown-head bg-primary bg-pattern rounded-top">
                            <div class="p-3">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h6 class="m-0 fs-16 fw-semibold text-white"> Notificões </h6>
                                    </div>
                                    <div class="col-auto dropdown-tabs">
                                        <span class="badge bg-light text-body fs-13"> 3 Novas</span>
                                    </div>
                                </div>
                            </div>
    
                        </div>
    
                        
                    </div>
                </div>
    
                <div class="dropdown ms-sm-3 header-item topbar-user">
                    <button type="button" class="btn material-shadow-none" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <span class="d-flex align-items-center">
                            <img src="{{ asset('assets/images/users/avatar-1.jpg') }}" alt="Header Avatar" class="rounded-circle header-profile-user">
                            <span class="text-start ms-xl-2">
                                <span class="d-none d-xl-inline-block ms-1 fw-medium user-name-text">
                                    
                                     {{-- MOSTRA O NOME DO USUÁRIO LOGADO NO SISTEMA --}}
                                @if (auth()->check())

                                {{ auth()->user()->name }}
                                    
                                @endif
                                </span>
                                <span class="d-none d-xl-block ms-1 fs-12 user-name-sub-text">Gestor</span>
                            </span>
                        </span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end">
                        <!-- item-->
                        <h6 class="dropdown-header">Bem-vindo(a)  @if (auth()->check())

                            {{ auth()->user()->name }}
                                
                            @endif</h6>
                        <a class="dropdown-item" href="{{ route('users.show', auth()->user()->id) }}"><i class="mdi mdi-account-circle text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Perfil</span></a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#"><i class="mdi mdi-wallet text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Carteira de Projectos : <b>{{ number_format(session('totalProjectosCarteira'), 2, ',', '.') }}</b></span></a>
                        <a class="dropdown-item" href="#"><span class="badge bg-success-subtle text-success mt-1 float-end">Novo</span><i class="mdi mdi-cog-outline text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Configurações</span></a>
                        <a class="dropdown-item" href="{{ route('logoutProcess') }}"><i class="mdi mdi-logout text-muted fs-16 align-middle me-1"></i> <span class="align-middle" data-key="t-logout">Logout</span></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </header>
    
    <!-- removeNotificationModal -->
    <div id="removeNotificationModal" class="modal fade zoomIn" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="NotificationModalbtn-close"></button>
            </div>
            <div class="modal-body">
                <div class="mt-2 text-center">
                    <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                    <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                        <h4>Are you sure ?</h4>
                        <p class="text-muted mx-4 mb-0">Are you sure you want to remove this Notification ?</p>
                    </div>
                </div>
                <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                    <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn w-sm btn-danger" id="delete-notification">Yes, Delete It!</button>
                </div>
            </div>
    
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <!-- ========== FIM TOP MENU ========== -->
    
    
    <!-- ======================================================================================================================== -->
    
    <!-- ========== AREA DE MENU ADMIN DO SISTEMA ========== -->
        <div class="app-menu navbar-menu">
            <!-- LOGO -->
            <div class="navbar-brand-box">
                <!-- Dark Logo-->
                <a href="{{ route('home') }}" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="{{ asset('assets/images/logo-sm.png') }}" alt="" height="32">
                    </span>
                    <span class="logo-lg">
                        <img src="{{ asset('assets/images/logo-dark.png') }}" alt="" height="26">
                    </span>
                </a>
                <!-- Light Logo-->
                <a href="{{ route('home') }}" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="{{ asset('assets/images/logo-sm.png') }}" alt="" height="32">
                    </span>
                    <span class="logo-lg">
                        <img src="{{ asset('assets/images/logo-light.png') }}" alt="" height="26">
                    </span>
                </a>
                <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
                    <i class="ri-record-circle-line"></i>
                </button>
            </div>
    
            
            <div id="scrollbar">
                <div class="container-fluid">
    
    
                    <div id="two-column-menu">
                    </div>
                    <ul class="navbar-nav" id="navbar-nav">
                        <li class="menu-title"><span data-key="t-menu">Menu</span></li>
                        
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth112" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth112">
                                <i class="  ri-dashboard-fill"></i><span data-key="t-Dashboards">Página Principal</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth112">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="{{ route('home') }}" class="nav-link" data-key="t-Gestão de Utilizadores">  FUNDO NACIONAL DE EMPREGO DE ANGOLA (FUNEA)
                                        </a>
                                        
                                    </li>
                                   
                                    
                                    
                                </ul>
                            </div>
                        </li>
    
                        <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-Paginas">Gestão do SIGEPIE</span></li>
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth1" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth1">
                                <i class="  ri-briefcase-4-fill"></i> <span data-key="t-Administrativa">Tabelas</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth1">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="#sidebarCrm" class="nav-link" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarCrm" data-key="t-level-2.2"> Tabelas Auxiliares
                                        </a>
                                        <div class="collapse menu-dropdown" id="sidebarCrm">
                                            <ul class="nav nav-sm flex-column">
                                                <li class="nav-item">
                                                    <a href="{{ route('Listar-EntidadePromotora') }}" class="nav-link" data-key="t-EntidadePromotora"> Entidade Promotora
                                                    </a>
                                                </li>                                               
                                                
                                                <li class="nav-item">
                                                    <a href="{{ route('tipo-projecto') }}" class="nav-link" data-key="t-DomíniodoProjecto"> Domínio do Projecto
                                                    </a>
                                                </li>                                                     
                                               
                                            </ul>
                                        </div>
                                    </li>
                                    <!-- <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Contratos"> Normativos </a>
                                    </li> -->
                                    
                                    
                                   
                                    
                                  
                                    
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#GestaoPessoas" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth">
                                <i class="ri-p2p-fill"></i> <span data-key="t-Finanças">Gestão de Pessoas</span>
                            </a>
                            <div class="collapse menu-dropdown" id="GestaoPessoas">
                                
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="#sidebarCrm" class="nav-link" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarCrm" data-key="t-level-2.2"> Grupo Auxiliar
                                        </a>
                                        <div class="collapse menu-dropdown" id="sidebarCrm">
                                            <ul class="nav nav-sm flex-column">
                                                <li class="nav-item">
                                                    <a href="{{ route('funcoes.index') }}" class="nav-link" data-key="t-Funções"> Funções
                                                    </a>
                                                </li>                                               
                                                
                                                <li class="nav-item">
                                                    <a href="{{ route('grupo-pessoais.index') }}" class="nav-link" data-key="t-GrupodePessoal"> Grupos de Pessoal
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a href="{{ route('coordenadas-bancarias.index') }}" class="nav-link" data-key="t-CoordenadasBancarias"> Coordenadas Bancárias
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a href="{{ route('departamentos.index') }}" class="nav-link" data-key="t-GrupodePessoal"> Unidades Processadoras
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a href="{{ route('funcionarios.index') }}" class="nav-link" data-key="t-GrupodePessoal"> Funcionários
                                                    </a>
                                                </li>  
                                                <li class="nav-item">
                                                    <a href="{{ route('remuneracoes.index') }}" class="nav-link" data-key="t-Remuneracoes"> Remunerações
                                                    </a>
                                                </li>                                                       
                                               
                                            </ul>
                                        </div>
                                    </li>
                                    
                                    
                                    <li class="nav-item">
                                        <a href="{{ route('processamento-salarios.index') }}" class="nav-link" data-key="t-Processamento de Salários">Processamento de Salários</a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Assiduidade"> Assiduidade</a>
                                    </li>

                                    
                                </ul>
                            </div>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth">
                                <i class=" ri-refund-2-line"></i> <span data-key="t-Finanças">Gestão de Projectos</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth">
                                <ul class="nav nav-sm flex-column">
                                    
                                    
                                    <li class="nav-item">
                                        <a href="{{ route('admin.projetos.index') }}" class="nav-link" data-key="t-AnalisarProjectos"> Carteira de Projectos</a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('admin.desembolso.index') }}" class="nav-link" data-key="t-AnalisarProjectos"> Ponto de situação dos desembolsos</a>
                                    </li>

                                    
                                </ul>
                            </div>
                        </li>
                        
                        
                        <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-Paginas">Configurações</span></li>
                       
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth11" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth11">
                                <i class="   ri-settings-4-fill"></i> <span data-key="t-Definições">Definições</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth11">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="{{ route('users.index') }}" class="nav-link" data-key="t-Gestão de Utilizadores"> Gestão de Utilizadores
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Serviços"> Backups
                                        </a>
                                        
                                    </li>
                                    
                                    
                                </ul>
                            </div>
                        </li>
                        
    
                        
    
                    </ul>
                </div>
                <!-- Sidebar -->
            </div>

         
    
            <div class="sidebar-background"></div>
        </div>
        <!-- Left Sidebar End -->
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>
    
    <!-- ========== FIM AREA DE MENU DO SISTEMA ========== -->
   

<!-- ======================================================================================================================== -->



    <!--ÁREA PARA CARREGAR O CONTEÚDO DA PÁGINA COM ACESSO DE ADMIN-->

@yield('Conteudo')

<!-- FIM ÁREA PARA CARREGAR O CONTEÚDO DA PÁGINA COM ACESSO DE ADMIN-->


<!-- RODAPÉ -->

@include('Layout.Rodape')
    
<!--start back-to-top-->

<button onclick="topFunction()" class="btn btn-primary btn-icon" id="back-to-top">
    <i class="ri-arrow-up-line"></i>
</button>

<!-- FIM back-to-top-->


<!-- JAVASCRIPT -->
<!-- JAVASCRIPT -->
<script src="{{ asset('assets/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/libs/simplebar/simplebar.min.js') }}"></script>
<script src="{{ asset('assets/libs/node-waves/waves.min.js') }}"></script>
<script src="{{ asset('assets/libs/feather-icons/feather.min.js') }}"></script>
<script src="{{ asset('assets/js/pages/plugins/lord-icon-2.1.0.js') }}"></script>
<script src="{{ asset('assets/js/plugins.js') }}"></script>
<script src="{{ asset('assets/js/pages/form-wizard.init.js') }}"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>


<!--datatable js-->
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>



<script src="{{ asset('assets/js/pages/datatables.init.js') }}"></script>

 <!-- apexcharts -->
 <script src="{{ asset('assets/libs/apexcharts/apexcharts.min.js') }}"></script>

 <!-- projects js -->
 <script src="{{ asset('assets/js/pages/dashboard-projects.init.js') }}"></script>

 <!-- App js -->
 <script src="{{ asset('assets/js/app.js') }}"></script>

 <script src="{{ asset('assets/libs/@ckeditor/ckeditor5-build-classic/build/ckeditor.js') }}"></script>

    <!-- dropzone js -->
    <script src="{{ asset('assets/libs/dropzone/dropzone-min.js') }}"></script>
    <!-- project-create init -->
    <script src="{{ asset('assets/js/pages/project-create.init.js') }}"></script>

   


 
<script>
    $(document).ready(function() {
        // Captura o clique nos botões que abrem a modal de visualização
        $('.btn-view').on('click', function() {
            var saidaId = $(this).data('id'); // Obtém o ID da saída de caixa

            // Faz a requisição AJAX para buscar os detalhes
            $.ajax({
                url: '/scaixa-detalhe/' + saidaId, // Rota para buscar os detalhes
                method: 'GET',
                success: function(response) {
                    // Preenche a modal com os dados da resposta
                    $('#referencia').text(response.referencia);
                    $('#data').text(response.data);
                    $('#descritivo').text(response.descritivo);
                    $('#observacao').text(response.observacao || 'N/A');
                    $('#valorK').text(response.valor);
                    $('#centroCusto').text(response.centro_custo.nome); // Assumindo relacionamento
                    $('#usuario').text(response.user.name); // Assumindo relacionamento
                    $('#recebidoPor').text(response.recebido_por);
                    $('#statusK').text(response.status);

                    if (response.suporte_documental) {
                        document.getElementById('suporteDocumental').src = "Doc/ComprovativoSaidaCaixa/" + response.suporte_documental;
                    } else {
                        document.getElementById('suporteDocumental').src = "Doc/ComprovativoSaidaCaixa/Exemplar.pdf"; // Define um valor padrão
                    }

                    if (response.assinatura) {
                        document.getElementById('assinaturaK').src = response.assinatura;
                    } else {
                        document.getElementById('assinaturaK').src = "oishd";
                    }
                },
                error: function(xhr) {
                    console.error('Erro ao buscar detalhes da saída de caixa.');
                }
            });
        });

    });
</script>

<!-- Scripts personalizados das views -->
@yield('scripts')

 </body>
 
 </html>