<!-- Modal de Resumo do Projeto -->
<div class="modal fade" id="modalResumo" tabindex="-1" aria-labelledby="modalResumoLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalResumoLabel">
                    <i class="ri-file-text-line me-2"></i>Resumo do Projeto
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- Informações Gerais -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">Informações Gerais</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <tbody>
                                            <tr>
                                                <th>Nome do Projeto:</th>
                                                <td id="resumo-nome"></td>
                                            </tr>
                                            <tr>
                                                <th>Tipo:</th>
                                                <td id="resumo-tipo"></td>
                                            </tr>
                                            <tr>
                                                <th>Orçamento:</th>
                                                <td id="resumo-orcamento"></td>
                                            </tr>
                                            <tr>
                                                <th>Beneficiários:</th>
                                                <td id="resumo-beneficiarios"></td>
                                            </tr>
                                            <tr>
                                                <th>Período:</th>
                                                <td id="resumo-periodo"></td>
                                            </tr>
                                            <tr>
                                                <th>Localização:</th>
                                                <td id="resumo-localizacao"></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Indicadores -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">Indicadores</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <tbody>
                                            <tr>
                                                <th>Empregos Diretos:</th>
                                                <td id="resumo-empregos"></td>
                                            </tr>
                                            <tr>
                                                <th>Kits Distribuídos:</th>
                                                <td id="resumo-kits"></td>
                                            </tr>
                                            <tr>
                                                <th>Total de Atividades:</th>
                                                <td id="resumo-total-atividades"></td>
                                            </tr>
                                            <tr>
                                                <th>Total de Programações:</th>
                                                <td id="resumo-total-programacoes"></td>
                                            </tr>
                                            <tr>
                                                <th>Valor Total Programado:</th>
                                                <td id="resumo-valor-total" class="fw-bold text-primary"></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Cronograma Físico -->
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">
                                    <i class="ri-calendar-line me-2"></i>Cronograma Físico das Atividades
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="tabela-cronograma">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Atividade</th>
                                                <th>Ano</th>
                                                <th>Data Início</th>
                                                <th>Data Fim</th>
                                                <th>Percentual</th>
                                            </tr>
                                        </thead>
                                        <tbody id="cronograma-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Programação Financeira -->
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">
                                    <i class="ri-money-dollar-circle-line me-2"></i>Programação Financeira
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="tabela-programacao">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Descrição</th>
                                                <th>Ano</th>
                                                <th>Valor</th>
                                                <th>Data Prevista</th>
                                            </tr>
                                        </thead>
                                        <tbody id="programacao-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Voltar e Editar</button>
                <button type="button" class="btn btn-primary" id="btn-confirmar-salvar">
                    <i class="ri-save-line me-1"></i>Confirmar e Salvar Projeto
                </button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Função para gerar resumo
    function gerarResumo() {
        // Dados gerais
        document.getElementById('resumo-nome').textContent = document.querySelector('[name="nomeProjecto"]').value || 'Não informado';
        
        const tipoSelect = document.querySelector('[name="tipo"]');
        document.getElementById('resumo-tipo').textContent = tipoSelect.options[tipoSelect.selectedIndex]?.text || 'Não informado';
        
        const orcamento = document.querySelector('[name="limiteorcamentalP"]').value;
        document.getElementById('resumo-orcamento').textContent = orcamento ? 
            parseFloat(orcamento).toLocaleString('pt-AO', { style: 'currency', currency: 'AOA' }) : 'Não informado';
        
        document.getElementById('resumo-beneficiarios').textContent = 
            document.querySelector('[name="beneficiarioDP"]').value || 'Não informado';
        
        const dataInicio = document.querySelector('[name="duracaoP"]').value;
        const dataFim = document.querySelector('[name="duracaoF"]').value;
        document.getElementById('resumo-periodo').textContent = 
            `${dataInicio ? new Date(dataInicio).toLocaleDateString('pt-BR') : 'N/A'} até ${dataFim ? new Date(dataFim).toLocaleDateString('pt-BR') : 'N/A'}`;
        
        document.getElementById('resumo-localizacao').textContent = 
            document.querySelector('[name="localizacao"]').value || 'Não informado';
        
        // Indicadores
        document.getElementById('resumo-empregos').textContent = 
            document.querySelector('[name="Emprego"]').value || '0';
        document.getElementById('resumo-kits').textContent = 
            document.querySelector('[name="nKitsDistribuidos"]').value || '0';
        
        // Cronograma físico
        const cronogramaBody = document.getElementById('cronograma-body');
        cronogramaBody.innerHTML = '';
        
        const atividadesDescricao = document.querySelectorAll('[name^="actividadeDescricao"]');
        let totalAtividades = 0;
        
        atividadesDescricao.forEach((elemento, index) => {
            if (elemento.value.trim()) {
                totalAtividades++;
                const ano = document.querySelector(`[name="actividadeAno[${index}]"]`)?.value || '';
                const dataInicio = document.querySelector(`[name="actividadeDataInicio[${index}]"]`)?.value || '';
                const dataFim = document.querySelector(`[name="actividadeDataFim[${index}]"]`)?.value || '';
                const percentual = document.querySelector(`[name="actividadePercentual[${index}]"]`)?.value || '';
                
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${elemento.value}</td>
                    <td>${ano}</td>
                    <td>${dataInicio ? new Date(dataInicio).toLocaleDateString('pt-BR') : 'N/A'}</td>
                    <td>${dataFim ? new Date(dataFim).toLocaleDateString('pt-BR') : 'N/A'}</td>
                    <td>${percentual}%</td>
                `;
                cronogramaBody.appendChild(row);
            }
        });
        
        document.getElementById('resumo-total-atividades').textContent = totalAtividades;
        
        // Programação financeira
        const programacaoBody = document.getElementById('programacao-body');
        programacaoBody.innerHTML = '';
        
        const despesasDescricao = document.querySelectorAll('[name^="despesaDescricao"]');
        let totalProgramacoes = 0;
        let valorTotal = 0;
        
        despesasDescricao.forEach((elemento, index) => {
            if (elemento.value.trim()) {
                totalProgramacoes++;
                const ano = document.querySelector(`[name="despesaAno[${index}]"]`)?.value || '';
                const valor = document.querySelector(`[name="despesaValor[${index}]"]`)?.value || 0;
                const dataPrevista = document.querySelector(`[name="despesaDataPrevista[${index}]"]`)?.value || '';
                
                valorTotal += parseFloat(valor);
                
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${elemento.value}</td>
                    <td>${ano}</td>
                    <td>${parseFloat(valor).toLocaleString('pt-AO', { style: 'currency', currency: 'AOA' })}</td>
                    <td>${dataPrevista ? new Date(dataPrevista).toLocaleDateString('pt-BR') : 'N/A'}</td>
                `;
                programacaoBody.appendChild(row);
            }
        });
        
        document.getElementById('resumo-total-programacoes').textContent = totalProgramacoes;
        document.getElementById('resumo-valor-total').textContent = 
            valorTotal.toLocaleString('pt-AO', { style: 'currency', currency: 'AOA' });
    }
    
    // Event listener para o botão de visualizar resumo
    const btnVisualizarResumo = document.getElementById('btn-visualizar-resumo');
    if (btnVisualizarResumo) {
        btnVisualizarResumo.addEventListener('click', function() {
            gerarResumo();
            const modal = new bootstrap.Modal(document.getElementById('modalResumo'));
            modal.show();
        });
    }
    
    // Event listener para confirmar e salvar
    const btnConfirmarSalvar = document.getElementById('btn-confirmar-salvar');
    if (btnConfirmarSalvar) {
        btnConfirmarSalvar.addEventListener('click', function() {
            document.getElementById('formCriarProjecto').submit();
        });
    }
});
</script>
