@extends('Layout.LayoutBaseCliente')

@section('Conteudo')
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Título da página -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">
                            <i class="ri-file-text-line label-icon align-middle fs-16 ms-2"></i> 
                            Relatório de Execução
                        </h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('homePromotor') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('Listar-Projecto') }}">Projetos</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('projetos.show', $projeto->id) }}">{{ $projeto->nomeProjecto }}</a></li>
                                <li class="breadcrumb-item active">Relatório</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Botões de ação -->
            <div class="row mb-3">
                <div class="col-12">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('projetos.show', $projeto->id) }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line me-1"></i>
                            Voltar ao Projeto
                        </a>
                        @if($relatorio->status == 'pendente' && Auth::id() == $relatorio->usuario_id)
                        <div class="btn-group">
                            <button type="button" class="btn btn-warning" onclick="editarRelatorio()">
                                <i class="ri-edit-line me-1"></i>
                                Editar Relatório
                            </button>
                            <button type="button" class="btn btn-danger" onclick="excluirRelatorio()">
                                <i class="ri-delete-bin-line me-1"></i>
                                Excluir
                            </button>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Card do Relatório -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <h5 class="card-title mb-0">
                                    <i class="ri-file-text-line me-2"></i>
                                    Relatório: {{ $relatorio->periodo_formatado }}
                                </h5>
                                <span class="badge bg-{{ $relatorio->status_cor }} fs-6">
                                    {{ $relatorio->status_formatado }}
                                </span>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Informações Gerais -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th class="ps-0" width="40%">Período:</th>
                                                    <td>{{ $relatorio->periodo_formatado }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0">Técnico Responsável:</th>
                                                    <td>
                                                        @if($relatorio->usuario)
                                                            {{ $relatorio->usuario->name }}
                                                        @else
                                                            <span class="text-muted">Não identificado</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0">Data de Criação:</th>
                                                    <td>{{ $relatorio->created_at->format('d/m/Y H:i') }}</td>
                                                </tr>
                                                @if($relatorio->percentual_fisico)
                                                <tr>
                                                    <th class="ps-0">% Físico:</th>
                                                    <td>
                                                        <span class="badge bg-light text-dark">{{ $relatorio->percentual_fisico_formatado }}</span>
                                                    </td>
                                                </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                @if($relatorio->valor_executado)
                                                <tr>
                                                    <th class="ps-0" width="40%">Valor Executado:</th>
                                                    <td>
                                                        <span class="text-success fw-medium">{{ $relatorio->valor_executado_formatado }}</span>
                                                    </td>
                                                </tr>
                                                @endif
                                                <tr>
                                                    <th class="ps-0">Status:</th>
                                                    <td>
                                                        <span class="badge bg-{{ $relatorio->status_cor }}">
                                                            {{ $relatorio->status_formatado }}
                                                        </span>
                                                    </td>
                                                </tr>
                                                @if($relatorio->aprovado_por && $relatorio->aprovado_em)
                                                <tr>
                                                    <th class="ps-0">Aprovado por:</th>
                                                    <td>{{ $relatorio->aprovador->name }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0">Data Aprovação:</th>
                                                    <td>{{ $relatorio->aprovado_em->format('d/m/Y H:i') }}</td>
                                                </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Descrições -->
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="card border">
                                        <div class="card-header bg-light">
                                            <h6 class="card-title mb-0">
                                                <i class="ri-tools-line me-2"></i>
                                                Descrição Técnica
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="text-muted" style="white-space: pre-wrap;">{{ $relatorio->descricao_tecnica }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <div class="card border">
                                        <div class="card-header bg-light">
                                            <h6 class="card-title mb-0">
                                                <i class="ri-money-dollar-circle-line me-2"></i>
                                                Descrição Financeira
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="text-muted" style="white-space: pre-wrap;">{{ $relatorio->descricao_financeira }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Observações -->
                            @if($relatorio->observacoes)
                            <div class="row">
                                <div class="col-12 mb-4">
                                    <div class="card border">
                                        <div class="card-header bg-light">
                                            <h6 class="card-title mb-0">
                                                <i class="ri-sticky-note-line me-2"></i>
                                                Observações
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="text-muted" style="white-space: pre-wrap;">{{ $relatorio->observacoes }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <!-- Anexos -->
                            @if($relatorio->anexos && count($relatorio->anexos) > 0)
                            <div class="row">
                                <div class="col-12">
                                    <div class="card border">
                                        <div class="card-header bg-light">
                                            <h6 class="card-title mb-0">
                                                <i class="ri-attachment-line me-2"></i>
                                                Anexos ({{ count($relatorio->anexos) }})
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                @foreach($relatorio->anexos as $index => $anexo)
                                                <div class="col-md-4">
                                                    <div class="card border">
                                                        <div class="card-body text-center p-3">
                                                            <div class="mb-2">
                                                                @php
                                                                    $extensao = pathinfo($anexo['nome_original'], PATHINFO_EXTENSION);
                                                                    $iconColor = match(strtolower($extensao)) {
                                                                        'pdf' => 'text-danger',
                                                                        'doc', 'docx' => 'text-primary',
                                                                        'xls', 'xlsx' => 'text-success',
                                                                        'jpg', 'jpeg', 'png' => 'text-warning',
                                                                        default => 'text-muted'
                                                                    };
                                                                @endphp
                                                                <i class="ri-file-line display-6 {{ $iconColor }}"></i>
                                                            </div>
                                                            <h6 class="mb-1 text-truncate" title="{{ $anexo['nome_original'] }}">
                                                                {{ $anexo['nome_original'] }}
                                                            </h6>
                                                            <p class="text-muted mb-2 small">
                                                                {{ number_format($anexo['tamanho'] / 1024, 1) }} KB
                                                            </p>
                                                            <a href="{{ route('projetos.relatorios.anexos.download', [$projeto->id, $relatorio->id, $index]) }}" 
                                                               class="btn btn-sm btn-outline-primary">
                                                                <i class="ri-download-line me-1"></i>
                                                                Baixar
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <!-- Motivo de Rejeição -->
                            @if($relatorio->status == 'rejeitado' && $relatorio->motivo_rejeicao)
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-danger">
                                        <h6 class="alert-heading">
                                            <i class="ri-error-warning-line me-2"></i>
                                            Motivo da Rejeição:
                                        </h6>
                                        <p class="mb-0">{{ $relatorio->motivo_rejeicao }}</p>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
@if($relatorio->status == 'pendente' && Auth::id() == $relatorio->usuario_id)
function editarRelatorio() {
    window.location.href = '{{ route("projetos.relatorios.edit", [$projeto->id, $relatorio->id]) }}';
}

function excluirRelatorio() {
    if (confirm('Tem certeza que deseja excluir este relatório? Esta ação não poderá ser desfeita.')) {
        fetch('{{ route("projetos.relatorios.destroy", [$projeto->id, $relatorio->id]) }}', {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Relatório excluído com sucesso!');
                window.location.href = '{{ route("projetos.show", $projeto->id) }}';
            } else {
                alert('Erro ao excluir relatório: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao excluir relatório.');
        });
    }
}
@endif
</script>
@endsection
