@extends('Layout.LayoutBaseCliente')

@section('Conteudo')
<div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                            <h4 class="mb-sm-0"><i class="ri-briefcase-fill label-icon align-middle fs-16 ms-2"></i> MEU PERFIL</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="{{ route('cliente.perfil.show') }}">Perfil</a></li>
                                    <li class="breadcrumb-item active">Detalhes do Perfil</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row ">
                    <div class="col-xl-12">
                        <div class="card ribbon-box border shadow-none mb-lg-0">
                            <div class="p-3">

                            <!--centralizar o formulario-->
                            <div class="row justify-content-center">
                        <div class="col-lg-8 ">
                            <div class="p-4 p-sm-5">
                                <div class="text-center mb-4">
                                    <h1 class="h4 text-gray-900 mb-2 fw-bold">Meu Perfil</h1>
                                    <p class="mb-4 text-muted">Atualize as suas informações pessoais e palavra-passe.</p>
                                </div>

                                @if (session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <i class="ri-checkbox-circle-line me-2"></i>
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif
                                @if (session('error'))
                                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        <i class="ri-alert-line me-2"></i>
                                        {{ session('error') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif
                                @if ($errors->any() && !$errors->has('nome') && !$errors->has('password')) {{-- Mostra apenas erros gerais --}}
                                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        <i class="ri-error-warning-line me-2"></i>
                                        Ocorreu um erro. Por favor, verifique os dados e tente novamente.
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif


                                <form method="POST" action="{{ route('cliente.perfil.update') }}" class="needs-validation" novalidate>
                                    @csrf
                                    @method('PUT')

                                    <div class="mb-3">
                                        <label for="nome" class="form-label">{{ __('Nome Completo') }}</label>
                                        <div class="input-group has-validation">
                                            <span class="input-group-text"><i class="ri-user-3-line"></i></span>
                                            <input id="nome" type="text" class="form-control @error('nome') is-invalid @enderror" name="nome" value="{{ old('nome', $utilizador->name) }}" required autocomplete="name" autofocus placeholder="O seu nome completo">
                                            @error('nome')
                                                <div class="invalid-feedback">
                                                    {{ $message }}
                                                </div>
                                            @else
                                                <div class="valid-feedback">
                                                    Nome parece bom!
                                                </div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="email" class="form-label">{{ __('Endereço de Email') }}</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="ri-mail-send-line"></i></span>
                                            <input id="email" type="email" class="form-control" name="email" value="{{ $utilizador->email }}" disabled readonly>
                                        </div>
                                        <small class="form-text text-muted ps-1">O email não pode ser alterado.</small>
                                    </div>

                                    <hr class="my-4">
                                    <p class="text-muted small mb-3">Se não desejar alterar a palavra-passe, deixe os campos abaixo em branco.</p>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="password" class="form-label">{{ __('Nova Palavra-passe') }}</label>
                                            <div class="input-group has-validation">
                                                <span class="input-group-text"><i class="ri-lock-password-line"></i></span>
                                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="new-password" placeholder="Nova palavra-passe (min. 6 caracteres)">
                                                @error('password')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6 mb-4">
                                            <label for="password-confirm" class="form-label">{{ __('Confirmar Nova Palavra-passe') }}</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="ri-lock-password-fill"></i></span>
                                                <input id="password-confirm" type="password" class="form-control @error('password') is-invalid @enderror" name="password_confirmation" autocomplete="new-password" placeholder="Confirme a nova palavra-passe">
                                                 {{-- O erro de password_confirmation é geralmente mostrado com o erro de password --}}
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="ri-save-3-line me-1"></i> {{ __('Atualizar Perfil') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                                
                                
                            
                            
                    </div>                
                </div>

            
                

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
    </div>
    <!-- end main content-->


@push('scripts')
<script>
// Example starter JavaScript for disabling form submissions if there are invalid fields
(function () {
  'use strict'

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  var forms = document.querySelectorAll('.needs-validation')

  // Loop over them and prevent submission
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }

        form.classList.add('was-validated')
      }, false)
    })
})()
</script>
@endpush

@endsection
