<!-- Este arquivo deve ser incluído no final do CriarProjecto.blade.php -->

<!-- Substituir os botões existentes por estes -->
<div class="text-end mb-4">
    <button type="reset" class="btn btn-danger w-sm">Cancelar</button>
    <button type="button" class="btn btn-info w-sm me-2" id="btn-visualizar-resumo">
        <i class="ri-eye-line me-1"></i>Visualizar Resumo
    </button>
    <button type="submit" class="btn btn-primary w-sm" id="btn-criar-projecto" style="display: none;">
        Confirmar e Salvar
    </button>
</div>

<!-- Incluir o modal de resumo -->
@include('Clientes.ResumoProjecto')

<!-- Script para funcionalidade de resumo -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const btnVisualizarResumo = document.getElementById('btn-visualizar-resumo');
    const btnCriarProjecto = document.getElementById('btn-criar-projecto');
    const formCriarProjecto = document.getElementById('form-criar-projecto') || document.querySelector('form');
    
    // Atualizar o ID do formulário
    if (formCriarProjecto && !formCriarProjecto.id) {
        formCriarProjecto.id = 'formCriarProjecto';
    }
    
    // Função para gerar resumo
    function gerarResumo() {
        // Dados gerais
        document.getElementById('resumo-nome').textContent = 
            document.querySelector('[name="nomeProjecto"]').value || 'Não informado';
        
        const tipoSelect = document.querySelector('[name="tipo"]');
        document.getElementById('resumo-tipo').textContent = 
            tipoSelect.options[tipoSelect.selectedIndex]?.text || 'Não informado';
        
        const orcamento = document.querySelector('[name="limiteorcamentalP"]').value;
        document.getElementById('resumo-orcamento').textContent = orcamento ? 
            parseFloat(orcamento).toLocaleString('pt-AO', { style: 'currency', currency: 'AOA' }) : 'Não informado';
        
        document.getElementById('resumo-beneficiarios').textContent = 
            document.querySelector('[name="beneficiarioDP"]').value || 'Não informado';
        
        const dataInicio = document.querySelector('[name="duracaoP"]').value;
        const dataFim = document.querySelector('[name="duracaoF"]').value;
        document.getElementById('resumo-periodo').textContent = 
            `${dataInicio ? new Date(dataInicio).toLocaleDateString('pt-BR') : 'N/A'} até ${dataFim ? new Date(dataFim).toLocaleDateString('pt-BR') : 'N/A'}`;
        
        document.getElementById('resumo-localizacao').textContent = 
            document.querySelector('[name="localizacao"]').value || 'Não informado';
        
        // Indicadores
        document.getElementById('resumo-empregos').textContent = 
            document.querySelector('[name="Emprego"]').value || '0';
        document.getElementById('resumo-kits').textContent = 
            document.querySelector('[name="nKitsDistribuidos"]').value || '0';
        
        // Cronograma físico
        const cronogramaBody = document.getElementById('cronograma-body');
        cronogramaBody.innerHTML = '';
        
        const atividadesDescricao = document.querySelectorAll('[name^="actividadeDescricao"]');
        let totalAtividades = 0;
        
        atividadesDescricao.forEach((elemento, index) => {
            if (elemento.value.trim()) {
                totalAtividades++;
                const ano = document.querySelector(`[name="actividadeAno[${index}]"]`)?.value || '';
                const dataInicio = document.querySelector(`[name="actividadeDataInicio[${index}]"]`)?.value || '';
                const dataFim = document.querySelector(`[name="actividadeDataFim[${index}]"]`)?.value || '';
                const percentual = document.querySelector(`[name="actividadePercentual[${index}]"]`)?.value || '';
                
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${elemento.value}</td>
                    <td>${ano}</td>
                    <td>${dataInicio ? new Date(dataInicio).toLocaleDateString('pt-BR') : 'N/A'}</td>
                    <td>${dataFim ? new Date(dataFim).toLocaleDateString('pt-BR') : 'N/A'}</td>
                    <td>${percentual}%</td>
                `;
                cronogramaBody.appendChild(row);
            }
        });
        
        document.getElementById('resumo-total-atividades').textContent = totalAtividades;
        
        // Programação financeira
        const programacaoBody = document.getElementById('programacao-body');
        programacaoBody.innerHTML = '';
        
        const despesasDescricao = document.querySelectorAll('[name^="despesaDescricao"]');
        let totalProgramacoes = 0;
        let valorTotal = 0;
        
        despesasDescricao.forEach((elemento, index) => {
            if (elemento.value.trim()) {
                totalProgramacoes++;
                const ano = document.querySelector(`[name="despesaAno[${index}]"]`)?.value || '';
                const valor = document.querySelector(`[name="despesaValor[${index}]"]`)?.value || 0;
                const dataInicial = document.querySelector(`[name="despesaDatainicial[${index}]"]`)?.value || '';
                const dataFinal = document.querySelector(`[name="despesaDatafinal[${index}]"]`)?.value || '';
                
                valorTotal += parseFloat(valor) || 0;
                
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${elemento.value}</td>
                    <td>${ano}</td>
                    <td>${parseFloat(valor || 0).toLocaleString('pt-AO', { style: 'currency', currency: 'AOA' })}</td>
                    <td>${dataInicial ? new Date(dataInicial).toLocaleDateString('pt-BR') : 'N/A'} - ${dataFinal ? new Date(dataFinal).toLocaleDateString('pt-BR') : 'N/A'}</td>
                `;
                programacaoBody.appendChild(row);
            }
        });
        
        document.getElementById('resumo-total-programacoes').textContent = totalProgramacoes;
        document.getElementById('resumo-valor-total').textContent = 
            valorTotal.toLocaleString('pt-AO', { style: 'currency', currency: 'AOA' });
    }
    
    // Event listener para o botão de visualizar resumo
    if (btnVisualizarResumo) {
        btnVisualizarResumo.addEventListener('click', function() {
            // Validar formulário básico antes de mostrar resumo
            const nomeProjecto = document.querySelector('[name="nomeProjecto"]').value;
            const tipo = document.querySelector('[name="tipo"]').value;
            
            if (!nomeProjecto.trim()) {
                alert('Por favor, preencha o nome do projeto antes de visualizar o resumo.');
                document.querySelector('[name="nomeProjecto"]').focus();
                return;
            }
            
            if (!tipo) {
                alert('Por favor, selecione o tipo de projeto antes de visualizar o resumo.');
                document.querySelector('[name="tipo"]').focus();
                return;
            }
            
            gerarResumo();
            const modal = new bootstrap.Modal(document.getElementById('modalResumo'));
            modal.show();
            
            // Mostrar botão de salvar após visualizar resumo
            btnCriarProjecto.style.display = 'inline-block';
        });
    }
    
    // Event listener para confirmar e salvar
    const btnConfirmarSalvar = document.getElementById('btn-confirmar-salvar');
    if (btnConfirmarSalvar) {
        btnConfirmarSalvar.addEventListener('click', function() {
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalResumo'));
            modal.hide();
            
            if (formCriarProjecto) {
                formCriarProjecto.submit();
            }
        });
    }
});
</script>
