@extends('Layout.LayoutBaseCliente')

@section('Conteudo')
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Título da página -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">
                            <i class="ri-file-text-line label-icon align-middle fs-16 ms-2"></i> 
                            DETALHES DO PROJECTO
                        </h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('homePromotor') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('Listar-Projecto') }}">Projectos</a></li>
                                <li class="breadcrumb-item active">Detalhes</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Botões de ação -->
            <div class="row mb-3">
                <div class="col-12">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('Listar-Projecto') }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line me-1"></i>
                            Voltar à Lista
                        </a>
                        <div class="btn-group">
                            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="ri-file-pdf-line me-1"></i>
                                PDF
                            </button>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="{{ route('projetos.visualizar-pdf', $projeto->id) }}" target="_blank">
                                        <i class="ri-eye-line me-2"></i>
                                        Visualizar PDF
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('projetos.exportar-pdf', $projeto->id) }}">
                                        <i class="ri-download-line me-2"></i>
                                        Baixar PDF
                                    </a>
                                </li>
                            </ul>
                            <a href="{{ route('projetos.edit', $projeto->id) }}" class="btn btn-warning">
                                <i class="ri-edit-line me-1"></i>
                                Editar
                            </a>
                            <button type="button" class="btn btn-danger" onclick="confirmarExclusao({{ $projeto->id }})">
                                <i class="ri-delete-bin-line me-1"></i>
                                Excluir
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informações gerais do projeto -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <h5 class="card-title mb-0">{{ $projeto->nomeProjecto }}</h5>
                                </div>
                                <div class="flex-shrink-0">
                                    @switch($projeto->status)
                                        @case('0')
                                            <span class="badge bg-warning fs-12">Recebido</span>
                                            @break
                                        @case('1')
                                            <span class="badge bg-primary fs-12">Em Análise</span>
                                            @break
                                        @case('2')
                                            <span class="badge bg-info fs-12">Aprovado</span>
                                            @break
                                        @case('3')
                                            <span class="badge bg-danger fs-12">Rejeitado</span>
                                            @break
                                        @case('4')
                                            <span class="badge bg-warning fs-12">Em Execução</span>
                                            @break
                                        @case('5')
                                            <span class="badge bg-success fs-12">Concluído</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary fs-12">Indefinido</span>
                                    @endswitch
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th class="ps-0" scope="row">Código:</th>
                                                    <td class="text-muted">{{ $projeto->codProjecto }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Tipo do Projecto:</th>
                                                    <td class="text-muted">{{ $projeto->tipoProjecto->descricao ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Custo Total do Projecto:</th>
                                                    <td class="text-muted">{{ number_format($projeto->limiteorcamentalP, 2, ',', '.') }} AOA</td>
                                                </tr>
                                                @if ($projeto->pagamentos->count() > 0)
                                                <tr>
                                                    <th class="ps-0" scope="row">Valor Desembolsado/Financiado:</th>
                                                    <td class="text-muted">{{ number_format($projeto->pagamentos->sum('valor'), 2, ',', '.') }} AOA</td>
                                                </tr>
                                                @endif
                                                <!-- diferenca entre custo total e valor desembolsado -->
                                                <tr>
                                                    <th class="ps-0" scope="row">Diferença entre custo total e valor desembolsado:</th>
                                                    <td class="text-muted">{{ number_format($projeto->limiteorcamentalP - $projeto->pagamentos->sum('valor'), 2, ',', '.') }} AOA</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Beneficiários:</th>
                                                    <td class="text-muted">{{ number_format($projeto->beneficiarioDP) }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Empregos Diretos:</th>
                                                    <td class="text-muted">{{ number_format($projeto->empregosDirectos) }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Kits Distribuídos:</th>
                                                    <td class="text-muted">{{ number_format($projeto->kitsDistribuidos) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th class="ps-0" scope="row">Data Início:</th>
                                                    <td class="text-muted">{{ date('d/m/Y', strtotime($projeto->duracaoP)) }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Data Fim:</th>
                                                    <td class="text-muted">{{ date('d/m/Y', strtotime($projeto->duracaoF)) }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Âmbito:</th>
                                                    <td class="text-muted">{{ $projeto->ambito }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Forma de Funcionamento:</th>
                                                    <td class="text-muted">{{ $projeto->mFuncionamento }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Localização:</th>
                                                    <td class="text-muted">{{ $projeto->localizacao_projecto }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Financiador:</th>
                                                    <td class="text-muted">{{ $projeto->financeador }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Gestor Responsável do Projecto:</th>
                                                    <td class="text-muted">{{ $projeto->adminResponsavel->name ?? 'N/A' }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Seção de Pagamentos -->
            @if($projeto->pagamentos->count() > 0)
            <div class="card">
                <div class="card-header bg-primary-light text-primary">
                    <h5 class="card-title mb-0">Histórico de Pagamentos</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Data</th>
                                    <th>Descrição</th>
                                    <th>Valor (AOA)</th>
                                    <th>Anexo</th>
                                    <th>Registado por</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($projeto->pagamentos as $pagamento)
                                <tr>
                                    <td>{{ $pagamento->data }}</td>
                                    <td>{{ $pagamento->descricao }}</td>
                                    <td>{{ number_format($pagamento->valor, 2, ',', '.') }}</td>
                                    <td>
                                        @if($pagamento->anexo)
                                        <a href="{{ asset('storage/' . $pagamento->anexo) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                            Ver Anexo
                                        </a>
                                        @else
                                        N/A
                                        @endif
                                    </td>
                                    <td>{{ $pagamento->user->name ?? 'N/A' }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @endif
            <!-- Fim Seção de Pagamentos -->

            <!-- Descrição e Justificação -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Descrição do Objectivo</h6>
                        </div>
                        <div class="card-body">
                            <p class="text-muted" style="text-align: justify;">{!! $projeto->descricaoObjectivo !!}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Justificação</h6>
                        </div>
                        <div class="card-body">
                            <p class="text-muted">{{ $projeto->justificacao }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cronograma Físico das Atividades -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="ri-calendar-line me-2"></i>
                                Cronograma Físico das Actividades
                            </h6>
                        </div>
                        <div class="card-body">
                            @if($projeto->cronogramasFisicos->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Actividade</th>
                                                <th>Ano</th>
                                                <th>Data Início</th>
                                                <th>Data Fim</th>
                                                <th>Percentual</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($projeto->cronogramasFisicos as $cronograma)
                                                <tr>
                                                    <td>{{ $cronograma->descricao }}</td>
                                                    <td>{{ $cronograma->ano }}</td>
                                                    <td>{{ date('d/m/Y', strtotime($cronograma->data_inicio)) }}</td>
                                                    <td>{{ date('d/m/Y', strtotime($cronograma->data_fim)) }}</td>
                                                    <td>
                                                        <div class="progress" style="height: 20px;">
                                                            <div class="progress-bar" role="progressbar" 
                                                                 style="width: {{ $cronograma->percentual }}%"
                                                                 aria-valuenow="{{ $cronograma->percentual }}" 
                                                                 aria-valuemin="{{ $cronograma->percentual }}" aria-valuemax="{{ $cronograma->percentual}}">
                                                                {{ number_format($cronograma->percentual, 0, ',', '.') }}%
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="ri-calendar-line display-4 text-muted"></i>
                                    <p class="text-muted mt-2">Nenhuma atividade cadastrada</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Programação Financeira -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center">
                                <h6 class="card-title mb-0 flex-grow-1">
                                    <i class="ri-money-dollar-circle-line me-2"></i>
                                    Programação Financeira
                                </h6>
                                <div class="flex-shrink-0">
                                    @php
                                        $totalProgramado = $projeto->programacoesFinanceiras->sum('valor');
                                    @endphp
                                    <span class="badge bg-primary fs-12">
                                        Total: {{ number_format($totalProgramado, 2, ',', '.') }} AOA
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            @if($projeto->programacoesFinanceiras->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Descrição</th>
                                                <th>Ano</th>
                                                <th>Valor</th>
                                                <th>Data Início</th>
                                                <th>Data Fim</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($projeto->programacoesFinanceiras as $programacao)
                                                <tr>
                                                    <td>{{ $programacao->descricao }}</td>
                                                    <td>{{ $programacao->ano }}</td>
                                                    <td class="fw-medium">{{ number_format($programacao->valor, 2, ',', '.') }} AOA</td>
                                                    <td>{{ date('d/m/Y', strtotime($programacao->data_inicial)) }}</td>
                                                    <td>{{ date('d/m/Y', strtotime($programacao->data_final)) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="ri-money-dollar-circle-line display-4 text-muted"></i>
                                    <p class="text-muted mt-2">Nenhuma programação financeira cadastrada</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Anexos do Projeto -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center">
                                <h6 class="card-title mb-0 flex-grow-1">
                                    <i class="ri-attachment-line me-2"></i>
                                    Anexos do Projecto
                                </h6>
                                <div class="flex-shrink-0">
                                    @php
                                        $anexos = collect([
                                            'Url_contratoP' => $projeto->Url_contratoP,
                                            'ambito' => $projeto->ambito,
                                            'impactoSocial' => $projeto->impactoSocial,
                                            'tecnicoEngenharia' => $projeto->tecnicoEngenharia,
                                            'analiseEfectividade' => $projeto->analiseEfectividade,
                                            'viabilidadeEconomica' => $projeto->viabilidadeEconomica,
                                            'impactoAmbiental' => $projeto->impactoAmbiental,
                                            'mitigacaoImpactos' => $projeto->mitigacaoImpactos
                                        ])->filter()->count();
                                    @endphp
                                    <span class="badge bg-info fs-12">
                                        {{ $anexos }} Anexo{{ $anexos !== 1 ? 's' : '' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            @php
                                $anexosDisponiveis = [
                                    'Url_contratoP' => [
                                        'titulo' => 'Contrato do Projeto',
                                        'icone' => 'ri-file-text-line',
                                        'cor' => 'primary',
                                        'valor' => $projeto->Url_contratoP
                                    ],
                                    'ambito' => [
                                        'titulo' => 'Âmbito do Projeto',
                                        'icone' => 'ri-focus-line',
                                        'cor' => 'success',
                                        'valor' => $projeto->ambito
                                    ],
                                    'impactoSocial' => [
                                        'titulo' => 'Estudo de Impacto Social',
                                        'icone' => 'ri-team-line',
                                        'cor' => 'info',
                                        'valor' => $projeto->impactoSocial
                                    ],
                                    'tecnicoEngenharia' => [
                                        'titulo' => 'Parecer Técnico de Engenharia',
                                        'icone' => 'ri-tools-line',
                                        'cor' => 'warning',
                                        'valor' => $projeto->tecnicoEngenharia
                                    ],
                                    'analiseEfectividade' => [
                                        'titulo' => 'Análise de Efetividade',
                                        'icone' => 'ri-bar-chart-line',
                                        'cor' => 'secondary',
                                        'valor' => $projeto->analiseEfectividade
                                    ],
                                    'viabilidadeEconomica' => [
                                        'titulo' => 'Estudo de Viabilidade Econômica',
                                        'icone' => 'ri-money-dollar-circle-line',
                                        'cor' => 'success',
                                        'valor' => $projeto->viabilidadeEconomica
                                    ],
                                    'impactoAmbiental' => [
                                        'titulo' => 'Estudo de Impacto Ambiental',
                                        'icone' => 'ri-leaf-line',
                                        'cor' => 'success',
                                        'valor' => $projeto->impactoAmbiental
                                    ],
                                    'mitigacaoImpactos' => [
                                        'titulo' => 'Plano de Mitigação de Impactos',
                                        'icone' => 'ri-shield-check-line',
                                        'cor' => 'danger',
                                        'valor' => $projeto->mitigacaoImpactos
                                    ]
                                ];
                            @endphp

                            @if(collect($anexosDisponiveis)->filter(function($anexo) { return !empty($anexo['valor']); })->count() > 0)
                                <div class="row g-3">
                                    @foreach($anexosDisponiveis as $campo => $anexo)
                                        @if(!empty($anexo['valor']))
                                            <div class="col-md-6 col-lg-4">
                                                <div class="card border h-100">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex align-items-start">
                                                            <div class="flex-shrink-0">
                                                                <div class="avatar-sm bg-{{ $anexo['cor'] }}-subtle rounded">
                                                                    <span class="avatar-title bg-{{ $anexo['cor'] }}-subtle text-{{ $anexo['cor'] }} rounded">
                                                                        <i class="{{ $anexo['icone'] }} fs-16"></i>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="flex-grow-1 ms-3">
                                                                <h6 class="mb-2 fs-14">{{ $anexo['titulo'] }}</h6>
                                                                @if(filter_var($anexo['valor'], FILTER_VALIDATE_URL))
                                                                    <!-- É uma URL -->
                                                                    <div class="mb-2">
                                                                        <a href="{{ $anexo['valor'] }}" target="_blank" class="btn btn-sm btn-{{ $anexo['cor'] }} btn-label">
                                                                            <i class="ri-external-link-line label-icon align-middle fs-12 me-2"></i>
                                                                            Abrir Anexo
                                                                        </a>
                                                                    </div>
                                                                    <small class="text-muted text-truncate d-block" style="max-width: 200px;" title="{{ $anexo['valor'] }}">
                                                                        {{ $anexo['valor'] }}
                                                                    </small>
                                                                @else
                                                                    <!-- É um caminho de arquivo -->
                                                                    <div class="mb-2">
                                                                        <a href="{{ asset('Doc/Projectos/' . $anexo['valor']) }}" target="_blank" class="btn btn-sm btn-{{ $anexo['cor'] }} btn-label">
                                                                            <i class="ri-download-line label-icon align-middle fs-12 me-2"></i>
                                                                            Baixar Arquivo
                                                                        </a>
                                                                    </div>
                                                                    <small class="text-muted">
                                                                        <i class="ri-file-line me-1"></i>
                                                                        {{ basename($anexo['valor']) }}
                                                                    </small>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="ri-attachment-line display-4 text-muted"></i>
                                    <h6 class="mt-3 text-muted">Nenhum anexo disponível</h6>
                                    <p class="text-muted mb-0">Este projeto ainda não possui anexos cadastrados.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informações bancarias -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <h5 class="card-title mb-0">Informações Bancarias</h5>
                                </div>
                                <div class="flex-shrink-0">
                                    <span class="badge bg-primary fs-12">NIF: {{ $projeto->nif }}</span>                                            
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th class="ps-0" scope="row">Nome do Banco:</th>
                                                    <td class="text-muted">{{ $projeto->nomeInst ?? 'N/A'}}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Endereço da Agência:</th>
                                                    <td class="text-muted">{{ $projeto->enderecoAgencia ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Contacto da Agência:</th>
                                                    <td class="text-muted">{{$projeto->contactoAgencia ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Nº de Conta bancária:</th>
                                                    <td class="text-muted">{{$projeto->numeroConta ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">IBAN: </th>
                                                    <td class="text-muted">AO06 {{ wordwrap(strtoupper(preg_replace('/[^A-Z0-9]/', '', $projeto->iban)), 4, ' ', true) ?? 'N/A'}}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">SWIFT:</th>
                                                    <td class="text-muted">{{$projeto->swif ?? 'N/A' }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th class="ps-0" scope="row">1º Assinante:</th>
                                                    <td class="text-muted">{{ $projeto->assinante1 ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">2º Assinante:</th>
                                                    <td class="text-muted">{{ $projeto->assinante2 ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">3º Assinante:</th>
                                                    <td class="text-muted">{{ $projeto->assinante3 ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">4º Assinante:</th>
                                                    <td class="text-muted">{{ $projeto->assinante4 ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">NIF:</th>
                                                    <td class="text-muted">{{ $projeto->nif }}</td>
                                                </tr>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Seção de Relatórios de Execução (apenas para projetos em execução) -->
            @if($projeto->status == 4 && $projeto->tecnico_projectoFK == Auth::id())
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <h6 class="card-title mb-0 flex-grow-1">
                                        <i class="ri-file-text-line me-2"></i>
                                        Relatórios de Execução
                                    </h6>
                                    <span class="badge bg-info ms-2">
                                        {{ $projeto->relatoriosExecucao->count() }} Relatório(s)
                                    </span>
                                </div>
                                <button type="button" class="btn btn-primary btn-sm" onclick="abrirModalRelatorio()">
                                    <i class="ri-add-line me-1"></i>
                                    Novo Relatório
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            @if($projeto->relatoriosExecucao->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Período</th>
                                                <th>% Físico</th>
                                                <th>Valor Executado</th>
                                                <th>Status</th>
                                                <th>Data Criação</th>
                                                <th>Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($projeto->relatoriosExecucao->sortByDesc('created_at') as $relatorio)
                                            <tr>
                                                <td>
                                                    <span class="fw-medium">{{ $relatorio->periodo_formatado }}</span>
                                                </td>
                                                <td>
                                                    @if($relatorio->percentual_fisico)
                                                        <span class="badge bg-light text-dark">{{ $relatorio->percentual_fisico_formatado }}</span>
                                                    @else
                                                        <span class="text-muted">N/A</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($relatorio->valor_executado)
                                                        <span class="text-success fw-medium">{{ $relatorio->valor_executado_formatado }}</span>
                                                    @else
                                                        <span class="text-muted">N/A</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <span class="badge bg-{{ $relatorio->status_cor }}">
                                                        {{ $relatorio->status_formatado }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="text-muted">{{ $relatorio->created_at->format('d/m/Y H:i') }}</span>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm">
                                                        <button type="button" class="btn btn-outline-info" onclick="verRelatorio({{ $relatorio->id }})" title="Visualizar">
                                                            <i class="ri-eye-line"></i>
                                                        </button>
                                                        @if($relatorio->status == 'pendente')
                                                        <button type="button" class="btn btn-outline-warning" onclick="editarRelatorio({{ $relatorio->id }})" title="Editar">
                                                            <i class="ri-edit-line"></i>
                                                        </button>
                                                        <button type="button" class="btn btn-outline-danger" onclick="excluirRelatorio({{ $relatorio->id }})" title="Excluir">
                                                            <i class="ri-delete-bin-line"></i>
                                                        </button>
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="ri-file-text-line display-4 text-muted"></i>
                                    <h6 class="mt-3 text-muted">Nenhum relatório de execução</h6>
                                    <p class="text-muted mb-3">Ainda não foram enviados relatórios de execução para este projeto.</p>
                                    <button type="button" class="btn btn-primary" onclick="abrirModalRelatorio()">
                                        <i class="ri-add-line me-1"></i>
                                        Criar Primeiro Relatório
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            @endif

        </div>
    </div>
</div>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="modalExcluir" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirmar Exclusão</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <i class="ri-delete-bin-line display-4 text-danger mb-3"></i>
                    <h5>Tem certeza que deseja excluir este projeto?</h5>
                    <p class="text-muted">Esta ação não poderá ser desfeita.</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <form id="formExcluir" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Sim, Excluir</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Criar/Editar Relatório de Execução -->
@if($projeto->status == 4 && $projeto->tecnico_projectoFK == Auth::id())
<div class="modal fade" id="modalRelatorio" tabindex="-1" data-bs-backdrop="static">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tituloModalRelatorio">
                    <i class="ri-file-text-line me-2"></i>
                    Novo Relatório de Execução
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formRelatorio" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <!-- Período de Execução -->
                        <div class="col-md-6 mb-3">
                            <label for="periodo_inicio" class="form-label">Data Início <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="periodo_inicio" name="periodo_inicio" required>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="periodo_fim" class="form-label">Data Fim <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="periodo_fim" name="periodo_fim" required>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>

                    <!-- Descrições -->
                    <div class="mb-3">
                        <label for="descricao_tecnica" class="form-label">Descrição Técnica <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="descricao_tecnica" name="descricao_tecnica" rows="4" 
                                  placeholder="Descreva detalhadamente o progresso técnico, atividades realizadas, marcos atingidos, etc. (mínimo 50 caracteres)" 
                                  required maxlength="2000" oninput="atualizarContadores(); validarCampo(this, 50, 2000);"></textarea>
                        <div class="form-text">Mínimo 50, máximo 2000 caracteres. Caracteres: <span id="contadorTecnica">0</span>/2000</div>
                        <div class="invalid-feedback"></div>
                    </div>

                    <div class="mb-3">
                        <label for="descricao_financeira" class="form-label">Descrição Financeira <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="descricao_financeira" name="descricao_financeira" rows="4" 
                                  placeholder="Descreva os gastos realizados, despesas executadas, recursos utilizados, etc. (mínimo 50 caracteres)" 
                                  required maxlength="2000" oninput="atualizarContadores(); validarCampo(this, 50, 2000);"></textarea>
                        <div class="form-text">Mínimo 50, máximo 2000 caracteres. Caracteres: <span id="contadorFinanceira">0</span>/2000</div>
                        <div class="invalid-feedback"></div>
                    </div>

                    <!-- Indicadores Numéricos -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="percentual_fisico" class="form-label">Percentual Físico Executado (%)</label>
                            <input type="number" class="form-control" id="percentual_fisico" name="percentual_fisico" 
                                   min="0" max="100" step="0.01" placeholder="Ex: 25.50">
                            <div class="form-text">Percentual de execução física do projeto (0-100%)</div>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="valor_executado" class="form-label">Valor Executado (Kz)</label>
                            <input type="number" class="form-control" id="valor_executado" name="valor_executado" 
                                   min="0" step="0.01" placeholder="Ex: 150000.00">
                            <div class="form-text">Valor financeiro já executado no período</div>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>

                    <!-- Anexos -->
                    <div class="mb-3">
                        <label for="anexos" class="form-label">Anexos</label>
                        <input type="file" class="form-control" id="anexos" name="anexos[]" multiple 
                               accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png">
                        <div class="form-text">
                            Arquivos aceitos: PDF, DOC, DOCX, XLS, XLSX, JPG, JPEG, PNG (máx. 10MB cada)
                        </div>
                        <div class="invalid-feedback"></div>
                    </div>

                    <!-- Observações -->
                    <div class="mb-3">
                        <label for="observacoes" class="form-label">Observações Adicionais</label>
                        <textarea class="form-control" id="observacoes" name="observacoes" rows="3" 
                                  placeholder="Observações, notas adicionais, comentários especiais, etc." 
                                  maxlength="1000" oninput="atualizarContadores(); validarCampo(this, 0, 1000);"></textarea>
                        <div class="form-text">Máximo 1000 caracteres. Caracteres: <span id="contadorObservacoes">0</span>/1000</div>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="ri-close-line me-1"></i>
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary" id="btnSalvarRelatorio">
                        <i class="ri-save-line me-1"></i>
                        Salvar Relatório
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif

<script>
// Funções para confirmação de exclusão do projeto
function confirmarExclusao(projetoId) {
    const form = document.getElementById('formExcluir');
    form.action = `/projetos/${projetoId}`;
    
    const modal = new bootstrap.Modal(document.getElementById('modalExcluir'));
    modal.show();
}

@if($projeto->status == 4 && $projeto->tecnico_projectoFK == Auth::id())
// Funções para gerenciamento de relatórios
let modalRelatorio;
let editandoRelatorio = false;
let relatorioIdEditando = null;

document.addEventListener('DOMContentLoaded', function() {
    modalRelatorio = new bootstrap.Modal(document.getElementById('modalRelatorio'));
    
    // Contadores de caracteres
    document.getElementById('descricao_tecnica').addEventListener('input', function() {
        document.getElementById('contadorTecnica').textContent = this.value.length;
    });
    
    document.getElementById('descricao_financeira').addEventListener('input', function() {
        document.getElementById('contadorFinanceira').textContent = this.value.length;
    });
    
    document.getElementById('observacoes').addEventListener('input', function() {
        document.getElementById('contadorObservacoes').textContent = this.value.length;
    });
    
    // Submit do formulário
    document.getElementById('formRelatorio').addEventListener('submit', function(e) {
        e.preventDefault();
        salvarRelatorio();
    });
});

function abrirModalRelatorio() {
    editandoRelatorio = false;
    relatorioIdEditando = null;
    document.getElementById('tituloModalRelatorio').innerHTML = 
        '<i class="ri-file-text-line me-2"></i>Novo Relatório de Execução';
    document.getElementById('btnSalvarRelatorio').innerHTML = 
        '<i class="ri-save-line me-1"></i>Salvar Relatório';
    
    // Limpar formulário
    document.getElementById('formRelatorio').reset();
    limparErros();
    atualizarContadores();
    
    modalRelatorio.show();
}

function salvarRelatorio() {
    const form = document.getElementById('formRelatorio');
    const formData = new FormData(form);
    const btnSalvar = document.getElementById('btnSalvarRelatorio');
    
    // Desabilitar botão
    btnSalvar.disabled = true;
    btnSalvar.innerHTML = '<i class="spinner-border spinner-border-sm me-1"></i>Salvando...';
    
    // Limpar erros anteriores
    limparErros();
    
    const url = editandoRelatorio ? 
        `/projetos/{{ $projeto->id }}/relatorios/${relatorioIdEditando}` : 
        `/projetos/{{ $projeto->id }}/relatorios`;
    
    const method = editandoRelatorio ? 'PUT' : 'POST';
    
    if (editandoRelatorio) {
        formData.append('_method', 'PUT');
    }
    
    // Obter token CSRF de forma segura
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '{{ csrf_token() }}';
    
    fetch(url, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': csrfToken
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            modalRelatorio.hide();
            
            // Toast de sucesso
            showToast('success', data.message);
            
            // Recarregar página após 1 segundo
            setTimeout(() => {
                window.location.reload();
            }, 1000);
        } else {
            mostrarErros(data.errors || {});
            showToast('error', data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        showToast('error', 'Erro ao salvar relatório. Tente novamente.');
    })
    .finally(() => {
        // Reabilitar botão
        btnSalvar.disabled = false;
        btnSalvar.innerHTML = editandoRelatorio ? 
            '<i class="ri-save-line me-1"></i>Atualizar Relatório' :
            '<i class="ri-save-line me-1"></i>Salvar Relatório';
    });
}

function verRelatorio(relatorioId) {
    window.open(`/projetos/{{ $projeto->id }}/relatorios/${relatorioId}`, '_blank');
}

function editarRelatorio(relatorioId) {
    // Carregamento dos dados do relatório
    fetch(`/projetos/{{ $projeto->id }}/relatorios/${relatorioId}/edit`)
    .then(response => {
        if (!response.ok) {
            throw new Error('Erro na resposta do servidor');
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            // Configurar estado de edição
            editandoRelatorio = true;
            relatorioIdEditando = relatorioId;
            
            // Atualizar título e botão do modal
            document.getElementById('tituloModalRelatorio').innerHTML = 
                '<i class="ri-edit-line me-2"></i>Editar Relatório de Execução';
            document.getElementById('btnSalvarRelatorio').innerHTML = 
                '<i class="ri-save-line me-1"></i>Atualizar Relatório';
            
            // Preencher campos do formulário
            document.getElementById('periodo_inicio').value = data.relatorio.periodo_inicio;
            document.getElementById('periodo_fim').value = data.relatorio.periodo_fim;
            document.getElementById('descricao_tecnica').value = data.relatorio.descricao_tecnica;
            document.getElementById('descricao_financeira').value = data.relatorio.descricao_financeira;
            document.getElementById('percentual_fisico').value = data.relatorio.percentual_fisico || '';
            document.getElementById('valor_executado').value = data.relatorio.valor_executado || '';
            document.getElementById('observacoes').value = data.relatorio.observacoes || '';
            
            // Atualizar contadores e limpar erros
            atualizarContadores();
            limparErros();
            
            // Mostrar modal
            modalRelatorio.show();
        } else {
            showToast('error', data.message || 'Erro ao carregar dados do relatório');
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        showToast('error', 'Erro ao carregar dados do relatório. Verifique sua conexão.');
    });
}

function excluirRelatorio(relatorioId) {
    if (confirm('Tem certeza que deseja excluir este relatório? Esta ação não poderá ser desfeita.')) {
        // Mostrar feedback de carregamento
        showToast('info', 'Excluindo relatório...');
        
        // Obter token CSRF de forma segura
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '{{ csrf_token() }}';
        
        fetch(`/projetos/{{ $projeto->id }}/relatorios/${relatorioId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': csrfToken,
                'Content-Type': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Erro na resposta do servidor');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showToast('success', data.message);
                // Recarregar página após sucesso
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                showToast('error', data.message || 'Erro ao excluir relatório');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            showToast('error', 'Erro ao excluir relatório. Verifique sua conexão.');
        });
    }
}

function mostrarErros(errors) {
    Object.keys(errors).forEach(campo => {
        const input = document.getElementById(campo);
        if (input) {
            input.classList.add('is-invalid');
            const feedback = input.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
                feedback.textContent = errors[campo][0];
            }
        }
    });
}

function limparErros() {
    document.querySelectorAll('.is-invalid').forEach(el => {
        el.classList.remove('is-invalid');
    });
    document.querySelectorAll('.invalid-feedback').forEach(el => {
        el.textContent = '';
    });
}

function atualizarContadores() {
    const tecnica = document.getElementById('descricao_tecnica');
    const financeira = document.getElementById('descricao_financeira');
    const observacoes = document.getElementById('observacoes');
    
    if (tecnica) document.getElementById('contadorTecnica').textContent = tecnica.value.length;
    if (financeira) document.getElementById('contadorFinanceira').textContent = financeira.value.length;
    if (observacoes) document.getElementById('contadorObservacoes').textContent = observacoes.value.length;
}

function validarCampo(campo, minimo, maximo) {
    const valor = campo.value.length;
    const contador = document.getElementById('contador' + campo.id.charAt(0).toUpperCase() + campo.id.slice(1).replace('_', ''));
    
    // Remover classes de validação anteriores
    campo.classList.remove('is-valid', 'is-invalid');
    
    if (minimo > 0 && valor < minimo) {
        campo.classList.add('is-invalid');
        if (contador) contador.style.color = '#dc3545';
    } else if (valor > maximo) {
        campo.classList.add('is-invalid');
        if (contador) contador.style.color = '#dc3545';
    } else if (minimo > 0 && valor >= minimo) {
        campo.classList.add('is-valid');
        if (contador) contador.style.color = '#198754';
    } else {
        if (contador) contador.style.color = '#6c757d';
    }
}

function showToast(type, message) {
    // Função simples para mostrar notificações
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert ${alertClass} alert-dismissible fade show position-fixed`;
    alertDiv.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(alertDiv);
    
    // Remover após 5 segundos
    setTimeout(() => {
        if (alertDiv.parentNode) {
            alertDiv.parentNode.removeChild(alertDiv);
        }
    }, 5000);
}
@endif
</script>
@endsection
