@extends('Layout.LayoutBaseAdmin')


@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item active">Gestão de Utilizadores</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            @if (session('success'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "{{ session('success') }}",
                        icon: "success"
                    });
                });
            </script>
            @endif

            @if (session('error'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "{{ session('error') }}",
                        icon: "error"
                    });
                });
            </script>
            @endif
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Listagem de Utilizadores</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row g-4 mb-3">
                                <div class="col-sm-auto">
                                    <div>
                                        <a href="{{ route('users.create') }}" class="btn btn-success add-btn"><i class="ri-add-line align-bottom me-1"></i> Adicionar Utilizador</a>
                                    </div>
                                </div>
                                <div class="col-sm">
                                    <div class="d-flex justify-content-sm-end">
                                        <div class="search-box ms-2">
                                            <input type="text" class="form-control search" placeholder="Pesquisar...">
                                            <i class="ri-search-line search-icon"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">ID</th>
                                            <th scope="col">Nome</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Telefone</th>
                                            <th scope="col">Tipo</th>
                                            <th scope="col">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($utilizadores as $utilizador)
                                        <tr>
                                            <td>{{ $utilizador->id }}</td>
                                            <td>{{ $utilizador->name }}</td>
                                            <td>{{ $utilizador->email }}</td>
                                            <td>{{ $utilizador->telefone }}</td>
                                            <td>
                                                @if($utilizador->admin == "1")
                                                <span class="badge bg-primary">Administrador</span>
                                                @else
                                                <span class="badge bg-success">Promotor</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="dropdown-custom-wrapper">
                                                    <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="ri-more-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="{{ route('users.show', $utilizador->id) }}"><i class="ri-eye-fill text-primary align-bottom me-2"></i> Ver Detalhes</a></li>
                                                        <li><a class="dropdown-item" href="{{ route('users.edit', $utilizador->id) }}"><i class="ri-pencil-fill text-success align-bottom me-2"></i> Editar</a></li>
                                                        <li>
                                                            <a class="dropdown-item" href="#" onclick="confirmResetPassword({{ $utilizador->id }})"><i class="ri-lock-unlock-fill text-warning align-bottom me-2"></i> Redefinir Senha</a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="#" onclick="confirmDelete({{ $utilizador->id }})"><i class="ri-delete-bin-fill text-danger align-bottom me-2"></i> Excluir</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                {{ $utilizadores->links() }}
                            </div>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de usuário (será acionado via JavaScript) -->
    <form id="delete-form" method="POST" style="display: none;">
        @csrf
        @method('DELETE')
    </form>

    <!-- Form para redefinição de senha -->
    <form id="reset-password-form" method="POST" style="display: none;">
        @csrf
    </form>

    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: "Tem certeza?",
                text: "Esta ação não pode ser revertida!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Sim, excluir!",
                cancelButtonText: "Cancelar"
            }).then((result) => {
                if (result.isConfirmed) {
                    var form = document.getElementById('delete-form');
                    form.action = "{{ url('/usuarios') }}/" + id;
                    form.submit();
                }
            });
        }

        function confirmResetPassword(id) {
            Swal.fire({
                title: "Redefinir senha?",
                text: "Uma nova senha será gerada e enviada para o email do usuário.",
                icon: "question",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Sim, redefinir!",
                cancelButtonText: "Cancelar"
            }).then((result) => {
                if (result.isConfirmed) {
                    var form = document.getElementById('reset-password-form');
                    form.action = "{{ url('/usuarios') }}/" + id + "/reset-senha";
                    form.submit();
                }
            });
        }

        // Script para pesquisa na tabela
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.querySelector('.search');
            const tableRows = document.querySelectorAll('tbody tr');

            searchInput.addEventListener('keyup', function() {
                const searchTerm = this.value.toLowerCase();
                
                tableRows.forEach(row => {
                    const text = row.textContent.toLowerCase();
                    if (text.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
        });
    </script>

</div>
<!-- end main content-->

@endsection
