@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item active">Gestão de Domínio de Projecto</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            @if (session('success'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "{{ session('success') }}",
                        icon: "success"
                    });
                });
            </script>
            @endif

            @if (session('error'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "{{ session('error') }}",
                        icon: "error"
                    });
                });
            </script>
            @endif
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Domínio de Projecto</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row g-4 mb-3">
                                <div class="col-sm-auto">
                                    <div>
                                        <button type="button" class="btn btn-success add-btn" data-bs-toggle="modal" data-bs-target="#addTipoProjectoModal"><i class="ri-add-line align-bottom me-1"></i> Adicionar Domínio de Projeto</button>
                                    </div>
                                </div>
                                <div class="col-sm">
                                    <form action="{{ route('tipo-projecto') }}" method="GET" class="d-flex justify-content-sm-end">
                                        <div class="search-box me-2">
                                            <input type="text" name="descricao" class="form-control" placeholder="Buscar por descrição..." value="{{ request('descricao') }}">
                                            <i class="ri-search-line search-icon"></i>
                                        </div>
                                        <div class="ms-2">
                                            <select name="status" class="form-select">
                                                <option value="">Status</option>
                                                <option value="1" {{ request('status') == '1' ? 'selected' : '' }}>Ativo</option>
                                                <option value="0" {{ request('status') == '0' ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                        </div>
                                        <div class="ms-2">
                                            <button type="submit" class="btn btn-primary">Filtrar</button>
                                            <a href="{{ route('tipo-projecto') }}" class="btn btn-light">Limpar</a>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">ID</th>
                                            <th scope="col">Descrição</th>
                                            <th scope="col">Data de Criação</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($tipos as $tipo)
                                        <tr>
                                            <td>{{ $tipo->id }}</td>
                                            <td>{{ $tipo->descricao }}</td>
                                            <td>{{ date('d/m/Y', strtotime($tipo->created_at)) }}</td>
                                            <td>
                                                @if($tipo->status == 1)
                                                <span class="badge bg-success">Ativo</span>
                                                @else
                                                <span class="badge bg-danger">Inativo</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="dropdown-custom-wrapper">
                                                    <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="ri-more-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="{{ route('TipoProjecto-edit', $tipo->id) }}"><i class="ri-pencil-fill text-success align-bottom me-2"></i> Editar</a></li>
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('TipoProjecto-toggle', $tipo->id) }}">
                                                                @if($tipo->status == 1)
                                                                <i class="ri-lock-fill text-warning align-bottom me-2"></i> Desativar
                                                                @else
                                                                <i class="ri-lock-unlock-fill text-success align-bottom me-2"></i> Ativar
                                                                @endif
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item delete-item" href="#" data-id="{{ $tipo->id }}" data-descricao="{{ $tipo->descricao }}"><i class="ri-delete-bin-fill text-danger align-bottom me-2"></i> Excluir</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5" class="text-center">Nenhum domínio de projecto encontrado</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                {{ $tipos->links() }}
                            </div>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de tipo de projeto (será acionado via JavaScript) -->
    <form id="delete-form" method="POST" style="display: none;">
        @csrf
        @method('DELETE')
    </form>

    <!-- Modal para adicionar tipo de projeto -->
    <div class="modal fade" id="addTipoProjectoModal" tabindex="-1" aria-labelledby="addTipoProjectoModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="addTipoProjectoModalLabel">Adicionar Domínio de Projecto</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('TipoProjecto-store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="tipo_projecto" class="form-label">Descrição <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="tipo_projecto" name="tipo_projecto" required maxlength="60" placeholder="Ex: FINANCIAMENTO, CONSTRUÇÃO, ETC">
                            <div class="form-text">Informe uma descrição única com até 60 caracteres.</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success"><i class="ri-save-line me-1"></i> Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Configuração dos botões de exclusão
            document.querySelectorAll('.delete-item').forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const descricao = this.getAttribute('data-descricao');
                    
                    Swal.fire({
                        title: "Tem certeza?",
                        text: `Você está prestes a excluir o tipo de projeto "${descricao}". Esta ação não pode ser revertida!`,
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#d33",
                        cancelButtonColor: "#3085d6",
                        confirmButtonText: "Sim, excluir!",
                        cancelButtonText: "Cancelar"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = `/delete-TipoProjecto/${id}`;
                            form.submit();
                        }
                    });
                });
            });
        });
    </script>

</div>
<!-- end main content-->

@endsection
