@extends('Layout.LayoutBaseAdmin')
@section('Conteudo')
<div class="main-content"><div class="page-content"><div class="container-fluid">
<div class="row"><div class="col-12"><div class="page-title-box d-flex justify-content-between align-items-center">
<div><h4>Revisar e Editar Salários - {{$parametros['descricao']}}</h4>
<p class="text-muted mb-0">Período: {{$parametros['mes']}}/{{$parametros['ano']}} | Total: {{count($dadosFuncionarios)}} funcionários</p></div>
<a href="{{route('processamento-salarios.index')}}" class="btn btn-secondary">Cancelar</a>
</div></div></div>

<form method="POST" action="{{route('processamento-salarios.store')}}" id="formProcessamento">
@csrf
<input type="hidden" name="descricao" value="{{$parametros['descricao']}}">
<input type="hidden" name="ano" value="{{$parametros['ano']}}">
<input type="hidden" name="mes" value="{{$parametros['mes']}}">
<input type="hidden" name="unidadePagadora" value="{{$parametros['unidadePagadora']}}">
<input type="hidden" name="unidadeProcessadora" value="{{$parametros['unidadeProcessadora']}}">

<div class="card">
<div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
<h5 class="mb-0 text-white"><i class="ri-edit-line me-2 text-white"></i>Revisar e Editar Salários - Completo Editável</h5>
<button type="button" class="btn btn-light btn-sm" onclick="aplicarATodos()">
<i class="ri-file-copy-line me-1"></i>Aplicar valores a todos</button>
</div>
<div class="card-body">
<div class="alert alert-info"><i class="ri-information-line me-2"></i>
<strong>Instruções:</strong> <u>Todos os campos são editáveis!</u> Revise e ajuste os valores de salário base, subsídios, abonos extras e descontos conforme necessário. 
Use o botão "Aplicar valores a todos" para aplicar os mesmos valores a todos os funcionários de uma só vez. Os totais são recalculados automaticamente.
</div>

<div class="table-responsive">
<table class="table table-bordered table-hover" id="tabelaFuncionarios">
<thead style="background-color:rgb(64,81,137);color:white;font-size:0.85rem;position:sticky;top:0">
<tr><th style="width:40px">#</th><th>NBI</th><th>Nome</th><th>Função</th><th>Departamento</th>
<th style="width:110px">Salário Base</th><th style="width:100px">Abono Fam.</th><th style="width:100px">S.Trans.</th>
<th style="width:100px">S.Alim.</th><th style="width:100px">S.Férias</th><th style="width:100px">Outros Sub.</th>
<th class="text-end">Total Bruto</th><th style="width:110px">Desconto</th><th style="width:110px">Abono Extra</th>
<th class="text-end">Total Líquido</th><th style="width:150px">Observação</th></tr>
</thead>
<tbody style="font-size:0.8rem">
@foreach($dadosFuncionarios as $idx => $func)
<tr data-idx="{{$idx}}">
<td class="text-center">{{$idx+1}}</td>
<td>{{$func['nbi']}}</td>
<td>{{$func['nome']}}</td>
<td>{{$func['funcao']}}</td>
<td>{{$func['departamento']}}</td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][salarioBase]" 
value="{{$func['salarioBase']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][abonoFamiliar]" 
value="{{$func['abonoFamiliar']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][subTransporte]" 
value="{{$func['subTransporte']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][subAlimentacao]" 
value="{{$func['subAlimentacao']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][subFerias]" 
value="{{$func['subFerias']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][subOutros]" 
value="{{$func['subOutros']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td class="text-end fw-bold total-bruto-{{$idx}}">{{number_format($func['totalBruto'],2,',','.')}}</td>
<td><input type="number" class="form-control form-control-sm" name="funcionarios[{{$idx}}][descontoCalculado]" 
value="{{$func['descontoCalculado']}}" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td><input type="number" class="form-control form-control-sm input-abono" name="funcionarios[{{$idx}}][acrescimoExtra]" 
value="0" step="0.01" min="0" data-idx="{{$idx}}" onchange="recalcularLinha({{$idx}})"></td>
<td class="text-end fw-bold total-liquido-{{$idx}}">{{number_format($func['totalBruto']-$func['descontoCalculado'],2,',','.')}}</td>
<td><input type="text" class="form-control form-control-sm" name="observacoes[{{$idx}}]" placeholder="Opcional" maxlength="200"></td>

<input type="hidden" name="funcionarios[{{$idx}}][id]" value="{{$func['id']}}">
<input type="hidden" name="funcionarios[{{$idx}}][nome]" value="{{$func['nome']}}">
<input type="hidden" name="funcionarios[{{$idx}}][nbi]" value="{{$func['nbi']}}">
<input type="hidden" name="funcionarios[{{$idx}}][funcao]" value="{{$func['funcao']}}">
<input type="hidden" name="funcionarios[{{$idx}}][grupoPessoal]" value="{{$func['grupoPessoal']}}">
<input type="hidden" name="funcionarios[{{$idx}}][tipoClasse]" value="{{$func['tipoClasse']}}">
<input type="hidden" name="funcionarios[{{$idx}}][descricao]" value="{{$func['descricao']}}">
</tr>
@endforeach
<tr class="table-secondary fw-bold"><td colspan="11" class="text-end">TOTAL GERAL:</td>
<td class="text-end" id="totalGeralBruto">{{number_format(array_sum(array_column($dadosFuncionarios,'totalBruto')),2,',','.')}}</td>
<td class="text-end text-danger" id="totalDesconto">{{number_format(array_sum(array_column($dadosFuncionarios,'descontoCalculado')),2,',','.')}}</td>
<td class="text-end text-success" id="totalAbonoExtra">0,00</td>
<td class="text-end" id="totalGeralLiquido">{{number_format(array_sum(array_column($dadosFuncionarios,'totalBruto'))-array_sum(array_column($dadosFuncionarios,'descontoCalculado')),2,',','.')}}</td>
<td></td></tr>
</tbody></table>
</div>
</div>
<div class="card-footer text-end">
<button type="button" class="btn btn-secondary" onclick="window.history.back()">Voltar</button>
<button type="submit" class="btn btn-success btn-lg"><i class="ri-check-line me-2"></i>Finalizar Processamento</button>
</div>
</div>
</form>
</div></div></div>

<script>
function recalcularLinha(idx) {
    // Pegar todos os valores editáveis da linha
    const salarioBase = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][salarioBase]"]`).value) || 0;
    const abonoFamiliar = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][abonoFamiliar]"]`).value) || 0;
    const subTransporte = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subTransporte]"]`).value) || 0;
    const subAlimentacao = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subAlimentacao]"]`).value) || 0;
    const subFerias = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subFerias]"]`).value) || 0;
    const subOutros = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subOutros]"]`).value) || 0;
    const desconto = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][descontoCalculado]"]`).value) || 0;
    const abonoExtra = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][acrescimoExtra]"]`).value) || 0;
    
    // Calcular total bruto
    const totalBruto = salarioBase + abonoFamiliar + subTransporte + subAlimentacao + subFerias + subOutros + abonoExtra;
    
    // Calcular total líquido
    const totalLiquido = totalBruto - desconto;
    
    // Atualizar displays
    document.querySelector(`.total-bruto-${idx}`).textContent = 
        totalBruto.toLocaleString('pt-AO', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    document.querySelector(`.total-liquido-${idx}`).textContent = 
        totalLiquido.toLocaleString('pt-AO', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    
    atualizarTotaisGerais();
}

function atualizarTotaisGerais() {
    let totalBruto = 0;
    let totalDesconto = 0;
    let totalAbonoExtra = 0;
    let totalLiquido = 0;
    
    const numFuncionarios = document.querySelectorAll('tr[data-idx]').length;
    
    for (let idx = 0; idx < numFuncionarios; idx++) {
        const salarioBase = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][salarioBase]"]`)?.value) || 0;
        const abonoFamiliar = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][abonoFamiliar]"]`)?.value) || 0;
        const subTransporte = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subTransporte]"]`)?.value) || 0;
        const subAlimentacao = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subAlimentacao]"]`)?.value) || 0;
        const subFerias = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subFerias]"]`)?.value) || 0;
        const subOutros = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][subOutros]"]`)?.value) || 0;
        const desconto = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][descontoCalculado]"]`)?.value) || 0;
        const abonoExtra = parseFloat(document.querySelector(`input[name="funcionarios[${idx}][acrescimoExtra]"]`)?.value) || 0;
        
        const bruto = salarioBase + abonoFamiliar + subTransporte + subAlimentacao + subFerias + subOutros + abonoExtra;
        const liquido = bruto - desconto;
        
        totalBruto += bruto;
        totalDesconto += desconto;
        totalAbonoExtra += abonoExtra;
        totalLiquido += liquido;
    }
    
    document.getElementById('totalGeralBruto').textContent = 
        totalBruto.toLocaleString('pt-AO', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    document.getElementById('totalDesconto').textContent = 
        totalDesconto.toLocaleString('pt-AO', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    document.getElementById('totalAbonoExtra').textContent = 
        totalAbonoExtra.toLocaleString('pt-AO', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    document.getElementById('totalGeralLiquido').textContent = 
        totalLiquido.toLocaleString('pt-AO', {minimumFractionDigits: 2, maximumFractionDigits: 2});
}

function aplicarATodos() {
    Swal.fire({
        title: 'Aplicar valores a todos',
        html: `
            <div class="text-start">
                <div class="mb-2">
                    <label class="form-label fw-bold">Abono Familiar (Kz)</label>
                    <input type="number" id="abonoFamiliarGeral" class="form-control" value="" step="0.01" min="0" placeholder="Deixe vazio para não alterar">
                </div>
                <div class="mb-2">
                    <label class="form-label fw-bold">Subsídio Transporte (Kz)</label>
                    <input type="number" id="subTransporteGeral" class="form-control" value="" step="0.01" min="0" placeholder="Deixe vazio para não alterar">
                </div>
                <div class="mb-2">
                    <label class="form-label fw-bold">Subsídio Alimentação (Kz)</label>
                    <input type="number" id="subAlimentacaoGeral" class="form-control" value="" step="0.01" min="0" placeholder="Deixe vazio para não alterar">
                </div>
                <div class="mb-2">
                    <label class="form-label fw-bold">Subsídio Férias (Kz)</label>
                    <input type="number" id="subFeriasGeral" class="form-control" value="" step="0.01" min="0" placeholder="Deixe vazio para não alterar">
                </div>
                <div class="mb-2">
                    <label class="form-label fw-bold">Abono Extra (Kz)</label>
                    <input type="number" id="abonoExtraGeral" class="form-control" value="" step="0.01" min="0" placeholder="Deixe vazio para não alterar">
                </div>
                <div class="mb-2">
                    <label class="form-label fw-bold text-danger">Desconto (Kz)</label>
                    <input type="number" id="descontoGeral" class="form-control" value="" step="0.01" min="0" placeholder="Deixe vazio para não alterar">
                </div>
            </div>
        `,
        width: '500px',
        showCancelButton: true,
        confirmButtonText: 'Aplicar',
        cancelButtonText: 'Cancelar',
        preConfirm: () => {
            return {
                abonoFamiliar: document.getElementById('abonoFamiliarGeral').value,
                subTransporte: document.getElementById('subTransporteGeral').value,
                subAlimentacao: document.getElementById('subAlimentacaoGeral').value,
                subFerias: document.getElementById('subFeriasGeral').value,
                abonoExtra: document.getElementById('abonoExtraGeral').value,
                desconto: document.getElementById('descontoGeral').value
            };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const numFuncionarios = document.querySelectorAll('tr[data-idx]').length;
            
            for (let idx = 0; idx < numFuncionarios; idx++) {
                if (result.value.abonoFamiliar !== '') {
                    document.querySelector(`input[name="funcionarios[${idx}][abonoFamiliar]"]`).value = result.value.abonoFamiliar;
                }
                if (result.value.subTransporte !== '') {
                    document.querySelector(`input[name="funcionarios[${idx}][subTransporte]"]`).value = result.value.subTransporte;
                }
                if (result.value.subAlimentacao !== '') {
                    document.querySelector(`input[name="funcionarios[${idx}][subAlimentacao]"]`).value = result.value.subAlimentacao;
                }
                if (result.value.subFerias !== '') {
                    document.querySelector(`input[name="funcionarios[${idx}][subFerias]"]`).value = result.value.subFerias;
                }
                if (result.value.abonoExtra !== '') {
                    document.querySelector(`input[name="funcionarios[${idx}][acrescimoExtra]"]`).value = result.value.abonoExtra;
                }
                if (result.value.desconto !== '') {
                    document.querySelector(`input[name="funcionarios[${idx}][descontoCalculado]"]`).value = result.value.desconto;
                }
                recalcularLinha(idx);
            }
            
            Swal.fire('Aplicado!', 'Valores aplicados a todos os funcionários.', 'success');
        }
    });
}

document.getElementById('formProcessamento').addEventListener('submit', function(e) {
    e.preventDefault();
    Swal.fire({
        title: 'Confirmar Processamento?',
        text: 'Esta ação irá processar os salários de {{count($dadosFuncionarios)}} funcionários.',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, processar!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});
</script>
@endsection
