@extends('Layout.LayoutBaseAdmin')
@section('Conteudo')
<div class="main-content"><div class="page-content"><div class="container-fluid">
<div class="row"><div class="col-12"><div class="page-title-box">
<h4>Processamento de Salários</h4></div></div></div>

@if(session('success'))<script>Swal.fire({title:"Sucesso!",text:"{{session('success')}}",icon:"success"});</script>@endif

<div class="row mb-3">
<div class="col-md-6"><div class="card"><div class="card-body text-center">
<h6>Total Processado</h6><h3>{{number_format($totalProcessado??0,2,',','.')}} Kz</h3>
</div></div></div>
<div class="col-md-6"><div class="card"><div class="card-body">
<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#novoModal">Novo Processamento</button>
</div></div></div>
</div>

<div class="card"><div class="card-body"><table class="table">
<thead><tr><th>Período</th><th>Descrição</th><th>Funcionários</th><th>Total</th><th>Status</th><th>Ações</th></tr></thead>
<tbody>@foreach($processamentos as $p)<tr>
<td>{{$p->nomeMes}}/{{$p->ano}}</td><td>{{$p->descricao}}</td>
<td>{{$p->quantidadeFuncionarios()}}</td><td>{{number_format($p->totalSalarios(),2,',','.')}} Kz</td>
<td><span class="badge bg-{{$p->status=='Concluído'?'success':'warning'}}">{{$p->status}}</span></td>
<td><a href="{{route('processamento-salarios.show',$p->id)}}" class="btn btn-sm btn-info">Ver</a>
<a href="{{route('processamento-salarios.exportar-pdf-geral',$p->id)}}" class="btn btn-sm btn-danger">PDF</a></td>
</tr>@endforeach</tbody></table>
{{$processamentos->links()}}</div></div>

<div class="modal fade" id="novoModal"><div class="modal-dialog">
<form method="POST" action="{{route('processamento-salarios.preparar')}}">@csrf
<div class="modal-content"><div class="modal-header"><h5>Novo</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
<div class="modal-body">
<div class="mb-3"><label>Descrição</label><input type="text" class="form-control" name="descricao" required></div>
<div class="row"><div class="col-6 mb-3"><label>Ano</label><input type="number" class="form-control" name="ano" value="{{date('Y')}}" required></div>
<div class="col-6 mb-3"><label>Mês</label><select class="form-select" name="mes" required>
@for($i=1;$i<=12;$i++)<option value="{{$i}}">{{$i}}</option>@endfor</select></div></div>
<div class="mb-3"><label>Unidade Pagadora</label><input type="text" class="form-control" name="unidadePagadora" required></div>
<div class="mb-3"><label>Unidade Processadora</label><select class="form-select" name="unidadeProcessadora" required>
@foreach($departamentos as $d)<option value="{{$d->nomeDepartamento}}">{{$d->nomeDepartamento}}</option>@endforeach</select></div>
<div class="mb-3"><label>Departamento (Opcional)</label><select class="form-select" name="id_departamento">
<option value="">Todos</option>@foreach($departamentos as $d)<option value="{{$d->id}}">{{$d->nomeDepartamento}}</option>@endforeach</select></div>
</div><div class="modal-footer"><button type="submit" class="btn btn-primary">Processar</button></div>
</div></form></div></div>
</div></div></div>
@endsection
