<div class="row">
    <div class="col-12 mb-3">
        <div class="d-flex align-items-center mb-2">
            <h5 class="mb-0 me-2">{{ $projecto->nomeProjecto }}</h5>
            <span class="badge {{ 
                $projecto->status == 0 ? 'bg-secondary' : 
                ($projecto->status == 1 ? 'bg-info' : 
                ($projecto->status == 2 ? 'bg-primary' : 
                ($projecto->status == 3 ? 'bg-danger' : 
                ($projecto->status == 4 ? 'bg-warning' : 'bg-success')))) 
            }}">
                @php
                    $statusText = [
                        0 => 'Projecto Recebido',
                        1 => 'Em Análise',
                        2 => 'Aprovado para Homologação',
                        3 => 'Rejeitado',
                        4 => 'Em Acompanhamento',
                        5 => 'Concluído'
                    ];
                @endphp
                {{ $statusText[$projecto->status] ?? 'Desconhecido' }}
            </span>
        </div>
        <p class="text-muted mb-0">Código: {{ $projecto->codProjecto }}</p>
    </div>
    
    <div class="col-md-6">
        <div class="card border mb-3">
            <div class="card-header bg-soft-primary">
                <h6 class="card-title mb-0">Informações Gerais</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless mb-0">
                    <tbody>
                        <tr>
                            <th class="ps-0" width="40%">Tipo de Projecto:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->tipoProjecto->nomeTipo ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Promotor:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->user->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Técnico Responsável:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->tecnicoProjecto->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Data de Submissão:</th>
                            <td class="text-muted text-end pe-0">{{ \Carbon\Carbon::parse($projecto->created_at)->format('d/m/Y H:i') }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Localização:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->localizacao_projecto }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Âmbito:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->ambito }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card border mb-3">
            <div class="card-header bg-soft-success">
                <h6 class="card-title mb-0">Detalhes Financeiros</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless mb-0">
                    <tbody>
                        <tr>
                            <th class="ps-0" width="40%">Limite Orçamental:</th>
                            <td class="text-muted text-end pe-0">{{ number_format($projecto->limiteorcamentalP, 2, ',', '.') }} KZ</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Nº Beneficiários:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->beneficiarioDP }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Financiador:</th>
                            <td class="text-muted text-end pe-0">{{ $projecto->financeador }}</td>
                        </tr>
                        <tr>
                            <th class="ps-0">Duração:</th>
                            <td class="text-muted text-end pe-0">
                                {{ \Carbon\Carbon::parse($projecto->duracaoP)->format('d/m/Y') }} - 
                                {{ \Carbon\Carbon::parse($projecto->duracaoF)->format('d/m/Y') }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-12">
        <div class="card border mb-0">
            <div class="card-header bg-soft-info">
                <h6 class="card-title mb-0">Descrição do Projecto</h6>
            </div>
            <div class="card-body">
                <h6 class="mb-2">Objectivo:</h6>
                <p class="text-muted mb-3">{{ $projecto->descricaoObjectivo }}</p>
                
                <h6 class="mb-2">Justificação:</h6>
                <p class="text-muted mb-3">{{ $projecto->justificacao }}</p>
                
                <h6 class="mb-2">Modo de Funcionamento:</h6>
                <p class="text-muted mb-3">{{ $projecto->mFuncionamento }}</p>
                
                @if($projecto->impactoSocial)
                <h6 class="mb-2">Impacto Social:</h6>
                <p class="text-muted mb-0">{{ $projecto->impactoSocial }}</p>
                @endif
            </div>
        </div>
    </div>
</div>
