@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item active">Gestão de Funcionários</li>
                            </ol>
                        </div>

    <!-- Modal: Atribuir Remuneração ao Funcionário -->
    <div class="modal fade" id="atribuirRemuneracaoModal" tabindex="-1" aria-labelledby="atribuirRemuneracaoModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title text-white" id="atribuirRemuneracaoModalLabel">Atribuir Remuneração para <span class="nome-funcionario text-white">Funcionário</span></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="form-atribuir-remuneracao" method="POST" action="">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="remuneracao_id" class="form-label">Remuneração <span class="text-danger">*</span></label>
                            <select class="form-select" id="remuneracao_id" name="remuneracao_id" required>
                                <option value="">Selecione</option>
                                @foreach($remuneracoes as $rem)
                                    <option value="{{ $rem->id }}" data-valor="{{ $rem->valor }}">{{ $rem->tipo }} — {{ Str::limit($rem->descricao, 80) }} — {{ number_format($rem->valor, 2, ',', '.') }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="valorRem" class="form-label">Valor <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="valorRem" name="valor" required min="0" step="0.01" placeholder="0,00">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="statusRem" class="form-label">Estado <span class="text-danger">*</span></label>
                                    <select class="form-select" id="statusRem" name="status" required>
                                        <option value="Ativo" selected>Ativo</option>
                                        <option value="Inativo">Inativo</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="observacaoRem" class="form-label">Observação</label>
                            <textarea class="form-control" id="observacaoRem" name="observacao" maxlength="1000" rows="3" placeholder="Observações (opcional)"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary"><i class="ri-save-line me-1"></i> Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal: Coordenadas Bancárias -->
    <div class="modal fade" id="coordenadasBancariasModal" tabindex="-1" aria-labelledby="coordenadasBancariasModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-info text-white">
                    <h5 class="modal-title text-white" id="coordenadasBancariasModalLabel">
                        <i class="ri-bank-card-line me-2"></i>Coordenadas Bancárias - <span class="nome-funcionario-banco text-white">Funcionário</span>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="form-coordenadas-bancarias" method="POST" action="">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="banco" class="form-label"><i class="ri-bank-line me-1"></i>Banco</label>
                                    <input type="text" class="form-control" id="banco" name="banco" maxlength="255" placeholder="Nome do banco">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="iban" class="form-label"><i class="ri-barcode-line me-1"></i>IBAN</label>
                                    <input type="text" class="form-control" id="iban" name="iban" maxlength="50" placeholder="AO06XXXXXXXXXXXXXXXX">
                                    <small class="text-muted">International Bank Account Number</small>
                                </div>
                            </div>
                            
                        </div>

                        <div class="row">
                            
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="nib" class="form-label"><i class="ri-hashtag me-1"></i>NIB</label>
                                    <input type="text" class="form-control" id="nib" name="nib" maxlength="50" placeholder="Número de Identificação Bancária">
                                    <small class="text-muted">Número de Identificação Bancária</small>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="swift_bic" class="form-label"><i class="ri-global-line me-1"></i>SWIFT/BIC</label>
                                    <input type="text" class="form-control" id="swift_bic" name="swift_bic" maxlength="20" placeholder="Código SWIFT/BIC">
                                    <small class="text-muted">Código de identificação internacional</small>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="observacoes_bancarias" class="form-label"><i class="ri-file-text-line me-1"></i>Observações</label>
                            <textarea class="form-control" id="observacoes_bancarias" name="observacoes_bancarias" rows="3" maxlength="1000" placeholder="Observações adicionais sobre as coordenadas bancárias"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal"><i class="ri-close-line me-1"></i>Cancelar</button>
                        <button type="submit" class="btn btn-info"><i class="ri-save-line me-1"></i>Salvar Coordenadas</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            @if (session('success'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "{{ session('success') }}",
                        icon: "success"
                    });
                });
            </script>
            @endif

            @if (session('error'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "{{ session('error') }}",
                        icon: "error"
                    });
                });
            </script>
            @endif
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Funcionários</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row g-4 mb-3">
                                <div class="col-sm-auto">
                                    <div>
                                        <button type="button" class="btn btn-success add-btn" data-bs-toggle="modal" data-bs-target="#addFuncionarioModal"><i class="ri-add-line align-bottom me-1"></i> Adicionar Funcionário</button>
                                    </div>
                                </div>
                                <div class="col-sm">
                                    <form action="{{ route('funcionarios.index') }}" method="GET" class="d-flex justify-content-sm-end gap-2">
                                        <div class="search-box me-2">
                                            <input type="text" name="nomeCompleto" class="form-control" placeholder="Buscar por nome..." value="{{ request('nomeCompleto') }}">
                                            <i class="ri-search-line search-icon"></i>
                                        </div>
                                        <div class="me-2">
                                            <select name="departamento" class="form-select">
                                                <option value="">Unidade Processadora</option>
                                                @foreach($departamentos as $departamento)
                                                    <option value="{{ $departamento->id }}" {{ request('departamento') == $departamento->id ? 'selected' : '' }}>
                                                        {{ $departamento->nomeDepartamento }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="me-2">
                                            <select name="funcao" class="form-select">
                                                <option value="">Função</option>
                                                @foreach($funcoes as $funcao)
                                                    <option value="{{ $funcao->id }}" {{ request('funcao') == $funcao->id ? 'selected' : '' }}>
                                                        {{ $funcao->nomeFuncao }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="me-2">
                                            <select name="estado" class="form-select">
                                                <option value="">Estado</option>
                                                <option value="Ativo" {{ request('estado') == 'Ativo' ? 'selected' : '' }}>Ativo</option>
                                                <option value="Inativo" {{ request('estado') == 'Inativo' ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                        </div>
                                        <div class="ms-2">
                                            <button type="submit" class="btn btn-primary">Filtrar</button>
                                            <a href="{{ route('funcionarios.index') }}" class="btn btn-light">Limpar</a>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">ID</th>
                                            <th scope="col">Nome Completo</th>
                                            <th scope="col">Documento</th>
                                            <th scope="col">Telefone</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Grupo de Pessoal</th>
                                            <th scope="col">Função</th>
                                            <th scope="col">Unidade Processadora</th>
                                            <th scope="col">Estado</th>
                                            <th scope="col">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($funcionarios as $funcionario)
                                        <tr>
                                            <td>{{ $funcionario->id }}</td>
                                            <td>{{ $funcionario->nomeCompleto }}</td>
                                            <td>{{ $funcionario->tipoDocumento }}: {{ $funcionario->numeroDocumento }}</td>
                                            <td>
                                                {{ $funcionario->telefone }}
                                                @if($funcionario->checkTelefone == '1')
                                                    <span class="badge bg-success ms-1">✓</span>
                                                @else
                                                    <span class="badge bg-warning ms-1">?</span>
                                                @endif
                                            </td>
                                            <td>{{ $funcionario->email }}</td>
                                            <td>{{ $funcionario->grupoPessoal->nomeGrupo ?? 'N/A' }}</td>
                                            <td>{{ $funcionario->funcao->nomeFuncao ?? 'N/A' }}</td>
                                            <td>{{ $funcionario->departamento->nomeDepartamento ?? 'N/A' }}</td>
                                            <td>
                                                @if($funcionario->estado == 'Ativo')
                                                <span class="badge bg-success">Ativo</span>
                                                @else
                                                <span class="badge bg-danger">Inativo</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="dropdown-custom-wrapper">
                                                    <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="ri-more-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="{{ route('funcionarios.edit', $funcionario->id) }}"><i class="ri-pencil-fill text-success align-bottom me-2"></i> Editar</a></li>
                                                        <li>
                                                            <a class="dropdown-item btn-coordenadas-bancarias" href="#" data-id="{{ $funcionario->id }}" data-nome="{{ $funcionario->nomeCompleto }}">
                                                                <i class="ri-bank-card-line text-info align-bottom me-2"></i> Coordenadas Bancárias
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item btn-atribuir-remuneracao" href="#" data-id="{{ $funcionario->id }}" data-nome="{{ $funcionario->nomeCompleto }}">
                                                                <i class="ri-money-dollar-circle-fill text-primary align-bottom me-2"></i> Atribuir Remuneração
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('funcionarios.toggle-status', $funcionario->id) }}">
                                                                @if($funcionario->estado == 'Ativo')
                                                                <i class="ri-lock-fill text-warning align-bottom me-2"></i> Desativar
                                                                @else
                                                                <i class="ri-lock-unlock-fill text-success align-bottom me-2"></i> Ativar
                                                                @endif
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item delete-item" href="#" data-id="{{ $funcionario->id }}" data-nome="{{ $funcionario->nomeCompleto }}"><i class="ri-delete-bin-fill text-danger align-bottom me-2"></i> Excluir</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="9" class="text-center">Nenhum funcionário encontrado</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                {{ $funcionarios->links() }}
                            </div>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de funcionário (será acionado via JavaScript) -->
    <form id="delete-form" method="POST" style="display: none;">
        @csrf
        @method('DELETE')
    </form>

    <!-- Modal para adicionar funcionário -->
    <div class="modal fade" id="addFuncionarioModal" tabindex="-1" aria-labelledby="addFuncionarioModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="addFuncionarioModalLabel">Adicionar Funcionário</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('funcionarios.store') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="nomeCompleto" class="form-label">Nome Completo <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="nomeCompleto" name="nomeCompleto" required maxlength="255" placeholder="Nome completo do funcionário">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="numeroDocumento" class="form-label">Número do Documento <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="numeroDocumento" name="numeroDocumento" required maxlength="50" placeholder="Número do BI/Passaporte">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="tipoDocumento" class="form-label">Tipo de Documento <span class="text-danger">*</span></label>
                                    <select class="form-select" id="tipoDocumento" name="tipoDocumento" required>
                                        <option value="">Selecione o tipo</option>
                                        <option value="BI">Bilhete de Identidade</option>
                                        <option value="Passaporte">Passaporte</option>
                                        <option value="Carta de Condução">Carta de Condução</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="numeroColaborador" class="form-label">Número do Colaborador</label>
                                    <input type="text" class="form-control" id="numeroColaborador" name="numeroColaborador" maxlength="50" placeholder="Número interno do colaborador">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="telefone" class="form-label">Telefone <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" id="telefone" name="telefone" required maxlength="20" placeholder="+244 XXX XXX XXX">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" id="email" name="email" required maxlength="255" placeholder="email@exemplo.com">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="id_departamento" class="form-label">Unidade Processadora<span class="text-danger">*</span></label>
                                    <select class="form-select" id="id_departamento" name="id_departamento" required>
                                        <option value="">Selecione o Unidade Processadora</option>
                                        @foreach($departamentos as $departamento)
                                            <option value="{{ $departamento->id }}">{{ $departamento->nomeDepartamento }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="id_funcao" class="form-label">Função <span class="text-danger">*</span></label>
                                    <select class="form-select" id="id_funcao" name="id_funcao" required>
                                        <option value="">Selecione a função</option>
                                        @foreach($funcoes as $funcao)
                                            <option value="{{ $funcao->id }}">{{ $funcao->nomeFuncao }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="mb-3">
                                    <label for="id_grupo_pessoal" class="form-label">Grupo Pessoal <span class="text-danger">*</span></label>
                                    <select class="form-select" id="id_grupo_pessoal" name="id_grupo_pessoal" required>
                                        <option value="">Selecione o grupo</option>
                                        @foreach($grupoPessoais as $grupoPessoal)
                                            <option value="{{ $grupoPessoal->id }}">{{ $grupoPessoal->nomeGrupo }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">Verificação do Documento</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="checkDocumento" name="checkDocumento" value="1">
                                        <label class="form-check-label" for="checkDocumento">Documento Verificado</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="mb-3">
                                    <label class="form-label">Verificação do Telefone</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="checkTelefone" name="checkTelefone" value="1">
                                        <label class="form-check-label" for="checkTelefone">Telefone Verificado</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success"><i class="ri-save-line me-1"></i> Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Configuração dos botões de exclusão
            document.querySelectorAll('.delete-item').forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const nome = this.getAttribute('data-nome');

                    Swal.fire({
                        title: "Tem certeza?",
                        text: `Você está prestes a excluir o funcionário "${nome}". Esta ação não pode ser revertida!`,
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#d33",
                        cancelButtonColor: "#3085d6",
                        confirmButtonText: "Sim, excluir!",
                        cancelButtonText: "Cancelar"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = `{{ url('funcionarios') }}/${id}`;
                            form.submit();
                        }
                    });
                });
            });

            // Atribuir Remuneração
            document.querySelectorAll('.btn-atribuir-remuneracao').forEach(function(btn) {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const nome = this.getAttribute('data-nome');

                    const modalEl = document.getElementById('atribuirRemuneracaoModal');
                    modalEl.querySelector('.nome-funcionario').textContent = nome;

                    const form = document.getElementById('form-atribuir-remuneracao');
                    form.action = `{{ url('funcionarios') }}/${id}/remuneracoes`;
                    form.reset();

                    const modal = new bootstrap.Modal(modalEl);
                    modal.show();
                });
            });

            // Coordenadas Bancárias
            document.querySelectorAll('.btn-coordenadas-bancarias').forEach(function(btn) {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const nome = this.getAttribute('data-nome');

                    const modalEl = document.getElementById('coordenadasBancariasModal');
                    modalEl.querySelector('.nome-funcionario-banco').textContent = nome;

                    const form = document.getElementById('form-coordenadas-bancarias');
                    form.action = `{{ url('funcionarios') }}/${id}/coordenadas`;

                    // Buscar coordenadas bancárias via AJAX
                    fetch(`{{ url('funcionarios') }}/${id}/coordenadas`)
                        .then(response => response.json())
                        .then(data => {
                            document.getElementById('banco').value = data.banco || '';
                            document.getElementById('iban').value = data.iban || '';
                            document.getElementById('nib').value = data.nib || '';
                            document.getElementById('swift_bic').value = data.swift_bic || ''
                            document.getElementById('observacoes_bancarias').value = data.observacoes_bancarias || '';
                        })
                        .catch(error => {
                            console.error('Erro ao carregar coordenadas:', error);
                            Swal.fire({
                                title: "Erro!",
                                text: "Não foi possível carregar as coordenadas bancárias.",
                                icon: "error"
                            });
                        });

                    const modal = new bootstrap.Modal(modalEl);
                    modal.show();
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
    const selectRemuneracao = document.getElementById('remuneracao_id');
    const inputValor = document.getElementById('valorRem');
    
    selectRemuneracao.addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        
        if (selectedOption.value !== '') {
            const valor = selectedOption.getAttribute('data-valor');
            inputValor.value = valor;
        } else {
            inputValor.value = '';
        }
    });
});
    </script>

</div>
<!-- end main content-->

@endsection
