 @extends('Layout.LayoutBaseAdmin')


 @section('Conteudo')
   

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Página Principal</a></li>
                                        <li class="breadcrumb-item active">Entidade Promotora</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <!-- Mensagens do sistema -->

                    @if (@session('msg'))
                        
                    

                    <script>
                        document.addEventListener('DOMContentLoaded',()=>{

                            Swal.fire({
                                title: "Pronto!",
                                text: "{{ session('msg') }}",
                                icon: "success"
                            });
                        });
                        
                    </script>

                     <!-- Mensagens do sistema -->
                        
                    @endif
                    

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card card-height-100">
                                <div class="card-header d-flex align-items-center ">
                                    <h4 class="card-title flex-grow-1 mb-0">Entidade Promotora</h4>

                                    <div class="hstack flex-wrap gap-2 mb-3 mb-lg-0" >
    
                                        <button type="button" class="btn btn-primary btn-label"  data-bs-toggle="modal" data-bs-target=".exampleModalFullscreen"><i class=" ri-add-fill label-icon align-middle fs-16 me-2"></i>Nova Entidade Promotora &nbsp; &nbsp; &nbsp;</button>
                                       
                                    </div>
                                    
                                </div><!-- end cardheader -->
                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table  class="table table-nowrap table-centered align-middle">
                                            <thead class="bg-light text-muted">
                                                <tr>
                                                    <th scope="col">Logotipo</th>
                                                    <th scope="col">Instituição</th>
                                                    <th scope="col">NIF</th>
                                                    <th scope="col">Endereço</th>
                                                    <th scope="col">E-mail</th>
                                                    <th scope="col">Contacto Primário</th>
                                                    <th scope="col">Website</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col" style="width: 10%;">Ações</th>
                                                </tr><!-- end tr -->
                                            </thead><!-- thead -->

                                            <tbody>
                                                @forelse ( $entidadesP as $projecto )
                                                
                                                <tr>
                                                    <td><img src="Img/Entidades/{{ $projecto->logo }}" alt="" class="rounded avatar-sm material-shadow"></td>
                                                    <td class="fw-medium">{{ $projecto->nomeRegistro}}</td>
                                                    <td class="fw-medium">{{ $projecto->nif}}</td>
                                                    <td class="fw-medium">{{ $projecto->endereco}}</td>
                                                    <td class="text-muted">{{ $projecto->email}}</td>
                                                    <td class="fw-medium">{{ $projecto->contactoPrimario}}</td>
                                                    <td class="fw-medium">{{ $projecto->website}}</td>
                                                    <td>
                                                        @if ($projecto->status>0)
                                                            <span class="badge bg-success-subtle text-success">Activo</span>
                                                        @else
                                                            <span class="badge bg-warning-subtle text-warning">Desativado</span>

                                                        @endif
                                                    </td>
                                                    <td class="text-muted"> 

                                                    <!-- Dropdown Menu - MODIFICADO -->
                                                    <div class="btn-group dropdown-custom-wrapper">
                                                        <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                            Opções
                                                        </button>
                                                        <div class="dropdown-menu dropdownmenu-primary">
                                                             <a class="dropdown-item " href="#"><i class=" ri-search-eye-line label-icon align-middle fs-16 me-2"></i> Detalhe</a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target=".exampleModalFullscreen21"dd><i class=" ri-building-3-fill label-icon align-middle fs-16 me-2"></i> Adicionar Responsável</a>
                                                            <a class="dropdown-item" href="#"><i class="ri-bank-fill label-icon align-middle fs-16 me-2"></i> Dados Bancários</a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item" href="#"><i class="ri-edit-fill label-icon align-middle fs-16 me-2"></i> Editar </a>                                                            
                                                            <a class="dropdown-item" href="#"><i class="ri-rotate-lock-fill label-icon align-middle fs-16 me-2"></i> Bloquear</a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item text-danger" href="#"><i class="ri-delete-bin-5-fill label-icon align-middle fs-16 me-2"></i> Excluir</a>
                                                        </div>
                                                    </div>
                                                </td>
                                                </tr><!-- end tr -->

                                                   
                                                @empty

                                                <tr>
                                                    <td colspan="9">Nenhum registro foi encontrado...</td>
                                                    
                                                    </td>
                                                </tr><!-- end
                                                    
                                                @endforelse
                                                
                                               
                                            </tbody><!-- end tbody -->
                                        </table><!-- end table -->
                                    </div>
                                    <br>
                                    {{ $entidadesP->onEachSide(3)->links() }}

                                </div><!-- end card body -->
                            </div><!-- end card -->
                        </div><!-- end col -->


                       
                       
                    </div><!-- end row -->

                    

                </div>
                <!-- container-fluid -->
                @include("Administracao.ComponentesAdmin.Cpt_EntidadePromotora")
                @include("Administracao.ComponentesAdmin.Cpt_Promotor")
            </div>
           
          


   @endsection
  