@extends('Layout.LayoutBaseAdmin')

@section('head-extra')
<style>
    .btn {
        cursor: pointer;
    }
</style>
@endsection

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('users.index') }}">Utilizadores</a></li>
                                <li class="breadcrumb-item active">Editar Utilizador</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Editar Utilizador: {{ $utilizador->name }}</h4>
                        </div><!-- end card header -->

                        <div class="card-body">

                            @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                            @endif

                            <form action="{{ route('users.update', $utilizador->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="nome" class="form-label">Nome Completo <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="nome" name="nome" value="{{ old('nome', $utilizador->name) }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control" id="email" name="email" value="{{ old('email', $utilizador->email) }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="tel" class="form-label">Telefone <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="tel" name="tel" value="{{ old('tel', $utilizador->telefone) }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="id_entidade" class="form-label">Entidade <span class="text-danger">*</span></label>
                                            <select class="form-select" id="id_entidade" name="id_entidade" required>
                                                <option value="">Selecione uma entidade</option>
                                                @foreach($entidades as $entidade)
                                                <option value="{{ $entidade->id }}" {{ (old('id_entidade', $utilizador->id_entidade) == $entidade->id) ? 'selected' : '' }}>
                                                    {{ $entidade->nome }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="tipo" class="form-label">Tipo de Utilizador <span class="text-danger">*</span></label>
                                            <select class="form-select" id="tipo" name="tipo" required>
                                                <option value="">Selecione o tipo de utilizador</option>
                                                <option value="1" {{ (old('tipo', $utilizador->admin) == '1') ? 'selected' : '' }}>Administrador</option>
                                                <option value="2" {{ (old('tipo', $utilizador->client) == '1') ? 'selected' : '' }}>Promotor</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="password" class="form-label">Nova Senha (opcional)</label>
                                            <input type="password" class="form-control" id="password" name="password">
                                            <small class="text-muted">Deixe em branco para manter a senha atual</small>
                                        </div>
                                    </div>

                                    <div class="col-12 mt-4">
                                        <div class="d-flex justify-content-end gap-2">
                                            <a href="{{ route('users.index') }}" class="btn btn-light" style="cursor: pointer;">Cancelar</a>
                                            <button type="submit" class="btn btn-primary" style="cursor: pointer;">Atualizar Utilizador</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
