@extends('Layout.LayoutBaseAdmin')

@section('head-extra')
<style>
    .btn {
        cursor: pointer;
    }
</style>
@endsection

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('tipo-projecto') }}">Tipos de Projeto</a></li>
                                <li class="breadcrumb-item active">Editar Tipo de Projeto</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Editar Tipo de Projeto: {{ $tipo->descricao }}</h4>
                        </div><!-- end card header -->

                        <div class="card-body">

                            @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                            @endif

                            <form action="{{ route('TipoProjecto-update', $tipo->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label for="descricao" class="form-label">Descrição <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="descricao" name="descricao" value="{{ old('descricao', $tipo->descricao) }}" required maxlength="60">
                                            <div class="form-text">Informe uma descrição única com até 60 caracteres.</div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">Status</label>
                                            <div class="form-check form-switch form-switch-md">
                                                <input class="form-check-input" type="checkbox" role="switch" id="status" name="status" value="1" {{ $tipo->status == 1 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="status">
                                                    <span class="badge {{ $tipo->status == 1 ? 'bg-success' : 'bg-danger' }}" id="statusBadge">
                                                        {{ $tipo->status == 1 ? 'Ativo' : 'Inativo' }}
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-12">
                                        <a href="{{ route('tipo-projecto') }}" class="btn btn-secondary">Cancelar</a>
                                        <button type="submit" class="btn btn-primary"><i class="ri-save-line me-1"></i> Salvar Alterações</button>
                                    </div>
                                </div>
                            </form>

                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Atualiza o badge de status quando o switch é alterado
            const statusSwitch = document.getElementById('status');
            const statusBadge = document.getElementById('statusBadge');
            
            statusSwitch.addEventListener('change', function() {
                if (this.checked) {
                    statusBadge.className = 'badge bg-success';
                    statusBadge.textContent = 'Ativo';
                } else {
                    statusBadge.className = 'badge bg-danger';
                    statusBadge.textContent = 'Inativo';
                }
            });
        });
    </script>

</div>
<!-- end main content-->

@endsection
