@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('funcoes.index') }}">Gestão de Funções</a></li>
                                <li class="breadcrumb-item active">Editar Função</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            @if (session('success'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "{{ session('success') }}",
                        icon: "success"
                    });
                });
            </script>
            @endif

            @if (session('error'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "{{ session('error') }}",
                        icon: "error"
                    });
                });
            </script>
            @endif
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Editar Função</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <form action="{{ route('funcoes.update', $funcao->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="nomeFuncao" class="form-label">Nome da Função <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nomeFuncao') is-invalid @enderror" id="nomeFuncao" name="nomeFuncao" value="{{ old('nomeFuncao', $funcao->nomeFuncao) }}" required maxlength="255" placeholder="Ex: Gerente, Analista, Coordenador">
                                            @error('nomeFuncao')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <div class="form-text">Informe o nome da função com até 255 caracteres.</div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="estado" class="form-label">Estado <span class="text-danger">*</span></label>
                                            <select class="form-select @error('estado') is-invalid @enderror" id="estado" name="estado" required>
                                                <option value="">Selecione o estado</option>
                                                <option value="Ativo" {{ old('estado', $funcao->estado) == 'Ativo' ? 'selected' : '' }}>Ativo</option>
                                                <option value="Inativo" {{ old('estado', $funcao->estado) == 'Inativo' ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                            @error('estado')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="ObservacaoFuncao" class="form-label">Observação</label>
                                            <textarea class="form-control @error('ObservacaoFuncao') is-invalid @enderror" id="ObservacaoFuncao" name="ObservacaoFuncao" rows="4" maxlength="1000" placeholder="Observações adicionais sobre a função (opcional)">{{ old('ObservacaoFuncao', $funcao->ObservacaoFuncao) }}</textarea>
                                            @error('ObservacaoFuncao')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <div class="form-text">Máximo de 1000 caracteres.</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="{{ route('funcoes.index') }}" class="btn btn-light"><i class="ri-arrow-left-line me-1"></i> Voltar</a>
                                            <button type="submit" class="btn btn-primary"><i class="ri-save-line me-1"></i> Atualizar Função</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
