@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('funcionarios.index') }}">Gestão de Funcionários</a></li>
                                <li class="breadcrumb-item active">Editar Funcionário</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            @if (session('success'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "{{ session('success') }}",
                        icon: "success"
                    });
                });
            </script>
            @endif

            @if (session('error'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "{{ session('error') }}",
                        icon: "error"
                    });
                });
            </script>
            @endif
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Editar Funcionário</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <form action="{{ route('funcionarios.update', $funcionario->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="nomeCompleto" class="form-label">Nome Completo <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nomeCompleto') is-invalid @enderror" id="nomeCompleto" name="nomeCompleto" value="{{ old('nomeCompleto', $funcionario->nomeCompleto) }}" required maxlength="255" placeholder="Nome completo do funcionário">
                                            @error('nomeCompleto')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="numeroDocumento" class="form-label">Número do Documento <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('numeroDocumento') is-invalid @enderror" id="numeroDocumento" name="numeroDocumento" value="{{ old('numeroDocumento', $funcionario->numeroDocumento) }}" required maxlength="50" placeholder="Número do BI/Passaporte">
                                            @error('numeroDocumento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="tipoDocumento" class="form-label">Tipo de Documento <span class="text-danger">*</span></label>
                                            <select class="form-select @error('tipoDocumento') is-invalid @enderror" id="tipoDocumento" name="tipoDocumento" required>
                                                <option value="">Selecione o tipo</option>
                                                <option value="BI" {{ old('tipoDocumento', $funcionario->tipoDocumento) == 'BI' ? 'selected' : '' }}>Bilhete de Identidade</option>
                                                <option value="Passaporte" {{ old('tipoDocumento', $funcionario->tipoDocumento) == 'Passaporte' ? 'selected' : '' }}>Passaporte</option>
                                                <option value="Carta de Condução" {{ old('tipoDocumento', $funcionario->tipoDocumento) == 'Carta de Condução' ? 'selected' : '' }}>Carta de Condução</option>
                                            </select>
                                            @error('tipoDocumento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="numeroColaborador" class="form-label">Número do Colaborador</label>
                                            <input type="text" class="form-control @error('numeroColaborador') is-invalid @enderror" id="numeroColaborador" name="numeroColaborador" value="{{ old('numeroColaborador', $funcionario->numeroColaborador) }}" maxlength="50" placeholder="Número interno do colaborador">
                                            @error('numeroColaborador')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="telefone" class="form-label">Telefone <span class="text-danger">*</span></label>
                                            <input type="tel" class="form-control @error('telefone') is-invalid @enderror" id="telefone" name="telefone" value="{{ old('telefone', $funcionario->telefone) }}" required maxlength="20" placeholder="+244 XXX XXX XXX">
                                            @error('telefone')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $funcionario->email) }}" required maxlength="255" placeholder="email@exemplo.com">
                                            @error('email')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="mb-3">
                                            <label for="id_departamento" class="form-label">Departamento <span class="text-danger">*</span></label>
                                            <select class="form-select @error('id_departamento') is-invalid @enderror" id="id_departamento" name="id_departamento" required>
                                                <option value="">Selecione o departamento</option>
                                                @foreach($departamentos as $departamento)
                                                    <option value="{{ $departamento->id }}" {{ old('id_departamento', $funcionario->id_departamento) == $departamento->id ? 'selected' : '' }}>
                                                        {{ $departamento->nomeDepartamento }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('id_departamento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="mb-3">
                                            <label for="id_funcao" class="form-label">Função <span class="text-danger">*</span></label>
                                            <select class="form-select @error('id_funcao') is-invalid @enderror" id="id_funcao" name="id_funcao" required>
                                                <option value="">Selecione a função</option>
                                                @foreach($funcoes as $funcao)
                                                    <option value="{{ $funcao->id }}" {{ old('id_funcao', $funcionario->id_funcao) == $funcao->id ? 'selected' : '' }}>
                                                        {{ $funcao->nomeFuncao }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('id_funcao')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="mb-3">
                                            <label for="id_grupo_pessoal" class="form-label">Grupo Pessoal <span class="text-danger">*</span></label>
                                            <select class="form-select @error('id_grupo_pessoal') is-invalid @enderror" id="id_grupo_pessoal" name="id_grupo_pessoal" required>
                                                <option value="">Selecione o grupo</option>
                                                @foreach($grupoPessoais as $grupoPessoal)
                                                    <option value="{{ $grupoPessoal->id }}" {{ old('id_grupo_pessoal', $funcionario->id_grupo_pessoal) == $grupoPessoal->id ? 'selected' : '' }}>
                                                        {{ $grupoPessoal->nomeGrupo }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('id_grupo_pessoal')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="estado" class="form-label">Estado <span class="text-danger">*</span></label>
                                            <select class="form-select @error('estado') is-invalid @enderror" id="estado" name="estado" required>
                                                <option value="">Selecione o estado</option>
                                                <option value="Ativo" {{ old('estado', $funcionario->estado) == 'Ativo' ? 'selected' : '' }}>Ativo</option>
                                                <option value="Inativo" {{ old('estado', $funcionario->estado) == 'Inativo' ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                            @error('estado')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label class="form-label">Verificação do Documento</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="checkDocumento" name="checkDocumento" value="1" {{ old('checkDocumento', $funcionario->checkDocumento) == '1' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="checkDocumento">Documento Verificado</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label class="form-label">Verificação do Telefone</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="checkTelefone" name="checkTelefone" value="1" {{ old('checkTelefone', $funcionario->checkTelefone) == '1' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="checkTelefone">Telefone Verificado</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="{{ route('funcionarios.index') }}" class="btn btn-light"><i class="ri-arrow-left-line me-1"></i> Voltar</a>
                                            <button type="submit" class="btn btn-primary"><i class="ri-save-line me-1"></i> Atualizar Funcionário</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
