@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('departamentos.index') }}">Gestão de Departamentos</a></li>
                                <li class="breadcrumb-item active">Editar Departamento</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Mensagens do sistema -->
            @if (session('success'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Sucesso!",
                        text: "{{ session('success') }}",
                        icon: "success"
                    });
                });
            </script>
            @endif

            @if (session('error'))
            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    Swal.fire({
                        title: "Erro!",
                        text: "{{ session('error') }}",
                        icon: "error"
                    });
                });
            </script>
            @endif
            <!-- Fim Mensagens do sistema -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Editar Departamento</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <form action="{{ route('departamentos.update', $departamento->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="nomeDepartamento" class="form-label">Nome do Departamento <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nomeDepartamento') is-invalid @enderror" id="nomeDepartamento" name="nomeDepartamento" value="{{ old('nomeDepartamento', $departamento->nomeDepartamento) }}" required maxlength="255" placeholder="Ex: Recursos Humanos, TI, Financeiro">
                                            @error('nomeDepartamento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <div class="form-text">Informe o nome do departamento com até 255 caracteres.</div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="estado" class="form-label">Estado <span class="text-danger">*</span></label>
                                            <select class="form-select @error('estado') is-invalid @enderror" id="estado" name="estado" required>
                                                <option value="">Selecione o estado</option>
                                                <option value="Ativo" {{ old('estado', $departamento->estado) == 'Ativo' ? 'selected' : '' }}>Ativo</option>
                                                <option value="Inativo" {{ old('estado', $departamento->estado) == 'Inativo' ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                            @error('estado')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="ObservacaoDepartamento" class="form-label">Observação</label>
                                            <textarea class="form-control @error('ObservacaoDepartamento') is-invalid @enderror" id="ObservacaoDepartamento" name="ObservacaoDepartamento" rows="4" maxlength="1000" placeholder="Observações adicionais sobre o departamento (opcional)">{{ old('ObservacaoDepartamento', $departamento->ObservacaoDepartamento) }}</textarea>
                                            @error('ObservacaoDepartamento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <div class="form-text">Máximo de 1000 caracteres.</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="{{ route('departamentos.index') }}" class="btn btn-light"><i class="ri-arrow-left-line me-1"></i> Voltar</a>
                                            <button type="submit" class="btn btn-primary"><i class="ri-save-line me-1"></i> Atualizar Departamento</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
