@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('users.index') }}">Utilizadores</a></li>
                                <li class="breadcrumb-item active">Detalhes do Utilizador</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Detalhes do Utilizador</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-8">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th class="ps-0" scope="row">ID:</th>
                                                    <td class="text-muted">{{ $utilizador->id }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Nome:</th>
                                                    <td class="text-muted">{{ $utilizador->name }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Email:</th>
                                                    <td class="text-muted">{{ $utilizador->email }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Telefone:</th>
                                                    <td class="text-muted">{{ $utilizador->telefone }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Entidade:</th>
                                                    <td class="text-muted">{{ $utilizador->entidade->nome ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Tipo de Utilizador:</th>
                                                    <td>
                                                        @if($utilizador->admin == "1")
                                                        <span class="badge bg-primary">Administrador</span>
                                                        @else
                                                        <span class="badge bg-success">Promotor</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Conta Verificada:</th>
                                                    <td>
                                                        @if($utilizador->email_verified_at)
                                                        <span class="badge bg-success">Sim</span>
                                                        @else
                                                        <span class="badge bg-danger">Não</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Data de Cadastro:</th>
                                                    <td class="text-muted">{{ $utilizador->created_at->format('d/m/Y H:i') }}</td>
                                                </tr>
                                                <tr>
                                                    <th class="ps-0" scope="row">Última Atualização:</th>
                                                    <td class="text-muted">{{ $utilizador->updated_at->format('d/m/Y H:i') }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="text-center">
                                        <div class="profile-user position-relative d-inline-block mx-auto mb-4">
                                            <img src="{{ asset('assets/images/users/avatar-1.jpg') }}" class="rounded-circle avatar-xl img-thumbnail user-profile-image" alt="Foto de perfil do utilizador">
                                        </div>
                                        <h5 class="fs-16 mb-1">{{ $utilizador->name }}</h5>
                                        <p class="text-muted mb-0">
                                            @if($utilizador->admin == "1")
                                            Administrador
                                            @else
                                            Promotor
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div><!-- end row -->

                            <div class="d-flex justify-content-end gap-2 mt-4">
                                <a href="{{ route('users.index') }}" class="btn btn-light">Voltar</a>
                                <a href="{{ route('users.edit', $utilizador->id) }}" class="btn btn-success"><i class="ri-pencil-fill align-bottom me-1"></i> Editar</a>
                                <button type="button" class="btn btn-danger" onclick="confirmDelete({{ $utilizador->id }})"><i class="ri-delete-bin-fill align-bottom me-1"></i> Excluir</button>
                            </div>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <!-- Form para exclusão de usuário (será acionado via JavaScript) -->
    <form id="delete-form" method="POST" style="display: none;">
        @csrf
        @method('DELETE')
    </form>

    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: "Tem certeza?",
                text: "Esta ação não pode ser revertida!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Sim, excluir!",
                cancelButtonText: "Cancelar"
            }).then((result) => {
                if (result.isConfirmed) {
                    var form = document.getElementById('delete-form');
                    form.action = "{{ url('/usuarios') }}/" + id;
                    form.submit();
                }
            });
        }
    </script>

</div>
<!-- end main content-->

@endsection
