@extends('Layout.LayoutBaseAdmin')
@section('Conteudo')
<div class="main-content"><div class="page-content"><div class="container-fluid">
<div class="row"><div class="col-12"><div class="page-title-box">
<h4>Detalhes do Processamento - {{$processamento->periodoReferencia}}</h4>
<a href="{{route('processamento-salarios.index')}}" class="btn btn-secondary btn-sm">Voltar</a>
</div></div></div>

<div class="row mb-3">
<div class="col-md-3"><div class="card"><div class="card-body text-center">
<h6>Descrição</h6><p>{{$processamento->descricao}}</p></div></div></div>
<div class="col-md-2"><div class="card"><div class="card-body text-center">
<h6>Funcionários</h6><h4>{{$processamento->quantidadeFuncionarios()}}</h4></div></div></div>
<div class="col-md-2"><div class="card"><div class="card-body text-center">
<h6>Total</h6><h4>{{number_format($processamento->totalSalarios(),2,',','.')}} Kz</h4></div></div></div>
<div class="col-md-2"><div class="card"><div class="card-body text-center">
<h6>Status</h6><span class="badge bg-{{$processamento->status=='Concluído'?'success':'warning'}}">{{$processamento->status}}</span>
</div></div></div>
@php
$enviados = $processamento->salariosProcessados->where('status_envio_email', 'Enviado')->count();
$falhados = $processamento->salariosProcessados->where('status_envio_email', 'Falhou')->count();
$semEmail = $processamento->salariosProcessados->where('status_envio_email', 'Sem Email')->count();
@endphp
<div class="col-md-3"><div class="card border-success"><div class="card-body text-center">
<h6 class="text-success"><i class="ri-mail-check-line"></i> E-mails Enviados</h6>
<h4 class="text-success">{{$enviados}}</h4>
@if($falhados > 0)<small class="text-danger">{{$falhados}} falharam</small>@endif
@if($semEmail > 0)<small class="text-muted d-block">{{$semEmail}} sem e-mail</small>@endif
</div></div></div>
</div>

<div class="card"><div class="card-header d-flex justify-content-between align-items-center">
<h5 class="mb-0">Salários Processados</h5>
<div>
@php
$semEmailCadastrado = $processamento->salariosProcessados->filter(fn($s) => !$s->email_funcionario || $s->email_funcionario == '')->count();
$pendentes = $processamento->salariosProcessados->filter(fn($s) => 
    in_array($s->status_envio_email, ['Pendente', 'Falhou', 'Sem Email']) && 
    $s->email_funcionario && 
    filter_var($s->email_funcionario, FILTER_VALIDATE_EMAIL)
)->count();
@endphp
@if($semEmailCadastrado > 0)
<form method="POST" action="{{route('processamento-salarios.sincronizar-emails',$processamento->id)}}" id="formSincronizar" style="display:inline;">
@csrf
<button type="button" class="btn btn-info btn-sm me-2" title="Buscar e-mails dos funcionários no cadastro" onclick="confirmarSincronizacao({{$semEmailCadastrado}})">
<i class="ri-refresh-line me-1"></i>Sincronizar E-mails ({{$semEmailCadastrado}})</button>
</form>
@endif
@if($pendentes > 0)
<form method="POST" action="{{route('processamento-salarios.reenviar-todos-emails',$processamento->id)}}" id="formReenviarTodos" style="display:inline;">
@csrf
<button type="button" class="btn btn-primary btn-sm me-2" onclick="confirmarReenvioTodos({{$pendentes}})">
<i class="ri-mail-send-line me-1"></i>Reenviar Todos ({{$pendentes}})</button>
</form>
@endif
<a href="{{route('processamento-salarios.exportar-pdf-geral',$processamento->id)}}" class="btn btn-danger btn-sm">
<i class="ri-file-pdf-line me-1"></i>Exportar PDF Geral</a>
</div>
</div><div class="card-body"><div class="table-responsive"><table class="table table-hover table-sm">
<thead style="background-color:rgb(64,81,137);color:white;font-size:0.8rem">
<tr><th>NBI</th><th>Nome</th><th>Função</th><th>Salário Base</th><th>Subsídios</th><th>Abono Extra</th><th>Descontos</th><th>Total Líquido</th><th>Status E-mail</th><th>Ações</th></tr>
</thead><tbody style="font-size:0.8rem">
@foreach($processamento->salariosProcessados as $sal)
<tr><td>{{$sal->nbi}}</td><td>{{$sal->nomeTrabalhador}}</td><td>{{$sal->funcao}}</td>
<td class="text-end">{{number_format($sal->salarioBase,2,',','.')}}</td>
<td class="text-end">{{number_format($sal->subTransporte+$sal->subAlimentacao+$sal->subFerias+$sal->subOutros+$sal->abonoFamiliar,2,',','.')}}</td>
<td class="text-end text-success">{{$sal->acrescimoExtra > 0 ? '+'.number_format($sal->acrescimoExtra,2,',','.') : '-'}}</td>
<td class="text-end text-danger">{{number_format($sal->desconto,2,',','.')}}</td>
<td class="text-end fw-bold">{{number_format($sal->total,2,',','.')}}</td>
<td>
@if($sal->status_envio_email == 'Enviado')
<span class="badge bg-success" title="Enviado em {{$sal->data_envio_email ? $sal->data_envio_email->format('d/m/Y H:i') : ''}}"><i class="ri-mail-check-line"></i> Enviado</span>
@elseif($sal->status_envio_email == 'Falhou')
<span class="badge bg-danger" title="Erro: {{$sal->erro_envio_email}}"><i class="ri-mail-close-line"></i> Falhou</span>
@elseif($sal->status_envio_email == 'Sem Email')
<span class="badge bg-secondary" title="Funcionário sem e-mail cadastrado"><i class="ri-mail-line"></i> Sem E-mail</span>
@else
<span class="badge bg-warning" title="Aguardando envio"><i class="ri-time-line"></i> Pendente</span>
@endif
</td>
<td>
<a href="{{route('processamento-salarios.recibo-individual',[$processamento->id,$sal->id])}}" class="btn btn-sm btn-outline-danger" title="Baixar Recibo">
<i class="ri-file-pdf-line"></i></a>
@if(in_array($sal->status_envio_email, ['Pendente', 'Falhou', 'Sem Email']) && $sal->email_funcionario)
<form method="POST" action="{{route('processamento-salarios.reenviar-email',[$processamento->id,$sal->id])}}" id="formReenviar{{$sal->id}}" style="display:inline;">
@csrf
<button type="button" class="btn btn-sm btn-outline-primary" title="Reenviar E-mail" 
onclick="confirmarReenvioIndividual('{{$sal->nomeTrabalhador}}', '{{$sal->email_funcionario}}', {{$sal->id}})">
<i class="ri-mail-send-line"></i></button>
</form>
@endif
</td>
</tr>@endforeach
<tr style="background-color:#f8f9fa;font-weight:bold"><td colspan="7" class="text-end">TOTAL GERAL:</td>
<td class="text-end">{{number_format($processamento->totalSalarios(),2,',','.')}} Kz</td><td></td><td></td></tr>
</tbody></table></div></div></div>
</div></div></div>
@endsection

@section('scripts')
<script>
// Confirmar sincronização de e-mails
function confirmarSincronizacao(quantidade) {
    Swal.fire({
        title: '🔄 Sincronizar E-mails?',
        html: `
            <div style="text-align: left;">
                <p>Esta ação irá buscar os e-mails atualizados dos <strong>${quantidade} funcionário(s)</strong> no cadastro.</p>
                <ul style="margin-top: 15px;">
                    <li>Busca e-mail por NBI</li>
                    <li>Atualiza registros automaticamente</li>
                    <li>Marca como "Pendente" para envio</li>
                </ul>
            </div>
        `,
        icon: 'info',
        showCancelButton: true,
        confirmButtonColor: '#0dcaf0',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="ri-refresh-line me-1"></i>Sincronizar',
        cancelButtonText: 'Cancelar',
        width: '500px'
    }).then((result) => {
        if (result.isConfirmed) {
            document.getElementById('formSincronizar').submit();
        }
    });
}

// Confirmar reenvio em massa
function confirmarReenvioTodos(quantidade) {
    Swal.fire({
        title: '📧 Reenviar E-mails em Massa?',
        html: `
            <div style="text-align: left;">
                <p>Serão reenviados <strong>${quantidade} e-mail(s)</strong> com recibo em PDF anexado.</p>
                <div style="background: #fff3cd; padding: 10px; border-radius: 5px; margin-top: 15px;">
                    <strong style="color: #856404;">⚠️ Atenção:</strong>
                    <ul style="margin: 5px 0 0 20px; color: #856404;">
                        <li>Status: Pendente, Falhou ou Sem E-mail</li>
                        <li>Apenas funcionários com e-mail válido</li>
                    </ul>
                </div>
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="ri-mail-send-line me-1"></i>Reenviar Todos',
        cancelButtonText: 'Cancelar',
        width: '550px'
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar loading
            Swal.fire({
                title: 'Reenviando E-mails...',
                html: 'Por favor, aguarde. Este processo pode levar alguns segundos.',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            document.getElementById('formReenviarTodos').submit();
        }
    });
}

// Confirmar reenvio individual
function confirmarReenvioIndividual(nome, email, id) {
    Swal.fire({
        title: '📧 Reenviar Recibo?',
        html: `
            <div style="text-align: left;">
                <p>Reenviar recibo de salário para:</p>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 15px 0;">
                    <p style="margin: 5px 0;"><strong>Funcionário:</strong> ${nome}</p>
                    <p style="margin: 5px 0;"><strong>E-mail:</strong> <span style="color: #0d6efd;">${email}</span></p>
                </div>
                <p style="font-size: 0.9em; color: #6c757d;">
                    <i class="ri-attachment-line"></i> O recibo em PDF será anexado automaticamente.
                </p>
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="ri-mail-send-line me-1"></i>Reenviar',
        cancelButtonText: 'Cancelar',
        width: '500px'
    }).then((result) => {
        if (result.isConfirmed) {
            document.getElementById('formReenviar' + id).submit();
        }
    });
}
</script>
@endsection
