@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('funcoes.index') }}">Gestão de Funções</a></li>
                                <li class="breadcrumb-item active">Detalhes da Função</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Detalhes da Função</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">ID:</label>
                                        <p class="form-control-plaintext">{{ $funcao->id }}</p>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Nome da Função:</label>
                                        <p class="form-control-plaintext">{{ $funcao->nomeFuncao }}</p>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Estado:</label>
                                        <p class="form-control-plaintext">
                                            @if($funcao->estado == 'Ativo')
                                                <span class="badge bg-success">Ativo</span>
                                            @else
                                                <span class="badge bg-danger">Inativo</span>
                                            @endif
                                        </p>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Data de Criação:</label>
                                        <p class="form-control-plaintext">{{ $funcao->created_at->format('d/m/Y H:i') }}</p>
                                    </div>
                                </div>
                            </div>

                            @if($funcao->ObservacaoFuncao)
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Observações:</label>
                                        <p class="form-control-plaintext">{{ $funcao->ObservacaoFuncao }}</p>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="d-flex justify-content-between">
                                        <a href="{{ route('funcoes.index') }}" class="btn btn-light"><i class="ri-arrow-left-line me-1"></i> Voltar</a>
                                        <div>
                                            <a href="{{ route('funcoes.edit', $funcao->id) }}" class="btn btn-primary me-2"><i class="ri-pencil-line me-1"></i> Editar</a>
                                            <a href="{{ route('funcoes.toggleStatus', $funcao->id) }}" class="btn btn-warning">
                                                @if($funcao->estado == 'Ativo')
                                                    <i class="ri-lock-fill me-1"></i> Desativar
                                                @else
                                                    <i class="ri-lock-unlock-fill me-1"></i> Ativar
                                                @endif
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
