@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('users.index') }}">Utilizadores</a></li>
                                <li class="breadcrumb-item active">Novo Utilizador</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Adicionar Novo Utilizador</h4>
                        </div><!-- end card header -->

                        <div class="card-body">

                            @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                            @endif

                            <form action="{{ route('users.store') }}" method="POST">
                                @csrf
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="nome" class="form-label">Nome Completo <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="nome" name="nome" value="{{ old('nome') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="tel" class="form-label">Telefone <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="tel" name="tel" value="{{ old('tel') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="id_entidade" class="form-label">Entidade <span class="text-danger">*</span></label>
                                            <select class="form-select" id="id_entidade" name="id_entidade" required>
                                                <option value="">Selecione uma entidade</option>
                                                @foreach($entidades as $entidade)
                                                <option value="{{ $entidade->id }}" {{ old('id_entidade') == $entidade->id ? 'selected' : '' }}>
                                                    {{ $entidade->nomeRegistro }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="tipo" class="form-label">Tipo de Utilizador <span class="text-danger">*</span></label>
                                            <select class="form-select" id="tipo" name="tipo" required>
                                                <option value="" selected>Selecione o tipo de utilizador</option>
                                                <option value="1" {{ old('tipo') == '1' ? 'selected' : '' }}>Gestor</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="alert alert-info">
                                            <i class="ri-information-line me-2"></i>
                                            Uma senha temporária será gerada automaticamente e enviada para o email do utilizador.
                                        </div>
                                    </div>

                                    <div class="col-12 mt-4">
                                        <div class="d-flex justify-content-end gap-2">
                                            <a href="{{ route('users.index') }}" class="btn btn-light">Cancelar</a>
                                            <button type="submit" class="btn btn-primary">Cadastrar Utilizador</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
