@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SIGEPIE - FUNEA (SISTEMA DE GESTÃO DE PROJECTOS/INICIATIVAS DE EMPREGO)</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Página Principal</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('departamentos.index') }}">Gestão de Departamentos</a></li>
                                <li class="breadcrumb-item active">Criar Departamento</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Criar Novo Departamento</h4>
                        </div><!-- end card header -->

                        <div class="card-body">
                            <form action="{{ route('departamentos.store') }}" method="POST">
                                @csrf

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="nomeDepartamento" class="form-label">Nome do Departamento <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nomeDepartamento') is-invalid @enderror" id="nomeDepartamento" name="nomeDepartamento" value="{{ old('nomeDepartamento') }}" required maxlength="255" placeholder="Nome do departamento">
                                            @error('nomeDepartamento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="ObservacaoDepartamento" class="form-label">Observações</label>
                                            <textarea class="form-control @error('ObservacaoDepartamento') is-invalid @enderror" id="ObservacaoDepartamento" name="ObservacaoDepartamento" rows="3" maxlength="1000" placeholder="Observações sobre o departamento">{{ old('ObservacaoDepartamento') }}</textarea>
                                            @error('ObservacaoDepartamento')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <div class="form-text">Máximo 1000 caracteres</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="{{ route('departamentos.index') }}" class="btn btn-light"><i class="ri-arrow-left-line me-1"></i> Voltar</a>
                                            <button type="submit" class="btn btn-success"><i class="ri-save-line me-1"></i> Criar Departamento</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>
<!-- end main content-->

@endsection
