@extends('Layout.LayoutBaseAdmin')

@section('Conteudo')
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Título da página -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">
                            <i class="ri-file-text-line label-icon align-middle fs-16 ms-2"></i> 
                            DETALHES DO PROJECTO
                        </h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('admin.projetos.index') }}">Gestão de Projectos</a></li>
                                <li class="breadcrumb-item active">Detalhes</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informações do Status e Ações -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex flex-wrap align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                        <span class="badge bg-{{ $projeto->status_cor }} fs-6 px-3 py-2">
                                            {{ $projeto->status_formatado }}
                                        </span>
                                    </div>
                                    <div>
                                        <h5 class="mb-1">{{ $projeto->nomeProjecto }}</h5>
                                        <p class="text-muted mb-0">Código: {{ $projeto->codProjecto }}</p>
                                    </div>
                                </div>
                                <div class="d-flex gap-2 flex-wrap">
                                    @if($projeto->status == 4)
                                        <a href="{{ route('admin.projetos.pagamentos', $projeto->id) }}" class="btn btn-success">
                                            <i class="ri-money-dollar-circle-line me-1"></i>
                                            Pagamentos
                                        </a>
                                    @endif
                                    @if($projeto->podeAlterarStatus(Auth::id()) && count($projeto->proximosStatusValidos()) > 0)
                                        <div class="dropdown">
                                            <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                <i class="ri-settings-3-line me-1"></i>
                                                Alterar Status
                                            </button>
                                            <ul class="dropdown-menu">
                                                @foreach($projeto->proximosStatusValidos() as $status)
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:void(0)" 
                                                           onclick="alterarStatus({{ $projeto->id }}, {{ $status }})">
                                                            <span class="badge bg-{{ ['', 'info', 'success', 'danger', 'primary', 'success'][$status] }} me-2">
                                                                {{ ['', 'Em Análise', 'Aprovar', 'Rejeitar', 'Em Execução', 'Concluir'][$status] }}
                                                            </span>
                                                        </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                    <a href="{{ route('admin.projetos.index') }}" class="btn btn-secondary">
                                        <i class="ri-arrow-left-line me-1"></i>
                                        Voltar à Lista
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Informações Básicas -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-information-line me-2"></i>Informações do Projecto
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Nome do Projecto:</label>
                                    <p class="text-muted">{{ $projeto->nomeProjecto }}</p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Código do Projecto:</label>
                                    <p class="text-muted">{{ $projeto->codProjecto }}</p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Tipo de Projecto:</label>
                                    <p class="text-muted">{{ $projeto->tipoProjecto->descricao ?? 'N/A' }}</p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Custo Total do Projecto:</label>
                                    <p class="text-muted fw-bold text-primary">{{ $projeto->limite_orcamental_formatado }}</p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Duração:</label>
                                    <p class="text-muted">
                                        @if($projeto->duracaoP && $projeto->duracaoF)
                                            {{ \Carbon\Carbon::parse($projeto->duracaoP)->format('d/m/Y') }} até 
                                            {{ \Carbon\Carbon::parse($projeto->duracaoF)->format('d/m/Y') }}
                                        @else
                                            Não informado
                                        @endif
                                    </p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Beneficiários:</label>
                                    <p class="text-muted">{{ number_format($projeto->beneficiarioDP ?? 0) }} pessoas</p>
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label fw-semibold">Descrição/Objetivo:</label>
                                    <div class="bg-light p-3 rounded">
                                        <p class="mb-0">{!! $projeto->descricaoObjectivo ?? 'Não informado' !!}</p>
                                    </div>
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label fw-semibold">Justificação:</label>
                                    <div class="bg-light p-3 rounded">
                                        <p class="mb-0">{{ $projeto->justificacao ?? 'Não informado' }}</p>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Localização:</label>
                                    <p class="text-muted">{{ $projeto->localizacao_projecto ?? 'Não informado' }}</p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Financiador:</label>
                                    <p class="text-muted">{{ $projeto->financeador ?? 'Não informado' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Cronograma Físico -->
                    @if($projeto->cronogramasFisicos->count() > 0)
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-calendar-line me-2"></i>Cronograma Físico
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Ano</th>
                                            <th>Actividade</th>
                                            <th>%</th>
                                            <th>Período</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($projeto->cronogramasFisicos as $cronograma)
                                        <tr>
                                            <td style="width: 5%; text-align: justify">{{ $cronograma->ano }}</td>
                                            <td style="width: 45%; text-align: justify">{{ $cronograma->descricao }}</td>
                                            <td style="width: 20%" class="fw-semibold">{{ $cronograma->percentual.'%' }}</td>
                                            <td style="width: 30%; text-align: justify">{{ $cronograma->data_inicio.' à '.$cronograma->data_fim }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Programação Financeira -->
                    @if($projeto->programacoesFinanceiras->count() > 0)
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-money-dollar-circle-line me-2"></i>Programação Financeira
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Ano</th>
                                            <th>Despesa</th>
                                            <th>Valor (AOA)</th>
                                            <th>Período</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php $totalProgramacao = 0; @endphp
                                        @foreach($projeto->programacoesFinanceiras as $programacao)
                                        <tr>
                                            <td style="width: 5%; text-align: justify">{{ $programacao->ano }}</td>
                                            <td style="width: 45%; text-align: justify">{{ $programacao->descricao }}</td>
                                            <td style="width: 20%" class="fw-semibold">{{ 'AOA ' . number_format($programacao->valor, 2, ',', '.') }}</td>
                                            <td style="width: 30%; text-align: justify">{{ $programacao->data_inicial.' à '.$programacao->data_final }}</td>
                                        </tr>
                                        @php $totalProgramacao += $programacao->valor; @endphp
                                        @endforeach
                                    </tbody>
                                    <tfoot class="table-light">
                                        <tr>
                                            <th></th>
                                            <th></th>
                                            <th>Total</th>
                                            <th class="text-primary">{{ 'AOA ' . number_format($totalProgramacao, 2, ',', '.') }}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Seção de Anexos do Projeto -->
                    @php
                        // Array com todos os campos de anexos do projeto
                        $attachments = [
                            ['field' => 'Url_contratoP', 'icon' => 'ri-file-text-line', 'color' => 'primary', 'title' => 'Contrato do Projeto'],
                            ['field' => 'ambito', 'icon' => 'ri-file-list-3-line', 'color' => 'info', 'title' => 'Âmbito do Projeto'],
                            ['field' => 'impactoSocial', 'icon' => 'ri-user-heart-line', 'color' => 'success', 'title' => 'Estudo de Impacto Social'],
                            ['field' => 'tecnicoEngenharia', 'icon' => 'ri-tools-line', 'color' => 'warning', 'title' => 'Parecer Técnico de Engenharia'],
                            ['field' => 'analiseEfectividade', 'icon' => 'ri-bar-chart-box-line', 'color' => 'secondary', 'title' => 'Análise de Efetividade'],
                            ['field' => 'viabilidadeEconomica', 'icon' => 'ri-money-dollar-circle-line', 'color' => 'primary', 'title' => 'Estudo de Viabilidade Econômica'],
                            ['field' => 'impactoAmbiental', 'icon' => 'ri-leaf-line', 'color' => 'success', 'title' => 'Estudo de Impacto Ambiental'],
                            ['field' => 'mitigacaoImpactos', 'icon' => 'ri-shield-check-line', 'color' => 'info', 'title' => 'Plano de Mitigação de Impactos']
                        ];
                        
                        // Filtrar apenas anexos que existem
                        $validAttachments = collect($attachments)->filter(function($att) use ($projeto) {
                            return !empty($projeto->{$att['field']});
                        });
                    @endphp
                    
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-attachment-2 me-2"></i>Anexos do Projeto
                                @if($validAttachments->count() > 0)
                                    <span class="badge bg-primary ms-2">{{ $validAttachments->count() }}</span>
                                @endif
                            </h5>
                        </div>
                        <div class="card-body">
                            @if($validAttachments->count() > 0)
                                <div class="row">
                                    @foreach($validAttachments as $attachment)
                                        <div class="col-lg-12 col-md-6 mb-3">
                                            <div class="border rounded p-3 h-100">
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <div class="avatar-sm rounded-circle bg-{{ $attachment['color'] }}-subtle d-flex align-items-center justify-content-center">
                                                            <i class="{{ $attachment['icon'] }} text-{{ $attachment['color'] }}"></i>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h6 class="mb-1">{{ $attachment['title'] }}</h6>
                                                        <p class="text-muted mb-2 small">{{ Str::limit($projeto->{$attachment['field']}, 60) }}</p>
                                                        
                                                        @if(filter_var($projeto->{$attachment['field']}, FILTER_VALIDATE_URL))
                                                            <!-- Se for URL -->
                                                            <a href="{{ $projeto->{$attachment['field']} }}" target="_blank" class="btn btn-outline-{{ $attachment['color'] }} btn-sm">
                                                                <i class="ri-external-link-line me-1"></i>Abrir Anexo
                                                            </a>
                                                        @else
                                                            <!-- Se for arquivo local -->
                                                            <a href="{{ asset($projeto->{$attachment['field']}) }}" download class="btn btn-outline-{{ $attachment['color'] }} btn-sm">
                                                                <i class="ri-download-line me-1"></i>Baixar Arquivo
                                                            </a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="ri-attachment-line display-6 text-muted"></i>
                                    <p class="text-muted mb-0 mt-2">Nenhum anexo disponível para este projeto.</p>
                                </div>
                            @endif
                        </div>
                    </div>

                </div>

                <!-- Sidebar com informações administrativas -->
                <div class="col-lg-4">
                    <!-- Status e Responsáveis -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-user-settings-line me-2"></i>Informações Administrativas
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Status Actual:</label>
                                <div>
                                    <span class="badge bg-{{ $projeto->status_cor }} fs-6">
                                        {{ $projeto->status_formatado }}
                                    </span>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Entidade Promotora:</label>
                                <p class="text-muted mb-0">{{ $projeto->tecnicoProjecto->name ?? 'Não atribuído' }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Gestor (FUNEA) Responsável:</label>
                                <p class="text-muted mb-0">
                                    @if($projeto->status == 0)
                                        <span class="text-warning"><i class="ri-user-add-line me-1"></i>A atribuir</span>
                                        <small class="d-block text-muted mt-1">Será atribuído quando alterar o status</small>
                                    @else
                                        {{ $projeto->adminResponsavel->name ?? 'N/A' }}
                                        @if($projeto->admin_responsavel_id == Auth::id())
                                            <span class="badge bg-success ms-2">Você</span>
                                        @endif
                                    @endif
                                </p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Data de Submissão:</label>
                                <p class="text-muted mb-0">{{ $projeto->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                            @if($projeto->data_mudanca_status)
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Última Alteração:</label>
                                <p class="text-muted mb-0">{{ $projeto->data_mudanca_status }}</p>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Histórico de Status (Placeholder para futura implementação) -->
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-history-line me-2"></i>Próximas Ações
                            </h5>
                        </div>
                        <div class="card-body">
                            @if(count($projeto->proximosStatusValidos()) > 0)
                                <p class="text-muted mb-3">Ações disponíveis para este projeto:</p>
                                @foreach($projeto->proximosStatusValidos() as $status)
                                    <div class="d-grid gap-2 mb-2">
                                        <button class="btn btn-outline-{{ ['', 'info', 'success', 'danger', 'primary', 'success'][$status] }} btn-sm" 
                                                onclick="alterarStatus({{ $projeto->id }}, {{ $status }})">
                                            {{ ['', 'Mover para Em Análise', 'Aprovar Projeto', 'Rejeitar Projeto', 'Iniciar Execução', 'Marcar como Concluído'][$status] }}
                                        </button>
                                    </div>
                                @endforeach
                            @else
                                <div class="text-center py-3">
                                    <i class="ri-check-double-line display-6 text-success"></i>
                                    <p class="text-muted mb-0 mt-2">Nenhuma ação disponível no momento</p>
                                </div>
                            @endif
                            
                            <!-- Botões de Exportação -->
                            <hr class="my-3">
                            <div class="d-grid gap-2">
                                <!-- Dropdown PDF -->
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-outline-danger dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ri-file-pdf-line me-1"></i>PDF
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.projetos.visualizar-pdf', $projeto->id) }}" target="_blank">
                                                <i class="ri-eye-line me-2"></i>Visualizar PDF
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.projetos.exportar-pdf', $projeto->id) }}">
                                                <i class="ri-download-line me-2"></i>Baixar PDF
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                
                                <!-- Botão Excel -->
                                <a href="{{ route('admin.projetos.exportar-excel', $projeto->id) }}" class="btn btn-success btn-sm">
                                    <i class="ri-file-excel-2-line me-1"></i>Exportar para Excel
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Indicadores -->
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-bar-chart-line me-2"></i>Indicadores
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="p-2 bg-primary bg-gradient rounded text-white">
                                        <h4 class="mb-1" style="color: white;">{{ number_format($projeto->empregosDirectos ?? 0) }}</h4>
                                        <p class="mb-0 fs-13">Empregos Diretos</p>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="p-2 bg-success bg-gradient rounded text-white">
                                        <h4 class="mb-1" style="color: white;">{{ number_format($projeto->kitsDistribuidos ?? 0) }}</h4>
                                        <p class="mb-0 fs-13">Kits Distribuídos</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                  

                    <!-- Informações Bancarias -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="ri-bank-line me-2"></i>Informações Bancarias
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Banco:</label>
                                <div>
                                    <span class="badge bg-{{ $projeto->status_cor }} fs-6">
                                        {{ $projeto->nomeInst }}
                                    </span>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Endereço da Agência:</label>
                                <p class="text-muted mb-0">{{ $projeto->enderecoAgencia }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Contacto da Agência:</label>
                                <p class="text-muted mb-0">{{ $projeto->contactoAgencia }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Numero de Conta:</label>
                                <p class="text-muted mb-0">{{ $projeto->numeroConta ?? 'N/A' }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">IBAN</label>
                                <p class="text-muted mb-0">{{ $projeto->iban ?? 'N/A' }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">SWIFT</label>
                                <p class="text-muted mb-0">{{ $projeto->swif ?? 'N/A' }}</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-semibold">1º Assinante</label>
                                <p class="text-muted mb-0">{{ $projeto->assinante1 ?? 'N/A' }}</p>
                            </div> 
                            <div class="mb-3">
                                <label class="form-label fw-semibold">2º Assinante</label>
                                <p class="text-muted mb-0">{{ $projeto->assinante2 ?? 'N/A' }}</p>
                            </div> 
                            <div class="mb-3">
                                <label class="form-label fw-semibold">3º Assinante</label>
                                <p class="text-muted mb-0">{{ $projeto->assinante3 ?? 'N/A' }}</p>
                            </div> 
                            <div class="mb-3">
                                <label class="form-label fw-semibold">4º Assinante</label>
                                <p class="text-muted mb-0">{{ $projeto->assinante4 ?? 'N/A' }}</p>
                            </div>    
                                                       
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Alteração de Status -->
<div class="modal fade" id="modalStatus" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="ri-settings-3-line me-2"></i>
                    Alterar Status do Projeto
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formStatus">
                    <input type="hidden" id="projetoId" value="{{ $projeto->id }}">
                    <input type="hidden" id="novoStatus">
                    
                    <div class="alert alert-info">
                        <i class="ri-information-line me-2"></i>
                        <span id="mensagemStatus"></span>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observações (Opcional)</label>
                        <textarea class="form-control" id="observacoes" name="observacoes" 
                                  rows="3" placeholder="Adicione observações sobre esta alteração..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarAlteracaoStatus()">
                    <i class="ri-check-line me-1"></i>
                    Confirmar Alteração
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// Função para alterar status
function alterarStatus(projetoId, novoStatus) {
    const statusNomes = {
        1: 'Em Análise',
        2: 'Aprovado',
        3: 'Rejeitado',
        4: 'Em Execução',
        5: 'Concluído'
    };
    
    document.getElementById('novoStatus').value = novoStatus;
    document.getElementById('mensagemStatus').textContent = 
        `Tem certeza que deseja alterar o status para "${statusNomes[novoStatus]}"?`;
    
    const modal = new bootstrap.Modal(document.getElementById('modalStatus'));
    modal.show();
}

// Função para confirmar alteração de status
function confirmarAlteracaoStatus() {
    const projetoId = document.getElementById('projetoId').value;
    const novoStatus = document.getElementById('novoStatus').value;
    const observacoes = document.getElementById('observacoes').value;
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '{{ csrf_token() }}';
    
    // Desabilitar botão
    const btnConfirmar = event.target;
    btnConfirmar.disabled = true;
    btnConfirmar.innerHTML = '<i class="ri-loader-4-line me-1"></i>Processando...';
    
    fetch(`/admin/projetos/${projetoId}/status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        },
        body: JSON.stringify({
            novo_status: novoStatus,
            observacoes: observacoes
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: 'Sucesso!',
                text: data.message,
                icon: 'success',
                timer: 2000
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                title: 'Erro!',
                text: data.message,
                icon: 'error'
            });
        }
    })
    .catch(error => {
        Swal.fire({
            title: 'Erro!',
            text: 'Erro na comunicação com o servidor. Tente novamente.',
            icon: 'error'
        });
    })
    .finally(() => {
        bootstrap.Modal.getInstance(document.getElementById('modalStatus')).hide();
        btnConfirmar.disabled = false;
        btnConfirmar.innerHTML = '<i class="ri-check-line me-1"></i>Confirmar Alteração';
    });
}
</script>
@endsection
