# Sistema de Gestão de Projectos de Emprego (SIGEPE) - Manual do Utilizador

## Índice

1. [Introdução](#introdução)
2. [Acesso ao Sistema](#acesso-ao-sistema)
3. [Dashboard Principal](#dashboard-principal)
4. [Gestão de Projetos - Técnicos](#gestão-de-projetos---técnicos)
5. [Área Administrativa](#área-administrativa)
6. [Exportação de Relatórios](#exportação-de-relatórios)
7. [Funcionalidades Avançadas](#funcionalidades-avançadas)
8. [Perguntas Frequentes](#perguntas-frequentes)
9. [Resolução de Problemas](#resolução-de-problemas)

---

## 1. Introdução

### O que é o Sistema de Gestão Financeira?
O Sistema de Gestão Financeira é uma plataforma web desenvolvida para facilitar o controle e acompanhamento de projetos desde a submissão até a conclusão. O sistema permite a gestão completa do ciclo de vida dos projetos com aprovações, análises técnicas e controle financeiro.

### Perfis de Utilizador
- **Técnico/Cliente**: Cria e gere os seus próprios projetos
- **Administrador**: Analisa, aprova/rejeita projetos e gere todo o sistema

### Funcionalidades Principais
- ✅ Criação e submissão de projetos
- ✅ Acompanhamento do status dos projetos
- ✅ Upload de documentos anexos
- ✅ Exportação de relatórios em PDF e Excel
- ✅ Dashboard com métricas e indicadores
- ✅ Sistema de notificações

---

## 2. Acesso ao Sistema

### 2.1 Como Fazer Login

1. **Aceder à página inicial** do sistema
2. **Inserir as suas credenciais:**
   - Email ou nome de utilizador
   - Palavra-passe
3. **Clicar em "Entrar"**

> **💡 Dica:** Se esqueceu a palavra-passe, contacte o administrador do sistema.

### 2.2 Primeira Utilização
Após o primeiro login:
1. Verifique se os seus dados estão corretos
2. Familiarize-se com o menu principal
3. Explore o dashboard para compreender as funcionalidades disponíveis

---

## 3. Dashboard Principal

### 3.1 Visão Geral do Dashboard

O dashboard apresenta informações importantes sobre:
- **Resumo dos seus projetos** (para técnicos)
- **Métricas gerais do sistema** (para administradores)
- **Notificações** e alertas importantes
- **Ações rápidas** mais utilizadas

### 3.2 Navegação Principal

**Menu Superior:**
- 🏠 **Dashboard** - Página principal
- 📋 **Projetos** - Gestão de projetos
- 📊 **Relatórios** - Exportações e análises
- ⚙️ **Administração** - (Apenas para administradores)
- 👤 **Perfil** - Dados pessoais e configurações

---

## 4. Gestão de Projetos - Técnicos

### 4.1 Criar Novo Projeto

**Passo 1: Aceder ao formulário**
1. No menu principal, clique em **"Projetos"**
2. Selecione **"Criar Novo Projeto"**

**Passo 2: Preencher informações básicas**
- **Nome do Projeto**: Título claro e descritivo
- **Código do Projeto**: Código único (gerado automaticamente)
- **Tipo de Projeto**: Selecione da lista disponível
- **Descrição/Objetivo**: Detalhe os objetivos do projeto

**Passo 3: Informações financeiras**
- **Limite Orçamental**: Valor total do projeto em Kwanzas
- **Duração Prevista**: Tempo estimado em meses
- **Financiador**: Entidade que irá financiar

**Passo 4: Cronograma físico**
Adicione as atividades principais:
- **Atividade**: Descrição da tarefa
- **Data de Início**: Quando a atividade começará
- **Data de Fim**: Prazo de conclusão
- **Responsável**: Quem executará a atividade

**Passo 5: Programação financeira**
Defina os custos por categoria:
- **Categoria**: Tipo de despesa
- **Valor**: Montante em Kwanzas
- **Período**: Quando será gasto

**Passo 6: Anexos de documentos**
Faça upload dos documentos necessários:
- 📄 **Contrato do Projeto**
- 📋 **Âmbito do Projeto**
- 📊 **Estudo de Impacto Social**
- 🔧 **Parecer Técnico de Engenharia**
- 📈 **Análise de Efetividade**
- 💰 **Estudo de Viabilidade Econômica**
- 🌍 **Estudo de Impacto Ambiental**
- ⚠️ **Plano de Mitigação de Impactos**

**Passo 7: Revisão e submissão**
1. Revise todas as informações inseridas
2. Clique em **"Salvar Projeto"**
3. Confirme a submissão

> **⚠️ Importante:** Após a submissão, o projeto ficará com status "Recebido" e será encaminhado para análise administrativa.

### 4.2 Acompanhar Projetos Existentes

**Ver lista de projetos:**
1. Aceda ao menu **"Projetos"**
2. Selecione **"Meus Projetos"**

**Informações disponíveis:**
- **Status atual** do projeto
- **Data de submissão**
- **Última atualização**
- **Valor do projeto**
- **Ações disponíveis**

**Status possíveis:**
- 🟡 **Recebido** - Aguarda análise
- 🔵 **Em Análise** - Sendo avaliado pelo administrador  
- 🟢 **Aprovado** - Projeto foi aprovado
- 🔴 **Rejeitado** - Projeto não foi aprovado
- 🟣 **Em Execução** - Projeto está a ser executado
- ⚫ **Concluído** - Projeto finalizado

### 4.3 Editar Projetos

**Quando posso editar:**
- Apenas projetos com status "Recebido" podem ser editados
- Após análise inicial, edições requerem aprovação administrativa

**Como editar:**
1. Na lista de projetos, clique no ícone ✏️ **"Editar"**
2. Faça as alterações necessárias
3. Clique em **"Atualizar Projeto"**

### 4.4 Visualizar Detalhes

**Para ver informações completas:**
1. Clique no nome do projeto ou no ícone 👁️ **"Visualizar"**
2. Será apresentada uma página com:
   - Todas as informações do projeto
   - Cronograma físico detalhado
   - Programação financeira
   - Documentos anexos
   - Histórico de alterações

---

## 5. Área Administrativa

> **📋 Nota:** Esta seção aplica-se apenas a utilizadores com perfil de Administrador.

### 5.1 Carteira de Projetos

**Aceder à gestão:**
1. Menu **"Administração"**
2. Selecione **"Carteira de Projetos"**

**Funcionalidades disponíveis:**
- **Visualizar todos os projetos** do sistema
- **Filtrar por status**, tipo, data, instituição
- **Alterar status** dos projetos
- **Visualizar detalhes** completos
- **Exportar relatórios**

### 5.2 Organização por Instituição

Os projetos são agrupados por instituição/técnico responsável, mostrando:
- **Nome da instituição**
- **Número de projetos**
- **Valor total dos projetos**
- **Distribuição por status**

### 5.3 Filtros Inteligentes

**Cards de Status Clicáveis:**
- 📧 **Recebidos** - Projetos aguardando análise
- 🔍 **Em Análise** - Projetos sendo avaliados
- ✅ **Aprovados** - Projetos aprovados
- ❌ **Rejeitados** - Projetos não aprovados  
- ⚡ **Em Execução** - Projetos em andamento
- 🏆 **Concluídos** - Projetos finalizados

**Filtros Avançados:**
- **Por tipo de projeto**
- **Por período** (data de submissão)
- **Por palavra-chave** (nome, código, descrição)

### 5.4 Alterar Status de Projetos

**Regras importantes:**
- Status "Recebido": Qualquer administrador pode alterar
- Outros status: Apenas o administrador responsável pode alterar

**Como alterar status:**
1. Clique no botão **"Alterar Status"** do projeto
2. Selecione o novo status
3. Adicione observações (opcional)
4. Confirme a alteração

**Fluxo de status:**
```
Recebido → Em Análise → Aprovado/Rejeitado
                    ↓
              Em Execução → Concluído
```

### 5.5 Dashboard Administrativo

**Métricas e Indicadores:**
- **Total de projetos** recebidos no mês
- **Taxa de aprovação** dos projetos
- **Projetos em execução**
- **Cumprimento de prazos** (30 dias para financiamento, 15 dias para pareceres)
- **Valores totais** por status

---

## 6. Exportação de Relatórios

### 6.1 Relatórios Individuais (Por Projeto)

**Formatos disponíveis:**
- 📄 **PDF** - Para visualização e impressão
- 📊 **Excel** - Para análise de dados

**Como exportar:**
1. Na página de detalhes do projeto
2. Clique no dropdown **"PDF"** ou **"Excel"**
3. Escolha **"Visualizar"** (PDF) ou **"Baixar"** (download direto)

**Conteúdo do relatório individual:**
- Informações básicas do projeto
- Cronograma físico completo
- Programação financeira detalhada
- Lista de anexos e documentos

### 6.2 Relatórios Gerais (Listagem)

> **📋 Disponível apenas para administradores**

**Como exportar listagem geral:**
1. Na página **"Carteira de Projetos"**
2. Aplique os filtros desejados (opcional)
3. Clique em **"PDF"** ou **"Excel"**

**Relatório PDF da listagem inclui:**
- Resumo geral com estatísticas
- Projetos agrupados por instituição  
- Badges coloridos por status
- Totais financeiros

**Relatório Excel da listagem inclui:**
- Código, nome, tipo de cada projeto
- Instituição responsável
- Status atual
- Valor do projeto
- Data de submissão

### 6.3 Relatórios de Desembolso

**Tipos disponíveis:**
- **Relatório Geral** - Todos os desembolsos
- **Por Instituição** - Filtrado por entidade

**Informações incluídas:**
- Projetos em execução
- Valores programados vs. executados
- Cronograma de desembolsos
- Análise de performance

---

## 7. Funcionalidades Avançadas

### 7.1 Pesquisa Inteligente

**Como pesquisar:**
1. Use a caixa de pesquisa no topo da página
2. Digite palavras-chave como:
   - Nome do projeto
   - Código do projeto
   - Nome da instituição
   - Palavras da descrição

### 7.2 Histórico de Alterações

Cada projeto mantém registo de:
- **Quem** fez alterações
- **Quando** foram feitas
- **Que** alterações foram realizadas
- **Status anterior e atual**

### 7.3 Sistema de Anexos

**Tipos de arquivos aceitos:**
- PDF (documentos)
- JPG, PNG (imagens)
- DOC, DOCX (documentos Word)

**Tamanho máximo:** 2MB por arquivo

**Como funciona:**
- URLs externas abrem em nova aba
- Arquivos locais são baixados
- Detecção automática do tipo de anexo

---

## 8. Perguntas Frequentes

### 8.1 Projetos

**P: Posso editar um projeto após submissão?**
R: Sim, mas apenas projetos com status "Recebido". Após análise inicial, contacte o administrador.

**P: Quanto tempo demora a análise?**
R: O sistema prevê 15 dias para pareceres técnicos e 30 dias para aprovação de financiamento.

**P: Posso anexar documentos após criar o projeto?**
R: Sim, desde que o projeto ainda esteja editável (status "Recebido").

### 8.2 Sistema

**P: Como recuperar palavra-passe?**
R: Contacte o administrador do sistema para resetar a palavra-passe.

**P: O sistema funciona no telemóvel?**
R: Sim, o sistema é totalmente responsivo e funciona em dispositivos móveis.

**P: Posso exportar dados dos meus projetos?**
R: Sim, use as funcionalidades de exportação em PDF e Excel disponíveis.

### 8.3 Administração

**P: Como me torno administrador?**
R: Apenas outros administradores podem atribuir permissões administrativas.

**P: Posso ver projetos de outras instituições?**
R: Como administrador, pode ver todos os projetos. Como técnico, apenas os seus próprios.

---

## 9. Resolução de Problemas

### 9.1 Problemas de Acesso

**Não consigo fazer login:**
1. Verifique se o email/utilizador está correto
2. Confirme se a palavra-passe está correta
3. Limpe a cache do navegador
4. Contacte o administrador se persistir

**Página não carrega:**
1. Verifique a ligação à internet
2. Experimente outro navegador
3. Limpe cookies e cache
4. Contacte o suporte técnico

### 9.2 Problemas com Projetos

**Não consigo criar projeto:**
1. Verifique se preencheu todos os campos obrigatórios
2. Confirme se os anexos não excedem 2MB
3. Tente novamente após alguns minutos

**Status não atualiza:**
1. Recarregue a página (F5)
2. Verifique se tem permissões adequadas
3. Contacte o administrador responsável

### 9.3 Problemas de Exportação

**PDF não abre:**
1. Verifique se tem leitor de PDF instalado
2. Experimente baixar em vez de visualizar
3. Teste com outro navegador

**Excel não baixa:**
1. Verifique se o bloqueador de pop-ups está desativo
2. Confirme se tem espaço de armazenamento
3. Tente novamente após alguns minutos

### 9.4 Suporte Técnico

**Para obter ajuda:**
- Contacte o administrador do sistema
- Descreva detalhadamente o problema
- Mencione que navegador está a usar
- Indique quando o problema começou

---

## Contactos e Suporte

**Suporte Técnico:**
- Email: [inserir email de suporte]
- Telefone: [inserir telefone]

**Administração do Sistema:**
- Email: [inserir email administrativo]

**Horário de Atendimento:**
- Segunda a Sexta: 08:00 - 17:00
- Resposta em até 24 horas

---

**Documento atualizado em:** {{ date('d/m/Y H:i:s') }}
**Versão do Sistema:** 1.0
**Manual do Utilizador - Versão:** 1.0
