<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('funcionarios', function (Blueprint $table) {
            $table->string('banco')->nullable()->after('id_grupo_pessoal');
            $table->string('iban')->nullable()->after('banco');
            $table->string('nib')->nullable()->after('iban');
            $table->string('swift_bic')->nullable()->after('nib');
            $table->text('observacoes_bancarias')->nullable()->after('titular_conta');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('funcionarios', function (Blueprint $table) {
            $table->dropColumn([
                'banco',
                'iban',
                'nib',
                'swift_bic',
                'observacoes_bancarias'
            ]);
        });
    }
};
