<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('salarios_processados', function (Blueprint $table) {
            $table->string('email_funcionario')->nullable()->after('nbi');
            $table->enum('status_envio_email', ['Pendente', 'Enviado', 'Falhou', 'Sem Email'])->default('Pendente')->after('total');
            $table->timestamp('data_envio_email')->nullable()->after('status_envio_email');
            $table->text('erro_envio_email')->nullable()->after('data_envio_email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('salarios_processados', function (Blueprint $table) {
            $table->dropColumn(['email_funcionario', 'status_envio_email', 'data_envio_email', 'erro_envio_email']);
        });
    }
};
