<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('salarios_processados', function (Blueprint $table) {
            $table->id();
            $table->string('nomeTrabalhador', 120);
            $table->string('nbi', 30);
            $table->string('funcao', 120);
            $table->string('grupoPessoal', 120);
            $table->string('tipoClasse', 120);
            $table->string('descricao', 120); 
            $table->decimal('salarioBase', 10, 2);
            $table->decimal('abonoFamiliar', 10, 2);
            $table->decimal('subTransporte', 10, 2);
            $table->decimal('subAlimentacao', 10, 2);
            $table->decimal('subFerias', 10, 2);
            $table->decimal('subOutros', 10, 2);
            $table->decimal('desconto', 10, 2);            
            $table->decimal('acrescimoExtra', 10, 2);
            $table->decimal('total', 10, 2);
            $table->foreignId('processamento_salarios_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('salarios_processados');
    }
};
