<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('funcionario_remuneracao', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('funcionario_id');
            $table->unsignedBigInteger('remuneracao_id');
            $table->decimal('valor', 15, 2);
            $table->string('status')->default('Ativo');
            $table->string('observacao')->nullable();
            $table->timestamps();

            $table->unique(['funcionario_id', 'remuneracao_id']);
            $table->foreign('funcionario_id')->references('id')->on('funcionarios')->onDelete('cascade');
            $table->foreign('remuneracao_id')->references('id')->on('remuneracoes')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('funcionario_remuneracao');
    }
};
